/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering.gui.action;

import chemaxon.clustering.gui.JKlustor;
import chemaxon.marvin.common.swing.modules.MolFileFilter;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;

public class ImportAction
extends AbstractAction {
    private static final String confirmText = "Merge structures into current clusters?";
    private static final String confirmTitle = "Merge structures";
    private static final Object[] confirmOptions = new Object[]{"Merge", "No"};
    JKlustor jKlustor;
    private JFileChooser importDialog;

    public ImportAction(JKlustor jKlustor) {
        this.jKlustor = jKlustor;
        this.initChooser();
        ImageIcon importIcon = new ImageIcon(JKlustor.class.getResource("icons/open2.png"));
        this.putValue("Name", "Open...");
        this.putValue("SmallIcon", importIcon);
        this.putValue("ShortDescription", "Open Structures");
        this.putValue("ActionCommandKey", "Import");
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(79, 2));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (this.importDialog.showOpenDialog(this.jKlustor.getClusterViewer()) == 0 && this.importDialog.getSelectedFile().canRead()) {
                this.jKlustor.importStructures(this.importDialog.getSelectedFile().getCanonicalPath());
            }
        }
        catch (Exception ex) {
            this.jKlustor.handleError(ex);
        }
    }

    private void initChooser() {
        this.importDialog = new JFileChooser();
        this.importDialog.setDialogTitle("Library MCS: Open Structures");
        this.importDialog.setMultiSelectionEnabled(false);
        this.importDialog.addChoosableFileFilter(new MolFileFilter("sdf"));
        this.importDialog.addChoosableFileFilter(new MolFileFilter("smiles"));
        this.importDialog.addChoosableFileFilter(new MolFileFilter("ALL_STRUCTURE_FILES"));
    }

    private int showCloseConfirmDialog() {
        return JOptionPane.showOptionDialog(this.jKlustor.getClusterViewer(), confirmText, confirmTitle, 0, 3, null, confirmOptions, confirmOptions[1]);
    }
}

