/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering.gui.component;

import chemaxon.clustering.MBaseNode;
import chemaxon.clustering.gui.MWrapNode;
import chemaxon.clustering.gui.component.ClusterViewer;
import chemaxon.clustering.gui.component.TreeTable;
import chemaxon.clustering.gui.component.TreeTableModel;
import com.objectplanet.chart.BarChart;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class ChartPanel
extends JPanel
implements TableCellRenderer {
    public static final int DEFAULT_INTERVAL_COUNT = 6;
    private MWrapNode wrapNode = null;
    private int propertyNumber;
    private int intervalCount = 6;
    BarChart chart = null;
    HistogramBars bars = null;
    ChartPanelColumn column = null;
    private static Vector columns = new Vector(10);

    private ChartPanel() {
    }

    private synchronized ChartPanelColumn getColumn() {
        while (this.propertyNumber >= columns.size()) {
            columns.add(null);
        }
        if (columns.get(this.propertyNumber) == null) {
            columns.set(this.propertyNumber, new ChartPanelColumn(this.wrapNode, this.propertyNumber, 6));
        }
        return (ChartPanelColumn)columns.get(this.propertyNumber);
    }

    public ChartPanel(MWrapNode wrpNode, int propNumber) {
        this.wrapNode = wrpNode;
        this.propertyNumber = propNumber;
        this.initChart();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.wrapNode = null;
        this.chart = null;
        this.bars = null;
        this.column = null;
        this.removeAll();
    }

    private void initChart() {
        this.setLayout(new BorderLayout());
        this.chart = new BarChart(this.intervalCount);
        this.chart.setValueLinesOn(true);
        try {
            this.column = this.getColumn();
            this.bars = new HistogramBars(this.column, this.wrapNode);
            this.chart.setBarWidth(this.column.isDiscrete() && this.column.getColumnWidth() == 1 ? 0.5 : 1.0);
            this.chart.setBackground(TreeTable.shadeColor);
            this.chart.setSampleColor(0, ClusterViewer.MARK_COLOR);
            boolean[] selected = this.bars.getSelected();
            Color c = this.chart.getSampleColor(0);
            for (int j = 0; j < this.intervalCount; ++j) {
                if (selected != null && selected[j]) {
                    this.chart.setSampleColor(j, Color.red);
                    continue;
                }
                this.chart.setSampleColor(j, c);
            }
            this.chart.setRange(0, this.bars.getMaxScale());
            this.chart.setSampleValues(0, this.bars.getValues());
            this.chart.setBarLabelsOn(true);
            this.chart.setMultiColorOn(true);
            this.chart.setBarLabels(this.column.getLabels());
            this.add("Center", (Component)this.chart);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ChartPanel getMChartPanelCellRenderer() {
        return new ChartPanel();
    }

    @Override
    public void paint(Graphics g) {
        double w;
        super.paint(g);
        Rectangle r = this.chart.getGraphBounds();
        if (!this.column.isDiscrete()) {
            int y;
            int x;
            int i;
            double[] dist = this.bars.getDistribution();
            int xp = 0;
            int yp = 0;
            g.setColor(Color.BLUE);
            for (i = 0; i < dist.length; ++i) {
                x = r.x + 1 + (int)((double)r.width * (double)i / (double)dist.length) + 1;
                y = r.y + r.height - (int)((double)(r.height - 1) * dist[i]) + 1;
                if (i != 0 && yp < r.y + r.height && y < r.y + r.height) {
                    g.drawLine(xp, yp, x, y);
                }
                xp = x;
                yp = y;
            }
            g.setColor(Color.YELLOW);
            for (i = 0; i < dist.length; ++i) {
                x = r.x + 1 + (int)((double)r.width * (double)i / (double)dist.length);
                y = r.y + r.height - (int)((double)(r.height - 1) * dist[i]);
                if (i != 0 && yp < r.y + r.height && y < r.y + r.height) {
                    g.drawLine(xp, yp, x, y);
                }
                xp = x;
                yp = y;
            }
        }
        if (this.bars.isSingleValue() && this.column.isDiscrete() && this.column.getColumnWidth() != 1 && (w = this.column.getMaxValue() - this.column.getMinValue()) > 0.0) {
            int x = r.x + (int)((double)r.width * (this.bars.getValue() - this.column.getMinValue()) / w);
            if (x == r.x) {
                ++x;
            }
            while (x >= r.x + r.width - 1) {
                --x;
            }
            g.setColor(Color.YELLOW);
            g.drawLine(x, r.y + 1, x, r.y + r.height - 1);
            g.setColor(Color.BLUE);
            g.drawLine(x + 1, r.y + 2, x + 1, r.y + r.height - 1);
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        ((ChartPanel)value).setBorder(BorderFactory.createMatteBorder(0, 0, 1, 1, table.getGridColor()));
        return (ChartPanel)value;
    }

    private static class HistogramBars {
        private double[] values = null;
        private double[] distribution = null;
        private boolean[] selected = null;
        private boolean singleValue = false;
        private double value = 0.0;
        private double maxscale = 0.0;

        public boolean isSingleValue() {
            return this.singleValue;
        }

        public double[] getValues() {
            return this.values;
        }

        public double getValue() {
            return this.value;
        }

        public boolean[] getSelected() {
            return this.selected;
        }

        public double getMaxScale() {
            return this.maxscale;
        }

        public double[] getDistribution() {
            return this.distribution;
        }

        public HistogramBars(ChartPanelColumn column, MWrapNode wrapNode) {
            if (wrapNode.getChildCount() == 0) {
                this.value = ((Number)wrapNode.getProperty(column.getPropertyNumber())).doubleValue();
                this.singleValue = true;
            }
            MBaseNode baseNode = wrapNode.getNode();
            int[] v = baseNode.getGraph().getPropertyInIntervalCountsNodeLevel(wrapNode.getPropertyKey(column.getPropertyNumber()), baseNode, column.getPropMin(), column.getPropMax(), column.getColumnCount());
            this.selected = baseNode.getGraph().isMarkedInIntervals();
            this.maxscale = 0.0;
            this.values = new double[v.length];
            for (int i = 0; i < v.length; ++i) {
                this.values[i] = v[i];
                if (!(this.maxscale < this.values[i])) continue;
                this.maxscale = this.values[i];
            }
            if (!column.isDiscrete()) {
                this.distribution = baseNode.getGraph().getPropertyInIntervalDistributionNodeLevel(wrapNode.getPropertyKey(column.getPropertyNumber()), baseNode, column.getMinValue(), column.getMaxValue(), 50);
            }
        }
    }

    private static class ChartPanelColumn {
        private boolean discrete = false;
        private String[] labels = null;
        private Object propMin = null;
        private Object propMax = null;
        private int columnCount = 0;
        private int propNumber = 0;
        private int firstColValue = 0;
        private int lastColValue = 0;
        private int columnWidth = 0;
        private double minValue = 0.0;
        private double maxValue = 0.0;

        public ChartPanelColumn(MWrapNode wrpNode, int prpNumber, int colCount) {
            this.columnCount = colCount;
            this.propNumber = prpNumber;
            Object propertyMin = wrpNode.getPropertyGlobalMin(this.propNumber);
            Object propertyMax = wrpNode.getPropertyGlobalMax(this.propNumber);
            this.discrete = wrpNode.getPropertyType(this.propNumber) == 2;
            this.labels = new String[this.columnCount];
            Arrays.fill(this.labels, "");
            if (this.discrete) {
                this.firstColValue = ((Number)propertyMin).intValue();
                this.lastColValue = ((Number)propertyMax).intValue();
                int valueCount = this.lastColValue - this.firstColValue + 1;
                if (valueCount < this.columnCount) {
                    this.lastColValue = this.firstColValue + this.columnCount - 1;
                } else if (valueCount % this.columnCount != 0) {
                    valueCount = (valueCount / this.columnCount + 1) * this.columnCount;
                    this.lastColValue = this.firstColValue + valueCount - 1;
                }
                this.columnWidth = (this.lastColValue - this.firstColValue + 1) / this.columnCount;
                if (this.columnWidth == 1) {
                    this.labels[0] = "" + this.firstColValue;
                    this.labels[this.labels.length - 1] = "" + this.lastColValue;
                } else {
                    this.labels[0] = this.firstColValue + ".." + (this.firstColValue + this.columnWidth - 1);
                    this.labels[this.labels.length - 1] = this.lastColValue - this.columnWidth + 1 + ".." + this.lastColValue;
                }
                propertyMin = new Double((double)this.firstColValue - 0.5);
                propertyMax = new Double((double)this.lastColValue + 0.5);
                this.minValue = this.firstColValue;
                this.maxValue = this.lastColValue;
            } else {
                this.minValue = ((Number)propertyMin).doubleValue();
                this.maxValue = ((Number)propertyMax).doubleValue();
                this.labels[0] = TreeTableModel.format(propertyMin);
                this.labels[this.labels.length - 1] = TreeTableModel.format(propertyMax);
            }
            this.propMin = propertyMin;
            this.propMax = propertyMax;
        }

        public boolean isDiscrete() {
            return this.discrete;
        }

        public int getColumnCount() {
            return this.columnCount;
        }

        public Object getPropMin() {
            return this.propMin;
        }

        public Object getPropMax() {
            return this.propMax;
        }

        public int getPropertyNumber() {
            return this.propNumber;
        }

        public double getMinValue() {
            return this.minValue;
        }

        public double getMaxValue() {
            return this.maxValue;
        }

        public String[] getLabels() {
            return this.labels;
        }

        public int getColumnWidth() {
            return this.columnWidth;
        }
    }
}

