/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering.gui.component;

import chemaxon.clustering.MBaseNode;
import chemaxon.clustering.MGraph;
import chemaxon.clustering.gui.component.ClusterViewer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JPanel;

public class DendogramPanel
extends JPanel {
    private static final int DEFAULT_GAP_BETWEEN_NODES = 4;
    private static final int DEFAULT_GAP_BETWEEN_CLUSTERS = 4;
    private static final int DEFAULT_LEVEL_HEIGHT = 60;
    private static final int LEFT_BORDER = 5;
    private static final int RIGHT_BORDER = 5;
    private static final int TOP_BORDER = 20;
    private static final int BOTTOM_BORDER = 20;
    private static int DEFAULT_MARK_SIZE = 3;
    private static int DEFAULT_MOUSE_SENSITIVITY_X = 6;
    private float gapBetweenNodes = 4.0f;
    private float gapBetweenClusters = 4.0f;
    private int markSize = DEFAULT_MARK_SIZE;
    private float paintingOffsetX = 0.0f;
    private float paintingOffsetY = 0.0f;
    private float currentLineWidth = 1.0f;
    private float xZoom = 1.0f;
    private float yZoom = 1.0f;
    private float xFrameZoom = 1.0f;
    private float yFrameZoom = 1.0f;
    private float levelHeight = 60.0f;
    private float offset;
    private boolean displayID = false;
    private MGraph graph;
    private int levelCount = 0;
    private MBaseNode root;
    private MBaseNode activeNode;
    private int mouseXSensitivity = DEFAULT_MOUSE_SENSITIVITY_X;
    private static int COLOR_NUMBER = 5;
    private static Color[] COLOR = new Color[COLOR_NUMBER];

    public void setGraph(MGraph g) {
        this.graph = g;
        this.levelCount = this.graph.getDepth();
        this.root = this.graph.getTopLevelClusterCount() == 0 ? null : this.graph.getTopLevelCluster(0).getParent();
        this.setFrameZoom();
    }

    public int getHorizontalMaximum() {
        return this.levelCount > 0 ? (int)this.horizontalSizeUnder(this.root) + 5 + 5 : 100;
    }

    public int getVerticalMaximum() {
        return this.levelCount * 60 + 20 + 20;
    }

    public void setDisplayID(boolean b) {
        this.displayID = b;
    }

    public void setPaintingOffsets(float x, float y) {
        this.paintingOffsetX = x;
        this.paintingOffsetY = y;
    }

    public void setZoomFactors(float xz, float yz) {
        this.xZoom = xz;
        this.yZoom = yz;
    }

    private void setFrameZoom() {
        this.xFrameZoom = (float)this.getWidth() / (float)this.getHorizontalMaximum();
        this.yFrameZoom = (float)this.getHeight() / (float)this.getVerticalMaximum();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (g instanceof Graphics2D) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setStroke(new BasicStroke(this.currentLineWidth, 0, 2));
        }
        this.paintGraph(g);
    }

    public int getLevelFromCoord(int yPaintCoord) {
        return 1 + (int)(this.yPaintCoordToYCoord(yPaintCoord) / this.levelHeight);
    }

    public int getCoordOfLevel(int level) {
        if (level < 1 || level > this.levelCount) {
            return -1;
        }
        return this.yCoordToPaintYCoord((0.5f + (float)(level - 1)) * this.levelHeight);
    }

    public void setActiveNode(MBaseNode node) {
        this.activeNode = node;
    }

    public MBaseNode calculateNodeFromPaintCoordinates(int xPaintCoord, int yPaintCoord) {
        int level = this.getLevelFromCoord(yPaintCoord);
        float xCoord = this.xPaintCoordToXCoord(xPaintCoord);
        float xTolCoord = this.xPaintCoordToXCoord(xPaintCoord + this.mouseXSensitivity);
        float xTolerance = Math.abs(xTolCoord - xCoord);
        MBaseNode searchNode = this.root;
        float offset = 0.0f - xTolerance;
        for (int tmpLevel = level; tmpLevel > 0; --tmpLevel) {
            boolean foundClusterOnThisLevel;
            MBaseNode child = searchNode.getFirstVisibleChild();
            if (child == null) {
                return null;
            }
            MBaseNode firstChld = child;
            float nextHorizontalSize = tmpLevel == 1 && level == this.levelCount ? this.gapBetweenNodes : this.horizontalSizeUnder(child) + this.gapBetweenNodes + this.gapBetweenClusters;
            boolean bl = foundClusterOnThisLevel = xCoord < offset + nextHorizontalSize;
            while (!foundClusterOnThisLevel) {
                offset += nextHorizontalSize;
                if ((child = child.getVisibleFollower()) == firstChld) {
                    return null;
                }
                nextHorizontalSize = tmpLevel == 1 && level == this.levelCount ? this.gapBetweenNodes : this.horizontalSizeUnder(child) + this.gapBetweenNodes + this.gapBetweenClusters;
                foundClusterOnThisLevel = xCoord < offset + nextHorizontalSize;
            }
            searchNode = child;
        }
        float gap = (this.firstChildDistFromClusterBegin(searchNode) + this.lastChildDistFromClusterBegin(searchNode)) / 2.0f - (xCoord - offset);
        if (gap < -2.0f * xTolerance || gap > 0.0f) {
            return null;
        }
        return searchNode;
    }

    private float paintCluster(Graphics g, MBaseNode cluster) {
        float xCoordFirst;
        MBaseNode firstChild = cluster.getFirstVisibleChild();
        if (firstChild == null) {
            float tmpOffset = this.offset;
            this.offset += cluster.getLastChild() == null ? this.gapBetweenNodes : this.gapBetweenNodes + this.gapBetweenClusters;
            return tmpOffset;
        }
        float yCoordParent = (float)cluster.getDepth() * this.levelHeight;
        float yCoordChild = yCoordParent + this.levelHeight;
        float xCoordLast = xCoordFirst = this.paintCluster(g, firstChild);
        float xCoordParent = xCoordFirst;
        this.paintNode(firstChild, g, xCoordLast, yCoordChild, yCoordParent);
        for (MBaseNode tmp = firstChild.getVisibleFollower(); tmp != firstChild; tmp = tmp.getVisibleFollower()) {
            xCoordLast = this.paintCluster(g, tmp);
            this.paintNode(tmp, g, xCoordLast, yCoordChild, yCoordParent);
        }
        if (firstChild.getFirstChild() == null) {
            this.offset += this.gapBetweenClusters;
        }
        xCoordParent += xCoordLast;
        xCoordParent = (int)(xCoordParent / 2.0f);
        if (cluster != this.root) {
            this.drawLine(g, xCoordFirst, yCoordParent, xCoordLast, yCoordParent, Color.BLACK);
        }
        return xCoordParent;
    }

    private void paintNode(MBaseNode node, Graphics g, float xCoord, float yCoord, float yCoordParent) {
        this.drawLine(g, xCoord, yCoord, xCoord, yCoordParent, this.calculateColor(node));
        this.drawNode(g, xCoord, (yCoord + yCoordParent) / 2.0f, node.isMarked(), node == this.activeNode);
    }

    private void paintGraph(Graphics g) {
        if (this.root != null) {
            this.offset = 0.0f;
            this.paintCluster(g, this.root);
        }
    }

    private void drawLine(Graphics g, float x1, float y1, float x2, float y2, Color color) {
        if (!g.getColor().equals(color)) {
            g.setColor(color);
        }
        if (!color.equals(Color.BLACK)) {
            g.fillRect(this.xCoordToPaintXCoord((x1 + x2) / 2.0f) - this.markSize, this.yCoordToPaintYCoord((y1 + y2) / 2.0f) - this.markSize * 3, 2 * this.markSize + 1, 6 * this.markSize + 1);
            g.setColor(Color.BLACK);
        }
        g.drawLine(this.xCoordToPaintXCoord(x1), this.yCoordToPaintYCoord(y1), this.xCoordToPaintXCoord(x2), this.yCoordToPaintYCoord(y2));
    }

    private void drawMark(Graphics g, float xCoord, float yCoord) {
        Color c = g.getColor();
        g.setColor(ClusterViewer.MARK_COLOR);
        g.fillRect(this.xCoordToPaintXCoord(xCoord) - this.markSize, this.yCoordToPaintYCoord(yCoord) - this.markSize, 2 * this.markSize + 1, 2 * this.markSize + 1);
        g.setColor(c);
    }

    private void drawMarkable(Graphics g, float xCoord, float yCoord) {
        Color c = g.getColor();
        g.setColor(ClusterViewer.MARK_COLOR);
        g.drawRect(this.xCoordToPaintXCoord(xCoord) - this.markSize, this.yCoordToPaintYCoord(yCoord) - this.markSize, 2 * this.markSize, 2 * this.markSize);
        g.setColor(c);
    }

    private void drawActiveMark(Graphics g, float xCoord, float yCoord) {
        int ms = this.markSize / 2;
        this.drawMark(g, xCoord, yCoord);
        Color c = g.getColor();
        g.setColor(Color.white);
        g.fillRect(this.xCoordToPaintXCoord(xCoord) - ms, this.yCoordToPaintYCoord(yCoord) - ms, 2 * ms + 1, 2 * ms + 1);
        g.setColor(c);
    }

    private void drawNode(Graphics g, float xCoord, float yCoord, boolean selected, boolean active) {
        if (!active && !selected) {
            return;
        }
        Color c = g.getColor();
        g.setColor(ClusterViewer.MARK_COLOR);
        if (selected) {
            g.fillRect(this.xCoordToPaintXCoord(xCoord) - this.markSize, this.yCoordToPaintYCoord(yCoord) - this.markSize, 2 * this.markSize + 1, 2 * this.markSize + 1);
        }
        if (active) {
            g.setColor(ClusterViewer.MARK_COLOR_BRIGHT);
            g.drawRect(this.xCoordToPaintXCoord(xCoord) - this.markSize, this.yCoordToPaintYCoord(yCoord) - this.markSize, 2 * this.markSize, 2 * this.markSize);
        }
        g.setColor(c);
    }

    private void drawString(Graphics g, float xDiff, String s, float x, float y) {
        if (xDiff < (float)(g.getFontMetrics().stringWidth(s) + 1)) {
            return;
        }
        g.drawString(s, this.xCoordToPaintXCoord(x) + 1, this.yCoordToPaintYCoord(y));
    }

    private int xCoordToPaintXCoord(float xCoord) {
        return this.xZoom == 0.0f ? -1 : (int)(this.xFrameZoom / this.xZoom * (xCoord + this.paintingOffsetX + 5.0f));
    }

    private int yCoordToPaintYCoord(float yCoord) {
        return this.yZoom == 0.0f ? -1 : (int)(this.yFrameZoom / this.yZoom * (yCoord + this.paintingOffsetY + 20.0f));
    }

    private float xPaintCoordToXCoord(int xPaintCoord) {
        return this.xZoom == 0.0f || this.xFrameZoom == 0.0f ? -1.0f : this.xZoom / this.xFrameZoom * (float)xPaintCoord - this.paintingOffsetX - 5.0f;
    }

    private float yPaintCoordToYCoord(int yPaintCoord) {
        return this.yZoom == 0.0f || this.yFrameZoom == 0.0f ? -1.0f : this.yZoom / this.yFrameZoom * (float)yPaintCoord - this.paintingOffsetY - 20.0f;
    }

    private float horizontalSizeUnder(MBaseNode nod) {
        if (nod == null) {
            return 0.0f;
        }
        MBaseNode firstNotHiddenChld = nod.getFirstVisibleChild();
        if (firstNotHiddenChld == null) {
            return 0.0f;
        }
        float gap = nod.getDepth() + 1 == this.graph.getDepth() ? this.gapBetweenNodes : this.gapBetweenNodes + this.gapBetweenClusters;
        float size = this.horizontalSizeUnder(firstNotHiddenChld);
        for (MBaseNode tmp = firstNotHiddenChld.getVisibleFollower(); tmp != firstNotHiddenChld; tmp = tmp.getVisibleFollower()) {
            size += gap + this.horizontalSizeUnder(tmp);
        }
        return size;
    }

    private float firstChildDistFromClusterBegin(MBaseNode nod) {
        if (nod == null) {
            return 0.0f;
        }
        MBaseNode firstChild = nod.getFirstVisibleChild();
        return (this.firstChildDistFromClusterBegin(firstChild) + this.lastChildDistFromClusterBegin(firstChild)) / 2.0f;
    }

    private float lastChildDistFromClusterBegin(MBaseNode nod) {
        if (nod == null) {
            return 0.0f;
        }
        float childrenSizeBefore = 0.0f;
        MBaseNode lastChild = nod.getLastVisibleChild();
        for (MBaseNode tmp = nod.getFirstVisibleChild(); tmp != lastChild; tmp = tmp.getFollower()) {
            childrenSizeBefore += tmp.getFirstChild() == null ? this.horizontalSizeUnder(tmp) + this.gapBetweenNodes : this.horizontalSizeUnder(tmp) + this.gapBetweenNodes + this.gapBetweenClusters;
        }
        return childrenSizeBefore + (this.firstChildDistFromClusterBegin(lastChild) + this.lastChildDistFromClusterBegin(lastChild)) / 2.0f;
    }

    private Color calculateColor(MBaseNode nod) {
        if (nod.isNewnode()) {
            return Color.WHITE;
        }
        if (nod.getColor() == 0) {
            return Color.BLACK;
        }
        int nc = 0;
        int red = 0;
        int green = 0;
        int blue = 0;
        for (int i = 1; i <= COLOR_NUMBER; ++i) {
            if (!nod.hasColor(i)) continue;
            ++nc;
            red += COLOR[i - 1].getRed();
            green += COLOR[i - 1].getGreen();
            blue += COLOR[i - 1].getBlue();
        }
        return new Color(red /= nc, green /= nc, blue /= nc);
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.setFrameZoom();
    }

    static {
        DendogramPanel.COLOR[0] = Color.RED;
        DendogramPanel.COLOR[1] = Color.BLUE;
        DendogramPanel.COLOR[2] = Color.GREEN;
        DendogramPanel.COLOR[3] = Color.YELLOW;
        DendogramPanel.COLOR[4] = Color.MAGENTA;
    }
}

