/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering.gui.component;

import chemaxon.clustering.MBaseNode;
import chemaxon.clustering.MGraph;
import chemaxon.clustering.MultiNode;
import chemaxon.clustering.gui.JDTSlider;
import chemaxon.clustering.gui.ToolTipManager;
import chemaxon.clustering.gui.component.ClusterViewer;
import chemaxon.clustering.gui.component.DendogramPanel;
import chemaxon.clustering.gui.component.LevelPanel;
import chemaxon.clustering.gui.component.MViewTablePanel;
import chemaxon.clustering.gui.component.RGroupTablePanel;
import chemaxon.clustering.gui.component.TreeTableModel;
import chemaxon.struc.Molecule;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DendogramViewer
extends JPanel
implements MouseInputListener,
ClipboardOwner,
FocusListener {
    Log log = LogFactory.getLog(DendogramViewer.class);
    private ClusterViewer clusterViewer;
    private DendogramPanel dendogramPanel = null;
    private LevelPanel levelChooser = null;
    private MGraph graph;
    private MBaseNode root;
    private JDTSlider horizontalSlider;
    private JDTSlider verticalSlider;
    private SliderHandler sliderHandler;
    private MBaseNode currentNode = null;
    private ToolTipManager tooltipManager;
    private ToolTipManager.MolToolTip tooltip = null;
    private boolean displayPropertiesInTooltips = true;
    private MBaseNode clickedNode = null;
    private TreePopupMenu popupMenu = new TreePopupMenu();

    public DendogramViewer() {
        this.dendogramPanel = new DendogramPanel();
        this.dendogramPanel.setBorder(BorderFactory.createBevelBorder(1));
        this.levelChooser = new LevelPanel(this);
        this.levelChooser.setBorder(BorderFactory.createBevelBorder(1));
        this.sliderHandler = new SliderHandler();
        this.tooltipManager = new ToolTipManager(this.dendogramPanel);
        this.tooltip = this.tooltipManager.getToolTip();
        this.dendogramPanel.addMouseListener(this);
        this.dendogramPanel.addMouseMotionListener(this);
        this.dendogramPanel.setRequestFocusEnabled(true);
        this.dendogramPanel.addFocusListener(this);
        this.setLayout();
    }

    public DendogramViewer(MGraph g) {
        this();
        this.setGraph(g);
    }

    public void setClusterViewer(ClusterViewer clusterViewer) {
        this.clusterViewer = clusterViewer;
    }

    public void setGraph(MGraph g) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"setGraph()", new Throwable().fillInStackTrace());
            this.log.trace((Object)("g.getPropertyCount=" + g.getPropertyCount()));
            this.log.trace((Object)g.logh.toString());
        }
        this.graph = g;
        this.root = this.graph.getTopLevelClusterCount() == 0 ? null : this.graph.getTopLevelCluster(0).getParent();
        this.dendogramPanel.setGraph(g);
        this.levelChooser.graphChanged();
        this.sliderHandler.initSliderValues();
    }

    public void setActiveNode(MBaseNode node) {
        this.tooltipManager.hideTip();
        this.dendogramPanel.setActiveNode(node);
        this.dendogramPanel.repaint();
    }

    public void onRemove() {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"onRemove()");
        }
        this.dendogramPanel.removeMouseListener(this);
        this.dendogramPanel.removeMouseMotionListener(this);
        this.tooltipManager.unregisterComponent(this);
        this.tooltipManager = null;
        this.tooltip = null;
        this.popupMenu = null;
        this.graph = null;
        this.root = null;
        this.currentNode = null;
        this.clickedNode = null;
        this.levelChooser.onRemove();
        this.levelChooser = null;
        this.dendogramPanel = null;
        this.clusterViewer = null;
        this.horizontalSlider.removeChangeListener(this.sliderHandler);
        this.verticalSlider.removeChangeListener(this.sliderHandler);
        this.horizontalSlider = null;
        this.verticalSlider = null;
        this.sliderHandler = null;
        this.removeAll();
    }

    private void setLayout() {
        this.setLayout(new BorderLayout());
        this.add((Component)((Object)this.horizontalSlider), "North");
        this.add((Component)((Object)this.verticalSlider), "East");
        JSplitPane horizontalSplitPane = new JSplitPane(1, this.levelChooser, this.dendogramPanel);
        horizontalSplitPane.setResizeWeight(0.0);
        horizontalSplitPane.setOneTouchExpandable(false);
        horizontalSplitPane.setDividerLocation(18);
        horizontalSplitPane.setDividerSize(0);
        horizontalSplitPane.setBorder(null);
        this.add((Component)horizontalSplitPane, "Center");
    }

    public int getLevelCount() {
        return this.graph == null ? 0 : this.graph.getDepth();
    }

    public LevelPanel getLevelChooser() {
        if (this.levelChooser == null) {
            this.levelChooser = new LevelPanel(this);
        }
        return this.levelChooser;
    }

    public void updateMarvinViewPanel(MViewTablePanel p) {
        if (p == null || this.graph == null) {
            return;
        }
        int numOfMolecules = this.graph.getMarkedNodeCount();
        MBaseNode n = null;
        Molecule m = null;
        p.clear();
        p.setMolCount(numOfMolecules);
        for (int i = 0; i < numOfMolecules; ++i) {
            n = i == 0 ? this.graph.firstMarked() : this.graph.nextMarked();
            m = n.getMoleculeWithProperty();
            int f = n.getParent() == this.root ? 0 : (n.hasChildren() ? 1 : 2);
            p.setMolecule(i, m, f);
            p.setText(i, this.getNodeText(n, p.isDisplayProperties()));
        }
    }

    public void addMouseMotionListener(final MViewTablePanel tp) {
        tp.mviewTable.addMouseMotionListener(new MouseMotionListener(){
            int activeCell = -1;

            @Override
            public void mouseDragged(MouseEvent e) {
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                if (DendogramViewer.this.clusterViewer == null || !DendogramViewer.this.isFocusOwner()) {
                    return;
                }
                int r = tp.getActiveCellIndex(e.getPoint());
                if (r != this.activeCell) {
                    this.activeCell = r;
                    MBaseNode node = null;
                    for (int i = 0; i < DendogramViewer.this.graph.getMarkedNodeCount(); ++i) {
                        MBaseNode mBaseNode = node = i == 0 ? DendogramViewer.this.graph.firstMarked() : DendogramViewer.this.graph.nextMarked();
                        if (i == this.activeCell) break;
                    }
                    DendogramViewer.this.clusterViewer.setActiveNode(node);
                }
            }
        });
    }

    public void updateRGroupPanel(RGroupTablePanel p) {
        int i;
        if (p == null || this.graph == null) {
            return;
        }
        int numOfMolecules = this.graph.getMarkedNodeCount();
        MBaseNode n = null;
        Object m = null;
        int rowCount = 0;
        for (i = 0; i < numOfMolecules; ++i) {
            MBaseNode mBaseNode = n = i == 0 ? this.graph.firstMarked() : this.graph.nextMarked();
            if (n.hasChildren() && (n.getParent() == this.root || n.getParent().getChildCount() == 1)) continue;
            ++rowCount;
        }
        p.clear();
        p.setMolCount(rowCount);
        rowCount = 0;
        for (i = 0; i < numOfMolecules; ++i) {
            int f;
            MBaseNode mBaseNode = n = i == 0 ? this.graph.firstMarked() : this.graph.nextMarked();
            int n2 = n.getParent() == this.root ? 0 : (f = n.hasChildren() ? 1 : 2);
            if (f != 2 && (f == 0 || n.getParent().getChildCount() == 1)) continue;
            p.setNode(rowCount, n, f);
            ++rowCount;
        }
    }

    private String getNodeText(MBaseNode n, boolean properties) {
        StringBuffer textBuffer = new StringBuffer();
        textBuffer.append(n.hasChildren() ? "ClusterID: " + String.valueOf(n.getID()) : "ID: " + n.getProperty("ID"));
        if (!properties) {
            return textBuffer.toString();
        }
        textBuffer.append("\n");
        int countMolProp = this.graph.getPropertyCount();
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("getNodeText() countMolProp=" + countMolProp));
        }
        if (n.hasChildren()) {
            for (int j = 0; j < countMolProp; ++j) {
                if (this.graph.isRangedProperty(j)) {
                    StringBuffer buffer = new StringBuffer();
                    buffer.append(this.graph.getPropertyKey(j));
                    buffer.append(": ");
                    try {
                        buffer.append(TreeTableModel.format(this.graph.getPropertyMin(this.graph.getPropertyKey(j), n)));
                        buffer.append(", ");
                        buffer.append(TreeTableModel.format(this.graph.getPropertyMax(this.graph.getPropertyKey(j), n)));
                        buffer.append(", ");
                        buffer.append(TreeTableModel.format(this.graph.getPropertyAverage(this.graph.getPropertyKey(j), n)));
                    }
                    catch (IllegalArgumentException e) {
                        // empty catch block
                    }
                    textBuffer.append(buffer);
                } else {
                    textBuffer.append(this.graph.getPropertyKey(j));
                }
                if (j >= countMolProp - 1) continue;
                textBuffer.append("\n");
            }
        } else {
            for (int j = 0; j < countMolProp; ++j) {
                try {
                    if (this.graph.isRangedProperty(j)) {
                        textBuffer.append(this.graph.getPropertyKey(j));
                        textBuffer.append(": ");
                        textBuffer.append(TreeTableModel.format(this.graph.getProperty(this.graph.getPropertyKey(j), n)));
                    } else {
                        textBuffer.append(this.graph.getPropertyKey(j));
                        textBuffer.append(": ");
                        textBuffer.append(n.getProperty(this.graph.getPropertyKey(j)));
                    }
                    if (j >= countMolProp - 1) continue;
                    textBuffer.append("\n");
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return textBuffer.toString();
    }

    public int getCoordOfLevel(int level) {
        return this.dendogramPanel.getCoordOfLevel(level);
    }

    public int getLevelFromCoord(int yPaintCoord) {
        return this.dendogramPanel.getLevelFromCoord(yPaintCoord);
    }

    public void unmarkAllNodes() {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"unmarkAllNodes()");
        }
        this.graph.unmarkAllNodes();
        this.levelChooser.clearSelection();
        this.clusterViewer.update();
    }

    public void markLevel(int level) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("markLevel() level=" + level));
        }
        this.graph.markLevel(level);
        this.clusterViewer.update();
    }

    public void unmarkLevel(int level) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("unmarkLevel() level=" + level));
        }
        this.graph.unmarkLevel(level);
        this.clusterViewer.update();
    }

    public void setDisplayID(boolean b) {
        this.dendogramPanel.setDisplayID(b);
    }

    public void setDisplayPropertiesInTooltips(boolean b) {
        this.displayPropertiesInTooltips = b;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.graph == null) {
            return;
        }
        this.clickedNode = this.dendogramPanel.calculateNodeFromPaintCoordinates(e.getX(), e.getY());
        if ((e.getModifiers() & 4) != 0) {
            this.processRighClick(e);
            return;
        }
        if (this.clickedNode == null) {
            if (!e.isControlDown() && !e.isShiftDown()) {
                this.unmarkAllNodes();
                this.repaint();
            }
            return;
        }
        int levelsUnder = this.graph.getDepth() - this.clickedNode.getDepth();
        this.clusterViewer.setActiveNode(this.clickedNode);
        if (e.getClickCount() == 1) {
            this.processMouseClick(e, levelsUnder);
        } else if (e.getClickCount() == 2) {
            this.processDoubleClick(e, levelsUnder);
        }
        this.repaint();
    }

    private void processRighClick(MouseEvent e) {
        if (this.clickedNode != null) {
            this.tooltipManager.enableTips(false);
            this.popupMenu.show(this, e.getX() + 15, e.getY() + 15);
        }
    }

    private void processMouseClick(MouseEvent e, int levelCountUnderClickedNode) {
        if (!e.isControlDown() && !e.isShiftDown()) {
            this.unmarkAllNodes();
        }
        if (e.isShiftDown()) {
            if (e.isControlDown() && this.clickedNode.isMarked()) {
                for (int i = 0; i <= levelCountUnderClickedNode; ++i) {
                    this.clickedNode.unmarkLevelUnder(i);
                }
            } else if (e.isAltDown()) {
                this.clickedNode.mark();
                this.clickedNode.markLevelUnder(levelCountUnderClickedNode);
            } else {
                for (int i = 0; i <= levelCountUnderClickedNode; ++i) {
                    this.clickedNode.markLevelUnder(i);
                }
            }
        } else if (e.isControlDown()) {
            if (this.clickedNode.isMarked()) {
                this.clickedNode.unmark();
            } else {
                this.clickedNode.mark();
            }
        } else if (e.isAltDown()) {
            this.clickedNode.mark();
            this.clickedNode.markLevelUnder(levelCountUnderClickedNode);
        } else {
            this.clickedNode.mark();
        }
        this.clusterViewer.update();
    }

    private void processDoubleClick(MouseEvent e, int levelCountUnderClickedNode) {
        if (!e.isControlDown() && !e.isShiftDown()) {
            this.unmarkAllNodes();
        }
        for (int i = 0; i <= levelCountUnderClickedNode; ++i) {
            this.clickedNode.markLevelUnder(i);
        }
        this.clusterViewer.update();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.tooltipManager.enableTips(true);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.tooltipManager.enableTips(false);
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.graph == null || this.root == null || this.popupMenu.isVisible()) {
            return;
        }
        if (!this.tooltipManager.isTipsEnabled()) {
            this.tooltipManager.enableTips(true);
        }
        MBaseNode lastNode = this.currentNode;
        this.currentNode = this.dendogramPanel.calculateNodeFromPaintCoordinates(e.getX(), e.getY());
        this.dendogramPanel.setActiveNode(this.currentNode);
        if (this.currentNode != null) {
            this.setCursor(Cursor.getPredefinedCursor(12));
        } else {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
        if (this.tooltip != null && this.currentNode != lastNode) {
            if (this.currentNode == null) {
                this.tooltip.update(null, null);
            } else {
                Image image = (Image)this.currentNode.getMoleculeWithProperty().toObject("image:w100,h100,#ffffD7");
                this.tooltip.update(image, this.getNodeText(this.currentNode, this.displayPropertiesInTooltips));
            }
            this.repaint();
        }
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    public class TreePopupMenu
    extends JPopupMenu {
        JMenuItem mark;
        JMenuItem unmark = new JMenuItem("Unmark node");
        JMenuItem markLeaves;
        JMenuItem markChildren;
        JMenuItem multiMark;
        JMenuItem copyToClipboard;

        TreePopupMenu() {
            this.unmark.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DendogramViewer.this.clickedNode.unmark();
                    DendogramViewer.this.clusterViewer.update();
                }
            });
            this.mark = new JMenuItem("Mark node");
            this.mark.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DendogramViewer.this.clickedNode.mark();
                    DendogramViewer.this.clusterViewer.update();
                }
            });
            this.markChildren = new JMenuItem("Mark children");
            this.markChildren.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int levelsUnder = DendogramViewer.this.graph.getDepth() - DendogramViewer.this.clickedNode.getDepth();
                    for (int i = 0; i <= levelsUnder; ++i) {
                        DendogramViewer.this.clickedNode.markLevelUnder(i);
                    }
                    DendogramViewer.this.clusterViewer.update();
                }
            });
            this.markLeaves = new JMenuItem("Mark leaf nodes");
            this.markLeaves.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DendogramViewer.this.clickedNode.markLevelUnder(DendogramViewer.this.graph.getDepth() - DendogramViewer.this.clickedNode.getDepth());
                    DendogramViewer.this.clusterViewer.update();
                }
            });
            this.multiMark = new JMenuItem("Mark instances");
            this.multiMark.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DendogramViewer.this.clickedNode.getGraph().unmarkAllNodes();
                    for (int i = 0; i < ((MultiNode)((Object)DendogramViewer.this.clickedNode)).countInstances(); ++i) {
                        ((MultiNode)((Object)DendogramViewer.this.clickedNode)).instance(i).mark();
                    }
                    DendogramViewer.this.clusterViewer.update();
                }
            });
            this.copyToClipboard = new JMenuItem("Copy to clipboard");
            this.copyToClipboard.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Clipboard clipboard;
                    try {
                        clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    }
                    catch (SecurityException sex) {
                        System.err.println("Warning: Cannot access system clipboard -> using local");
                        clipboard = new Clipboard("MCSClipboard");
                    }
                    StringSelection ss = new StringSelection(DendogramViewer.this.clickedNode.getMoleculeWithProperty().toFormat("mrv"));
                    clipboard.setContents(ss, DendogramViewer.this);
                }
            });
        }

        @Override
        public void show(Component invoker, int x, int y) {
            this.removeAll();
            if (DendogramViewer.this.clickedNode.isMarked()) {
                this.add(this.unmark);
            } else {
                this.add(this.mark);
            }
            if (DendogramViewer.this.clickedNode.hasChildren()) {
                this.add(this.markLeaves);
                this.add(this.markChildren);
            }
            this.add(this.copyToClipboard);
            super.show(invoker, x, y);
        }
    }

    public class SliderHandler
    implements ChangeListener {
        public SliderHandler() {
            DendogramViewer.this.horizontalSlider = new JDTSlider(0, 0, 100, 0, 100);
            DendogramViewer.this.verticalSlider = new JDTSlider(1, 0, 100, 0, 100);
            DendogramViewer.this.horizontalSlider.addChangeListener(this);
            DendogramViewer.this.verticalSlider.addChangeListener(this);
            this.initSliderValues();
        }

        @Override
        public void stateChanged(ChangeEvent c) {
            this.calculateZoom();
            DendogramViewer.this.repaint();
        }

        private void initSliderValues() {
            int horizontalMaximum = DendogramViewer.this.dendogramPanel.getHorizontalMaximum();
            int verticalMaximum = DendogramViewer.this.dendogramPanel.getVerticalMaximum();
            DendogramViewer.this.horizontalSlider.setMaximum(horizontalMaximum);
            DendogramViewer.this.verticalSlider.setMaximum(verticalMaximum);
            DendogramViewer.this.horizontalSlider.setValues(0, horizontalMaximum);
            DendogramViewer.this.verticalSlider.setValues(0, verticalMaximum);
            this.calculateZoom();
        }

        private void calculateZoom() {
            float yZoom = (float)(DendogramViewer.this.verticalSlider.getMaxValue() - DendogramViewer.this.verticalSlider.getMinValue()) / (float)(DendogramViewer.this.verticalSlider.getMaximum() - DendogramViewer.this.verticalSlider.getMinimum());
            float paintingOffsetY = -((float)(DendogramViewer.this.verticalSlider.getMaximum() - DendogramViewer.this.verticalSlider.getMaxValue()));
            float xZoom = (float)(DendogramViewer.this.horizontalSlider.getMaxValue() - DendogramViewer.this.horizontalSlider.getMinValue()) / (float)(DendogramViewer.this.horizontalSlider.getMaximum() - DendogramViewer.this.horizontalSlider.getMinimum());
            float paintingOffsetX = -((float)(DendogramViewer.this.horizontalSlider.getMinValue() - DendogramViewer.this.horizontalSlider.getMinimum()));
            DendogramViewer.this.dendogramPanel.setZoomFactors(xZoom, yZoom);
            DendogramViewer.this.dendogramPanel.setPaintingOffsets(paintingOffsetX, paintingOffsetY);
        }
    }
}

