/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering.gui.component;

import chemaxon.clustering.MBaseNode;
import chemaxon.clustering.gui.component.ClusterViewer;
import chemaxon.clustering.gui.component.MViewTablePanel;
import chemaxon.core.util.BondTable;
import chemaxon.marvin.MolPrinter;
import chemaxon.sss.search.Decomposition;
import chemaxon.sss.search.RGroupDecomposition;
import chemaxon.struc.MDocument;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;

public class RGroupTablePanel
extends JPanel {
    public static final int STRUCTURE_COLUMN = 0;
    public static final int RELATION_2_COLUMN = 1;
    public static final int DEFAULT_COLUMN_COUNT = 2;
    private RGroupDecomposition decompositor = new RGroupDecomposition();
    protected RGroupTableModel model;
    protected JTable rGroupTable;
    protected int molCount = 0;
    protected int molSet = 0;
    protected int rowCount = 2;
    protected int columnCount = 2;
    protected ArrayList molFlag = new ArrayList();
    protected ArrayList nodes = new ArrayList();
    private ArrayList colorKeys = new ArrayList();
    Hashtable colorTable = new Hashtable();
    private ClusterViewer clusterViewer;
    private MouseMotionListener mml = null;
    private int activeRow = -1;
    private boolean[] enabledRGroups = null;

    public RGroupTablePanel(ClusterViewer clusterViewer) {
        this.initColorTable();
        this.clusterViewer = clusterViewer;
        this.model = new RGroupTableModel();
        this.rGroupTable = new JTable(this.model);
        this.rGroupTable.setAutoResizeMode(0);
        this.createMouseMotionListener();
        this.rGroupTable.addMouseMotionListener(this.mml);
        this.rGroupTable.setRowHeight(150);
        this.rGroupTable.setRowSelectionAllowed(false);
        MolRenderer molRenderer = new MolRenderer();
        this.rGroupTable.setDefaultRenderer(Molecule.class, molRenderer);
        JScrollPane scrollPane = new JScrollPane(this.rGroupTable);
        this.setLayout(new BorderLayout());
        this.add((Component)scrollPane, "Center");
    }

    public void onRemove() {
        this.rGroupTable.removeMouseMotionListener(this.mml);
        this.rGroupTable.setModel(null);
        this.clusterViewer = null;
        this.rGroupTable = null;
        this.clear();
        this.model = null;
    }

    private void initColorTable() {
        this.colorTable.put("0", Color.blue);
        this.colorTable.put("-", Color.lightGray);
        this.colorTable.put("1", new Color(255, 178, 0));
        this.colorTable.put("2", Color.green);
        this.colorTable.put("3", new Color(42, 181, 193));
        this.colorTable.put("4", Color.magenta);
        this.colorTable.put("5", new Color(39, 143, 36));
        this.colorTable.put("6", new Color(155, 144, 239));
        this.colorTable.put("7", new Color(155, 144, 7));
        this.colorTable.put("8", new Color(177, 45, 193));
        this.colorTable.put("9", new Color(222, 198, 56));
        this.colorTable.put("10", new Color(218, 148, 130));
        this.colorTable.put("11", new Color(204, 72, 76));
        this.colorTable.put("12", new Color(76, 76, 76));
        this.colorTable.put("empty", Color.red);
        this.colorTable.put("other", new Color(128, 128, 128));
    }

    public void clear() {
        this.columnCount = 2;
        this.enabledRGroups = null;
        this.nodes.clear();
        this.molFlag.clear();
        this.model.clear();
    }

    public void setMolCount(int i) {
        this.rowCount = this.molCount = i;
        this.columnCount = this.getColumnCount();
        this.model.set(this.rowCount, this.columnCount);
        this.setColumnWidths();
    }

    public void setColumnVisible(int c, boolean b) {
    }

    private int getColumnCount() {
        return this.columnCount;
    }

    public void setNode(int i, MBaseNode node, int flag) {
        this.nodes.add(i, node);
        Molecule structure = node.getMolecule();
        Molecule parent = this.getSelectedParentOfNode(node).getMolecule();
        this.model.setValueAt(structure, i, 0);
        this.decomposition(i, parent, structure);
        this.molFlag.add(i, new Integer(flag));
    }

    private MBaseNode getSelectedParentOfNode(MBaseNode n) {
        MBaseNode pn = n.getGraph().getUppermostSelectedCluster(n);
        return pn == n ? n.getGraph().getTopLevelCluster(n) : pn;
    }

    private boolean decomposition(int i, Molecule query, Molecule target) {
        try {
            this.decompositor.setQuery(query);
            this.decompositor.setTarget(target);
            Decomposition d = this.decompositor.findDecomposition();
            if (d == null) {
                return false;
            }
            d.color();
            Molecule mol = d.getTarget();
            Molecule rgMol = query.cloneMolecule();
            RGroupDecomposition.addRGroups(rgMol, 0);
            this.decompositor.setQuery(rgMol);
            Molecule rgTarget = target.cloneMolecule();
            rgTarget.valenceCheck();
            rgTarget.hydrogenize(true);
            this.decompositor.setTarget(rgTarget);
            d = this.decompositor.findDecomposition();
            if (d == null) {
                this.setRGroupedTarget(i, mol);
                return false;
            }
            d.color();
            rgTarget = d.getTarget();
            this.setRGroupedTarget(i, rgTarget);
            Molecule[] ligands = d.getLigands();
            int extraColumns = ligands.length - query.getAtomCount();
            if (this.columnCount < 2 + extraColumns) {
                this.columnCount = 2 + extraColumns;
                this.model.setColumnCount(this.columnCount);
                boolean[] enabledRs = new boolean[extraColumns];
                if (this.enabledRGroups != null) {
                    System.arraycopy(this.enabledRGroups, 0, enabledRs, 0, this.enabledRGroups.length);
                }
                this.enabledRGroups = enabledRs;
            }
            int molIndex = 2;
            for (int li = 0; li < ligands.length; ++li) {
                if (ligands[li] == null) continue;
                if (ligands[li].getAtomCount() > 1 || ligands[li].getAtom(0).getAtno() != 1) {
                    this.enabledRGroups[molIndex - 2] = true;
                }
                this.setMolecule(i, molIndex++, ligands[li]);
            }
            this.setColumnWidths();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private void setRGroupedTarget(int row, Molecule rgTarget) {
        int i;
        Molecule rgMol = new Molecule();
        ArrayList<Integer> rgaAtoms = new ArrayList<Integer>();
        ArrayList<Integer> rgbAtoms = new ArrayList<Integer>();
        for (int i2 = 0; i2 < rgTarget.getAtomCount(); ++i2) {
            if (rgTarget.getAtom(i2).getSetSeq() != 0) continue;
            int[][] ctab = rgTarget.getCtab();
            for (int j = 0; j < ctab[i2].length; ++j) {
                int n = ctab[i2][j];
                if (rgTarget.getAtom(n).getAtno() == 1 || rgTarget.getAtom(n).getSetSeq() == 0) continue;
                rgaAtoms.add(new Integer(i2));
                rgbAtoms.add(new Integer(n));
            }
        }
        MolAtom[] ma = new MolAtom[rgTarget.getAtomCount()];
        for (int i3 = 0; i3 < rgTarget.getAtomCount(); ++i3) {
            MolAtom at = rgTarget.getAtom(i3);
            if (at.getSetSeq() != 0) continue;
            ma[i3] = new MolAtom(at.getAtno(), at.getX(), at.getY(), at.getZ());
            rgMol.add(ma[i3]);
        }
        BondTable btab = rgTarget.getBondTable();
        for (int i4 = 0; i4 < rgTarget.getAtomCount(); ++i4) {
            if (rgTarget.getAtom(i4).getSetSeq() != 0) continue;
            for (int j = 0; j < i4; ++j) {
                if (rgTarget.getAtom(j).getSetSeq() != 0 || btab.getBondIndex(i4, j) == -1) continue;
                rgMol.add(new MolBond(ma[i4], ma[j], rgTarget.getBond(btab.getBondIndex(i4, j)).getFlags()));
            }
        }
        String rgString = "";
        for (i = 0; i < rgMol.getAtomCount(); ++i) {
            rgString = rgString + (i > 0 ? ";0" : "0");
        }
        for (i = 0; i < rgaAtoms.size(); ++i) {
            int atomIndex = (Integer)rgbAtoms.get(i);
            MolAtom oN = rgTarget.getAtom(atomIndex);
            MolAtom a = new MolAtom(134, oN.getX(), oN.getY(), oN.getZ());
            int seq = rgTarget.getAtom(atomIndex).getSetSeq();
            a.setRgroup(seq == 0 ? 0 : seq - 1);
            rgString = rgString + ";";
            rgString = rgString + (seq == 0 ? "-" : "" + (seq - 1));
            rgMol.add(a);
            MolAtom scA = ma[(Integer)rgaAtoms.get(i)];
            rgMol.add(new MolBond(scA, a, 1));
        }
        rgMol.setProperty("DMAP", rgString);
        this.setMolecule(row, 1, rgMol);
    }

    private void setColumnWidths() {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (i >= 2 && !this.enabledRGroups[i - 2]) {
                this.rGroupTable.getColumnModel().getColumn(i).setPreferredWidth(25);
                continue;
            }
            this.rGroupTable.getColumnModel().getColumn(i).setPreferredWidth(100);
        }
    }

    public void setMolecule(int r, int c, Molecule m) {
        this.model.setValueAt(m, r, c);
        this.colorMolecule(m, m.getProperty("DMAP"));
    }

    private boolean colorMolecule(Molecule mol, String symbols) {
        boolean changed = false;
        if (symbols == null) {
            return changed;
        }
        StringTokenizer st = new StringTokenizer(symbols, ";", true);
        ArrayList<String> atoms = new ArrayList<String>();
        boolean lastWasDelim = true;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equals(";")) {
                if (lastWasDelim) {
                    atoms.add("");
                }
                lastWasDelim = true;
                continue;
            }
            lastWasDelim = false;
            atoms.add(token);
        }
        if (lastWasDelim) {
            atoms.add("");
        }
        if (atoms.size() != mol.getAtomCount()) {
            System.err.println("Warning : Property count (" + atoms.size() + ") and " + "molecule atom count (" + mol.getAtomCount() + ") mismatch.");
        } else {
            for (int x = 0; x < atoms.size(); ++x) {
                String atomSt = (String)atoms.get(x);
                if (atomSt.length() <= 0) continue;
                String newAtomSt = RGroupTablePanel.orderTokens(atomSt, "/");
                atoms.set(x, newAtomSt);
                int num = this.colorKeys.indexOf(newAtomSt);
                if (num != -1) {
                    mol.getAtom(x).setSetSeq(num + 1);
                } else {
                    mol.getAtom(x).setSetSeq(63);
                }
                changed = true;
            }
        }
        return changed;
    }

    private static String orderTokens(String input, String delimiter) {
        if (delimiter == null) {
            return null;
        }
        if (delimiter.length() == 0) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(input, delimiter.substring(0, 1));
        ArrayList<String> list = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        Collections.sort(list);
        String newSt = "";
        for (int y = 0; y < list.size(); ++y) {
            if (y > 0) {
                newSt = newSt + delimiter;
            }
            newSt = newSt + (String)list.get(y);
        }
        return newSt;
    }

    private void createMouseMotionListener() {
        this.mml = new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                if (RGroupTablePanel.this.clusterViewer == null) {
                    return;
                }
                int r = RGroupTablePanel.this.rGroupTable.rowAtPoint(e.getPoint());
                if (r != RGroupTablePanel.this.activeRow) {
                    RGroupTablePanel.this.activeRow = r;
                    MBaseNode node = (MBaseNode)RGroupTablePanel.this.nodes.get(RGroupTablePanel.this.activeRow);
                    RGroupTablePanel.this.clusterViewer.setActiveNode(node);
                }
            }
        };
    }

    class MolRenderer
    extends JPanel
    implements TableCellRenderer {
        private MolPrinter printer = new MolPrinter();
        private Dimension size = new Dimension();
        private Rectangle bounds = new Rectangle();
        private int[] setColorRGB;

        public MolRenderer() {
            this.printer.setImplicitH("off");
            this.setColorRGB = new int[64];
            Enumeration e = RGroupTablePanel.this.colorTable.keys();
            int i = 1;
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                Color color = (Color)RGroupTablePanel.this.colorTable.get(key);
                if (key.equals("other")) {
                    this.setColorRGB[63] = color.getRGB();
                    continue;
                }
                if (key.equals("empty")) {
                    this.setColorRGB[0] = color.getRGB();
                    continue;
                }
                this.setColorRGB[i++] = color.getRGB();
                RGroupTablePanel.this.colorKeys.add(RGroupTablePanel.orderTokens(key, "/"));
            }
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            boolean setColoringEnabled;
            Molecule m = (Molecule)value;
            if (m == null || m.getAtomCount() == 0) {
                return null;
            }
            boolean bl = setColoringEnabled = column != 0;
            if (setColoringEnabled) {
                MDocument doc = m.getDocument();
                if (doc == null) {
                    doc = new MDocument(m);
                }
                for (int i = 0; i < this.setColorRGB.length; ++i) {
                    doc.setAtomSetRGB(i, this.setColorRGB[i]);
                }
                this.printer.setDoc(doc);
            } else {
                this.printer.setMol(m);
            }
            this.printer.setSetColoringEnabled(setColoringEnabled);
            int f = (Integer)RGroupTablePanel.this.molFlag.get(row);
            try {
                if (f == 0) {
                    this.printer.setBackgroundColor(MViewTablePanel.topLevelColor);
                } else if (f == 1) {
                    this.printer.setBackgroundColor(MViewTablePanel.innerLevelColor);
                } else {
                    this.printer.setBackgroundColor(Color.WHITE);
                }
            }
            catch (IndexOutOfBoundsException ie) {
                this.printer.setBackgroundColor(Color.WHITE);
            }
            return this;
        }

        @Override
        protected void paintComponent(Graphics g) {
            this.bounds.setSize(this.getSize(this.size));
            double scale = this.printer.maxScale(this.size);
            if (scale > 28.0) {
                scale = 28.0;
            }
            this.printer.setScale(scale);
            this.printer.paint(g, this.bounds);
        }
    }

    class RGroupTableModel
    extends AbstractTableModel {
        Object[] data = new Object[0];
        int rc = 0;
        int cc = 0;

        RGroupTableModel() {
        }

        public void setColumnCount(int c) {
            Object[] newData = new Object[this.rc * c];
            for (int i = 0; i < this.rc; ++i) {
                for (int j = 0; j < this.cc; ++j) {
                    newData[i * c + j] = this.data[i * this.cc + j];
                }
            }
            this.data = newData;
            this.cc = c;
            this.fireTableStructureChanged();
        }

        @Override
        public int getColumnCount() {
            return this.cc;
        }

        @Override
        public int getRowCount() {
            return this.rc;
        }

        @Override
        public String getColumnName(int col) {
            String s = "";
            switch (col) {
                case 0: {
                    s = s + "Structure";
                    break;
                }
                case 1: {
                    s = s + "Scaffold";
                    break;
                }
                default: {
                    s = s + "R" + (col - 2 + 1);
                }
            }
            return s;
        }

        public void clear() {
            this.data = null;
            this.fireTableStructureChanged();
        }

        public void set(int rc, int cc) {
            this.rc = rc;
            this.cc = cc;
            if (this.data == null) {
                this.data = new Object[rc * cc];
            }
            this.fireTableStructureChanged();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (rowIndex * this.cc + columnIndex < 0) {
                return null;
            }
            if (rowIndex * this.cc + columnIndex >= this.data.length) {
                return null;
            }
            return this.data[rowIndex * this.cc + columnIndex];
        }

        public Class getColumnClass(int c) {
            return Molecule.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            this.data[row * this.cc + col] = value;
            this.fireTableCellUpdated(row, col);
        }

        public void setValueAt(Object value, int idx) {
            this.setValueAt(value, idx, 0);
        }
    }
}

