/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering.gui.component;

import chemaxon.clustering.gui.component.ChartPanel;
import chemaxon.clustering.gui.component.TreeRenderer;
import chemaxon.clustering.gui.component.TreeTable;
import chemaxon.marvin.beans.MViewPane;
import java.awt.Component;
import java.awt.Cursor;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;

public class TreeTableEditorFactory {
    TreeTable treeTable = null;

    public TreeTableEditorFactory(TreeTable table) {
        this.treeTable = table;
        this.setEditors();
    }

    public void onRemove() {
        this.treeTable.setDefaultEditor(TreeRenderer.class, null);
        this.treeTable.setDefaultEditor(MViewPane.class, null);
        this.treeTable.setDefaultEditor(String.class, null);
        this.treeTable.setDefaultEditor(ChartPanel.class, null);
    }

    public void setTreeEditor(TreeRenderer tree) {
        this.treeTable.setDefaultEditor(TreeRenderer.class, new TreeEditor(tree));
    }

    public TableCellEditor getEditor(Class c) {
        TableCellEditor editor = null;
        if (!c.equals(TreeRenderer.class) && c.equals(ChartPanel.class)) {
            return new ChartPanelEditor();
        }
        return editor;
    }

    private void setEditors() {
        this.treeTable.setDefaultEditor(MViewPane.class, new MViewPaneEditor());
        this.treeTable.setDefaultEditor(String.class, null);
        this.treeTable.setDefaultEditor(ChartPanel.class, new ChartPanelEditor());
    }

    public class MViewPaneEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
            if (table.getCursor() == Cursor.getPredefinedCursor(9)) {
                return null;
            }
            return (MViewPane)value;
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }
    }

    public class ChartPanelEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
            if (table.getCursor() == Cursor.getPredefinedCursor(9)) {
                return null;
            }
            return (ChartPanel)value;
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }
    }

    public class TreeEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        protected TreeRenderer renderer;

        public TreeEditor(TreeRenderer cellRenderer) {
            this.renderer = cellRenderer;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
            if (table.getCursor() == Cursor.getPredefinedCursor(9)) {
                return null;
            }
            table.repaint();
            this.renderer.setEditedRow(row);
            return this.renderer;
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }
    }
}

