/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering.gui.component;

import chemaxon.clustering.MGraph;
import chemaxon.clustering.gui.component.ChartPanel;
import chemaxon.clustering.gui.component.ClusterViewer;
import chemaxon.clustering.gui.component.TreeRenderer;
import chemaxon.clustering.gui.component.TreeTable;
import chemaxon.marvin.beans.MViewPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class TreeTableRendererFactory {
    TreeTable treeTable = null;

    public TreeTableRendererFactory(TreeTable table) {
        this.treeTable = table;
        this.setRenderers();
    }

    public void onRemove() {
        this.treeTable.setDefaultRenderer(TreeRenderer.class, null);
        this.treeTable.setDefaultRenderer(MViewPane.class, null);
        this.treeTable.setDefaultRenderer(String.class, null);
        this.treeTable.setDefaultRenderer(ChartPanel.class, null);
        this.treeTable = null;
    }

    public void setTreeRenderer(TreeRenderer tree) {
        this.treeTable.setDefaultRenderer(TreeRenderer.class, tree);
    }

    public void setCompoundCountRenderer(MGraph g, boolean stringOnly) {
        if (stringOnly) {
            this.treeTable.getColumnModel().getColumn(1).setCellRenderer(this.treeTable.getDefaultRenderer(String.class));
        } else {
            int max = 0;
            for (int i = 0; i < g.getTopLevelClusterCount(); ++i) {
                int c = g.getTopLevelCluster(i).getLeafNodeCount();
                if (c <= max) continue;
                max = c;
            }
            JCompoundPanel cp = new JCompoundPanel();
            cp.setMaxValue(max);
            this.treeTable.getColumnModel().getColumn(1).setCellRenderer(cp);
        }
    }

    private void setRenderers() {
        this.treeTable.setDefaultRenderer(MViewPane.class, new MViewPaneRenderer());
        this.treeTable.setDefaultRenderer(String.class, new StringRenderer());
        this.treeTable.setDefaultRenderer(ChartPanel.class, ChartPanel.getMChartPanelCellRenderer());
    }

    public TableCellRenderer getRenderer(Class c) {
        TableCellRenderer renderer = null;
        if (c.equals(String.class)) {
            return new StringRenderer();
        }
        if (!c.equals(TreeRenderer.class)) {
            if (c.equals(MViewPane.class)) {
                return new MViewPaneRenderer();
            }
            if (c.equals(ChartPanel.class)) {
                // empty if block
            }
        }
        return renderer;
    }

    class JCompoundPanel
    extends JPanel
    implements TableCellRenderer {
        int max;
        int c;

        public JCompoundPanel() {
            this.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 1, TreeTableRendererFactory.this.treeTable.getGridColor()));
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.c != 1) {
                int x = this.getWidth() < 40 ? 3 : 10;
                int y = this.getHeight() < 20 ? 3 : (this.getHeight() - 20) / 2;
                int w = this.getWidth() - 2 * x;
                g.drawRect(x - 1, y - 1, w + 1, this.getHeight() - 2 * y + 1);
                g.setColor(Color.white);
                g.fillRect(x, y, w, this.getHeight() - 2 * y);
                g.setColor(ClusterViewer.MARK_COLOR);
                if (this.max != 0) {
                    w = (int)((float)w * ((float)this.c / (float)this.max));
                }
                g.fillRect(x, y, w, this.getHeight() - 2 * y);
                g.setColor(Color.black);
            }
            int l = (this.getWidth() - g.getFontMetrics().stringWidth("" + this.c)) / 2;
            int h = (this.getHeight() + g.getFontMetrics().getHeight() / 2) / 2;
            g.drawString("" + this.c, l, h);
        }

        private void setValue(int c) {
            this.c = c;
        }

        public void setMaxValue(int max) {
            this.max = max;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            this.setValue(Integer.parseInt((String)value));
            return this;
        }
    }

    class StringRenderer
    extends DefaultTableCellRenderer {
        public StringRenderer() {
            this.setHorizontalAlignment(0);
            noFocusBorder = BorderFactory.createMatteBorder(0, 0, 1, 1, TreeTableRendererFactory.this.treeTable.getGridColor());
        }
    }

    public class MViewPaneRenderer
    extends MViewPane
    implements TableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            ((MViewPane)value).setBorder(BorderFactory.createMatteBorder(0, 0, 1, 1, table.getGridColor()));
            return (MViewPane)value;
        }
    }
}

