/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering.gui.component;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.event.MouseInputListener;

public class TreeTableResizer
implements MouseInputListener {
    private static final int SENSITY = 5;
    private static Cursor resizeCursor = Cursor.getPredefinedCursor(9);
    private JTable table;
    private boolean dragging;
    private boolean rowSelectionAllowed;
    private int row;
    private int startY;
    private int startHeight;
    private Cursor lastCursor;

    public TreeTableResizer(JTable t) {
        this.table = t;
        this.table.addMouseListener(this);
        this.table.addMouseMotionListener(this);
        this.row = -1;
    }

    public void unregister() {
        this.table.removeMouseListener(this);
        this.table.removeMouseMotionListener(this);
        this.table = null;
    }

    @Override
    public void mouseClicked(MouseEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }

    public void removeListener() {
        if (this.table == null) {
            return;
        }
        this.table.removeMouseListener(this);
        this.table.removeMouseMotionListener(this);
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        if (this.isMouseOverRowMargin(event.getPoint())) {
            if (this.lastCursor == null) {
                this.lastCursor = this.table.getCursor();
            }
            this.table.setCursor(resizeCursor);
        } else {
            this.table.setCursor(this.lastCursor);
        }
    }

    @Override
    public void mousePressed(MouseEvent event) {
        if (this.isMouseOverRowMargin(event.getPoint())) {
            this.dragging = true;
            this.startY = event.getPoint().y;
            this.startHeight = this.table.getRowHeight(this.row);
            this.rowSelectionAllowed = this.table.getRowSelectionAllowed();
            this.table.setRowSelectionAllowed(false);
        }
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        if (!this.dragging) {
            return;
        }
        int newHeight = this.startHeight + event.getY() - this.startY;
        if (newHeight < 1) {
            newHeight = 1;
        }
        this.table.setRowHeight(this.row, newHeight);
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        if (!this.dragging) {
            return;
        }
        this.table.setRowSelectionAllowed(this.rowSelectionAllowed);
        this.dragging = false;
        this.row = -1;
    }

    private boolean isMouseOverRowMargin(Point p) {
        if (!this.table.isEnabled()) {
            return false;
        }
        this.row = this.table.rowAtPoint(p);
        int column = this.table.columnAtPoint(p);
        if (this.row == -1 || column == -1) {
            return false;
        }
        Rectangle r = this.table.getCellRect(this.row, column, true);
        return p.y >= r.y + r.height - 5;
    }
}

