/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering.scaffolding.logging;

import java.util.Vector;
import org.apache.commons.logging.Log;

public class LogHistory
implements Log {
    private Log base = null;
    private Vector store;

    private synchronized void addToStore(Object arg0, Throwable arg1) {
        this.store.add(new Long(System.currentTimeMillis()));
        this.store.add(arg0);
        this.store.add(arg1);
    }

    private void addToStore(Object arg0) {
        this.addToStore(arg0, null);
    }

    public synchronized String toString() {
        try {
            long ct = 0L;
            StringBuffer ret = new StringBuffer();
            ret.append("LogHistory:\n");
            int i = 0;
            block2: while (i < this.store.size()) {
                Throwable tt;
                long time = (Long)this.store.get(i++);
                if (ct == 0L) {
                    ct = time;
                }
                long ms = (time -= ct) % 1000L;
                long sec = time / 1000L % 60L;
                long min = time / 60000L;
                ret.append(String.format("%5d:%02d.%03d ", new Long(min), new Long(sec), new Long(ms)));
                Object o = this.store.get(i++);
                if (o == null) {
                    ret.append("null");
                } else {
                    String s = o.toString();
                    ret.append(s);
                }
                if (i == 2) {
                    ret.append(" (");
                    ret.append(ct);
                    ret.append(")");
                }
                ret.append("\n");
                if ((tt = (Throwable)this.store.get(i++)) == null) continue;
                StackTraceElement[] str = tt.getStackTrace();
                for (int j = 0; j < str.length; ++j) {
                    ret.append("          ");
                    ret.append(str[j].getClassName());
                    ret.append(".");
                    ret.append(str[j].getMethodName());
                    ret.append("(");
                    ret.append(str[j].getFileName());
                    ret.append(":");
                    ret.append(str[j].getLineNumber());
                    ret.append(")\n");
                    if (!str[j].getClassName().startsWith("java.") && !str[j].getClassName().startsWith("javax.")) continue;
                    ret.append("          ... " + (str.length - j - 1) + " more\n");
                    continue block2;
                }
            }
            return ret.toString();
        }
        catch (Exception e) {
            if (this.base.isErrorEnabled()) {
                this.base.error((Object)"Exception in LogHistory", (Throwable)e);
                if (this.store != null) {
                    for (int i = 0; i < this.store.size(); ++i) {
                        Object o = this.store.get(i);
                        if (o == null) {
                            this.base.error((Object)("Store(" + i + ") is null"));
                            continue;
                        }
                        this.base.error((Object)("Store(" + i + ") is " + o + " (" + o.getClass().toString() + ")"));
                    }
                }
            }
            return "Error.";
        }
    }

    public LogHistory(Log base, String name, boolean storeCreationStacktrace) {
        this.base = base;
        this.store = new Vector();
        this.addToStore(name, storeCreationStacktrace ? new Throwable().fillInStackTrace() : null);
    }

    public void debug(Object arg0) {
        this.base.debug(arg0);
        this.addToStore(arg0);
    }

    public void debug(Object arg0, Throwable arg1) {
        this.base.debug(arg0, arg1);
    }

    public void error(Object arg0) {
        this.base.error(arg0);
        this.addToStore(arg0);
    }

    public void error(Object arg0, Throwable arg1) {
        this.base.error(arg0, arg1);
        this.addToStore(arg0, arg1);
    }

    public void fatal(Object arg0) {
        this.base.fatal(arg0);
        this.addToStore(arg0);
    }

    public void fatal(Object arg0, Throwable arg1) {
        this.base.fatal(arg0);
        this.addToStore(arg0, arg1);
    }

    public void info(Object arg0) {
        this.base.info(arg0);
        this.addToStore(arg0);
    }

    public void info(Object arg0, Throwable arg1) {
        this.base.info(arg0, arg1);
        this.addToStore(arg0, arg1);
    }

    public boolean isDebugEnabled() {
        return this.base.isDebugEnabled();
    }

    public boolean isErrorEnabled() {
        return this.base.isErrorEnabled();
    }

    public boolean isFatalEnabled() {
        return this.base.isFatalEnabled();
    }

    public boolean isInfoEnabled() {
        return this.base.isInfoEnabled();
    }

    public boolean isTraceEnabled() {
        return this.base.isTraceEnabled();
    }

    public boolean isWarnEnabled() {
        return this.base.isWarnEnabled();
    }

    public void trace(Object arg0) {
        this.base.trace(arg0);
        this.addToStore(arg0);
    }

    public void trace(Object arg0, Throwable arg1) {
        this.base.trace(arg0, arg1);
        this.addToStore(arg0, arg1);
    }

    public void warn(Object arg0) {
        this.base.warn(arg0);
        this.addToStore(arg0);
    }

    public void warn(Object arg0, Throwable arg1) {
        this.base.warn(arg0, arg1);
        this.addToStore(arg0, arg1);
    }
}

