/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering.server;

import chemaxon.clustering.server.Server;
import chemaxon.clustering.tools.simplexml.create.HTMLCreator;
import chemaxon.clustering.tools.simplexml.create.PrinterPrintWriter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServerConnection
extends Thread {
    Log log = LogFactory.getLog(ServerConnection.class);
    Server srv;
    Socket sock = null;
    Server.Request request = null;
    Server.Response response = null;

    public ServerConnection(Server srv, Socket sock) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"ServerConnection constructed.");
        }
        this.setPriority(4);
        this.srv = srv;
        this.sock = sock;
    }

    public ServerConnection(Server srv) {
        this.srv = srv;
    }

    public Server.LinkTransformer getTLink() {
        return this.srv.getTlink();
    }

    public Server.LinkTransformer getTPLink() {
        return this.srv.getTPageLink();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.sock == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"No socket given.");
            }
            return;
        }
        Server.Response resp = null;
        try {
            Server.RequestFromSocket requ = new Server.RequestFromSocket(this.sock);
            resp = new Server.ResponseFromSocket(this.sock);
            this.process(requ, resp);
        }
        catch (Exception e) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Exception in run(): " + e.getMessage()), (Throwable)e);
            }
        }
        finally {
            if (resp != null) {
                resp.close();
            }
        }
    }

    public void process(Server.Request request, Server.Response response) {
        block10: {
            this.request = request;
            this.response = response;
            try {
                if (request.isGet() || request.isHead()) {
                    if (request.getRequestURI().equals("") && this.srv.emptyRedirect != null) {
                        response.sendRedirect(this.srv.getTPageLink().encode(this.srv.emptyRedirect));
                        return;
                    }
                    Server.StaticMap.MapResult mf = this.srv.getStaticMapping(request.getRequestURI());
                    if (mf != null) {
                        InputStream is;
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)("Requested " + mf.mapped));
                        }
                        if ((is = this.getClass().getResourceAsStream(mf.mapped)) == null) {
                            response.sendError(404, "File not found: " + mf.mapped);
                            return;
                        }
                        String contentType = null;
                        contentType = request.getRequestURI().endsWith(".htm") || request.getRequestURI().endsWith(".html") ? "text/html" : "text/plain";
                        this.respondStream(contentType, is, mf.processor, (Server.Session)mf.session, request, response);
                        return;
                    }
                    Server.Action a = this.srv.getStaticAction(request.getRequestURI());
                    if (a != null) {
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)("Action found: " + a.toString()));
                        }
                        a.execute(this);
                        response.close();
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)"Action returned but not closed");
                        }
                        return;
                    }
                }
                response.sendError(404, "404 Not Found request: " + request.getRequestURI());
            }
            catch (Exception e) {
                if (!this.log.isErrorEnabled()) break block10;
                this.log.error((Object)("Exception in run(): " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public void respondHTMLFull(String content) {
        this.respondHTMLFull(content, this.request, this.response);
    }

    public HTMLCreator respondHTMLCreator(String title) {
        return this.respondHTML(title, this.request, this.response);
    }

    public void respondHTMLFull(Object content, Server.Request rq, Server.Response rs) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Respond HTML content. headOnly: " + rq.isHead()));
        }
        rs.setContentType("text/html");
        if (!rq.isHead()) {
            rs.getWriter().print(content.toString());
        }
        rs.close();
    }

    public void respondGeneric(String contentType, Object content) {
        this.respond(contentType, content, this.request, this.response);
    }

    public void respond(String contentType, Object content, Server.Request rq, Server.Response rs) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Respond " + contentType + " headOnly: " + rq.isHead()));
        }
        rs.setContentType(contentType);
        if (!rq.isHead()) {
            rs.getWriter().print(content.toString());
        }
        rs.close();
    }

    public void respondError(int code, String msg) {
        this.response.sendError(code, msg);
    }

    public void respondByteArray(String contentType, byte[] data) throws IOException {
        this.respondByteArray(contentType, data, this.request, this.response);
    }

    public void respondByteArray(String contentType, byte[] data, Server.Request req, Server.Response resp) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Respond contentType: " + contentType + " headOnly: " + req.isHead()));
        }
        resp.setContentType(contentType);
        if (!req.isHead()) {
            resp.getOutputStream().write(data);
        }
        resp.close();
    }

    void respondStream(String contentType, InputStream is, Server.TextProcessor proc, Server.Session s, Server.Request req, Server.Response resp) throws IOException {
        block6: {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Respond contentType: " + contentType + " headOnly: " + req.isHead()));
            }
            resp.setContentType(contentType);
            if (!req.isHead()) {
                if (proc == null) {
                    OutputStream os = resp.getOutputStream();
                    byte[] buff = new byte[10000];
                    int n = 0;
                    while (true) {
                        int rc;
                        if ((rc = is.read(buff)) < 0) {
                            if (this.log.isTraceEnabled()) {
                                this.log.trace((Object)("EOF; read and sent " + n + " bytes"));
                            }
                            break block6;
                        }
                        os.write(buff, 0, rc);
                        n += rc;
                    }
                }
                BufferedReader r = new BufferedReader(new InputStreamReader(is));
                PrinterPrintWriter p = new PrinterPrintWriter(resp.getWriter());
                proc.process(r, p, s);
                r.close();
            }
        }
        resp.close();
    }

    public HTMLCreator respondHTML(String title, Server.Request req, final Server.Response resp) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Respond HTML content. headOnly: " + req.isHead()));
        }
        resp.setContentType("text/html");
        if (req.isHead()) {
            resp.close();
            return null;
        }
        HTMLCreator htmlco = new HTMLCreator(title, this.srv.getTlink().encode("/static/style.css"), new PrinterPrintWriter(resp.getWriter())){

            @Override
            public void closed() {
                super.closed();
                if (ServerConnection.this.log.isTraceEnabled()) {
                    ServerConnection.this.log.trace((Object)"closed() called in HTMLCreator");
                }
                resp.close();
            }
        };
        return htmlco;
    }
}

