/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering.server.clustorServer;

import chemaxon.clustering.backend.Clustor;
import chemaxon.clustering.backend.Entity;
import chemaxon.clustering.backend.EntityGroup;
import chemaxon.clustering.backend.EntityProperties;
import chemaxon.clustering.backend.HC;
import chemaxon.clustering.backend.HierarchicEntityGroup;
import chemaxon.clustering.backend.TreeNodeEntityGroup;
import chemaxon.clustering.backend.oa.ChemFormatFactory;
import chemaxon.clustering.backend.oa.OAWrStat;
import chemaxon.clustering.boundary.CDescriptor;
import chemaxon.clustering.boundary.ComparableDescriptor;
import chemaxon.clustering.server.Server;
import chemaxon.clustering.server.ServerConnection;
import chemaxon.clustering.server.clustorServer.GroupCache;
import chemaxon.clustering.tools.simplexml.create.HTMLCreator;
import chemaxon.clustering.util.IntStat;
import chemaxon.clustering.util.RAIterator;
import chemaxon.common.util.IntVector;
import chemaxon.formats.MolImporter;
import chemaxon.marvin.modelling.TextUtils;
import chemaxon.struc.Molecule;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URLEncoder;
import javax.imageio.ImageIO;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CS
implements Server.NewSessionCallback<CSSession> {
    Log log = LogFactory.getLog(CS.class);
    Server srv = new Server<CSSession>(this);
    Clustor clus;
    ChemFormatFactory cff;
    OAWrStat oawrstat = null;
    ShowMatrix showmatrix;
    ShowSingleStructure showsinglestructure;
    GroupCache gc;

    public CS(ChemFormatFactory cff, Clustor clus) throws IOException {
        this.clus = clus;
        this.cff = cff;
        this.gc = new GroupCache(clus.getHC());
        this.srv.setEmptyRedirect("/show/overview");
        this.srv.setStaticAction("show/overview", new Overview());
        this.srv.setStaticAction("show/stat", new ShowStatistics());
        this.srv.setStaticAction("show/clusters", new ShowClusterImages());
        this.showmatrix = new ShowMatrix();
        this.srv.setStaticAction("show/matrix", this.showmatrix);
        this.srv.setStaticAction("show/singlecluster", new ShowSingleCluster());
        this.showsinglestructure = new ShowSingleStructure();
        this.srv.setStaticAction("show/singlestructure", this.showsinglestructure);
        this.srv.setStaticAction("get/cluster/png", new GetClusterReprImage());
        this.srv.setStaticAction("get/cluster/smiles", new GetClusterReprSmiles());
        this.srv.setStaticAction("get/allclusters/smiles", new GetAllClusterRepresentants());
        this.srv.setStaticAction("get/cluster/leavessmiles", new GetClusterMembersSmiles());
        this.srv.setStaticAction("get/leave/png", new GetLeaveImage());
        this.srv.setStaticAction("get/leave/smiles", new GetLeaveSmiles());
        this.srv.setStaticAction("generate/barimage", new GenerateBarImage());
    }

    public Server getServer() {
        return this.srv;
    }

    String tpl(String l) {
        return this.srv.getTPageLink().encode(l);
    }

    String tl(String l) {
        return this.srv.getTlink().encode(l);
    }

    @Override
    public CSSession initSession(Server server) {
        return new CSSession(server);
    }

    public synchronized OAWrStat getStat() {
        if (this.oawrstat == null) {
            this.oawrstat = new OAWrStat(2);
            this.oawrstat.calc(this.clus);
        }
        return this.oawrstat;
    }

    public String getPageLinks(Server.Action a, Server.Action.IParamDescriptor p, int size, int count) {
        return this.getPageLinks(a, p, size, count, "&nbsp;");
    }

    public String getPageLinks(Server.Action a, Server.Action.IParamDescriptor p, int size, int count, String sep) {
        StringBuffer seek = new StringBuffer();
        seek.append("<center>");
        int s = p.getCurrentValue();
        if (s > 0) {
            seek.append("<a href=\"" + p.getChangedLink(a, 0) + "\">" + this.getIconImage("first16.png") + "</a>");
            seek.append(sep);
        }
        if (s > size) {
            seek.append("<a href=\"" + p.getChangedLink(a, s - size) + "\">" + this.getIconImage("previous16.png") + "</a>");
            seek.append(sep);
        }
        int tmps = 0;
        int i = 0;
        while (i < 4) {
            if (tmps < s) {
                seek.append("<a href=\"" + p.getChangedLink(a, tmps) + "\">" + (tmps + 1) + "-" + (tmps + size) + "</a>");
                seek.append(sep);
            }
            ++i;
            tmps += size;
        }
        tmps = s - size * 2;
        i = 0;
        while (i < 5) {
            if (!(tmps < s && tmps <= size * 4 || tmps > s && tmps >= count - size * 4)) {
                if (i == 2) {
                    seek.append("<b>" + (tmps + 1) + "-" + Math.min(tmps + size, count) + "</b>");
                    seek.append(sep);
                } else {
                    seek.append("<a href=\"" + p.getChangedLink(a, tmps) + "\">" + (tmps + 1) + "-" + (tmps + size) + "</a>");
                    seek.append(sep);
                }
            }
            ++i;
            tmps += size;
        }
        tmps = count - size * 4;
        i = 0;
        while (i < 4) {
            if (tmps > s) {
                seek.append("<a href=\"" + p.getChangedLink(a, tmps) + "\">" + (tmps + 1) + "-" + (tmps + size) + "</a>");
                seek.append(sep);
            }
            ++i;
            tmps += size;
        }
        if (s + size < count - size) {
            seek.append("<a href=\"" + p.getChangedLink(a, s + size) + "\">" + this.getIconImage("next16.png") + "</a>");
            seek.append(sep);
        }
        if (count - size > s) {
            seek.append("<a href=\"" + p.getChangedLink(a, count - size) + "\">" + this.getIconImage("last16.png") + "</a>");
            seek.append(sep);
        }
        seek.append("</center>");
        return seek.toString();
    }

    String getIconImage(String name) {
        return CS.getIconImage(name, this.srv.getTlink());
    }

    static String getIconImage(String name, Server.LinkTransformer t) {
        return "<img src=\"" + t.encode("/static/icons/" + name) + "\" border=\"0\" style=\"vertical-align:middle;\"/>";
    }

    String getIconImage(String name, String alt) {
        return CS.getIconImage(name, alt, this.srv.getTlink());
    }

    static String getIconImage(String name, String alt, Server.LinkTransformer t) {
        return CS.getIconImage(name, alt, alt, t);
    }

    static String getIconImage(String name, String alt, String title, Server.LinkTransformer t) {
        return "<img src=\"" + t.encode("/static/icons/" + name) + "\" border=\"0\" style=\"vertical-align:middle;\" alt=\"" + alt + "\" title=\"" + title + "\"/>";
    }

    void appendHeader(HTMLCreator p, Server.Action a) {
        p.text("<div id=\"headerimg\"><A HREF=\"http://chemaxon.com\"><img src=\"" + this.tl("/static/1-powered_100px.gif") + "\" border=\"0\"/></A>" + "</div>" + "<div id=\"header\">" + ((Server.Session)a.getSession()).fontSizeChangeLinks(a) + "&nbsp;" + "<A HREF=\"" + this.tpl("/show/overview") + "\">Overview</A>&nbsp;|&nbsp;" + "<A HREF=\"" + this.tpl("/show/stat") + "\">Statistics</A>&nbsp;|&nbsp;" + "<A HREF=\"" + this.tpl("/show/clusters") + "\">Clusters</A>&nbsp;|&nbsp;" + "<A HREF=\"" + this.tpl("/show/matrix") + "\">Matrix</A>&nbsp;|&nbsp;" + "<A HREF=\"" + this.tpl("/exit") + "\">Exit</A><BR>" + "</div>");
    }

    public static String makeWrappable(String s) {
        if (s.indexOf(9) >= 0) {
            return s.replace('\t', ' ');
        }
        if (s.indexOf(124) >= 0) {
            return s.replaceAll("\\|", "\\ \\|\\ ");
        }
        return s;
    }

    public void appendStat(HTMLCreator c) {
        int i;
        OAWrStat stat = this.getStat();
        c.h2("Statistics");
        HTMLCreator.TablePrinter t = c.table();
        HTMLCreator.TableRow r = t.row();
        r.hcell(HTMLCreator.HAlign.center, "Structure count");
        r.cell(HTMLCreator.HAlign.right, "" + stat.stct);
        r = t.row();
        r.hcell(HTMLCreator.HAlign.center, "Clustering level count");
        r.cell(HTMLCreator.HAlign.right, "" + stat.levelCount);
        t.close();
        t = c.table();
        r = t.row();
        r.cell("");
        for (i = 0; i < stat.levelCount; ++i) {
            String ll = "Level " + (i + 1);
            if (i + 1 == stat.preferredLevel) {
                ll = "* " + ll + " *";
            }
            r.hcell(3, 1, HTMLCreator.HAlign.center, ll);
        }
        r = t.row();
        r.hcell(HTMLCreator.HAlign.center, "Total cluster count (including singletons)");
        for (i = 0; i < stat.levelCount; ++i) {
            r.cell(HTMLCreator.HAlign.right, "" + stat.cc[i]);
            r.cell(HTMLCreator.HAlign.center, "<a href=\"" + this.tpl("/show/clusters?mode=0&level=" + (i + 1)) + "\">" + this.getIconImage("eye16.png", "View clusters") + "</a>");
            r.cell(HTMLCreator.HAlign.center, "<a href=\"" + this.tl("/get/allclusters/smiles?type=0&level=" + (i + 1)) + "\">" + this.getIconImage("save16.png", "Download cluster representants") + "</a>");
        }
        r = t.row();
        r.hcell(HTMLCreator.HAlign.center, "Singleton cluster (structure) count");
        for (i = 0; i < stat.levelCount; ++i) {
            r.cell(HTMLCreator.HAlign.right, "" + stat.sc[i]);
            r.cell(HTMLCreator.HAlign.center, "<a href=\"" + this.tpl("/show/clusters?mode=6&level=" + (i + 1)) + "\">" + this.getIconImage("eye16.png", "View clusters") + "</a>");
            r.cell(HTMLCreator.HAlign.center, "<a href=\"" + this.tl("/get/allclusters/smiles?type=6&level=" + (i + 1)) + "\">" + this.getIconImage("save16.png", "Download cluster representants") + "</a>");
        }
        r = t.row();
        r.hcell(HTMLCreator.HAlign.center, "Real cluster count");
        for (i = 0; i < stat.levelCount; ++i) {
            r.cell(HTMLCreator.HAlign.right, "" + stat.rc[i]);
            r.cell(HTMLCreator.HAlign.center, "<a href=\"" + this.tpl("/show/clusters?mode=3&level=" + (i + 1)) + "\">" + this.getIconImage("eye16.png", "View clusters") + "</a>");
            r.cell(HTMLCreator.HAlign.center, "<a href=\"" + this.tl("/get/allclusters/smiles?type=3&level=" + (i + 1)) + "\">" + this.getIconImage("save16.png", "Download cluster representants") + "</a>");
        }
        r = t.row();
        r.hcell(1, 2, HTMLCreator.HAlign.center, "Clustering coverage");
        for (i = 0; i < stat.levelCount; ++i) {
            r.cell(2, 1, HTMLCreator.HAlign.right, TextUtils.formatNumber(stat.ccov[i], 4));
            r.cell(HTMLCreator.HAlign.center, "%");
        }
        r = t.row();
        for (i = 0; i < stat.levelCount; ++i) {
            r.cell(3, 1, HTMLCreator.HAlign.center, "<img src=\"" + this.tl("/generate/barimage?w=100&h=14&b1=" + stat.ccov[i] / 100.0) + "\" />");
        }
        r.close();
        t.close();
    }

    public class Overview
    extends Server.Action {
        @Override
        public Server.Action initClone() {
            return new Overview();
        }

        @Override
        public void execute(ServerConnection conn) {
            HTMLCreator c = conn.respondHTMLCreator("Overview");
            CS.this.appendHeader(c, this);
            c.h1("Clustering process overview");
            c.p("This page shows a general overview of the clustering session");
            HTMLCreator.TablePrinter t = c.table();
            HTMLCreator.TableRow r = t.row();
            r.hcell(1, 3, HTMLCreator.HAlign.left, "Clustering method");
            r.cell(CS.this.clus.getShortName());
            r = t.row();
            r.cell(CS.this.clus.getLongName());
            r = t.row();
            r.cell(CS.this.clus.getClusteringSummary());
            r = t.row();
            r.hcell(HTMLCreator.HAlign.left, "Molecular descriptor used");
            ComparableDescriptor desc = CS.this.clus.getDesc();
            r.cell(desc == null ? "N/A" : desc.getFactory().getSummaryString());
            r = t.row();
            r.hcell(HTMLCreator.HAlign.left, "Total imported count");
            r.cell("" + CS.this.clus.getHC().getImportedCount());
            r = t.row();
            r.hcell(HTMLCreator.HAlign.left, "Stored leaves");
            r.cell("" + CS.this.clus.getHC().getLeavesCount());
            t.close();
            c.h2("Tree size");
            t = c.table();
            r = t.row();
            r.hcell(HTMLCreator.HAlign.center, "Level");
            r.hcell(HTMLCreator.HAlign.center, "Group count");
            r.hcell(HTMLCreator.HAlign.center, "Referenced leaves");
            for (int i = 1; i < CS.this.clus.getHC().getLevelCount(); ++i) {
                TreeNodeEntityGroup g = CS.this.clus.getHC().getLevelGroup(i);
                r = t.row();
                String ll = "" + i;
                r.hcell(HTMLCreator.HAlign.center, ll);
                r.cell(HTMLCreator.HAlign.center, "" + g.getSubtreeCount());
                r.cell(HTMLCreator.HAlign.center, "" + g.size());
            }
            t.close();
            CS.this.appendStat(c);
        }
    }

    public class ShowStatistics
    extends Server.Action {
        @Override
        public Server.Action initClone() {
            return new ShowStatistics();
        }

        @Override
        public void execute(ServerConnection conn) {
            int si;
            int i;
            OAWrStat stat = CS.this.getStat();
            HTMLCreator c = conn.respondHTMLCreator("Statistics");
            CS.this.appendHeader(c, this);
            c.h1("Clustering size / coverage statistics");
            CS.this.appendStat(c);
            HTMLCreator.TablePrinter t = c.table(HTMLCreator.HAlign.center);
            HTMLCreator.TableRow r = t.row();
            r.hcell(1, 3, HTMLCreator.HAlign.center, "Size");
            for (i = 0; i < stat.levelCount; ++i) {
                String ll = "LEVEL " + (i + 1);
                if (stat.preferredLevel == i + 1) {
                    ll = "* " + ll + " *";
                }
                r.hcell(6, 1, HTMLCreator.HAlign.center, ll);
            }
            r = t.row();
            for (i = 0; i < stat.levelCount; ++i) {
                r.hcell(1, 2, HTMLCreator.HAlign.center, "Frequency");
                r.hcell(3, 1, HTMLCreator.HAlign.center, "Coverage");
                r.hcell(2, 1, HTMLCreator.HAlign.center, "Cumulative");
            }
            r.close();
            r = t.row();
            for (i = 0; i < stat.levelCount; ++i) {
                r.hcell(1, 1, HTMLCreator.HAlign.center, "Single");
                r.hcell(1, 1, HTMLCreator.HAlign.center, "This size");
                r.hcell(1, 1, HTMLCreator.HAlign.center, "All");
                r.hcell(1, 1, HTMLCreator.HAlign.center, "Count");
                r.hcell(1, 1, HTMLCreator.HAlign.center, "Percentage");
            }
            r.close();
            int[] prevsifi = new int[stat.levelCount];
            int[] prevfi = new int[stat.levelCount];
            int[] sizes = stat.getAllSizes();
            for (int i2 = sizes.length - 1; i2 >= 0 && (si = sizes[i2]) != 1; --i2) {
                double cumgroupct;
                double cumscov;
                double tsizcov;
                double singlecov;
                int fi;
                IntStat is;
                int j;
                r = t.row();
                r.hcell(1, 2, HTMLCreator.HAlign.right, "" + si);
                for (j = 0; j < stat.levelCount; ++j) {
                    is = stat.stat[j];
                    fi = is.getFreq(sizes[i2]);
                    if (fi == 0) {
                        r.cell(6, 2, HTMLCreator.HAlign.center, "");
                        continue;
                    }
                    int n = j;
                    prevsifi[n] = prevsifi[n] + si * fi;
                    int n2 = j;
                    prevfi[n2] = prevfi[n2] + fi;
                    r.cell(1, 2, HTMLCreator.HAlign.right, "" + fi);
                    singlecov = (double)si / (double)stat.stct;
                    tsizcov = (double)(si * fi) / (double)stat.stct;
                    cumscov = (double)prevsifi[j] / (double)stat.stct;
                    cumgroupct = (double)prevfi[j] / (double)stat.rc[j];
                    r.cell(1, 1, HTMLCreator.HAlign.right, TextUtils.formatNumber(100.0 * singlecov, 4) + "&nbsp;%");
                    r.cell(1, 1, HTMLCreator.HAlign.right, TextUtils.formatNumber(100.0 * tsizcov, 4) + "&nbsp;%");
                    r.cell(1, 1, HTMLCreator.HAlign.right, TextUtils.formatNumber(100.0 * cumscov, 4) + "&nbsp;%");
                    r.cell(1, 1, HTMLCreator.HAlign.right, "" + prevfi[j]);
                    r.cell(1, 1, HTMLCreator.HAlign.right, TextUtils.formatNumber(100.0 * cumgroupct, 4) + "&nbsp;%");
                }
                r.close();
                r = t.row();
                for (j = 0; j < stat.levelCount; ++j) {
                    is = stat.stat[j];
                    fi = is.getFreq(sizes[i2]);
                    if (fi == 0) continue;
                    singlecov = (double)si / (double)stat.stct;
                    tsizcov = (double)(si * fi) / (double)stat.stct;
                    cumscov = (double)prevsifi[j] / (double)stat.stct;
                    cumgroupct = (double)prevfi[j] / (double)stat.rc[j];
                    r.cell(1, 1, HTMLCreator.HAlign.center, "<img src=\"" + CS.this.tl("/generate/barimage?w=100&h=10&b1=" + singlecov) + "\" />");
                    r.cell(1, 1, HTMLCreator.HAlign.center, "<img src=\"" + CS.this.tl("/generate/barimage?w=100&h=10&b1=" + tsizcov) + "\" />");
                    r.cell(3, 1, HTMLCreator.HAlign.center, "<img src=\"" + CS.this.tl("/generate/barimage?w=150&h=10&b1=" + cumscov + "&b2=" + cumgroupct + "&ct=2") + "\" />");
                }
                r.close();
            }
            t.close();
        }
    }

    public class GetClusterReprImage
    extends Server.Action {
        int w = 300;
        int h = 300;
        int id = 5;

        @Override
        public void reset() {
            super.reset();
            this.w = 300;
            this.h = 300;
            this.id = 5;
        }

        @Override
        public Server.Action initClone() {
            return new GetClusterReprImage();
        }

        @Override
        public boolean setParam(String name, String value) {
            super.setParam(name, value);
            if (CS.this.log.isTraceEnabled()) {
                CS.this.log.trace((Object)("Param name: " + name + " Value: " + value));
            }
            try {
                if (name.equals("id")) {
                    this.id = Integer.parseInt(value);
                    return true;
                }
                if (name.equals("w")) {
                    this.w = Integer.parseInt(value);
                    return true;
                }
                if (name.equals("h")) {
                    this.h = Integer.parseInt(value);
                    return true;
                }
            }
            catch (Exception e) {
                CS.this.log.error((Object)("name: " + name + " value: " + value + " " + e.getMessage()), (Throwable)e);
            }
            return false;
        }

        @Override
        public void execute(ServerConnection conn) {
            try {
                byte[] img;
                String smi;
                block8: {
                    HC.RetrievePropertyObject rs = CS.this.clus.getClusterRepresentantIntermediate();
                    smi = (String)rs.getPropertyObject(CS.this.clus.getHC().getTree().getGroup(this.id).properties());
                    Molecule m = smi.length() == 0 ? new Molecule() : MolImporter.importMol(smi);
                    img = null;
                    try {
                        img = m.toBinFormat("png:h" + this.h + ",w" + this.w);
                    }
                    catch (Exception e) {
                        if (!CS.this.log.isErrorEnabled()) break block8;
                        CS.this.log.error((Object)("Exception in " + this.getLink() + " smi=" + smi), (Throwable)e);
                    }
                }
                if (img == null || img.length == 0) {
                    if (CS.this.log.isErrorEnabled()) {
                        CS.this.log.error((Object)("Error in " + this.getLink() + " smi=" + smi));
                    }
                    conn.respondError(404, "Error.");
                } else {
                    conn.respondByteArray("image/png", img);
                }
            }
            catch (Exception e) {
                if (CS.this.log.isErrorEnabled()) {
                    CS.this.log.error((Object)e);
                }
                conn.respondError(404, "Error: " + e.getMessage());
            }
        }
    }

    public class GenerateBarImage
    extends Server.Action {
        Server.Action.IParamDescriptor w = this.addIParamDescriptor("w", 100);
        Server.Action.IParamDescriptor h = this.addIParamDescriptor("h", 15);
        Server.Action.DParamDescriptor b1 = this.addDParamDescriptor("b1", -1.0);
        Server.Action.DParamDescriptor b2 = this.addDParamDescriptor("b2", -1.0);
        Server.Action.IParamDescriptor ct = this.addIParamDescriptor("ct", 1);

        @Override
        public Server.Action initClone() {
            return new GenerateBarImage();
        }

        public void fillRect(Graphics2D g2d, int x1, int y1, int x2, int y2) {
            g2d.fillRect(x1, y1, x2 - x1 + 1, y2 - y1 + 1);
        }

        @Override
        public void execute(ServerConnection conn) {
            try {
                int width = this.w.getCurrentValue();
                int height = this.h.getCurrentValue();
                ByteArrayOutputStream ba = null;
                BufferedImage img = new BufferedImage(width, height, 1);
                Graphics2D g2d = img.createGraphics();
                g2d.setColor(Color.WHITE);
                g2d.fillRect(0, 0, width, height);
                g2d.setColor(Color.BLACK);
                g2d.drawRect(0, 0, width - 1, height - 1);
                if (this.b1.getCurrentValue() > 0.0 && this.b1.getCurrentValue() <= 1.0) {
                    g2d.setColor(Color.BLUE);
                    int x1 = 1;
                    int y1 = 1;
                    int x2 = (int)Math.round((double)(width - 2) * this.b1.getCurrentValue());
                    int y2 = height - 2;
                    if (this.ct.getCurrentValue() > 1) {
                        y2 = height / 2 - 1;
                    }
                    this.fillRect(g2d, x1, y1, x2, y2);
                    if (this.ct.getCurrentValue() > 1) {
                        y1 = y2 + 1;
                        y2 = height - 2;
                        x1 = (int)Math.round((double)(width - 2) * (1.0 - this.b2.getCurrentValue()));
                        x2 = width - 2;
                        g2d.setColor(Color.GRAY);
                        this.fillRect(g2d, x1, y1, x2, y2);
                    }
                }
                g2d.dispose();
                ba = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)img, "png", ba);
                conn.respondByteArray("image/png", ba.toByteArray());
            }
            catch (Exception e) {
                conn.respondError(404, "Error: " + e.getMessage());
            }
        }
    }

    public class GetClusterMembersSmiles
    extends Server.Action {
        Server.Action.IParamDescriptor id = this.addIParamDescriptor("id", 0);

        @Override
        public Server.Action initClone() {
            return new GetClusterMembersSmiles();
        }

        @Override
        public void execute(ServerConnection conn) {
            try {
                EntityGroup g = CS.this.clus.getHC().getTree().getGroup(this.id.getCurrentValue());
                StringBuffer resp = new StringBuffer();
                for (int i = 0; i < g.size(); ++i) {
                    Entity e = (Entity)g.get(i);
                    String smi = CS.this.cff.getRetrieveLeaveIntermediate().getPropertyObject(e) + "\tCLUSTERID_" + this.id.getCurrentValue() + "_LEAFID_" + e.getIndex();
                    resp.append(smi);
                    resp.append("\n");
                }
                conn.respondGeneric("text/plain", resp);
            }
            catch (Exception e) {
                conn.respondError(404, "Error: " + e.getMessage());
            }
        }
    }

    public class GetAllClusterRepresentants
    extends Server.Action {
        Server.Action.IParamDescriptor type = this.addIParamDescriptor("type", 0);
        Server.Action.IParamDescriptor level = this.addIParamDescriptor("level", 1);

        @Override
        public Server.Action initClone() {
            return new GetAllClusterRepresentants();
        }

        @Override
        public void execute(ServerConnection conn) {
            try {
                RAIterator<EntityGroup> cc = CS.this.gc.getFilteredGroup(this.level.getCurrentValue(), this.type.getCurrentValue());
                HC.RetrievePropertyObject rs = CS.this.clus.getClusterRepresentantIntermediate();
                StringBuffer ret = new StringBuffer();
                for (int i = 0; i < cc.size(); ++i) {
                    EntityGroup gi = (EntityGroup)cc.get(i);
                    EntityProperties gip = gi.properties();
                    String smi = (String)rs.getPropertyObject(gip);
                    smi = smi + "\tCLUSTERID_" + gip.indexOfEntity() + "_CLUSTERSIZE_" + gi.size();
                    ret.append(smi);
                    ret.append('\n');
                }
                conn.respondGeneric("text/plain", ret);
            }
            catch (Exception e) {
                conn.respondError(404, "Error: " + e.getMessage());
            }
        }
    }

    public class GetClusterReprSmiles
    extends Server.Action {
        Server.Action.IParamDescriptor id = this.addIParamDescriptor("id", 0);

        @Override
        public Server.Action initClone() {
            return new GetClusterReprSmiles();
        }

        @Override
        public void execute(ServerConnection conn) {
            try {
                HC.RetrievePropertyObject rs = CS.this.clus.getClusterRepresentantIntermediate();
                String smi = (String)rs.getPropertyObject(CS.this.clus.getHC().getTree().getGroup(this.id.getCurrentValue()).properties());
                smi = smi + "\tCLUSTERID_" + this.id.getCurrentValue();
                conn.respondGeneric("text/plain", smi);
            }
            catch (Exception e) {
                conn.respondError(404, "Error: " + e.getMessage());
            }
        }
    }

    public class GetLeaveSmiles
    extends Server.Action {
        Server.Action.IParamDescriptor id = this.addIParamDescriptor("id", 0);

        @Override
        public Server.Action initClone() {
            return new GetLeaveSmiles();
        }

        @Override
        public void execute(ServerConnection conn) {
            try {
                Entity e = CS.this.clus.getHC().getTree().getLeaf(this.id.getCurrentValue());
                String smi = CS.this.cff.getRetrieveLeaveIntermediate().getPropertyObject(e) + "\tLEAFID_" + this.id.getCurrentValue();
                conn.respondGeneric("text/plain", smi);
            }
            catch (Exception e) {
                conn.respondError(404, "Error: " + e.getMessage());
            }
        }
    }

    public class GetLeaveImage
    extends Server.Action {
        Server.Action.IParamDescriptor id = this.addIParamDescriptor("id", 0);
        Server.Action.IParamDescriptor w = this.addIParamDescriptor("w", 300);
        Server.Action.IParamDescriptor h = this.addIParamDescriptor("h", 300);

        @Override
        public Server.Action initClone() {
            return new GetLeaveImage();
        }

        @Override
        public void execute(ServerConnection conn) {
            try {
                Entity e = CS.this.clus.getHC().getTree().getLeaf(this.id.getCurrentValue());
                String smi = CS.this.cff.getRetrieveLeaveIntermediate().getPropertyObject(e);
                Molecule m = smi.length() == 0 ? new Molecule() : MolImporter.importMol(smi);
                byte[] img = m.toBinFormat("png:h" + this.h.getCurrentValue() + ",w" + this.w.getCurrentValue());
                conn.respondByteArray("image/png", img);
            }
            catch (Exception e) {
                if (CS.this.log.isErrorEnabled()) {
                    CS.this.log.error((Object)e);
                }
                conn.respondError(404, "Error: " + e.getMessage());
            }
        }
    }

    public class ShowClusterImages
    extends Server.Action<CSSession> {
        Server.Action.IParamDescriptor startid = this.addIParamDescriptor("sid", 0);
        Server.Action.IParamDescriptor mode = this.addIParamDescriptor("mode", 0);
        Server.Action.IParamDescriptor level = this.addIParamDescriptor("level", 1);

        @Override
        public Server.Action initClone() {
            return new ShowClusterImages();
        }

        @Override
        public void execute(ServerConnection conn) {
            boolean on;
            HTMLCreator c = conn.respondHTMLCreator("Clusters - level: " + this.level.getCurrentValue());
            CS.this.appendHeader(c, this);
            StringBuffer hs = new StringBuffer("Clusters view - level:");
            for (int i = CS.this.gc.getLevelCount() - 1; i >= 1; --i) {
                if (i == this.level.getCurrentValue()) {
                    hs.append(" <i>" + i + "</i>");
                    continue;
                }
                hs.append(" <a href=\"" + this.level.getChangedLink(i) + "\">" + i + "</a>");
            }
            c.h1(hs.toString());
            RAIterator<EntityGroup> cc = CS.this.gc.getFilteredGroup(this.level.getCurrentValue(), this.mode.getCurrentValue());
            int ts = ((CSSession)this.getSession()).tableRows.getCurrentValue() * ((CSSession)this.getSession()).tableCols.getCurrentValue();
            if (this.startid.getCurrentValue() + ts > cc.size()) {
                this.startid.setCurrentValue(cc.size() - ts);
            }
            if (this.startid.getCurrentValue() < 0) {
                this.startid.setCurrentValue(0);
            }
            HTMLCreator.TablePrinter t = c.table(HTMLCreator.HAlign.center);
            HTMLCreator.TableRow r = t.row();
            r.hcell(3, 1, HTMLCreator.HAlign.center, "All clusters");
            r.ecell(1, 1, null, null);
            r.hcell(3, 1, HTMLCreator.HAlign.center, "No singletons");
            r.ecell(1, 1, null, null);
            r.hcell(1, 1, HTMLCreator.HAlign.center, "Only singletons");
            r.ecell(1, 1, null, null);
            r.ecell(1, 1, null, null);
            r.hcell(1, 1, HTMLCreator.HAlign.center, "Image size");
            r.hcell(1, 1, HTMLCreator.HAlign.center, "Columns");
            r.hcell(1, 1, HTMLCreator.HAlign.center, "Rows");
            r.ecell(1, 1, null, null);
            r.ecell(1, 1, null, null);
            r.hcell(3, 1, HTMLCreator.HAlign.center, "Show/hide");
            r.close();
            r = t.row();
            int v = 0;
            String ms = "Natural";
            r.cell(HTMLCreator.HAlign.center, (this.mode.getCurrentValue() == v ? "<b>" + ms + "</b>" : "<a href=\"" + this.mode.getChangedLink(v) + "\">" + ms + "</a>") + "&nbsp;<a href=\"/get/allclusters/smiles?type=" + v + "\">" + CS.this.getIconImage("save16.png", "Download cluster representants") + "</a>");
            v = 1;
            ms = "Desc. size";
            r.cell(HTMLCreator.HAlign.center, (this.mode.getCurrentValue() == v ? "<b>" + ms + "</b>" : "<a href=\"" + this.mode.getChangedLink(v) + "\">" + ms + "</a>") + "&nbsp;<a href=\"/get/allclusters/smiles?type=" + v + "\">" + CS.this.getIconImage("save16.png", "Download cluster representants") + "</a>");
            v = 2;
            ms = "Asc. size";
            r.cell(HTMLCreator.HAlign.center, (this.mode.getCurrentValue() == v ? "<b>" + ms + "</b>" : "<a href=\"" + this.mode.getChangedLink(v) + "\">" + ms + "</a>") + "&nbsp;<a href=\"/get/allclusters/smiles?type=" + v + "\">" + CS.this.getIconImage("save16.png", "Download cluster representants") + "</a>");
            r.ecell(1, 1, null, null);
            v = 3;
            ms = "Natural";
            r.cell(HTMLCreator.HAlign.center, (this.mode.getCurrentValue() == v ? "<b>" + ms + "</b>" : "<a href=\"" + this.mode.getChangedLink(v) + "\">" + ms + "</a>") + "&nbsp;<a href=\"/get/allclusters/smiles?type=" + v + "\">" + CS.this.getIconImage("save16.png", "Download cluster representants") + "</a>");
            v = 4;
            ms = "Desc. size";
            r.cell(HTMLCreator.HAlign.center, (this.mode.getCurrentValue() == v ? "<b>" + ms + "</b>" : "<a href=\"" + this.mode.getChangedLink(v) + "\">" + ms + "</a>") + "&nbsp;<a href=\"/get/allclusters/smiles?type=" + v + "\">" + CS.this.getIconImage("save16.png", "Download cluster representants") + "</a>");
            v = 5;
            ms = "Asc. size";
            r.cell(HTMLCreator.HAlign.center, (this.mode.getCurrentValue() == v ? "<b>" + ms + "</b>" : "<a href=\"" + this.mode.getChangedLink(v) + "\">" + ms + "</a>") + "&nbsp;<a href=\"/get/allclusters/smiles?type=" + v + "\">" + CS.this.getIconImage("save16.png", "Download cluster representants") + "</a>");
            r.ecell(1, 1, null, null);
            v = 6;
            ms = "Natural";
            r.cell(HTMLCreator.HAlign.center, (this.mode.getCurrentValue() == v ? "<b>" + ms + "</b>" : "<a href=\"" + this.mode.getChangedLink(v) + "\">" + ms + "</a>") + "&nbsp;<a href=\"/get/allclusters/smiles?type=" + v + "\">" + CS.this.getIconImage("save16.png", "Download cluster representants") + "</a>");
            r.ecell(1, 1, null, null);
            r.ecell(1, 1, null, null);
            r.cell(1, 1, HTMLCreator.HAlign.center, ((CSSession)this.getSession()).imgResizerLinks(this));
            r.cell(1, 1, HTMLCreator.HAlign.center, ((CSSession)this.getSession()).tableColCtLinks(this));
            r.cell(1, 1, HTMLCreator.HAlign.center, ((CSSession)this.getSession()).tableRowCtLinks(this));
            r.ecell(1, 1, null, null);
            r.ecell(1, 1, null, null);
            Server.Action.IParamDescriptor ipd = ((CSSession)this.getSession()).clustersShowID;
            ms = "ID";
            boolean bl = on = ipd.getCurrentValue() != 0;
            if (on) {
                ms = "<b>" + ms + "</b>";
            }
            r.cell(1, 1, HTMLCreator.HAlign.center, "<a href=\"" + ipd.getChangedLink((Server.Action)this, ipd.getCurrentValue() == 0 ? "1" : "0") + "\">" + ms + "</a>");
            ipd = ((CSSession)this.getSession()).clustersShowSize;
            ms = "Size";
            boolean bl2 = on = ipd.getCurrentValue() != 0;
            if (on) {
                ms = "<b>" + ms + "</b>";
            }
            r.cell(1, 1, HTMLCreator.HAlign.center, "<a href=\"" + ipd.getChangedLink((Server.Action)this, ipd.getCurrentValue() == 0 ? "1" : "0") + "\">" + ms + "</a>");
            ipd = ((CSSession)this.getSession()).clustersShowCovBar;
            ms = "Coverage bar";
            boolean bl3 = on = ipd.getCurrentValue() != 0;
            if (on) {
                ms = "<b>" + ms + "</b>";
            }
            r.cell(1, 1, HTMLCreator.HAlign.center, "<a href=\"" + ipd.getChangedLink((Server.Action)this, ipd.getCurrentValue() == 0 ? "1" : "0") + "\">" + ms + "</a>");
            r.close();
            t.close();
            c.tag("center", CS.this.getPageLinks(null, this.startid, ts, cc.size()));
            t = c.table(HTMLCreator.HAlign.center);
            EntityGroup[] gg = new EntityGroup[((CSSession)this.getSession()).tableCols.getCurrentValue()];
            int[] no = new int[((CSSession)this.getSession()).tableCols.getCurrentValue()];
            int ii = this.startid.getCurrentValue();
            for (int y = 0; y < ((CSSession)this.getSession()).tableRows.getCurrentValue(); ++y) {
                int id;
                int x;
                for (int i = 0; i < gg.length; ++i) {
                    gg[i] = null;
                }
                if (ii >= cc.size()) break;
                for (x = 0; x < ((CSSession)this.getSession()).tableCols.getCurrentValue(); ++x) {
                    if (ii >= cc.size()) continue;
                    no[x] = ii;
                    gg[x] = (EntityGroup)cc.get(ii);
                    ++ii;
                }
                if (((CSSession)this.getSession()).clustersShowID.getCurrentValue() != 0) {
                    r = t.row();
                    for (x = 0; x < ((CSSession)this.getSession()).tableCols.getCurrentValue(); ++x) {
                        if (gg[x] == null) continue;
                        id = gg[x].properties().indexOfEntity();
                        r.hcell(HTMLCreator.HAlign.center, "(" + (no[x] + 1) + ") Group ID: " + id);
                    }
                    r.close();
                }
                r = t.row();
                for (x = 0; x < ((CSSession)this.getSession()).tableCols.getCurrentValue(); ++x) {
                    if (gg[x] == null) continue;
                    id = gg[x].properties().indexOfEntity();
                    r.cell(HTMLCreator.HAlign.center, "<a href=\"" + CS.this.tpl("/show/singlecluster?id=" + id) + "\">" + "<img src=\"" + CS.this.tl("/get/cluster/png?id=" + id + "&w=" + ((CSSession)this.getSession()).tableImageSize.getCurrentValue() + "&h=" + ((CSSession)this.getSession()).tableImageSize.getCurrentValue()) + "\" alt=\"Cluster representant image\" border=\"0\"/>" + "</a>");
                }
                r.close();
                if (((CSSession)this.getSession()).clustersShowSize.getCurrentValue() != 0) {
                    r = t.row();
                    for (x = 0; x < ((CSSession)this.getSession()).tableCols.getCurrentValue(); ++x) {
                        if (gg[x] == null) continue;
                        id = gg[x].properties().indexOfEntity();
                        String stc = "";
                        if (gg[x].isHierarchic() && gg[x].getHierarchic().getSubtreeCount() > 0) {
                            stc = "<span title=\"subtree count\"><b>" + gg[x].getHierarchic().getSubtreeCount() + "</b></span>/";
                        }
                        r.cell(HTMLCreator.HAlign.center, "Size: " + stc + gg[x].size() + " (" + TextUtils.formatNumber((double)gg[x].size() * 100.0 / (double)CS.this.clus.getHC().getLeavesCount(), 2) + " %) " + "<a href=\"" + CS.this.tl("/get/cluster/leavessmiles?id=" + id) + "\">" + CS.this.getIconImage("save16.png", "Save members") + "</a>");
                    }
                    r.close();
                }
                if (((CSSession)this.getSession()).clustersShowCovBar.getCurrentValue() == 0) continue;
                r = t.row();
                for (x = 0; x < ((CSSession)this.getSession()).tableCols.getCurrentValue(); ++x) {
                    if (gg[x] == null) continue;
                    id = gg[x].properties().indexOfEntity();
                    r.cell(HTMLCreator.HAlign.center, "<img src=\"" + CS.this.tl("/generate/barimage?w=" + ((CSSession)this.getSession()).tableImageSize.getCurrentValue() + "&h=5&b1=" + (double)gg[x].size() / (double)CS.this.clus.getHC().getLeavesCount()) + "\" />");
                }
                r.close();
            }
            t.close();
        }
    }

    public class ShowSingleCluster
    extends Server.Action<CSSession> {
        Server.Action.IParamDescriptor id = this.addIParamDescriptor("id", 0);
        Server.Action.IParamDescriptor imgsiz = this.addIParamDescriptor("imgsiz", 200);
        Server.Action.IParamDescriptor startno = this.addIParamDescriptor("startno", 0);
        Server.Action.IParamDescriptor ststartno = this.addIParamDescriptor("ststartno", 0);

        @Override
        public Server.Action initClone() {
            return new ShowSingleCluster();
        }

        @Override
        public void execute(ServerConnection conn) {
            HTMLCreator.TableRow r;
            HTMLCreator.TablePrinter t;
            HC.RetrieveDescriptor ld = CS.this.cff.getRetrieveLeaveDescriptor();
            HC.RetrieveDescriptor gd = CS.this.clus.getClusterRepresentantDescriptor();
            ComparableDescriptor desc = CS.this.clus.getDesc();
            boolean distAvailable = ld != null && gd != null && desc != null;
            HTMLCreator c = conn.respondHTMLCreator("Clusters");
            CS.this.appendHeader(c, this);
            c.h1("Single cluster view");
            EntityGroup g = CS.this.clus.getHC().getTree().getGroup(this.id.getCurrentValue());
            boolean parentsDisplayed = false;
            if (CS.this.clus.isFirstParentIDStored() && CS.this.clus.getFirstParentID().getPropertyInt(g.properties()) != 0) {
                int i;
                int fpi;
                parentsDisplayed = true;
                c.h2("Parent nodes");
                c.p("Here all the enclosing clusters are displayed. These clusters are the \"parents\" of the selected cluster. The first (leftmost) displayed cluster is at the highest level meaning that it is the widest one enclosing the selected cluster. This representation can be considered as the route from a root cluster to the displayed one. (Note that each cluster displayed in this table represents a different level in the clustering hierarchy.)");
                IntVector fps = new IntVector();
                IntVector fpsiz = new IntVector();
                EntityGroup gg = g;
                while (fps.size() < 20 && (fpi = CS.this.clus.getFirstParentID().getPropertyInt(gg.properties())) != 0) {
                    fps.add(fpi);
                    gg = CS.this.clus.getHC().getTree().getGroup(fpi);
                    fpsiz.add(gg.size());
                }
                t = c.table(HTMLCreator.HAlign.center);
                r = t.row();
                r.hcell(fps.size(), 1, HTMLCreator.HAlign.center, "Parents");
                r.close();
                r = t.row();
                for (i = fps.size() - 1; i >= 0; --i) {
                    r.hcell(HTMLCreator.HAlign.center, "ID=" + fps.get(i) + " Size=" + fpsiz.get(i));
                }
                r.close();
                r = t.row();
                for (i = fps.size() - 1; i >= 0; --i) {
                    r.cell(HTMLCreator.HAlign.center, "<a href=\"" + CS.this.tl("/show/singlecluster?id=" + fps.get(i)) + "\">" + "<img src=\"" + CS.this.tl("/get/cluster/png?id=" + fps.get(i)) + "&w=" + ((CSSession)this.getSession()).tableImageSize.getCurrentValue() + "&h=" + ((CSSession)this.getSession()).tableImageSize.getCurrentValue() + "\" border=\"0\" />" + "</a>");
                }
                r.close();
                t.close();
            }
            boolean sl = CS.this.clus.getHC().isStoringLeaves();
            if (parentsDisplayed) {
                c.h2("Currently selected cluster");
            }
            c.p("The followng table shows the currently selected cluster, cluster informations and download links.");
            t = c.table(HTMLCreator.HAlign.center);
            CDescriptor gdesc = null;
            if (distAvailable) {
                gdesc = (CDescriptor)gd.getPropertyObject(g.properties());
            }
            r = t.row();
            r.hcell(1, 7 + (sl ? 4 : 0), HTMLCreator.HAlign.def, "<a href=\"" + CS.this.tl("/get/cluster/smiles?id=" + this.id.getCurrentValue()) + "\">" + "<img src=\"" + CS.this.tl("/get/cluster/png?id=" + this.id.getCurrentValue() + "&w=" + this.imgsiz.getCurrentValue() + "&h=" + this.imgsiz.getCurrentValue()) + "\" alt=\"Cluster representant image\" border=\"0\"/>" + "</a>");
            r.hcell(HTMLCreator.HAlign.left, "Cluster ID");
            r.cell(HTMLCreator.HAlign.left, "" + this.id.getCurrentValue());
            r.close();
            r = t.row();
            r.hcell(HTMLCreator.HAlign.left, "Hierarchy:");
            String hs = null;
            hs = g.isHierarchic() ? "Subtree count: " + g.getHierarchic().getSubtreeCount() : "No";
            r.cell(HTMLCreator.HAlign.left, hs);
            r = t.row();
            r.hcell(HTMLCreator.HAlign.left, "Cluster size");
            r.cell(HTMLCreator.HAlign.left, "" + g.size());
            r = t.row();
            r.hcell(HTMLCreator.HAlign.left, "Cluster coverage");
            r.cell(HTMLCreator.HAlign.left, TextUtils.formatNumber((double)g.size() * 100.0 / (double)CS.this.clus.getHC().getLeavesCount(), 2) + " %");
            r = t.row();
            r.hcell(1, 2, HTMLCreator.HAlign.left, "Download");
            r.cell("<a href=\"" + CS.this.tl("/get/cluster/smiles?id=" + this.id.getCurrentValue()) + "\">" + "Cluster representant" + "</a>");
            r = t.row();
            r.cell("<a href=\"" + CS.this.tl("/get/cluster/leavessmiles?id=" + this.id.getCurrentValue()) + "\">" + "Cluster members" + "</a>");
            r = t.row();
            r.cell(1, 1, HTMLCreator.HAlign.left, "Cluster image size");
            r.cell(1, 1, HTMLCreator.HAlign.center, "<a href=\"" + this.imgsiz.getChangedLink((int)Math.round((double)this.imgsiz.getCurrentValue() * 0.66)) + "\">" + CS.this.getIconImage("zoom-out16.png") + "</a>&nbsp;<a href=\"" + this.imgsiz.getChangedLink((int)Math.round((double)this.imgsiz.getCurrentValue() * 1.5)) + "\">" + CS.this.getIconImage("zoom-in16.png") + "</a>");
            r.close();
            if (sl) {
                boolean on;
                r = t.row();
                r.cell(1, 1, HTMLCreator.HAlign.left, "Leaf image size");
                r.cell(1, 1, HTMLCreator.HAlign.center, ((CSSession)this.getSession()).imgResizerLinks(this));
                r.close();
                r = t.row();
                r.cell(1, 1, HTMLCreator.HAlign.left, "Columns");
                r.cell(1, 1, HTMLCreator.HAlign.center, ((CSSession)this.getSession()).tableColCtLinks(this));
                r.close();
                r = t.row();
                r.cell(1, 1, HTMLCreator.HAlign.left, "Rows");
                r.cell(1, 1, HTMLCreator.HAlign.center, ((CSSession)this.getSession()).tableRowCtLinks(this));
                r.close();
                r = t.row();
                r.cell(1, 1, HTMLCreator.HAlign.left, "Show/hide");
                StringBuffer sb = new StringBuffer();
                Server.Action.IParamDescriptor ipd = ((CSSession)this.getSession()).sclusviewShowID;
                String ms = "IDs";
                boolean bl = on = ipd.getCurrentValue() != 0;
                if (on) {
                    ms = "<b>" + ms + "</b>";
                }
                sb.append("<a href=\"" + ipd.getChangedLink((Server.Action)this, ipd.getCurrentValue() == 0 ? "1" : "0") + "\">" + ms + "</a>");
                sb.append("&nbsp;");
                if (distAvailable) {
                    ipd = ((CSSession)this.getSession()).sclusviewShowDist;
                    ms = "Distance";
                    boolean bl2 = on = ipd.getCurrentValue() != 0;
                    if (on) {
                        ms = "<b>" + ms + "</b>";
                    }
                    sb.append("<a href=\"" + ipd.getChangedLink((Server.Action)this, ipd.getCurrentValue() == 0 ? "1" : "0") + "\">" + ms + "</a>");
                    sb.append("&nbsp;");
                    ipd = ((CSSession)this.getSession()).sclusviewShowDistBar;
                    ms = "DistanceBar";
                    boolean bl3 = on = ipd.getCurrentValue() != 0;
                    if (on) {
                        ms = "<b>" + ms + "</b>";
                    }
                    sb.append("<a href=\"" + ipd.getChangedLink((Server.Action)this, ipd.getCurrentValue() == 0 ? "1" : "0") + "\">" + ms + "</a>");
                }
                r.cell(1, 1, HTMLCreator.HAlign.center, sb.toString());
                ShowMatrix sm = CS.this.showmatrix;
                r.cell(1, 1, HTMLCreator.HAlign.center, "<a href=\"" + sm.getLink(new Server.Action.ParamDescriptor[]{sm.cgt, sm.rgt}, new String[]{sm.cgt.getChangedLink(new int[]{1, this.id.getCurrentValue()}), sm.rgt.getChangedLink(new int[]{1, this.id.getCurrentValue()})}) + "\">This in matrix</a>");
                r.close();
            }
            t.close();
            if (g.isHierarchic() && g.getHierarchic().getSubtreeCount() > 0) {
                c.h2("Direct subtrees");
                c.p("The following table shows the immediate subtrees of the currently dispalyed cluster. These clusters represents the next partition of the current cluster. It is possible that some or all of these further partitions are singletons representing one structure. (Not that all of the displayed clusters here are assigned to the same level in the hierarchy.)");
                HierarchicEntityGroup hg = g.getHierarchic();
                int co = ((CSSession)this.getSession()).tableCols.getCurrentValue();
                int n = hg.getSubtreeCount();
                if (n < co) {
                    co = n;
                }
                t = c.table(HTMLCreator.HAlign.center);
                r = t.row();
                r.hcell(co, 1, HTMLCreator.HAlign.center, "Subtrees");
                r.close();
                for (int p = 0; p < n; p += co) {
                    EntityGroup gx;
                    if (((CSSession)this.getSession()).sclusviewShowID.getCurrentValue() != 0) {
                        r = t.row();
                        for (int x = 0; x < co && p + x < n; ++x) {
                            gx = hg.getSubtree(p + x);
                            r.cell(HTMLCreator.HAlign.center, "ID=" + gx.getIndex() + " size=" + gx.size());
                        }
                        r.close();
                    }
                    r = t.row();
                    for (int x = 0; x < co && p + x < n; ++x) {
                        gx = hg.getSubtree(p + x);
                        r.cell(HTMLCreator.HAlign.center, "<a href=\"" + CS.this.tl("/show/singlecluster?id=" + gx.getIndex()) + "\">" + "<img src=\"" + CS.this.tl("/get/cluster/png?id=" + gx.getIndex() + "&w=" + ((CSSession)this.getSession()).tableImageSize.getCurrentValue() + "&h=" + ((CSSession)this.getSession()).tableImageSize.getCurrentValue()) + "\" border=\"0\" />" + "</a>");
                    }
                    r.close();
                }
                t.close();
            }
            if (!sl) {
                c.p("<B>Individual input structures are not stored.</B>");
            } else {
                c.h2("Represented structures");
                c.p("Here all of the structures which are represented by the current cluster are accessible. If subtrees are associated to the current cluster then they represent a narrowe grouping of the input structures. (Note that the displayed structures are on the same, bottom hierarchy level regardless of the position of the displayed cluster.)");
                int ts = ((CSSession)this.getSession()).tableRows.getCurrentValue() * ((CSSession)this.getSession()).tableCols.getCurrentValue();
                int n = g.size();
                int ro = ((CSSession)this.getSession()).tableRows.getCurrentValue();
                int co = ((CSSession)this.getSession()).tableCols.getCurrentValue();
                if (this.startno.getCurrentValue() + ts > n) {
                    this.startno.setCurrentValue(n - ts);
                }
                if (this.startno.getCurrentValue() < 0) {
                    this.startno.setCurrentValue(0);
                }
                int s = this.startno.getCurrentValue();
                StringBuffer seek = new StringBuffer();
                seek.append("<center>");
                if (s > 0) {
                    seek.append("<a href=\"" + this.startno.getChangedLink(0) + "\">" + CS.this.getIconImage("first16.png") + "</a>&nbsp;");
                }
                if (s > ts) {
                    seek.append("<a href=\"" + this.startno.getChangedLink(s - ts) + "\">" + CS.this.getIconImage("previous16.png") + "</a>&nbsp;");
                }
                int tmps = 0;
                int i = 0;
                while (i < 4) {
                    if (tmps < s) {
                        seek.append("<a href=\"" + this.startno.getChangedLink(tmps) + "\">" + (tmps + 1) + "-" + (tmps + ts) + "</a>&nbsp;");
                    }
                    ++i;
                    tmps += ts;
                }
                tmps = s - ts * 2;
                i = 0;
                while (i < 5) {
                    if (!(tmps < s && tmps <= ts * 4 || tmps > s && tmps >= n - ts * 4)) {
                        if (i == 2) {
                            seek.append("<b>" + (tmps + 1) + "-" + Math.min(tmps + ts, n) + "</b>&nbsp;");
                        } else {
                            seek.append("<a href=\"" + this.startno.getChangedLink(tmps) + "\">" + (tmps + 1) + "-" + (tmps + ts) + "</a>&nbsp;");
                        }
                    }
                    ++i;
                    tmps += ts;
                }
                tmps = n - ts * 4;
                i = 0;
                while (i < 4) {
                    if (tmps > s) {
                        seek.append("<a href=\"" + this.startno.getChangedLink(tmps) + "\">" + (tmps + 1) + "-" + (tmps + ts) + "</a>&nbsp;");
                    }
                    ++i;
                    tmps += ts;
                }
                if (s + ts < n - ts) {
                    seek.append("<a href=\"" + this.startno.getChangedLink(s + ts) + "\">" + CS.this.getIconImage("next16.png") + "</a>&nbsp;");
                }
                if (n - ts > s) {
                    seek.append("<a href=\"" + this.startno.getChangedLink(n - ts) + "\">" + CS.this.getIconImage("last16.png") + "</a>&nbsp;");
                }
                seek.append("</center>");
                c.p(seek.toString());
                t = c.table(HTMLCreator.HAlign.center);
                for (int y = 0; y < ro && y * co + s < n; ++y) {
                    int p;
                    int x;
                    int[] ids = new int[co];
                    double[] dists = new double[co];
                    if (((CSSession)this.getSession()).sclusviewShowID.getCurrentValue() != 0) {
                        r = t.row();
                        for (x = 0; x < co && (p = s + y * co + x) < n; ++x) {
                            ids[x] = ((Entity)g.get(p)).getIndex();
                            r.hcell(HTMLCreator.HAlign.center, "(" + (p + 1) + ") ID=" + ids[x]);
                        }
                        r.close();
                    }
                    r = t.row();
                    for (x = 0; x < co && (p = s + y * co + x) < n; ++x) {
                        ids[x] = ((Entity)g.get(p)).getIndex();
                        r.cell(HTMLCreator.HAlign.center, "<a href=\"" + CS.this.tl("/show/singlestructure?id=" + ids[x]) + "\">" + "<img src=\"" + CS.this.tl("/get/leave/png?id=" + ids[x] + "&w=" + ((CSSession)this.getSession()).tableImageSize.getCurrentValue() + "&h=" + ((CSSession)this.getSession()).tableImageSize.getCurrentValue()) + "\" border=\"0\" />" + "</a>");
                    }
                    r.close();
                    if (!distAvailable || ((CSSession)this.getSession()).sclusviewShowDist.getCurrentValue() == 0 && ((CSSession)this.getSession()).sclusviewShowDistBar.getCurrentValue() == 0) continue;
                    for (x = 0; x < co && (p = s + y * co + x) < n; ++x) {
                        dists[x] = desc.calcDistance(gdesc, ld.getDescriptor((Entity)g.get(p)));
                    }
                    if (((CSSession)this.getSession()).sclusviewShowDist.getCurrentValue() != 0) {
                        r = t.row();
                        for (x = 0; x < co && (p = s + y * co + x) < n; ++x) {
                            r.cell(HTMLCreator.HAlign.center, TextUtils.formatNumber(dists[x], 2));
                        }
                        r.close();
                    }
                    if (((CSSession)this.getSession()).sclusviewShowDistBar.getCurrentValue() == 0) continue;
                    r = t.row();
                    for (x = 0; x < co && (p = s + y * co + x) < n; ++x) {
                        r.cell(HTMLCreator.HAlign.center, "<img src=\"" + CS.this.tl("/generate/barimage?w=" + ((CSSession)this.getSession()).tableImageSize.getCurrentValue() + "&h=7&b1=" + dists[x]) + "\" />");
                    }
                    r.close();
                }
                t.close();
            }
        }
    }

    public class ShowSingleStructure
    extends Server.Action<CSSession> {
        Server.Action.IParamDescriptor id = this.addIParamDescriptor("id", 0);
        Server.Action.IParamDescriptor imgsiz = this.addIParamDescriptor("imgsiz", 200);

        @Override
        public Server.Action initClone() {
            return new ShowSingleStructure();
        }

        @Override
        public void execute(ServerConnection conn) {
            String smie;
            HTMLCreator.TableRow r;
            HTMLCreator.TablePrinter t;
            HTMLCreator c;
            CDescriptor dd;
            ComparableDescriptor desc;
            String smi;
            block8: {
                Entity e = CS.this.clus.getHC().getTree().getLeaf(this.id.getCurrentValue());
                smi = CS.this.cff.getRetrieveLeaveIntermediate().getPropertyObject(e);
                HC.RetrieveDescriptor retr = CS.this.cff.getRetrieveLeaveDescriptor();
                desc = CS.this.cff.getDescriptor();
                dd = retr.getDescriptor(e);
                c = conn.respondHTMLCreator("Structure");
                CS.this.appendHeader(c, this);
                c.h1("Single structure view");
                boolean parentsDisplayed = false;
                if (CS.this.clus.isLeavesFirstParentIDStored() && CS.this.clus.getLeavesFirstParentID().getPropertyInt(e) != 0) {
                    int i;
                    parentsDisplayed = true;
                    c.h2("Parent cluster(s)");
                    c.p("Here the clusters containing the selected structure are displayed. The last cluster is the immediate parent of this structure. The firs displayed cluster is the one assigned to the highest hierarchy level.");
                    int pi = CS.this.clus.getLeavesFirstParentID().getPropertyInt(e);
                    EntityGroup g = CS.this.clus.getHC().getTree().getGroup(pi);
                    IntVector fps = new IntVector();
                    IntVector fpsiz = new IntVector();
                    fps.add(pi);
                    fpsiz.add(g.size());
                    if (CS.this.clus.isFirstParentIDStored() && CS.this.clus.getFirstParentID().getPropertyInt(g.properties()) != 0) {
                        int fpi;
                        EntityGroup gg = g;
                        while (fps.size() < 20 && (fpi = CS.this.clus.getFirstParentID().getPropertyInt(gg.properties())) != 0) {
                            fps.add(fpi);
                            gg = CS.this.clus.getHC().getTree().getGroup(fpi);
                            fpsiz.add(gg.size());
                        }
                    }
                    t = c.table(HTMLCreator.HAlign.center);
                    r = t.row();
                    r.hcell(fps.size(), 1, HTMLCreator.HAlign.center, "Parents");
                    r.close();
                    r = t.row();
                    for (i = fps.size() - 1; i >= 0; --i) {
                        r.hcell(HTMLCreator.HAlign.center, "ID=" + fps.get(i) + " Size=" + fpsiz.get(i));
                    }
                    r.close();
                    r = t.row();
                    for (i = fps.size() - 1; i >= 0; --i) {
                        r.cell(HTMLCreator.HAlign.center, "<a href=\"" + CS.this.tl("/show/singlecluster?id=" + fps.get(i)) + "\">" + "<img src=\"" + CS.this.tl("/get/cluster/png?id=" + fps.get(i)) + "&w=" + ((CSSession)this.getSession()).tableImageSize.getCurrentValue() + "&h=" + ((CSSession)this.getSession()).tableImageSize.getCurrentValue() + "\" border=\"0\" />" + "</a>");
                    }
                    r.close();
                    t.close();
                }
                if (parentsDisplayed) {
                    c.h2("Selected structure");
                }
                t = c.table(HTMLCreator.HAlign.center);
                r = t.row();
                r.hcell(1, 4, HTMLCreator.HAlign.center, "<img src=\"" + CS.this.tl("/get/leave/png?id=" + this.id.getCurrentValue() + "&w=" + this.imgsiz.getCurrentValue() + "&h=" + this.imgsiz.getCurrentValue()) + "\" alt=\"Structure\" border=\"0\"/>");
                r.hcell(HTMLCreator.HAlign.left, "Id");
                r.cell("" + this.id.getCurrentValue());
                r.close();
                r = t.row();
                r.hcell(1, 2, HTMLCreator.HAlign.left, "Download");
                r.cell("<a href=\"" + CS.this.tl("/get/leave/smiles?id=" + this.id.getCurrentValue()) + "\">smiles</a>");
                r.close();
                r = t.row();
                smie = smi;
                try {
                    smie = URLEncoder.encode(smi, "UTF-8");
                }
                catch (Exception ex) {
                    if (!CS.this.log.isErrorEnabled()) break block8;
                    CS.this.log.error((Object)"Exception processing smiles", (Throwable)ex);
                }
            }
            r.cell("<a href=\"http://chemaxon.com/marvin/sketch/index.jsp?mol=" + smie + "\">Open in marvin demo</a>");
            r.close();
            r = t.row();
            r.hcell(HTMLCreator.HAlign.left, "Image size");
            r.cell(HTMLCreator.HAlign.center, ((CSSession)this.getSession()).zoomInOutLinks(null, this.imgsiz, 10, 10000));
            r.close();
            t.close();
            c.p("");
            t = c.table(HTMLCreator.HAlign.left, "100%");
            r = t.row();
            r.hcell(HTMLCreator.HAlign.left, "SMILES");
            r.cell(HTMLCreator.HAlign.left, smi);
            r.close();
            r = t.row();
            r.hcell(HTMLCreator.HAlign.left, "Descriptor (serialized)");
            r.cell(HTMLCreator.HAlign.left, CS.makeWrappable(desc.toString(dd)));
            r.close();
            r = t.row();
            r.hcell(HTMLCreator.HAlign.left, "Descriptor (human readable)");
            r.cell(HTMLCreator.HAlign.left, CS.makeWrappable(desc.toHumanReadableString(dd)));
            r.close();
            t.close();
        }
    }

    public class ShowMatrix
    extends Server.Action<CSSession> {
        Server.Action.IAParamDescriptor cgt = this.addIAParamDescriptor("cgt", new int[]{0, 0}, true);
        Server.Action.IParamDescriptor cst = this.addIParamDescriptor("cst", 0);
        Server.Action.IAParamDescriptor rgt = this.addIAParamDescriptor("rgt", new int[]{0, 0}, true);
        Server.Action.IParamDescriptor rst = this.addIParamDescriptor("rst", 0);

        @Override
        public Server.Action initClone() {
            return new ShowMatrix();
        }

        String appendClusterSelector(Server.Action.IAParamDescriptor gt, String sep, String gsep) {
            StringBuffer b = new StringBuffer();
            int[] cv = gt.getCurrentValue();
            b.append("<b>All</b>");
            b.append(sep);
            String s = "natural";
            int i = 0;
            if (cv[0] == 0 && cv[1] == i) {
                b.append("<b>");
                b.append(s);
                b.append("</b>");
            } else {
                b.append("<a href=\"" + gt.getChangedLink(new int[]{0, i}) + "\">" + s + "</a>");
            }
            b.append(sep);
            s = "desc.s.";
            i = 1;
            if (cv[0] == 0 && cv[1] == i) {
                b.append("<b>");
                b.append(s);
                b.append("</b>");
            } else {
                b.append("<a href=\"" + gt.getChangedLink(new int[]{0, i}) + "\">" + s + "</a>");
            }
            b.append(sep);
            s = "asc.s.";
            i = 2;
            if (cv[0] == 0 && cv[1] == i) {
                b.append("<b>");
                b.append(s);
                b.append("</b>");
            } else {
                b.append("<a href=\"" + gt.getChangedLink(new int[]{0, i}) + "\">" + s + "</a>");
            }
            b.append(gsep);
            b.append("<b>No singletons</b>");
            b.append(sep);
            s = "natural";
            i = 3;
            if (cv[0] == 0 && cv[1] == i) {
                b.append("<b>");
                b.append(s);
                b.append("</b>");
            } else {
                b.append("<a href=\"" + gt.getChangedLink(new int[]{0, i}) + "\">" + s + "</a>");
            }
            b.append(sep);
            s = "desc.s.";
            i = 4;
            if (cv[0] == 0 && cv[1] == i) {
                b.append("<b>");
                b.append(s);
                b.append("</b>");
            } else {
                b.append("<a href=\"" + gt.getChangedLink(new int[]{0, i}) + "\">" + s + "</a>");
            }
            b.append(sep);
            s = "asc.s.";
            i = 5;
            if (cv[0] == 0 && cv[1] == i) {
                b.append("<b>");
                b.append(s);
                b.append("</b>");
            } else {
                b.append("<a href=\"" + gt.getChangedLink(new int[]{0, i}) + "\">" + s + "</a>");
            }
            b.append(gsep);
            b.append("<b>Singletons</b>");
            b.append(sep);
            s = "natural";
            i = 6;
            if (cv[0] == 0 && cv[1] == i) {
                b.append("<b>");
                b.append(s);
                b.append("</b>");
            } else {
                b.append("<a href=\"" + gt.getChangedLink(new int[]{0, i}) + "\">" + s + "</a>");
            }
            b.append(sep);
            return b.toString();
        }

        @Override
        public void execute(ServerConnection conn) {
            int idx;
            int idx2;
            int i;
            HTMLCreator c = conn.respondHTMLCreator("Matrix view");
            CS.this.appendHeader(c, this);
            int cols = ((CSSession)this.getSession()).matrixCols.getCurrentValue();
            int rows = ((CSSession)this.getSession()).matrixRows.getCurrentValue();
            int imgs = ((CSSession)this.getSession()).matrixImageSize.getCurrentValue();
            HC.RetrieveDescriptor crepr = CS.this.clus.getClusterRepresentantDescriptor();
            ComparableDescriptor desc = CS.this.cff.getDescriptor();
            HC.RetrieveDescriptor dr = CS.this.cff.getRetrieveLeaveDescriptor();
            int colgsize = 0;
            int rowgsize = 0;
            RAIterator<EntityGroup> colg = null;
            RAIterator<Entity> colsg = null;
            if (this.cgt.getCurrentValue()[0] == 0) {
                colg = CS.this.gc.getFilteredGroup(1, this.cgt.getCurrentValue()[1]);
                colgsize = colg.size();
            } else {
                colsg = CS.this.clus.getHC().getTree().getGroup(this.cgt.getCurrentValue()[1]).iterator();
                colgsize = colsg.size();
            }
            RAIterator<EntityGroup> rowg = null;
            RAIterator<Entity> rowsg = null;
            if (this.rgt.getCurrentValue()[0] == 0) {
                rowg = CS.this.gc.getFilteredGroup(1, this.rgt.getCurrentValue()[1]);
                rowgsize = rowg.size();
            } else {
                rowsg = CS.this.clus.getHC().getTree().getGroup(this.rgt.getCurrentValue()[1]).iterator();
                rowgsize = rowsg.size();
            }
            if (this.cst.getCurrentValue() >= colgsize) {
                this.cst.setCurrentValue(colgsize - cols);
            }
            if (this.cst.getCurrentValue() < 0) {
                this.cst.setCurrentValue(0);
            }
            if (this.rst.getCurrentValue() >= rowgsize) {
                this.rst.setCurrentValue(rowgsize - rows);
            }
            if (this.rst.getCurrentValue() < 0) {
                this.rst.setCurrentValue(0);
            }
            HTMLCreator.TablePrinter t = c.table(HTMLCreator.HAlign.center);
            HTMLCreator.TableRow r = t.row();
            r.ecell(3, colg == null ? 3 : 4, HTMLCreator.HAlign.center, "Columns:&nbsp" + ((CSSession)this.getSession()).plussMinusLinks(this, ((CSSession)this.getSession()).matrixCols, 1, 50) + "&nbsp;" + "Rows:&nbsp" + ((CSSession)this.getSession()).plussMinusLinks(this, ((CSSession)this.getSession()).matrixRows, 1, 50) + "<BR>" + "ImgSize:&nbsp" + ((CSSession)this.getSession()).zoomInOutLinks(this, ((CSSession)this.getSession()).matrixImageSize, 30, 1000));
            StringBuffer cscell = new StringBuffer();
            cscell.append(this.appendClusterSelector(this.cgt, "&nbsp;", "&nbsp;|&nbsp;"));
            cscell.append(" ");
            if (colg == null) {
                cscell.append("<b>Group&nbsp;" + this.cgt.getCurrentValue()[1] + "&nbsp;members:</b>&nbsp;");
            }
            cscell.append(CS.this.getPageLinks(null, this.cst, cols, colgsize));
            r.hcell(cols, 1, HTMLCreator.HAlign.center, cscell.toString());
            r.close();
            CDescriptor[] cd = new CDescriptor[cols];
            int[] ci = new int[cols];
            EntityGroup[] cg = new EntityGroup[cols];
            Entity[] ce = new Entity[cols];
            r = t.row();
            for (i = 0; i < cols && (idx2 = i + this.cst.getCurrentValue()) < colgsize; ++i) {
                if (colg != null) {
                    cg[i] = (EntityGroup)colg.get(idx2);
                    if (crepr != null) {
                        cd[i] = (CDescriptor)crepr.getPropertyObject(cg[i].properties());
                    }
                    ci[i] = cg[i].properties().indexOfEntity();
                    r.hcell(HTMLCreator.HAlign.center, "<b>(" + (idx2 + 1) + ") Group ID: " + ci[i] + "</b>");
                    continue;
                }
                ce[i] = (Entity)colsg.get(idx2);
                cd[i] = dr.getDescriptor(ce[i]);
                ci[i] = ce[i].getIndex();
                r.hcell(HTMLCreator.HAlign.center, "<b>(" + (idx2 + 1) + ") Node ID: " + ci[i] + "</b>");
            }
            r.close();
            r = t.row();
            for (i = 0; i < cols && (idx2 = i + this.cst.getCurrentValue()) < colgsize; ++i) {
                if (colg != null) {
                    r.hcell(HTMLCreator.HAlign.center, "<a href=\"" + this.cgt.getChangedLink(new int[]{1, ci[i]}) + "\">" + "<img src=\"" + CS.this.tl("/get/cluster/png?id=" + ci[i] + "&w=" + ((CSSession)this.getSession()).matrixImageSize.getCurrentValue() + "&h=" + ((CSSession)this.getSession()).matrixImageSize.getCurrentValue()) + "\" alt=\"Cluster representant image\" border=\"0\"/>" + "</a>");
                    continue;
                }
                r.hcell(HTMLCreator.HAlign.center, "<img src=\"" + CS.this.tl("/get/leave/png?id=" + ci[i] + "&w=" + ((CSSession)this.getSession()).matrixImageSize.getCurrentValue() + "&h=" + ((CSSession)this.getSession()).matrixImageSize.getCurrentValue()) + "\" alt=\"Cluster element image\" border=\"0\"/>");
            }
            r.close();
            if (colg != null) {
                r = t.row();
                for (i = 0; i < cols && (idx2 = i + this.cst.getCurrentValue()) < colgsize; ++i) {
                    if (colg == null) continue;
                    r.hcell(HTMLCreator.HAlign.center, "size: " + cg[i].size());
                }
                r.close();
            }
            CDescriptor[] rd = new CDescriptor[rows];
            int[] ri = new int[cols];
            EntityGroup[] rg = new EntityGroup[rows];
            Entity[] re = new Entity[rows];
            for (int i2 = 0; i2 < rows && (idx = i2 + this.rst.getCurrentValue()) < rowgsize; ++i2) {
                r = t.row();
                if (i2 == 0) {
                    StringBuffer rscell = new StringBuffer();
                    rscell.append(this.appendClusterSelector(this.rgt, "<br>", "<br><hr><br>"));
                    rscell.append("<BR><BR><BR>");
                    if (rowg == null) {
                        rscell.append("<b>Group&nbsp;" + this.rgt.getCurrentValue()[1] + "&nbsp;members:</b><BR><BR><BR>");
                    }
                    rscell.append(CS.this.getPageLinks(null, this.rst, rows, rowgsize, "<BR>"));
                    r.hcell(1, rows, HTMLCreator.HAlign.center, rscell.toString());
                }
                if (rowg != null) {
                    rg[i2] = (EntityGroup)rowg.get(idx);
                    ri[i2] = rg[i2].properties().indexOfEntity();
                    if (crepr != null) {
                        rd[i2] = (CDescriptor)crepr.getPropertyObject(rg[i2].properties());
                    }
                    r.hcell(HTMLCreator.HAlign.center, "<B>(" + (idx + 1) + ")" + "<BR><BR>Group ID:" + "<BR>" + ri[i2] + "<BR><BR>size:" + "<BR>" + rg[i2].size());
                    r.hcell(HTMLCreator.HAlign.center, "<a href=\"" + this.rgt.getChangedLink(new int[]{1, ri[i2]}) + "\">" + "<img src=\"" + CS.this.tl("/get/cluster/png?id=" + ri[i2] + "&w=" + ((CSSession)this.getSession()).matrixImageSize.getCurrentValue() + "&h=" + ((CSSession)this.getSession()).matrixImageSize.getCurrentValue()) + "\" alt=\"Cluster representant image\" border=\"0\"/>" + "</a>");
                } else {
                    re[i2] = (Entity)rowsg.get(idx);
                    ri[i2] = re[i2].getIndex();
                    rd[i2] = dr.getDescriptor(re[i2]);
                    r.hcell(HTMLCreator.HAlign.center, "<B>(" + (idx + 1) + ")" + "<BR><BR>Node ID:" + "<BR>" + ri[i2]);
                    r.hcell(HTMLCreator.HAlign.center, "<img src=\"" + CS.this.tl("/get/leave/png?id=" + ri[i2] + "&w=" + ((CSSession)this.getSession()).matrixImageSize.getCurrentValue() + "&h=" + ((CSSession)this.getSession()).matrixImageSize.getCurrentValue()) + "\" alt=\"Cluster representant image\" border=\"0\"/>");
                }
                for (int j = 0; j < cols; ++j) {
                    if (cd[j] == null) continue;
                    double d = desc.calcDistance(cd[j], rd[i2]);
                    r.cell(HTMLCreator.HAlign.center, TextUtils.formatNumber(d, 2) + "<BR><BR><BR>" + "<img src=\"" + CS.this.tl("/generate/barimage?w=" + ((CSSession)this.getSession()).matrixImageSize.getCurrentValue() + "&h=7&b1=" + d) + "\" />");
                }
                r.close();
            }
            t.close();
            c.close();
        }
    }

    public static class CSSession
    extends Server.Session {
        Server.Action.IParamDescriptor tableImageSize = this.addIParamDescriptor("tis", 150);
        Server.Action.IParamDescriptor tableCols = this.addIParamDescriptor("tcc", 5);
        Server.Action.IParamDescriptor tableRows = this.addIParamDescriptor("trc", 3);
        Server.Action.IParamDescriptor clustersShowID = this.addIParamDescriptor("clustersShowID", 1);
        Server.Action.IParamDescriptor clustersShowSize = this.addIParamDescriptor("clustersShowSize", 1);
        Server.Action.IParamDescriptor clustersShowCovBar = this.addIParamDescriptor("clustersShowCovBar", 1);
        Server.Action.IParamDescriptor sclusviewShowDist = this.addIParamDescriptor("sclusviewShowDist", 1);
        Server.Action.IParamDescriptor sclusviewShowDistBar = this.addIParamDescriptor("sclusviewShowDistBa", 1);
        Server.Action.IParamDescriptor sclusviewShowID = this.addIParamDescriptor("sclusviewShowID", 1);
        Server.Action.IParamDescriptor matrixCols = this.addIParamDescriptor("matrixcols", 10);
        Server.Action.IParamDescriptor matrixRows = this.addIParamDescriptor("matrixrows", 5);
        Server.Action.IParamDescriptor matrixImageSize = this.addIParamDescriptor("matriximgsize", 120);

        public CSSession(Server server) {
            super(server);
        }

        public String plussMinusLinks(Server.Action a, Server.Action.IParamDescriptor pd, int lowerLimit, int upperLimit) {
            int cv = pd.getCurrentValue();
            int lv = cv - 1;
            int hv = cv + 1;
            if (lv < lowerLimit) {
                lv = lowerLimit;
            }
            if (hv > upperLimit) {
                hv = upperLimit;
            }
            return "<a href=\"" + pd.getChangedLink(a, "" + lv) + "\">" + CS.getIconImage("minus16.png", this.getServer().getTlink()) + "</a>&nbsp;<a href=\"" + pd.getChangedLink(a, "" + hv) + "\">" + CS.getIconImage("plus16.png", this.getServer().getTlink()) + "</a>";
        }

        public String zoomInOutLinks(Server.Action a, Server.Action.IParamDescriptor pd, int lowerLimit, int upperLimit) {
            int cv = pd.getCurrentValue();
            int lv = (int)Math.round((double)pd.getCurrentValue() / 1.3);
            int hv = (int)Math.round((double)pd.getCurrentValue() * 1.3);
            if (lv < lowerLimit) {
                lv = lowerLimit;
            }
            if (hv > upperLimit) {
                hv = upperLimit;
            }
            return "<a href=\"" + pd.getChangedLink(a, "" + lv) + "\">" + CS.getIconImage("zoom-out16.png", this.getServer().getTlink()) + "</a>&nbsp;<a href=\"" + pd.getChangedLink(a, "" + hv) + "\">" + CS.getIconImage("zoom-in16.png", this.getServer().getTlink()) + "</a>";
        }

        public String imgResizerLinks(Server.Action a) {
            return this.zoomInOutLinks(a, this.tableImageSize, 10, 1920);
        }

        public String tableColCtLinks(Server.Action a) {
            return this.plussMinusLinks(a, this.tableCols, 1, 50);
        }

        public String tableRowCtLinks(Server.Action a) {
            return this.plussMinusLinks(a, this.tableRows, 1, 50);
        }
    }
}

