/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering.tools.simpleeval;

import chemaxon.clustering.tools.simpleeval.DoubleVariable;
import chemaxon.clustering.tools.simpleeval.EvalUtil;
import chemaxon.clustering.tools.simpleeval.OperatorDouble;
import chemaxon.clustering.tools.simpleeval.OperatorInt;

public class MultiplyDI
implements OperatorDouble {
    OperatorDouble op1;
    OperatorInt op2;

    public MultiplyDI(OperatorDouble op1, OperatorInt op2) {
        this.op1 = op1;
        this.op2 = op2;
    }

    public MultiplyDI(double op1, OperatorInt op2) {
        this.op1 = new DoubleVariable(op1);
        this.op2 = op2;
    }

    @Override
    public double evaluateDouble() {
        return this.op1.evaluateDouble() * (double)this.op2.evaluateInt();
    }

    @Override
    public Double evaluate() {
        return new Double(this.evaluateDouble());
    }

    @Override
    public String toString(boolean symbolic) {
        return EvalUtil.toString(this.op1, this.op2, "*", this.getPrecedence(), symbolic);
    }

    @Override
    public int getPrecedence() {
        return 3;
    }

    @Override
    public void clearUsage() {
        this.op1.clearUsage();
        this.op2.clearUsage();
    }

    @Override
    public void setUsage() {
        this.op1.setUsage();
        this.op2.setUsage();
    }

    @Override
    public void checkUsage() {
        this.clearUsage();
        this.setUsage();
    }

    @Override
    public boolean isUsed() {
        return true;
    }
}

