/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering.tools.simplexml.create;

import chemaxon.clustering.tools.simplexml.create.Printer;
import chemaxon.clustering.tools.simplexml.create.XMLNode;
import chemaxon.clustering.tools.simplexml.create.XMLNodeAdmin;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SimpleXMLNode<S extends Printer>
implements XMLNodeAdmin<S> {
    Log log = LogFactory.getLog(SimpleXMLNode.class);
    S s;
    boolean attributesDone = false;
    boolean childsDone = false;
    XMLNodeAdmin.Pinger ping = null;
    boolean wrsTagOpenNameWritten = false;
    boolean wrsTagOpenFullyWritten = false;
    boolean wrsNodeWritten = false;
    boolean newline = false;
    String name = null;
    Vector<String> attribs = null;
    Vector<XMLNodeAdmin<S>> childs = null;
    Vector<XMLNodeAdmin<S>> passedchilds = null;

    public SimpleXMLNode(String name, boolean newline) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("[" + name + "] Node constructed"));
        }
        this.name = name;
        this.newline = newline;
    }

    @Override
    public void addAttribute(String name, String value) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("[" + this.getName() + "] Add attribute: " + name + "=" + value));
        }
        if (this.attributesDone) {
            throw new UnsupportedOperationException("addParam on closed node");
        }
        if (this.attribs == null) {
            this.attribs = new Vector();
        }
        this.attribs.add(name);
        this.attribs.add(value);
        if (this.wrsTagOpenNameWritten) {
            this.update();
        }
    }

    @Override
    public void setPinger(XMLNodeAdmin.Pinger ping) {
        this.ping = ping;
    }

    @Override
    public void addChild(XMLNode<S> child) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("[" + this.name + "] Add child: " + child.getName()));
        }
        if (!this.attributesDone && this.log.isInfoEnabled()) {
            this.log.info((Object)"Child added before attributes done", new Throwable());
        }
        if (this.childsDone) {
            throw new UnsupportedOperationException("addChild on closed node");
        }
        if (this.childs == null) {
            this.childs = new Vector();
        }
        this.childs.add((XMLNodeAdmin)child);
        if (this.wrsTagOpenNameWritten) {
            this.update();
        }
    }

    @Override
    public void close() {
        int i;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("[" + this.getName() + "] close"));
        }
        this.attributesDone = true;
        this.childsDone = true;
        if (this.passedchilds != null) {
            for (i = 0; i < this.passedchilds.size(); ++i) {
                this.passedchilds.get(i).close();
            }
        }
        if (this.childs != null) {
            for (i = 0; i < this.childs.size(); ++i) {
                this.childs.get(i).close();
            }
        }
        if (this.wrsTagOpenNameWritten) {
            this.update();
        }
    }

    @Override
    public void hintChildsDone() {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("[" + this.getName() + "] hintChildsDone"));
        }
        this.childsDone = true;
        if (this.wrsTagOpenNameWritten) {
            this.update();
        }
    }

    @Override
    public void hintAttributesDone() {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("[" + this.getName() + "] hintAttribsDone"));
        }
        this.attributesDone = true;
        if (this.wrsTagOpenNameWritten) {
            this.update();
        }
    }

    private void update() {
        if (this.ping != null) {
            this.ping.ping();
        }
    }

    @Override
    public XMLNodeAdmin<S> getNextChild() {
        if (this.childsDone && this.childs.size() == 0) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        if (!this.childsDone && this.childs.size() == 0) {
            return null;
        }
        XMLNodeAdmin<S> c = this.childs.remove(0);
        if (this.passedchilds == null) {
            this.passedchilds = new Vector();
        }
        this.passedchilds.add(c);
        return c;
    }

    @Override
    public XMLNodeAdmin.updateState writeStream() {
        while (true) {
            if (this.wrsNodeWritten) {
                return XMLNodeAdmin.updateState.writeFinished;
            }
            if (!this.wrsTagOpenNameWritten) {
                this.wrsTagOpenNameWritten = true;
                if (this.newline) {
                    this.s.println();
                }
                this.s.print('<');
                this.s.print(this.name);
                if (!this.log.isTraceEnabled()) continue;
                this.log.trace((Object)("[" + this.getName() + "] Tag open name written"));
                continue;
            }
            if (this.wrsTagOpenNameWritten && this.attribs != null && this.attribs.size() > 0) {
                for (int i = 0; i < this.attribs.size(); ++i) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)("[" + this.getName() + "] Write attribute " + this.attribs.get(i)));
                    }
                    this.s.print(' ');
                    this.s.print(this.attribs.get(i++));
                    this.s.print('=');
                    this.s.print('\"');
                    this.s.print(this.attribs.get(i));
                    this.s.print('\"');
                }
                this.attribs.clear();
                continue;
            }
            if (this.attributesDone) {
                if (this.childsDone && (this.childs == null || this.childs.size() == 0) && !this.wrsTagOpenFullyWritten) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)("[" + this.getName() + "] Write short close tag"));
                    }
                    this.s.print("/>");
                    this.wrsNodeWritten = true;
                    continue;
                }
                if (this.childs != null && this.childs.size() > 0 && !this.wrsTagOpenFullyWritten) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)("[" + this.getName() + "] Finish opening tag"));
                    }
                    this.s.print('>');
                    this.wrsTagOpenFullyWritten = true;
                    continue;
                }
                if (!this.wrsTagOpenFullyWritten) {
                    return XMLNodeAdmin.updateState.writingTag;
                }
            } else {
                return XMLNodeAdmin.updateState.writingTag;
            }
            if (!this.wrsTagOpenFullyWritten || !this.childsDone || this.childs.size() != 0) break;
            if (this.newline) {
                this.s.println();
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("[" + this.getName() + "] Write closing tag"));
            }
            this.s.println("</" + this.name + ">");
            this.wrsNodeWritten = true;
        }
        if (this.wrsTagOpenFullyWritten && (!this.childsDone || this.childs.size() != 0)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("[" + this.getName() + "] Waiting for child"));
            }
            return XMLNodeAdmin.updateState.waitingForChild;
        }
        throw new UnsupportedOperationException("Internal state error " + this.wrsTagOpenFullyWritten + " " + this.wrsTagOpenNameWritten);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public static XMLNode createXML(final Printer ps, String rootNodeName) {
        SimpleXMLNode root = new SimpleXMLNode(rootNodeName, true);
        Updater<Printer> updater = new Updater<Printer>(root, ps);
        updater.setClosedCallback(new XMLNodeAdmin.Pinger(){

            @Override
            public void ping() {
                ps.close();
            }
        });
        ps.print("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        updater.ping();
        return root;
    }

    @Override
    public void setStream(S stream) {
        this.s = stream;
    }

    public static class Updater<S>
    implements XMLNodeAdmin.Pinger {
        Log log = LogFactory.getLog(Updater.class);
        XMLNodeAdmin<S> root;
        S stream;
        Vector<XMLNodeAdmin<S>> stack;
        XMLNodeAdmin.Pinger closedCallback = null;
        boolean pinging = false;

        public Updater(XMLNodeAdmin<S> root, S stream) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Constructed. Root name: " + root.getName()));
            }
            this.root = root;
            this.stream = stream;
            this.stack = new Vector();
            this.addToStack(root);
        }

        void addToStack(XMLNodeAdmin<S> item) {
            item.setPinger(this);
            item.setStream(this.stream);
            this.stack.add(item);
        }

        public void setClosedCallback(XMLNodeAdmin.Pinger closedCallback) {
            this.closedCallback = closedCallback;
        }

        @Override
        public void ping() {
            if (this.pinging) {
                return;
            }
            this.pinging = true;
            this.ping_0();
            this.pinging = false;
        }

        void ping_0() {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"Ping");
            }
            boolean newLoop = true;
            while (newLoop) {
                newLoop = false;
                if (this.stack.size() == 0) {
                    return;
                }
                XMLNodeAdmin<S> tos = this.stack.lastElement();
                XMLNodeAdmin.updateState state = tos.writeStream();
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("TOS: " + tos.getName() + " state: " + (Object)((Object)state)));
                }
                switch (state) {
                    case writingTag: {
                        break;
                    }
                    case waitingForChild: {
                        XMLNodeAdmin<S> child = tos.getNextChild();
                        if (child == null) break;
                        this.addToStack(child);
                        newLoop = true;
                        break;
                    }
                    case writeFinished: {
                        this.stack.remove(this.stack.size() - 1);
                        newLoop = true;
                        if (this.stack.size() != 0) break;
                        if (this.closedCallback != null) {
                            this.closedCallback.ping();
                        }
                        return;
                    }
                }
            }
        }
    }
}

