/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering.util;

import chemaxon.common.util.IntVector;
import java.util.BitSet;

public class IntStat {
    IntVector vals = new IntVector();
    IntVector freq = new IntVector();

    public void addValue(int v) {
        this.addValue(v, 1);
    }

    public void addValue(int v, int f) {
        if (f == 0) {
            return;
        }
        int pos = -1;
        boolean match = false;
        for (int i = 0; i < this.vals.size(); ++i) {
            int vi = this.vals.get(i);
            if (vi == v) {
                match = true;
                pos = i;
                break;
            }
            if (vi <= v) continue;
            match = false;
            pos = i;
            break;
        }
        if (match) {
            this.freq.set(pos, this.freq.get(pos) + f);
        } else if (pos < 0) {
            this.vals.add(v);
            this.freq.add(f);
        } else {
            this.vals.insertElementAt(v, pos);
            this.freq.insertElementAt(f, pos);
        }
    }

    public int getFreq(int v) {
        for (int i = 0; i < this.vals.size(); ++i) {
            if (this.vals.get(i) == v) {
                return this.freq.get(i);
            }
            if (this.vals.get(i) <= v) continue;
            return 0;
        }
        return 0;
    }

    public BitSet getUsedFreqs() {
        BitSet ret = new BitSet();
        this.setUsedFreqs(ret);
        return ret;
    }

    public void setUsedFreqs(BitSet b) {
        for (int i = this.vals.size() - 1; i >= 0; --i) {
            if (this.freq.get(i) == 0) continue;
            b.set(this.vals.get(i));
        }
    }

    public int getFreqCount() {
        return this.freq.size();
    }

    public int getFreqByIndex(int i) {
        return this.freq.get(i);
    }

    public int getValsByIndex(int i) {
        return this.vals.get(i);
    }

    public int getFreq() {
        int fsum = 0;
        for (int i = 0; i < this.freq.size(); ++i) {
            fsum += this.freq.get(i);
        }
        return fsum;
    }

    public String toString() {
        if (this.vals.isEmpty()) {
            return "EMPTY";
        }
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < this.vals.size(); ++i) {
            if (i != 0) {
                b.append(' ');
            }
            b.append(this.vals.get(i));
            b.append(':');
            b.append(this.freq.get(i));
            b.append('x');
        }
        return b.toString();
    }
}

