/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering.util;

import chemaxon.clustering.util.IntegerIterator;
import chemaxon.clustering.util.IntegerSet;
import chemaxon.clustering.util.SimpleIntegerSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RangeIntegerSet
implements IntegerSet {
    boolean all = false;
    boolean lo = false;
    int ll = 0;
    boolean ho = false;
    int hl = 0;
    IntegerSet singleValues = null;

    public RangeIntegerSet(String range) {
        int i;
        Log log = LogFactory.getLog(RangeIntegerSet.class);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Construct RangeIntegerSet(" + range + ")"));
        }
        if (range.equalsIgnoreCase("none")) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"NONE selected");
            }
            return;
        }
        if (range.equalsIgnoreCase("all")) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"ALL selected");
            }
            this.all = true;
            return;
        }
        String[] specifiers = range.split(",");
        if (log.isTraceEnabled()) {
            log.trace((Object)"Specifiers recognized:");
            for (i = 0; i < specifiers.length; ++i) {
                log.trace((Object)specifiers[i]);
            }
        }
        for (i = 0; i < specifiers.length; ++i) {
            int n;
            String s = specifiers[i];
            if (s.indexOf(45) < 0) {
                int v = Integer.parseInt(s);
                if (this.singleValues == null) {
                    this.singleValues = new SimpleIntegerSet();
                }
                this.singleValues.add(v);
                if (!log.isTraceEnabled()) continue;
                log.trace((Object)("Single value added: " + v));
                continue;
            }
            String[] ss = s.split("-");
            if (ss.length == 1) {
                if (s.endsWith("-")) {
                    n = Integer.parseInt(ss[0]);
                    if (this.ho && n >= this.hl) continue;
                    this.ho = true;
                    this.hl = n;
                    if (!log.isTraceEnabled()) continue;
                    log.trace((Object)("Higher open new limit: " + this.hl));
                    continue;
                }
                throw new UnsupportedOperationException();
            }
            if (ss.length == 2) {
                if (s.startsWith("-")) {
                    n = Integer.parseInt(ss[1]);
                    if (this.lo && n <= this.ll) continue;
                    this.lo = true;
                    this.ll = n;
                    if (!log.isTraceEnabled()) continue;
                    log.trace((Object)("Lower open new limit: " + this.ll));
                    continue;
                }
                int n1 = Integer.parseInt(ss[0]);
                int n2 = Integer.parseInt(ss[1]);
                if (this.singleValues == null) {
                    this.singleValues = new SimpleIntegerSet();
                }
                for (int ii = n1; ii <= n2; ++ii) {
                    if (this.singleValues.contains(ii)) continue;
                    this.singleValues.add(ii);
                }
                if (!log.isTraceEnabled()) continue;
                log.trace((Object)("Interval added: " + n1 + "-" + n2));
                continue;
            }
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public boolean contains(int value) {
        if (this.all) {
            return true;
        }
        if (this.lo && value <= this.ll) {
            return true;
        }
        if (this.ho && value >= this.hl) {
            return true;
        }
        return this.singleValues != null && this.singleValues.contains(value);
    }

    public String toString() {
        if (this.all) {
            return "all";
        }
        StringBuffer ret = new StringBuffer();
        if (this.lo) {
            ret.append("-" + this.ll);
        }
        if (this.singleValues != null) {
            for (int i = 0; i < this.singleValues.size(); ++i) {
                if (ret.length() > 0) {
                    ret.append(',');
                }
                int v = this.singleValues.get(i);
                ret.append(v);
            }
        }
        if (this.ho) {
            if (ret.length() > 0) {
                ret.append(',');
            }
            ret.append(this.hl + "-");
        }
        return ret.toString();
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void add(int value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int get(int index) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean remove(int value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int removeFirst() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int removeLast() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int indexOf(int value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void removeAll() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void removeElementAt(int index) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public IntegerIterator iterator() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int[] toIntArray() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int max() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void addInterval(int lowest, int highest) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void ensureCapacity(int itemCount, int itemRange) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

