/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering.util;

import chemaxon.clustering.util.RAIterator;
import chemaxon.clustering.util.RandomAccess;
import java.util.ConcurrentModificationException;

public class SimpleRAIterator<E>
implements RAIterator<E> {
    int ccexp;
    int nextToReturn;
    RandomAccess<E> base;

    public SimpleRAIterator(RandomAccess<E> base) {
        this.ccexp = base.getCC();
        this.base = base;
        this.nextToReturn = 0;
    }

    void checkCC() {
        if (this.ccexp != this.base.getCC()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void reset() {
        this.checkCC();
        this.nextToReturn = 0;
    }

    @Override
    public boolean hasNext() {
        this.checkCC();
        return this.nextToReturn < this.base.size();
    }

    @Override
    public E next() {
        if (this.hasNext()) {
            return this.base.get(this.nextToReturn++);
        }
        return null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        this.checkCC();
        return this.base.size();
    }

    @Override
    public E get(int i) {
        return this.base.get(i);
    }

    @Override
    public int getCC() {
        return this.base.getCC();
    }

    @Override
    public int indexOf(E e) {
        return this.base.indexOf(e);
    }

    public static <E> int naiveIndexOf(RandomAccess<E> base, E e) {
        for (int i = 0; i < base.size(); ++i) {
            if (base.get(i) != e) continue;
            return i;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public boolean isGetSupported() {
        return true;
    }
}

