/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering.util;

import chemaxon.marvin.modelling.util.U;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TextUtil {

    public static class ProcessArguments {
        Log log = LogFactory.getLog(ProcessArguments.class);
        Vector<String> args;

        public ProcessArguments(String[] args) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Construct, args: " + U.sel(args)));
            }
            if (args == null) {
                args = new String[]{};
            }
            this.args = new Vector(args.length);
            for (int i = 0; i < args.length; ++i) {
                this.args.add(args[i]);
            }
        }

        public ProcessArguments(String arg, String prefix, char delimiter) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Construct, arg: " + arg + " delimiter: " + delimiter));
            }
            if (prefix != null && prefix.length() != 0) {
                if (!arg.startsWith(prefix)) {
                    throw new IndexOutOfBoundsException("Prefix mismatch");
                }
                arg = arg.substring(prefix.length());
            }
            if (arg == null) {
                this.args = new Vector();
                return;
            }
            StringTokenizer t = new StringTokenizer(arg, Character.toString(delimiter));
            int tc = t.countTokens();
            this.args = new Vector(tc);
            while (t.hasMoreTokens()) {
                this.args.add(t.nextToken());
            }
        }

        public ProcessArguments(String arg, char delimiter) {
            this(arg, null, delimiter);
        }

        public int getUnprocessedArgumentCount() {
            return this.args.size();
        }

        public boolean isEmpty() {
            return this.args.isEmpty();
        }

        public String fetchFirst() {
            if (this.isEmpty()) {
                return null;
            }
            return this.args.remove(0);
        }

        public int fetchSingleArgument(String name, boolean removeAll) {
            int ret = 0;
            for (int i = 0; i < this.args.size(); ++i) {
                if (!this.args.get(i).equals(name)) continue;
                this.args.remove(i);
                if (removeAll) {
                    ++ret;
                    --i;
                    continue;
                }
                return 1;
            }
            return ret;
        }

        public boolean fetchSingleArgument(String name) {
            return this.fetchSingleArgument(name, false) != 0;
        }

        public String fetchValue(String key) {
            for (int i = 0; i < this.args.size(); ++i) {
                int p;
                String ai = this.args.get(i);
                if (!ai.startsWith(key)) continue;
                for (p = key.length(); p < ai.length() && Character.isWhitespace(ai.charAt(p)); ++p) {
                }
                if (ai.charAt(p) != '=') continue;
                this.args.remove(ai);
                return ai.substring(p + 1);
            }
            return null;
        }

        public Integer fetchIntegerValue(String key) {
            String ret = this.fetchValue(key);
            if (ret == null) {
                return null;
            }
            return new Integer(ret);
        }

        public Boolean fetchBooleanValue(String key) {
            String ret = this.fetchValue(key);
            if (ret == null) {
                return null;
            }
            return Boolean.valueOf(ret);
        }

        public <E extends Enum<E>> E fetchEnumValue(String key, Class<E> type) {
            String ret = this.fetchValue(key);
            if (ret == null) {
                return null;
            }
            return Enum.valueOf(type, ret);
        }

        public String fetchSingleArgumentWithParam(String name) {
            for (int i = 0; i < this.args.size(); ++i) {
                if (!this.args.get(i).equals(name)) continue;
                this.args.remove(i);
                if (i < this.args.size()) {
                    return this.args.remove(i);
                }
                return "";
            }
            return null;
        }
    }
}

