/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.common.util;

import java.lang.reflect.Array;
import java.util.Arrays;

public final class ArrayTools {
    public static int[] initArray(int[] array, int length) {
        int[] newArray = array;
        if (newArray == null || newArray.length < length) {
            newArray = new int[length];
        }
        return newArray;
    }

    public static long[] initArray(long[] array, int length) {
        long[] newArray = array;
        if (newArray == null || newArray.length < length) {
            newArray = new long[length];
        }
        return newArray;
    }

    public static short[] extendArray(short[] array, int length) {
        short[] newArray = array;
        if (array == null || array.length < length) {
            newArray = new short[length + 10];
            if (null != array) {
                System.arraycopy(array, 0, newArray, 0, array.length);
            }
        }
        return newArray;
    }

    public static int[] extendArray(int[] array, int length) {
        int[] newArray = array;
        if (array == null || array.length < length) {
            newArray = new int[length + 10];
            if (null != array) {
                System.arraycopy(array, 0, newArray, 0, array.length);
            }
        }
        return newArray;
    }

    public static long[] extendArray(long[] array, int length) {
        long[] newArray = array;
        if (array == null || array.length < length) {
            newArray = new long[length + 10];
            if (null != array) {
                System.arraycopy(array, 0, newArray, 0, array.length);
            }
        }
        return newArray;
    }

    public static boolean[] initArray(boolean[] array, int length) {
        boolean[] newArray = array;
        if (newArray == null || newArray.length < length) {
            newArray = new boolean[length];
        }
        return newArray;
    }

    public static int[] initArrayAndFill(int[] array, int length, int defaultvalue) {
        int[] newArray = array;
        if (newArray == null || newArray.length < length) {
            newArray = new int[length];
            if (defaultvalue == 0) {
                return newArray;
            }
        }
        Arrays.fill(newArray, defaultvalue);
        return newArray;
    }

    public static int[] initArray(int[] array, int length, int defaultvalue) {
        int[] newArray = array;
        if (newArray == null || newArray.length < length) {
            newArray = new int[length];
            if (defaultvalue == 0) {
                return newArray;
            }
            Arrays.fill(newArray, defaultvalue);
        }
        return newArray;
    }

    public static boolean foundInArray(int[] a, int val) {
        return ArrayTools.indexInArray(a, a.length, val) != -1;
    }

    public static boolean foundInArray(long[] a, long val) {
        return ArrayTools.indexInArray(a, a.length, val) != -1L;
    }

    public static <T> boolean foundInArray(T[] a, T val) {
        return ArrayTools.indexInArray(a, a.length, val) != -1;
    }

    public static int indexInArray(int[] array, int value) {
        return ArrayTools.indexInArray(array, array.length, value);
    }

    public static long indexInArray(long[] array, long value) {
        return ArrayTools.indexInArray(array, array.length, value);
    }

    public static <T> int indexInArray(T[] array, T value) {
        return ArrayTools.indexInArray(array, 0, array.length, value);
    }

    public static int indexInArray(int[] array, int length, int value) {
        for (int x = 0; x < length; ++x) {
            if (array[x] != value) continue;
            return x;
        }
        return -1;
    }

    public static long indexInArray(long[] array, int length, long value) {
        for (int x = 0; x < length; ++x) {
            if (array[x] != value) continue;
            return x;
        }
        return -1L;
    }

    public static <T> int indexInArray(T[] array, int length, T value) {
        return ArrayTools.indexInArray(array, 0, length, value);
    }

    public static <T> int indexInArray(T[] array, int from, int to, T value) {
        for (int x = from; x < array.length && x < to; ++x) {
            if (!array[x].equals(value)) continue;
            return x;
        }
        return -1;
    }

    public static String[] extendArray(String[] array, int length) {
        String[] newArray = array;
        if (array == null || array.length < length) {
            newArray = new String[length + 10];
            if (null != array) {
                System.arraycopy(array, 0, newArray, 0, array.length);
            }
        }
        return newArray;
    }

    public static int[][] extendArray(int[][] array, int length) {
        Object newArray = array;
        if (array == null || array.length < length) {
            newArray = new int[length + 10][];
            if (null != array) {
                System.arraycopy(array, 0, newArray, 0, array.length);
            }
        }
        return newArray;
    }

    public static int[] extendArrayWithOne(int[] array) {
        int length = array == null ? 0 : array.length;
        int[] newArray = new int[length + 1];
        if (null != array) {
            System.arraycopy(array, 0, newArray, 0, length);
        }
        return newArray;
    }

    public static int binarySearch(int[] array, int number, int low, int high) {
        while (low <= high) {
            int mid = low + high >> 1;
            int midVal = array[mid];
            if (midVal < number) {
                low = mid + 1;
                continue;
            }
            if (midVal > number) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static int binarySearchForFirst(int[] array, int number, int low, int high) {
        int l = low - 1;
        int h = high + 1;
        while (h - l > 1) {
            int mid = l + h >> 1;
            if (array[mid] < number) {
                l = mid;
                continue;
            }
            h = mid;
        }
        if (h == high + 1 || array[h] != number) {
            return -1;
        }
        return h;
    }

    public static boolean[] initBooleanArrayAndFill(boolean[] arr, int length, boolean defaultValue) {
        boolean[] newArray = arr;
        if (newArray == null || newArray.length < length) {
            newArray = new boolean[length];
            if (!defaultValue) {
                return newArray;
            }
        }
        ArrayTools.fillBooleanArray(newArray, defaultValue);
        return newArray;
    }

    public static void fillBooleanArray(boolean[] array, boolean value) {
        if (array == null) {
            return;
        }
        for (int i = 0; i < array.length; ++i) {
            array[i] = value;
        }
    }

    public static void fillBooleanArray(boolean[] array, boolean[] values) {
        if (array == null) {
            return;
        }
        for (int i = 0; i < array.length && i < values.length; ++i) {
            array[i] = values[i];
        }
    }

    public static void sortDescending(int[] a) {
        int n = a.length;
        for (int j = 1; j < n; ++j) {
            int x = a[j];
            for (int i = j - 1; i >= 0 && a[i] < x; --i) {
                a[i + 1] = a[i];
            }
            a[i + 1] = x;
        }
    }

    public static void sortDescending(int[] a, int[] b) {
        int n = a.length;
        for (int j = 1; j < n; ++j) {
            int x = a[j];
            int y = b[j];
            for (int i = j - 1; i >= 0 && a[i] < x; --i) {
                a[i + 1] = a[i];
                b[i + 1] = b[i];
            }
            a[i + 1] = x;
            b[i + 1] = y;
        }
    }

    public static void sortDescending(int[] a, int[][] b) {
        int n = a.length;
        for (int j = 1; j < n; ++j) {
            int x = a[j];
            int[] y = b[j];
            for (int i = j - 1; i >= 0 && a[i] < x; --i) {
                a[i + 1] = a[i];
                b[i + 1] = b[i];
            }
            a[i + 1] = x;
            b[i + 1] = y;
        }
    }

    public static void sort(long[] l) {
        int length = l.length;
        if (length > 1) {
            ArrayTools.sort1(l, 0, length, null);
        }
    }

    private static void sort1(long[] x, int off, int len, int[] x2) {
        int c;
        int a;
        if (len < 7) {
            for (int i = off; i < len + off; ++i) {
                for (int j = i; j > off && x[j - 1] > x[j]; --j) {
                    ArrayTools.swap(x, j, j - 1, x2);
                }
            }
            return;
        }
        int m = off + (len >> 1);
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = ArrayTools.med3(x, l, l + s, l + 2 * s);
                m = ArrayTools.med3(x, m - s, m, m + s);
                n = ArrayTools.med3(x, n - 2 * s, n - s, n);
            }
            m = ArrayTools.med3(x, l, m, n);
        }
        long v = x[m];
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            if (b <= c && x[b] <= v) {
                if (x[b] == v) {
                    ArrayTools.swap(x, a++, b, x2);
                }
                ++b;
                continue;
            }
            while (c >= b && x[c] >= v) {
                if (x[c] == v) {
                    ArrayTools.swap(x, c, d--, x2);
                }
                --c;
            }
            if (b > c) break;
            ArrayTools.swap(x, b++, c--, x2);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        ArrayTools.vecswap(x, off, b - s, s, x2);
        s = Math.min(d - c, n - d - 1);
        ArrayTools.vecswap(x, b, n - s, s, x2);
        s = b - a;
        if (s > 1) {
            ArrayTools.sort1(x, off, s, x2);
        }
        if ((s = d - c) > 1) {
            ArrayTools.sort1(x, n - s, s, x2);
        }
    }

    private static void swap(long[] x, int a, int b, int[] x2) {
        long t = x[a];
        x[a] = x[b];
        x[b] = t;
        if (x2 != null) {
            int t2 = x2[a];
            x2[a] = x2[b];
            x2[b] = t2;
        }
    }

    private static void vecswap(long[] x, int a, int b, int n, int[] x2) {
        int i = 0;
        while (i < n) {
            ArrayTools.swap(x, a, b, x2);
            ++i;
            ++a;
            ++b;
        }
    }

    private static int med3(long[] x, int a, int b, int c) {
        return x[a] < x[b] ? (x[b] < x[c] ? b : (x[a] < x[c] ? c : a)) : (x[b] > x[c] ? b : (x[a] > x[c] ? c : a));
    }

    public static void sort(long[] l, int[] x) {
        int length = l.length;
        if (length > 1) {
            ArrayTools.sort1(l, 0, length, x);
        }
    }

    public static void sort(long[] l, int[] x, int offset, int len) {
        int length = l.length;
        if (offset + len <= length) {
            ArrayTools.sort1(l, offset, len, x);
        } else {
            System.err.println("Sorting called with invalid arguments: array length " + length + " is smaller than offset (" + offset + ") + len(" + len + ") " + (offset + len));
        }
    }

    public static int[] mergeSortedArrays(int[] targetA, int targetALen, int[] sourceA, int sourceALen) {
        if (targetA == null) {
            return sourceA;
        }
        if (sourceA == null) {
            return targetA;
        }
        int[] ret = new int[targetALen + sourceALen];
        int ti = 0;
        int si = 0;
        for (int i = 0; i < ret.length; ++i) {
            boolean stepSource = false;
            if (ti == targetALen) {
                stepSource = true;
            } else if (si != sourceALen) {
                stepSource |= sourceA[si] < targetA[ti];
            }
            if (stepSource) {
                ret[i] = sourceA[si];
                ++si;
                continue;
            }
            ret[i] = targetA[ti];
            ++ti;
        }
        return ret;
    }

    public static boolean contains(int[] array, int element) {
        if (array == null) {
            return false;
        }
        for (int x : array) {
            if (x != element) continue;
            return true;
        }
        return false;
    }

    public static <T> T[] concatArrays(T[] a, T[] b) {
        int alen = a.length;
        int blen = b.length;
        Object[] result = (Object[])Array.newInstance(a.getClass().getComponentType(), alen + blen);
        System.arraycopy(a, 0, result, 0, alen);
        System.arraycopy(b, 0, result, alen, blen);
        return result;
    }

    public static boolean equalsArrays(int[] list1, int[] list2) {
        Arrays.sort(list1);
        Arrays.sort(list2);
        return Arrays.equals(list1, list2);
    }
}

