/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.common.util;

import java.io.IOException;
import java.io.InputStream;

public class Base64InputStream
extends InputStream {
    private static final int[] VALS64;
    private boolean inputStreamEndReached = false;
    private int[] bufferedOutput = new int[3];
    private int bufferedOutputPosition = 0;
    private InputStream inputStream;

    public Base64InputStream(InputStream is) {
        this.inputStream = is;
    }

    @Override
    public int read() throws IOException {
        if (this.bufferedOutputPosition == 0) {
            int b0;
            do {
                if ((b0 = this.inputStream.read()) >= 0) continue;
                return -1;
            } while (b0 == 32 || b0 == 9 || b0 == 13 || b0 == 10);
            int b1 = this.inputStream.read();
            int b2 = this.inputStream.read();
            int b3 = this.inputStream.read();
            if (b1 < 0 || b2 < 0 || b3 < 0) {
                throw new IOException("Unexpected end of file");
            }
            int v0 = VALS64[b0];
            int v1 = VALS64[b1];
            if (v0 < 0 || v1 < 0) {
                throw new IOException("Invalid character");
            }
            if (b2 == 61) {
                this.bufferedOutput[0] = (v0 << 2 | v1 >> 4) & 0xFF;
                this.bufferedOutput[1] = -1;
                this.bufferedOutput[2] = -1;
                this.bufferedOutputPosition = 1;
                return this.bufferedOutput[0];
            }
            if (b3 == 61) {
                int v2 = VALS64[b2];
                if (v2 < 0) {
                    throw new IOException("Invalid character");
                }
                this.bufferedOutput[0] = (v0 << 2 | v1 >> 4) & 0xFF;
                this.bufferedOutput[1] = (v1 << 4 | v2 >> 2) & 0xFF;
                this.bufferedOutput[2] = -1;
                this.bufferedOutputPosition = 1;
                return this.bufferedOutput[0];
            }
            int v2 = VALS64[b2];
            int v3 = VALS64[b3];
            if (v2 < 0 || v3 < 0) {
                throw new IOException("Invalid character");
            }
            this.bufferedOutput[0] = (v0 << 2 | v1 >> 4) & 0xFF;
            this.bufferedOutput[1] = (v1 << 4 | v2 >> 2) & 0xFF;
            this.bufferedOutput[2] = (v2 << 6 | v3) & 0xFF;
            this.bufferedOutputPosition = 1;
            return this.bufferedOutput[0];
        }
        if (this.bufferedOutputPosition == 2) {
            this.bufferedOutputPosition = 0;
            return this.bufferedOutput[2];
        }
        return this.bufferedOutput[this.bufferedOutputPosition++];
    }

    @Override
    public void close() throws IOException {
    }

    public int[] decode(int b0, int b1, int b2, int b3) throws IOException {
        if (b0 < 0 || b1 < 0 || b2 < 0 || b3 < 0) {
            throw new IOException("Unexpected end of file");
        }
        int v0 = VALS64[b0];
        int v1 = VALS64[b1];
        if (v0 < 0 || v1 < 0) {
            throw new IOException("Invalid character");
        }
        if (b2 == 61) {
            this.bufferedOutput[0] = (v0 << 2 | v1 >> 4) & 0xFF;
            this.bufferedOutput[1] = -1;
            this.bufferedOutput[2] = -1;
        } else if (b3 == 61) {
            int v2 = VALS64[b2];
            if (v2 < 0) {
                throw new IOException("Invalid character");
            }
            this.bufferedOutput[0] = (v0 << 2 | v1 >> 4) & 0xFF;
            this.bufferedOutput[1] = (v1 << 4 | v2 >> 2) & 0xFF;
            this.bufferedOutput[2] = -1;
        } else {
            int v2 = VALS64[b2];
            int v3 = VALS64[b3];
            if (v2 < 0 || v3 < 0) {
                throw new IOException("Invalid character");
            }
            this.bufferedOutput[0] = (v0 << 2 | v1 >> 4) & 0xFF;
            this.bufferedOutput[1] = (v1 << 4 | v2 >> 2) & 0xFF;
            this.bufferedOutput[2] = (v2 << 6 | v3) & 0xFF;
        }
        return this.bufferedOutput;
    }

    static {
        int i;
        VALS64 = new int[256];
        String s = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
        for (i = 0; i < 256; ++i) {
            Base64InputStream.VALS64[i] = -1;
        }
        for (i = 0; i < 64; ++i) {
            Base64InputStream.VALS64[s.charAt((int)i)] = i;
        }
    }
}

