/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.common.util;

import java.awt.Color;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class ColorParser {
    private static final String COLORSTR = "black 000000 white FFFFFF red FF0000 yellow FFFF00 lime 00FF00 aqua 00FFFF blue 0000FF fuchsia FF00FF gray 808080 silver C0C0C0 maroon 800000 olive 808000 green 008000 teal 008080 navy 000080 purple 800080 brown 5c3317 darkgreen 006400";
    private static final Hashtable COLORHASH = new Hashtable();

    public static Color parseColor(String str) throws IllegalArgumentException {
        int rgb;
        if ((str = str.trim().toLowerCase()).startsWith("#")) {
            int rgb2;
            if ((str = str.substring(1)).length() != 6) {
                throw new IllegalArgumentException("color #" + str + " is not a 6-digit hexadecimal value");
            }
            try {
                rgb2 = Integer.parseInt(str, 16);
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException("color #" + str + " is not a valid hexadecimal value");
            }
            return new Color(rgb2);
        }
        Color c = (Color)COLORHASH.get(str);
        if (c != null) {
            return c;
        }
        if (str.length() != 6) {
            throw new IllegalArgumentException("color " + str + " is neither a known color name" + " nor a 6-digit hexadecimal value");
        }
        try {
            rgb = Integer.parseInt(str, 16);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("color #" + str + " is not a valid hexadecimal value");
        }
        return new Color(rgb);
    }

    public static String toString(int rgb) {
        String s = "000000" + Integer.toString(rgb &= 0xFFFFFF, 16);
        return "#" + s.substring(s.length() - 6, s.length());
    }

    public static String toString(Color color) {
        return color == null ? null : ColorParser.toString(color.getRGB());
    }

    static {
        StringTokenizer st = new StringTokenizer(COLORSTR);
        while (st.hasMoreTokens()) {
            String key = st.nextToken();
            String sval = st.nextToken();
            int rgb = Integer.parseInt(sval, 16);
            COLORHASH.put(key, new Color(rgb));
        }
        COLORHASH.put("cyan", Color.cyan);
        COLORHASH.put("darkgray", Color.darkGray);
        COLORHASH.put("lightgray", Color.lightGray);
        COLORHASH.put("magenta", Color.magenta);
        COLORHASH.put("orange", Color.orange);
        COLORHASH.put("pink", Color.pink);
    }
}

