/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.common.util;

import java.io.Serializable;
import java.util.NoSuchElementException;

public final class FloatVector
implements Cloneable,
Serializable {
    public float[] elementData;
    private int expectedElementCount = 0;
    protected int elementCount;
    protected int capacityIncrement;

    public FloatVector(int initialCapacity, int capacityIncrement) {
        this.elementData = new float[initialCapacity];
        this.capacityIncrement = capacityIncrement;
    }

    public FloatVector(int initialCapacity) {
        this(initialCapacity, 0);
    }

    public FloatVector() {
        this(10);
    }

    public FloatVector(float[] anArray) {
        this(anArray.length);
        System.arraycopy(anArray, 0, this.elementData, 0, anArray.length);
        this.elementCount = anArray.length;
    }

    public final void copyInto(float[] anArray) {
        int i = this.elementCount;
        while (i-- > 0) {
            anArray[i] = this.elementData[i];
        }
    }

    public final float[] toArray() {
        float[] anArray = new float[this.elementCount];
        this.copyInto(anArray);
        return anArray;
    }

    public final void trimToSize() {
        int oldCapacity = this.elementData.length;
        if (this.elementCount < oldCapacity) {
            float[] oldData = this.elementData;
            this.elementData = new float[this.elementCount];
            System.arraycopy(oldData, 0, this.elementData, 0, this.elementCount);
        }
    }

    public final void ensureCapacity(int minCapacity) {
        if (minCapacity > this.elementData.length) {
            this.ensureCapacityHelper(minCapacity);
        }
    }

    public void setExpectedSize(int size) {
        this.expectedElementCount = size;
    }

    private void ensureCapacityHelper(int minCapacity) {
        int newCapacity;
        int oldCapacity = this.elementData.length;
        float[] oldData = this.elementData;
        int n = newCapacity = this.capacityIncrement > 0 ? oldCapacity + this.capacityIncrement : oldCapacity * 3 / 2 + 1;
        if (newCapacity < minCapacity) {
            newCapacity = minCapacity;
        }
        if (this.expectedElementCount > 0 && newCapacity > this.expectedElementCount && minCapacity <= this.expectedElementCount) {
            newCapacity = this.expectedElementCount;
        }
        this.elementData = new float[newCapacity];
        System.arraycopy(oldData, 0, this.elementData, 0, this.elementCount);
    }

    public final void setSize(int newSize) {
        if (newSize > this.elementCount && newSize > this.elementData.length) {
            this.ensureCapacityHelper(newSize);
        } else {
            for (int i = newSize; i < this.elementCount; ++i) {
                this.elementData[i] = 0.0f;
            }
        }
        this.elementCount = newSize;
    }

    public final int capacity() {
        return this.elementData.length;
    }

    public final int size() {
        return this.elementCount;
    }

    public final boolean isEmpty() {
        return this.elementCount == 0;
    }

    public final boolean contains(float elem) {
        return this.indexOf(elem, 0) >= 0;
    }

    public final int indexOf(float elem) {
        return this.indexOf(elem, 0);
    }

    public final int indexOf(float elem, int index) {
        for (int i = index; i < this.elementCount; ++i) {
            if (elem != this.elementData[i]) continue;
            return i;
        }
        return -1;
    }

    public final int lastIndexOf(float elem) {
        return this.lastIndexOf(elem, this.elementCount - 1);
    }

    public final int lastIndexOf(float elem, int index) {
        for (int i = index; i >= 0; --i) {
            if (elem != this.elementData[i]) continue;
            return i;
        }
        return -1;
    }

    public final float elementAt(int index) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.elementCount);
        }
        try {
            return this.elementData[index];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException(index + " < 0");
        }
    }

    public final float firstElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[0];
    }

    public final float lastElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[this.elementCount - 1];
    }

    public final void setElementAt(float obj, int index) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.elementCount);
        }
        this.elementData[index] = obj;
    }

    public final void removeElementAt(int index) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.elementCount);
        }
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int j = this.elementCount - index - 1;
        if (j > 0) {
            System.arraycopy(this.elementData, index + 1, this.elementData, index, j);
        }
        --this.elementCount;
    }

    public final void insertElementAt(float obj, int index) {
        int newcount = this.elementCount + 1;
        if (index >= newcount) {
            throw new ArrayIndexOutOfBoundsException(index + " > " + this.elementCount);
        }
        if (newcount > this.elementData.length) {
            this.ensureCapacityHelper(newcount);
        }
        System.arraycopy(this.elementData, index, this.elementData, index + 1, this.elementCount - index);
        this.elementData[index] = obj;
        ++this.elementCount;
    }

    public final void addElement(float obj) {
        int newcount = this.elementCount + 1;
        if (newcount > this.elementData.length) {
            this.ensureCapacityHelper(newcount);
        }
        this.elementData[this.elementCount++] = obj;
    }

    public final void addElements(float[] array) {
        this.addElements(array, 0, array.length);
    }

    public final void addElements(float[] array, int offset, int length) {
        int srcEnd = Math.min(offset + length, array.length);
        int numOfAdded = srcEnd - offset;
        int newLength = numOfAdded + this.elementCount;
        this.ensureCapacity(newLength);
        System.arraycopy(array, offset, this.elementData, this.elementCount, numOfAdded);
        this.elementCount = newLength;
    }

    public final boolean removeElement(float obj) {
        int i = this.indexOf(obj);
        if (i >= 0) {
            this.removeElementAt(i);
            return true;
        }
        return false;
    }

    public final void removeAllElements() {
        this.elementCount = 0;
    }

    public Object clone() throws CloneNotSupportedException {
        FloatVector v = (FloatVector)super.clone();
        v.elementData = new float[this.elementCount];
        System.arraycopy(this.elementData, 0, v.elementData, 0, this.elementCount);
        return v;
    }

    public boolean addAll(FloatVector other) {
        if (other == null || other.isEmpty()) {
            return false;
        }
        this.addElements(other.elementData, 0, other.elementCount);
        return true;
    }
}

