/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.common.util;

import java.io.Serializable;
import java.util.NoSuchElementException;

public final class LongVector
implements Cloneable,
Serializable {
    public long[] elementData;
    private int expectedElementCount = 0;
    protected int elementCount;
    protected int capacityIncrement;

    public LongVector(int initialCapacity, int capacityIncrement) {
        this.elementData = new long[initialCapacity];
        this.capacityIncrement = capacityIncrement;
    }

    public LongVector(int initialCapacity) {
        this(initialCapacity, 0);
    }

    public LongVector() {
        this(10);
    }

    public LongVector(long[] anArray) {
        this(anArray.length);
        System.arraycopy(anArray, 0, this.elementData, 0, anArray.length);
        this.elementCount = anArray.length;
    }

    public final void copyInto(long[] anArray) {
        int i = this.elementCount;
        while (i-- > 0) {
            anArray[i] = this.elementData[i];
        }
    }

    public final long[] toArray() {
        long[] anArray = new long[this.elementCount];
        this.copyInto(anArray);
        return anArray;
    }

    public final void trimToSize() {
        int oldCapacity = this.elementData.length;
        if (this.elementCount < oldCapacity) {
            long[] oldData = this.elementData;
            this.elementData = new long[this.elementCount];
            System.arraycopy(oldData, 0, this.elementData, 0, this.elementCount);
        }
    }

    public final void ensureCapacity(int minCapacity) {
        if (minCapacity > this.elementData.length) {
            this.ensureCapacityHelper(minCapacity);
        }
    }

    public void setExpectedSize(int size) {
        this.expectedElementCount = size;
    }

    private void ensureCapacityHelper(int minCapacity) {
        int newCapacity;
        int oldCapacity = this.elementData.length;
        long[] oldData = this.elementData;
        int n = newCapacity = this.capacityIncrement > 0 ? oldCapacity + this.capacityIncrement : oldCapacity * 3 / 2 + 1;
        if (newCapacity < minCapacity) {
            newCapacity = minCapacity;
        }
        if (this.expectedElementCount > 0 && newCapacity > this.expectedElementCount && minCapacity <= this.expectedElementCount) {
            newCapacity = this.expectedElementCount;
        }
        this.elementData = new long[newCapacity];
        System.arraycopy(oldData, 0, this.elementData, 0, this.elementCount);
    }

    public final void setSize(int newSize) {
        if (newSize > this.elementCount && newSize > this.elementData.length) {
            this.ensureCapacityHelper(newSize);
        } else {
            for (int i = newSize; i < this.elementCount; ++i) {
                this.elementData[i] = 0L;
            }
        }
        this.elementCount = newSize;
    }

    public final int capacity() {
        return this.elementData.length;
    }

    public final int size() {
        return this.elementCount;
    }

    public final boolean isEmpty() {
        return this.elementCount == 0;
    }

    public final boolean contains(long elem) {
        return this.indexOf(elem, 0) >= 0;
    }

    public final int indexOf(long elem) {
        return this.indexOf(elem, 0);
    }

    public final int indexOf(long elem, int index) {
        for (int i = index; i < this.elementCount; ++i) {
            if (elem != this.elementData[i]) continue;
            return i;
        }
        return -1;
    }

    public final int lastIndexOf(long elem) {
        return this.lastIndexOf(elem, this.elementCount - 1);
    }

    public final int lastIndexOf(long elem, int index) {
        for (int i = index; i >= 0; --i) {
            if (elem != this.elementData[i]) continue;
            return i;
        }
        return -1;
    }

    public final long get(int index) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.elementCount);
        }
        try {
            return this.elementData[index];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException(index + " < 0");
        }
    }

    public final void set(int index, long v) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.elementCount);
        }
        this.elementData[index] = v;
    }

    public final void add(long v) {
        int newcount = this.elementCount + 1;
        if (newcount > this.elementData.length) {
            this.ensureCapacityHelper(newcount);
        }
        this.elementData[this.elementCount++] = v;
    }

    public final void add(int index, long v) {
        int newcount = this.elementCount + 1;
        if (index >= newcount) {
            throw new ArrayIndexOutOfBoundsException(index + " > " + this.elementCount);
        }
        if (newcount > this.elementData.length) {
            this.ensureCapacityHelper(newcount);
        }
        System.arraycopy(this.elementData, index, this.elementData, index + 1, this.elementCount - index);
        this.elementData[index] = v;
        ++this.elementCount;
    }

    public boolean addAll(LongVector other) {
        if (other == null || other.isEmpty()) {
            return false;
        }
        this.addElements(other.elementData, 0, other.elementCount);
        return true;
    }

    public final long remove(int index) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.elementCount);
        }
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        long old = this.elementData[index];
        int j = this.elementCount - index - 1;
        if (j > 0) {
            System.arraycopy(this.elementData, index + 1, this.elementData, index, j);
        }
        --this.elementCount;
        return old;
    }

    public final void clear() {
        this.elementCount = 0;
    }

    public final long elementAt(int index) {
        return this.get(index);
    }

    public final long firstElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[0];
    }

    public final long lastElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[this.elementCount - 1];
    }

    public final void setElementAt(long v, int index) {
        this.set(index, v);
    }

    public final void removeElementAt(int index) {
        this.remove(index);
    }

    public final void insertElementAt(long v, int index) {
        this.add(index, v);
    }

    public final void addElement(long v) {
        this.add(v);
    }

    public final void addElements(long[] array) {
        this.addElements(array, 0, array.length);
    }

    public final void addElements(long[] array, int offset, int length) {
        int srcEnd = Math.min(offset + length, array.length);
        int numOfAdded = srcEnd - offset;
        int newLength = numOfAdded + this.elementCount;
        this.ensureCapacity(newLength);
        System.arraycopy(array, offset, this.elementData, this.elementCount, numOfAdded);
        this.elementCount = newLength;
    }

    public final boolean removeElement(long obj) {
        int i = this.indexOf(obj);
        if (i >= 0) {
            this.removeElementAt(i);
            return true;
        }
        return false;
    }

    public final void removeAllElements() {
        this.clear();
    }

    public Object clone() throws CloneNotSupportedException {
        LongVector v = (LongVector)super.clone();
        v.elementData = new long[this.elementCount];
        System.arraycopy(this.elementData, 0, v.elementData, 0, this.elementCount);
        return v;
    }

    public void fill(int value) {
        for (int x = 0; x < this.elementCount; ++x) {
            this.elementData[x] = value;
        }
    }

    public void sort() {
        if (this.elementCount > 1) {
            LongVector.sort1(this.elementData, 0, this.elementCount);
        }
    }

    private static void sort1(long[] x, int off, int len) {
        int c;
        int a;
        if (len < 7) {
            for (int i = off; i < len + off; ++i) {
                for (int j = i; j > off && x[j - 1] > x[j]; --j) {
                    LongVector.swap(x, j, j - 1);
                }
            }
            return;
        }
        int m = off + (len >> 1);
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = LongVector.med3(x, l, l + s, l + 2 * s);
                m = LongVector.med3(x, m - s, m, m + s);
                n = LongVector.med3(x, n - 2 * s, n - s, n);
            }
            m = LongVector.med3(x, l, m, n);
        }
        long v = x[m];
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            if (b <= c && x[b] <= v) {
                if (x[b] == v) {
                    LongVector.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && x[c] >= v) {
                if (x[c] == v) {
                    LongVector.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            LongVector.swap(x, b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        LongVector.vecswap(x, off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        LongVector.vecswap(x, b, n - s, s);
        s = b - a;
        if (s > 1) {
            LongVector.sort1(x, off, s);
        }
        if ((s = d - c) > 1) {
            LongVector.sort1(x, n - s, s);
        }
    }

    private static void swap(long[] x, int a, int b) {
        long t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private static void vecswap(long[] x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            LongVector.swap(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private static int med3(long[] x, int a, int b, int c) {
        return x[a] < x[b] ? (x[b] < x[c] ? b : (x[a] < x[c] ? c : a)) : (x[b] > x[c] ? b : (x[a] > x[c] ? c : a));
    }

    public String toString() {
        StringBuffer res = new StringBuffer(this.size() * 3);
        res.append('[');
        for (int i = 0; i < this.size(); ++i) {
            if (i > 0) {
                res.append(',');
            }
            res.append(this.get(i));
        }
        res.append(']');
        return res.toString();
    }
}

