/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.config;

import chemaxon.config.ConfigDisplayPanel;
import chemaxon.config.ConfigFrame;
import chemaxon.config.EditorPanel;
import chemaxon.config.HelpFrame;
import chemaxon.config.struct.ConfigTreeNode;
import chemaxon.config.struct.XMLFileFilter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.List;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.filechooser.FileFilter;
import org.dom4j.Element;

public class ConfigDisplayFrame
extends JFrame
implements ActionListener {
    private final String SCHEMADIR = "schemas/schemaList.xsd";
    private JToolBar toolbar;
    private JMenuBar menubar;
    private JButton btnSaveFile;
    private JButton btnSource;
    private JMenuItem miSave;
    private JMenuItem miSaveAs;
    private JFileChooser fc;
    private File[] schemaList;
    private ConfigDisplayPanel configPane;
    private JSplitPane splitPane;

    public ConfigDisplayFrame() {
        this.commonInit();
    }

    public ConfigDisplayFrame(String startfile) {
        this.commonInit();
        File inFile = new File(startfile);
        for (int i = 1; i < this.getContentPane().getComponentCount(); ++i) {
            this.getContentPane().remove(i);
        }
        if (this.configPane != null) {
            this.configPane = null;
        }
        try {
            this.configPane = new ConfigDisplayPanel(inFile);
            this.configPane.setMenuListener(this);
            this.setTitle("XML Configuration Editor " + inFile.getName());
            System.setProperty("lastFile", inFile.getPath());
            this.btnSaveFile.setEnabled(true);
            this.miSaveAs.setEnabled(true);
            this.miSave.setEnabled(true);
            this.btnSource.setEnabled(true);
        }
        catch (Exception ex) {
            this.showErrDialog("Unable to open this file", ex);
            this.btnSaveFile.setEnabled(false);
            this.miSaveAs.setEnabled(false);
            this.btnSource.setEnabled(false);
            this.miSave.setEnabled(false);
        }
        catch (Error er) {
            this.showErrDialog("Unable to open this file", er);
            this.btnSaveFile.setEnabled(false);
            this.miSaveAs.setEnabled(false);
            this.btnSource.setEnabled(false);
            this.miSave.setEnabled(false);
        }
        JScrollPane treeScroll = new JScrollPane(this.configPane);
        this.configPane.setMinimumSize(new Dimension(200, 400));
        JPanel instructionPane = new JPanel();
        instructionPane.setBackground(Color.white);
        instructionPane.add(new JLabel("Build your configuration file by using the options at the left"));
        this.splitPane = new JSplitPane(1, treeScroll, instructionPane);
        this.splitPane.setOneTouchExpandable(false);
        this.splitPane.setDividerLocation(200);
        this.getContentPane().add((Component)this.splitPane, "Center");
        this.validateTree();
        this.repaint();
    }

    private void commonInit() {
        this.setTitle("XML Configuration Editor");
        this.fc = new JFileChooser();
        this.fc.setFileFilter(new XMLFileFilter());
        FileFilter ff = this.fc.getAcceptAllFileFilter();
        this.fc.removeChoosableFileFilter(ff);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent ev) {
                boolean continueAfter = ConfigDisplayFrame.this.saveBeforeClose();
                if (continueAfter) {
                    System.exit(0);
                }
            }
        });
        this.toolbar = new JToolBar();
        this.toolbar.setName("XML Configure Tool");
        this.menubar = new JMenuBar();
        this.setJMenuBar(this.menubar);
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic(70);
        this.menubar.add(fileMenu);
        JMenuItem miNew = new JMenuItem("New", 78);
        miNew.setActionCommand("new");
        miNew.addActionListener(this);
        JMenuItem miOpen = new JMenuItem("Open", 79);
        miOpen.addActionListener(this);
        miOpen.setActionCommand("open");
        this.miSave = new JMenuItem("Save", 83);
        this.miSave.addActionListener(this);
        this.miSave.setActionCommand("save");
        this.miSave.setEnabled(false);
        this.miSaveAs = new JMenuItem("Save As", 65);
        this.miSaveAs.setActionCommand("saveas");
        this.miSaveAs.addActionListener(this);
        this.miSaveAs.setEnabled(false);
        JMenuItem miExit = new JMenuItem("Exit", 88);
        miExit.addActionListener(this);
        miExit.setActionCommand("exit");
        fileMenu.add(miNew);
        fileMenu.add(miOpen);
        fileMenu.addSeparator();
        fileMenu.add(this.miSave);
        fileMenu.add(this.miSaveAs);
        fileMenu.addSeparator();
        fileMenu.add(miExit);
        JMenu helpMenu = new JMenu("Help");
        helpMenu.setMnemonic(72);
        JMenuItem miHelp = new JMenuItem("Help Contents", 72);
        miHelp.setActionCommand("help");
        miHelp.addActionListener(this);
        JMenuItem miAbout = new JMenuItem("About", 65);
        miAbout.setActionCommand("about");
        miAbout.addActionListener(this);
        helpMenu.add(miHelp);
        helpMenu.add(miAbout);
        this.menubar.add(helpMenu);
        URL iconURL = ConfigFrame.class.getResource("img/saveCD.gif");
        ImageIcon saveIcon = new ImageIcon(iconURL, "Save");
        this.btnSaveFile = new JButton(saveIcon);
        iconURL = ConfigFrame.class.getResource("img/newFile.gif");
        ImageIcon newIcon = new ImageIcon(iconURL, "New");
        JButton btnNew = new JButton(newIcon);
        iconURL = ConfigFrame.class.getResource("img/fileOpen.gif");
        ImageIcon openIcon = new ImageIcon(iconURL, "Open");
        JButton btnOpen = new JButton(openIcon);
        iconURL = ConfigFrame.class.getResource("img/toText.png");
        ImageIcon sourceIcon = new ImageIcon(iconURL, "To Text");
        this.btnSource = new JButton(sourceIcon);
        btnNew.addActionListener(this);
        btnNew.setActionCommand("new");
        btnNew.setToolTipText("New File");
        btnNew.setAlignmentY(0.0f);
        btnOpen.addActionListener(this);
        btnOpen.setActionCommand("open");
        btnOpen.setAlignmentY(0.0f);
        btnOpen.setToolTipText("Open File");
        this.btnSaveFile.addActionListener(this);
        this.btnSaveFile.setActionCommand("save");
        this.btnSaveFile.setAlignmentY(0.0f);
        this.btnSaveFile.setToolTipText("Save");
        this.btnSaveFile.setEnabled(false);
        this.btnSource.addActionListener(this);
        this.btnSource.setActionCommand("toText");
        this.btnSource.setToolTipText("Edit This File in Text Mode");
        this.btnSource.setAlignmentY(0.0f);
        this.btnSource.setEnabled(false);
        this.toolbar.add(btnNew);
        this.toolbar.add(Box.createRigidArea(new Dimension(5, 0)));
        this.toolbar.add(btnOpen);
        this.toolbar.add(Box.createRigidArea(new Dimension(5, 0)));
        this.toolbar.add(this.btnSaveFile);
        this.toolbar.add(Box.createRigidArea(new Dimension(10, 0)));
        this.toolbar.add(this.btnSource);
        this.toolbar.add(Box.createRigidArea(new Dimension(40, 0)));
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.toolbar, "North");
        this.pack();
        this.setSize(740, 550);
        this.setVisible(true);
    }

    private String showSchemaDialog() {
        InputStream is = ConfigFrame.class.getResourceAsStream("schemas/schemaList.xsd");
        BufferedReader in = new BufferedReader(new InputStreamReader(is));
        Vector<String> v = new Vector<String>();
        try {
            String fN;
            while ((fN = in.readLine()) != null) {
                v.add(fN);
            }
        }
        catch (IOException ex) {
            this.showErrDialog("Unable to access list of available schemas", ex);
        }
        Object[] opts = new Object[v.size()];
        opts = v.toArray();
        String fileName = (String)JOptionPane.showInputDialog(this, "Which schema would you like to use to create your configuration file?", "Schema Choice Dialog", -1, null, opts, "");
        if (fileName != null) {
            return fileName;
        }
        return "";
    }

    private void showErrDialog(String s, Object o) {
        if (o instanceof Exception) {
            Exception e = (Exception)o;
            System.out.println(e.getMessage());
        }
        String errMsg = "An Error Occurred\n" + s + "\nSee Terminal Output for More Information";
        JOptionPane.showMessageDialog(this, errMsg, "An Error Has Occurred", 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        String comm = e.getActionCommand();
        if (comm.equals("new")) {
            boolean continueAfter;
            if (this.configPane != null && !(continueAfter = this.saveBeforeClose())) {
                return;
            }
            System.setProperty("lastFile", "");
            String schemaName = this.showSchemaDialog();
            if (schemaName.equals("")) {
                return;
            }
            for (int i = 1; i < this.getContentPane().getComponentCount(); ++i) {
                this.getContentPane().remove(i);
            }
            if (this.configPane != null) {
                this.configPane = null;
            }
            try {
                this.configPane = new ConfigDisplayPanel(schemaName);
                this.configPane.setMenuListener(this);
                this.setTitle("XML Configuration Editor ");
                this.btnSaveFile.setEnabled(true);
                this.miSaveAs.setEnabled(true);
                this.btnSource.setEnabled(true);
            }
            catch (Exception ex) {
                this.showErrDialog("", ex);
                this.btnSaveFile.setEnabled(false);
                this.miSaveAs.setEnabled(false);
                this.btnSource.setEnabled(false);
            }
            catch (Error er) {
                this.showErrDialog("", er);
                this.btnSaveFile.setEnabled(false);
                this.miSaveAs.setEnabled(false);
                this.btnSource.setEnabled(false);
            }
            this.miSave.setEnabled(false);
            JScrollPane treeScroll = new JScrollPane(this.configPane);
            JPanel instructionPane = new JPanel();
            instructionPane.setBackground(Color.white);
            instructionPane.add(new JLabel("Build your configuration file by using the options at the left"));
            this.splitPane = new JSplitPane(1, treeScroll, instructionPane);
            this.splitPane.setOneTouchExpandable(false);
            this.splitPane.setDividerLocation(200);
            this.getContentPane().add((Component)this.splitPane, "Center");
            this.validateTree();
            this.repaint();
            return;
        }
        if (comm.equals("exit")) {
            boolean continueAfter = this.saveBeforeClose();
            if (!continueAfter) return;
            System.exit(0);
            return;
        }
        if (comm.equals("nodeselected")) {
            if (!(e.getSource() instanceof ConfigDisplayPanel.ElementMenuItem)) return;
            ConfigDisplayPanel.ElementMenuItem mi = (ConfigDisplayPanel.ElementMenuItem)e.getSource();
            Element schemaEl = mi.getElement();
            EditorPanel ep = new EditorPanel(schemaEl);
            this.configPane.getInstance().addChild(ep.getElement());
            int oldPos = this.splitPane.getDividerLocation();
            this.splitPane.setBottomComponent(ep);
            this.splitPane.setDividerLocation(oldPos);
            return;
        }
        if (comm.equals("nodeedit")) {
            ConfigTreeNode tn = this.configPane.getSelectedTreeNode();
            String xPath = tn.getNodePath();
            Element schemaEl = this.configPane.getSchema().getSchemaFromInstance(xPath);
            EditorPanel ep = new EditorPanel(schemaEl);
            int index = tn.getParent().getIndex(tn);
            Element parentEl = (Element)this.configPane.getInstance().getDocument().selectSingleNode(tn.getNodePath() + "/parent::*");
            List matchingEls = parentEl.elements();
            Element forEdit = (Element)matchingEls.get(index);
            ep.setInstance(forEdit);
            this.splitPane.setBottomComponent(ep);
            return;
        }
        if (comm.equals("toText")) {
            JFrame textFrame = new JFrame("XML Source");
            JTextArea ta = new JTextArea(this.configPane.getInstance().getXML());
            ta.setLineWrap(true);
            textFrame.getContentPane().add(ta);
            textFrame.pack();
            textFrame.setSize(300, 200);
            textFrame.setVisible(true);
            textFrame.setDefaultCloseOperation(2);
            return;
        }
        if (comm.equals("removenode")) {
            this.configPane.getInstance().remove();
            return;
        }
        if (comm.equals("saveas")) {
            int ret = this.fc.showSaveDialog(this);
            if (ret != 0) return;
            File file = this.fc.getSelectedFile();
            if (!file.getName().endsWith(".xml")) {
                String path = file.getPath();
                path = path.concat(".xml");
                file = new File(path);
            }
            if (this.configPane != null) {
                try {
                    this.configPane.saveToFile(file);
                    System.setProperty("lastFile", file.getPath());
                }
                catch (Exception ex) {
                    this.showErrDialog("Error saving file", ex);
                }
            }
            this.setTitle("XML Configuration Editor - " + file.getName());
            this.miSave.setEnabled(true);
            return;
        }
        if (comm.equals("save")) {
            String savedFile = System.getProperty("lastFile");
            File file = null;
            if (savedFile == null || savedFile.equals("")) {
                int ret = this.fc.showSaveDialog(this);
                if (ret != 0) return;
                file = this.fc.getSelectedFile();
                if (!file.getName().endsWith(".xml")) {
                    String path = file.getPath();
                    path = path.concat(".xml");
                    file = new File(path);
                }
            } else {
                file = new File(savedFile);
            }
            if (this.configPane != null) {
                try {
                    this.configPane.saveToFile(file);
                    System.setProperty("lastFile", file.getPath());
                }
                catch (Exception ex) {
                    this.showErrDialog("Error saving file", ex);
                }
            }
            this.setTitle("XML Configuration Editor - " + file.getName());
            this.miSave.setEnabled(true);
            return;
        }
        if (comm.equals("open")) {
            boolean continueAfter;
            if (this.configPane != null && !(continueAfter = this.saveBeforeClose())) {
                return;
            }
            int ret = this.fc.showOpenDialog(this);
            if (ret != 0) return;
            File file = this.fc.getSelectedFile();
            for (int i = 1; i < this.getContentPane().getComponentCount(); ++i) {
                this.getContentPane().remove(i);
            }
            if (this.configPane != null) {
                this.configPane = null;
            }
            try {
                this.configPane = new ConfigDisplayPanel(file);
                this.configPane.setMenuListener(this);
                this.setTitle("XML Configuration Editor " + file.getName());
                System.setProperty("lastFile", file.getPath());
                this.btnSaveFile.setEnabled(true);
                this.miSaveAs.setEnabled(true);
                this.miSave.setEnabled(true);
                this.btnSource.setEnabled(true);
            }
            catch (Exception ex) {
                this.showErrDialog("Unable to open this file", ex);
                this.btnSaveFile.setEnabled(false);
                this.miSaveAs.setEnabled(false);
                this.btnSource.setEnabled(false);
                this.miSave.setEnabled(false);
            }
            catch (Error er) {
                this.showErrDialog("Unable to open this file", er);
                this.btnSaveFile.setEnabled(false);
                this.miSaveAs.setEnabled(false);
                this.btnSource.setEnabled(false);
                this.miSave.setEnabled(false);
            }
            JScrollPane treeScroll = new JScrollPane(this.configPane);
            this.configPane.setMinimumSize(new Dimension(200, 400));
            JPanel instructionPane = new JPanel();
            instructionPane.setBackground(Color.white);
            instructionPane.add(new JLabel("Build your configuration file by using the options at the left"));
            this.splitPane = new JSplitPane(1, treeScroll, instructionPane);
            this.splitPane.setOneTouchExpandable(false);
            this.splitPane.setDividerLocation(200);
            this.getContentPane().add((Component)this.splitPane, "Center");
            this.validateTree();
            this.repaint();
            return;
        }
        if (comm.equals("help")) {
            HelpFrame hf = new HelpFrame("help");
            return;
        } else {
            if (!comm.equals("about")) return;
            HelpFrame helpFrame = new HelpFrame("about");
        }
    }

    public boolean saveBeforeClose() {
        if (this.configPane != null) {
            try {
                boolean b = this.configPane.hasFileChanged();
                if (b) {
                    int doSave = JOptionPane.showConfirmDialog(this, "The file contents have changed.  Save before closing?");
                    if (doSave == 1) {
                        return true;
                    }
                    if (doSave == 2) {
                        return false;
                    }
                    String lastSavedFile = System.getProperty("lastFile");
                    if (lastSavedFile.equals("")) {
                        int ret = this.fc.showSaveDialog(this);
                        if (ret == 0) {
                            File file = this.fc.getSelectedFile();
                            if (!file.getName().endsWith(".xml")) {
                                String path = file.getPath();
                                path = path.concat(".xml");
                                file = new File(path);
                            }
                            if (this.configPane != null) {
                                this.configPane.saveToFile(file);
                            }
                        }
                    } else {
                        this.configPane.saveToFile(new File(lastSavedFile));
                    }
                }
            }
            catch (Exception ex) {
                this.showErrDialog("Unable to Save File", ex);
                return false;
            }
        }
        return true;
    }

    public static void main(String[] args) {
        ConfigDisplayFrame f = new ConfigDisplayFrame();
    }
}

