/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.config;

import chemaxon.config.ConfigInstance;
import chemaxon.config.ConfigSchema;
import chemaxon.config.converter.Converter;
import chemaxon.config.struct.ConfigTreeNode;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.JTree;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.util.NodeComparator;

public class ConfigDisplayPanel
extends JPanel
implements ActionListener {
    private ConfigInstance instObj;
    private ConfigSchema schemaObj;
    private JTree configTree;
    private JPopupMenu pmenu;
    private JMenu addMenu;
    private JMenuItem miRemoveNode;
    private JMenuItem miEditNode;
    private ActionListener aListener;

    public ConfigDisplayPanel() {
    }

    public ConfigDisplayPanel(String schemaName) {
        this.setBackground(Color.white);
        this.schemaObj = new ConfigSchema(schemaName, true);
        this.instObj = new ConfigInstance(this.schemaObj.getRoot());
        this.configTree = this.instObj.getTree();
        this.add(this.configTree);
        this.commonInit();
    }

    public ConfigDisplayPanel(File instanceDoc) {
        this.setBackground(Color.white);
        try {
            Converter conVert = new Converter(instanceDoc);
            conVert.convert();
            Document instance = conVert.getObject();
            Element root = instance.getRootElement();
            String schemaXSD = root.attributeValue("schemaLocation");
            this.schemaObj = new ConfigSchema(schemaXSD, false);
            this.instObj = new ConfigInstance(instance);
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
        }
        this.commonInit();
    }

    private void commonInit() {
        this.configTree = this.instObj.getTree();
        this.add(this.configTree);
        this.aListener = this;
        this.pmenu = new JPopupMenu();
        this.addMenu = new JMenu("Add Section");
        this.pmenu.add(this.addMenu);
        this.miEditNode = new JMenuItem("Edit");
        this.miEditNode.setActionCommand("nodeedit");
        this.pmenu.add(this.miEditNode);
        this.miRemoveNode = new JMenuItem("Remove");
        this.miRemoveNode.setActionCommand("removenode");
        this.miRemoveNode.addActionListener(this.aListener);
        this.pmenu.add(this.miRemoveNode);
        this.addMouseListener(new PopupListener(this.pmenu));
        this.configTree.addMouseListener(new PopupListener(this.pmenu));
    }

    public JPanel createButtonPanel() {
        JPanel bPane = new JPanel();
        bPane.setLayout(new FlowLayout());
        JButton showXML = new JButton("Show XML");
        showXML.setActionCommand("showxml");
        showXML.addActionListener(this);
        bPane.add(showXML);
        return bPane;
    }

    private void makeSubMenu(JMenu parentmenu, List items, String xPath) {
        parentmenu.removeAll();
        if (items == null) {
            parentmenu.setEnabled(false);
            return;
        }
        parentmenu.setEnabled(true);
        for (int i = 0; i < items.size(); ++i) {
            Object item = items.get(i);
            if (item instanceof Element) {
                int existing = this.instObj.getElementCount(xPath + "/" + ((Element)item).attributeValue("name"));
                String maxOcc = ((Element)item).attributeValue("maxOccurs");
                int allowed = 0;
                if (!maxOcc.equals("unbounded")) {
                    allowed = Integer.parseInt(maxOcc);
                }
                if (existing >= allowed && !maxOcc.equals("unbounded")) continue;
                ElementMenuItem miElement = new ElementMenuItem((Element)item);
                miElement.setActionCommand("nodeselected");
                miElement.addActionListener(this.aListener);
                parentmenu.add(miElement);
            }
            if (parentmenu.getItemCount() != 0) continue;
            parentmenu.setEnabled(false);
        }
    }

    private void addNewElement(Element schemaEl) {
    }

    public void setMenuListener(ActionListener al) {
        this.aListener = al;
        this.miEditNode.addActionListener(this.aListener);
    }

    public ConfigTreeNode getSelectedTreeNode() {
        return (ConfigTreeNode)this.configTree.getLastSelectedPathComponent();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("showxml")) {
            JFrame textFrame = new JFrame("XML Source");
            JTextArea ta = new JTextArea(this.instObj.getXML());
            ta.setLineWrap(true);
            textFrame.getContentPane().add(ta);
            textFrame.pack();
            textFrame.setSize(300, 200);
            textFrame.setVisible(true);
            textFrame.setDefaultCloseOperation(2);
        } else if (cmd.equals("removenode")) {
            this.instObj.remove();
        }
        this.validateTree();
        this.repaint();
    }

    public ConfigInstance getInstance() {
        return this.instObj;
    }

    public ConfigSchema getSchema() {
        return this.schemaObj;
    }

    public void saveToFile(File oFile) throws Exception {
        Document outDoc = this.instObj.getDocument();
        Converter conVert = new Converter(outDoc, oFile);
        conVert.convert();
    }

    public boolean hasFileChanged() {
        NodeComparator ncompare = new NodeComparator();
        Document currentDoc = this.instObj.getDocument();
        Element currRoot = currentDoc.getRootElement();
        String savedFile = System.getProperty("lastFile");
        if (savedFile.equals("")) {
            return true;
        }
        Converter fileConverter = new Converter(savedFile);
        try {
            fileConverter.convert();
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
            return true;
        }
        Document savedDoc = fileConverter.getObject();
        Element savedRoot = savedDoc.getRootElement();
        return ncompare.compare(savedRoot, currRoot) != 0;
    }

    public class ElementMenuItem
    extends JMenuItem {
        private Element element;

        ElementMenuItem(Element el) {
            super(el.attributeValue("name"));
            this.element = el;
        }

        public Element getElement() {
            return this.element;
        }
    }

    class PopupListener
    extends MouseAdapter {
        JPopupMenu popup;

        PopupListener(JPopupMenu popupMenu) {
            this.popup = popupMenu;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                ConfigTreeNode selNode = (ConfigTreeNode)ConfigDisplayPanel.this.configTree.getLastSelectedPathComponent();
                String xPath = selNode.getNodePath();
                List kids = ConfigDisplayPanel.this.schemaObj.getChildList(xPath);
                ConfigDisplayPanel.this.makeSubMenu(ConfigDisplayPanel.this.addMenu, kids, xPath);
                this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

