/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.config;

import chemaxon.config.DynConfigPanel;
import chemaxon.config.HelpFrame;
import chemaxon.config.struct.XMLFileFilter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.JTree;

public class ConfigFrame
extends JFrame
implements ActionListener {
    private final String SCHEMADIR = "schemas/schemaList.xsd";
    private DynConfigPanel configPanel;
    private JSplitPane splitPane;
    private JTree optTree;
    private JToolBar toolbar;
    private JMenuBar menubar;
    private JLabel fileLabel;
    private File saveFile;
    private JButton btnSaveFile;
    private JButton btnSource;
    private JButton btnGUI;
    private JMenuItem miSave;
    private JMenuItem miSaveAs;
    private JFileChooser fc;
    private File[] schemaList;

    public ConfigFrame() {
        this.saveFile = null;
        this.commonInit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigFrame(String fileName) {
        File file;
        this.commonInit();
        this.saveFile = file = new File(fileName);
        for (int i = 1; i < this.getContentPane().getComponentCount(); ++i) {
            this.getContentPane().remove(i);
        }
        if (this.configPanel != null) {
            this.configPanel = null;
        }
        try {
            this.configPanel = new DynConfigPanel(file);
            this.saveFile = file;
            this.setTitle("XML Configuration Editor - " + this.saveFile.getName());
            this.btnSaveFile.setEnabled(true);
            this.miSave.setEnabled(true);
            this.miSaveAs.setEnabled(true);
            if (this.configPanel.hasSchema) {
                this.btnSource.setEnabled(true);
                this.btnGUI.setEnabled(false);
            } else {
                this.btnGUI.setEnabled(true);
                this.btnSource.setEnabled(false);
            }
        }
        catch (Exception ex) {
            this.showErrDialog("Unable To Open File", ex);
        }
        catch (Error er) {
            this.showErrDialog("Unable To Open File", er);
        }
        finally {
            if (this.configPanel.constructorEx != null) {
                this.showErrDialog("Schema Location Error", this.configPanel.constructorEx);
            }
            this.saveFile = file;
            this.setTitle("XML Configuration Editor - " + this.saveFile.getName());
            this.btnSaveFile.setEnabled(true);
            this.miSave.setEnabled(true);
            this.miSaveAs.setEnabled(true);
            if (this.configPanel != null) {
                this.loadContent();
            }
            this.validateTree();
            this.repaint();
        }
    }

    private void commonInit() {
        this.setTitle("XML Configuration Editor");
        this.fc = new JFileChooser();
        this.fc.setFileFilter(new XMLFileFilter());
        javax.swing.filechooser.FileFilter ff = this.fc.getAcceptAllFileFilter();
        this.fc.removeChoosableFileFilter(ff);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent ev) {
                ConfigFrame.this.saveBeforeClose();
            }
        });
        this.toolbar = new JToolBar();
        this.toolbar.setName("XML Configure Tool");
        this.menubar = new JMenuBar();
        this.setJMenuBar(this.menubar);
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic(70);
        this.menubar.add(fileMenu);
        JMenuItem miNew = new JMenuItem("New", 78);
        miNew.setActionCommand("new");
        miNew.addActionListener(this);
        JMenuItem miOpen = new JMenuItem("Open", 79);
        miOpen.addActionListener(this);
        miOpen.setActionCommand("open");
        this.miSave = new JMenuItem("Save", 83);
        this.miSave.addActionListener(this);
        this.miSave.setActionCommand("save");
        this.miSave.setEnabled(false);
        this.miSaveAs = new JMenuItem("Save As", 65);
        this.miSaveAs.setActionCommand("saveas");
        this.miSaveAs.addActionListener(this);
        this.miSaveAs.setEnabled(false);
        JMenuItem miExit = new JMenuItem("Exit", 88);
        miExit.addActionListener(this);
        miExit.setActionCommand("exit");
        fileMenu.add(miNew);
        fileMenu.add(miOpen);
        fileMenu.addSeparator();
        fileMenu.add(this.miSave);
        fileMenu.add(this.miSaveAs);
        fileMenu.addSeparator();
        fileMenu.add(miExit);
        JMenu helpMenu = new JMenu("Help");
        helpMenu.setMnemonic(72);
        JMenuItem miHelp = new JMenuItem("Help Contents", 72);
        miHelp.setActionCommand("help");
        miHelp.addActionListener(this);
        JMenuItem miAbout = new JMenuItem("About", 65);
        miAbout.setActionCommand("about");
        miAbout.addActionListener(this);
        helpMenu.add(miHelp);
        helpMenu.add(miAbout);
        this.menubar.add(helpMenu);
        URL iconURL = ConfigFrame.class.getResource("img/saveCD.gif");
        ImageIcon saveIcon = new ImageIcon(iconURL, "Save");
        this.btnSaveFile = new JButton(saveIcon);
        iconURL = ConfigFrame.class.getResource("img/newFile.gif");
        ImageIcon newIcon = new ImageIcon(iconURL, "New");
        JButton btnNew = new JButton(newIcon);
        iconURL = ConfigFrame.class.getResource("img/fileOpen.gif");
        ImageIcon openIcon = new ImageIcon(iconURL, "Open");
        JButton btnOpen = new JButton(openIcon);
        iconURL = ConfigFrame.class.getResource("img/toText.png");
        ImageIcon sourceIcon = new ImageIcon(iconURL, "To Text");
        this.btnSource = new JButton(sourceIcon);
        iconURL = ConfigFrame.class.getResource("img/toGUI.png");
        ImageIcon guiIcon = new ImageIcon(iconURL, "To GUI");
        this.btnGUI = new JButton(guiIcon);
        btnNew.addActionListener(this);
        btnNew.setActionCommand("new");
        btnNew.setToolTipText("New File");
        btnNew.setAlignmentY(0.0f);
        btnOpen.addActionListener(this);
        btnOpen.setActionCommand("open");
        btnOpen.setAlignmentY(0.0f);
        btnOpen.setToolTipText("Open File");
        this.btnSaveFile.addActionListener(this);
        this.btnSaveFile.setActionCommand("save");
        this.btnSaveFile.setAlignmentY(0.0f);
        this.btnSaveFile.setToolTipText("Save");
        this.btnSaveFile.setEnabled(false);
        this.btnSource.addActionListener(this);
        this.btnSource.setActionCommand("toText");
        this.btnSource.setToolTipText("Edit This File in Text Mode");
        this.btnSource.setAlignmentY(0.0f);
        this.btnSource.setEnabled(false);
        this.btnGUI.addActionListener(this);
        this.btnGUI.setActionCommand("toGUI");
        this.btnGUI.setToolTipText("Edit This File in GUI Mode");
        this.btnGUI.setAlignmentY(0.0f);
        this.btnGUI.setEnabled(false);
        this.toolbar.add(btnNew);
        this.toolbar.add(Box.createRigidArea(new Dimension(5, 0)));
        this.toolbar.add(btnOpen);
        this.toolbar.add(Box.createRigidArea(new Dimension(5, 0)));
        this.toolbar.add(this.btnSaveFile);
        this.toolbar.add(Box.createRigidArea(new Dimension(10, 0)));
        this.toolbar.add(this.btnSource);
        this.toolbar.add(Box.createRigidArea(new Dimension(5, 0)));
        this.toolbar.add(this.btnGUI);
        this.toolbar.add(Box.createRigidArea(new Dimension(40, 0)));
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.toolbar, "North");
        this.pack();
        this.setSize(740, 550);
        this.setVisible(true);
    }

    public static void main(String[] args) {
        ConfigFrame f = new ConfigFrame();
    }

    private void loadContent() {
        this.validate();
        if (this.configPanel.hasSchema) {
            this.optTree = this.configPanel.getTree();
            JPanel treePanel = new JPanel();
            treePanel.setLayout(new BoxLayout(treePanel, 1));
            treePanel.add(this.optTree);
            treePanel.add(Box.createHorizontalStrut(300));
            treePanel.setBackground(Color.white);
            treePanel.setMinimumSize(new Dimension(150, 300));
            this.configPanel.setMinimumSize(new Dimension(300, 300));
            JScrollPane treeScroll = new JScrollPane(treePanel);
            this.splitPane = new JSplitPane(1, treeScroll, this.configPanel);
            this.splitPane.setOneTouchExpandable(false);
            this.splitPane.setDividerLocation(200);
            this.getContentPane().add((Component)this.splitPane, "Center");
        } else {
            this.getContentPane().add(this.configPanel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent ev) {
        block76: {
            String comm = ev.getActionCommand();
            if (comm.equals("new")) {
                if (this.configPanel != null) {
                    this.saveBeforeClose();
                }
                this.saveFile = null;
                String schemaName = this.showSchemaDialog();
                for (int i = 1; i < this.getContentPane().getComponentCount(); ++i) {
                    this.getContentPane().remove(i);
                }
                if (!schemaName.equals("")) {
                    if (this.configPanel != null) {
                        this.configPanel = null;
                    }
                    try {
                        this.configPanel = new DynConfigPanel(schemaName);
                        this.setTitle("XML Configuration Editor ");
                        this.btnSaveFile.setEnabled(true);
                        this.miSaveAs.setEnabled(true);
                        this.btnSource.setEnabled(true);
                        this.btnGUI.setEnabled(false);
                    }
                    catch (Exception ex) {
                        this.showErrDialog("", ex);
                        this.btnSaveFile.setEnabled(false);
                        this.miSaveAs.setEnabled(false);
                        this.btnSource.setEnabled(false);
                    }
                    catch (Error er) {
                        this.showErrDialog("", er);
                        this.btnSaveFile.setEnabled(false);
                        this.miSaveAs.setEnabled(false);
                        this.btnSource.setEnabled(false);
                    }
                    this.miSave.setEnabled(false);
                }
                if (this.configPanel != null) {
                    this.loadContent();
                }
                this.validateTree();
                this.repaint();
            } else if (comm.equals("open")) {
                int ret;
                if (this.configPanel != null) {
                    this.saveBeforeClose();
                }
                if ((ret = this.fc.showOpenDialog(this)) == 0) {
                    File file = this.fc.getSelectedFile();
                    for (int i = 1; i < this.getContentPane().getComponentCount(); ++i) {
                        this.getContentPane().remove(i);
                    }
                    if (this.configPanel != null) {
                        this.configPanel = null;
                    }
                    try {
                        this.configPanel = new DynConfigPanel(file);
                        this.saveFile = file;
                        this.setTitle("XML Configuration Editor - " + this.saveFile.getName());
                        this.btnSaveFile.setEnabled(true);
                        this.miSave.setEnabled(true);
                        this.miSaveAs.setEnabled(true);
                        if (this.configPanel.hasSchema) {
                            this.btnSource.setEnabled(true);
                            this.btnGUI.setEnabled(false);
                        }
                        this.btnGUI.setEnabled(true);
                        this.btnSource.setEnabled(false);
                    }
                    catch (Exception ex) {
                        this.showErrDialog("Unable to open this file", ex);
                        this.btnSaveFile.setEnabled(false);
                        this.miSaveAs.setEnabled(false);
                        this.btnSource.setEnabled(false);
                        this.miSave.setEnabled(false);
                    }
                    catch (Error er) {
                        this.showErrDialog("Unable to open this file", er);
                        this.btnSaveFile.setEnabled(false);
                        this.miSaveAs.setEnabled(false);
                        this.btnSource.setEnabled(false);
                        this.miSave.setEnabled(false);
                    }
                    finally {
                        if (this.configPanel != null) {
                            if (this.configPanel.constructorEx != null) {
                                this.showErrDialog("Schema Location Error", this.configPanel.constructorEx);
                            }
                            this.loadContent();
                        }
                        this.validateTree();
                        this.repaint();
                    }
                }
            } else if (comm.equals("save")) {
                try {
                    if (this.saveFile == null) {
                        int ret = this.fc.showSaveDialog(this);
                        if (ret == 0) {
                            File file = this.fc.getSelectedFile();
                            if (!file.getName().endsWith(".xml")) {
                                String path = file.getPath();
                                path = path.concat(".xml");
                                file = new File(path);
                            }
                            if (this.configPanel != null) {
                                this.configPanel.saveFile(file);
                            }
                            this.setTitle("XML Configuration Editor - " + file.getName());
                            this.saveFile = file;
                            this.miSave.setEnabled(true);
                        }
                        break block76;
                    }
                    if (this.configPanel != null) {
                        this.configPanel.saveFile(this.saveFile);
                        this.setTitle("XML Configuration Editor - " + this.saveFile.getName());
                        break block76;
                    }
                    throw new Exception("Previous Errors Preventing Save");
                }
                catch (Exception ex) {
                    this.showErrDialog("Unable to Save File", ex);
                }
            } else if (comm.equals("saveas")) {
                int ret = this.fc.showSaveDialog(this);
                if (ret == 0) {
                    File file = this.fc.getSelectedFile();
                    if (!file.getName().endsWith(".xml")) {
                        String path = file.getPath();
                        path = path.concat(".xml");
                        file = new File(path);
                    }
                    if (this.configPanel != null) {
                        try {
                            this.configPanel.saveFile(file);
                        }
                        catch (Exception ex) {
                            this.showErrDialog("Unable to Save File", ex);
                        }
                    }
                    this.setTitle("XML Configuration Editor - " + file.getName());
                    this.saveFile = file;
                    this.btnSaveFile.setEnabled(true);
                }
            } else if (comm.equals("exit")) {
                this.saveBeforeClose();
                System.exit(0);
            } else if (comm.equals("help")) {
                HelpFrame hf = new HelpFrame("help");
            } else if (comm.equals("about")) {
                HelpFrame hf = new HelpFrame("about");
            } else if (comm.equals("toText")) {
                if (this.configPanel != null) {
                    if (this.saveFile == null) {
                        int saveRet = this.fc.showSaveDialog(this);
                        if (saveRet == 0) {
                            this.saveFile = this.fc.getSelectedFile();
                            if (!this.saveFile.getName().endsWith(".xml")) {
                                String path = this.saveFile.getPath();
                                path = path.concat(".xml");
                                this.saveFile = new File(path);
                            }
                        } else {
                            this.validateTree();
                            this.repaint();
                            return;
                        }
                    }
                    try {
                        this.configPanel.saveFile(this.saveFile);
                    }
                    catch (Exception ex) {
                        this.showErrDialog("Unable to Save File", ex);
                    }
                    for (int i = 1; i < this.getContentPane().getComponentCount(); ++i) {
                        this.getContentPane().remove(i);
                    }
                    this.configPanel = null;
                    try {
                        this.configPanel = new DynConfigPanel(-1, this.saveFile);
                        this.btnSaveFile.setEnabled(true);
                        this.miSave.setEnabled(true);
                        this.miSaveAs.setEnabled(true);
                        this.btnSource.setEnabled(false);
                        this.btnGUI.setEnabled(true);
                    }
                    catch (Exception ex) {
                        this.showErrDialog("Unable to convert file to Text Mode", ex);
                    }
                    if (this.configPanel != null) {
                        this.loadContent();
                    }
                }
                this.validateTree();
                this.repaint();
            } else if (comm.equals("toGUI")) {
                if (this.configPanel != null) {
                    if (this.saveFile == null) {
                        int saveRet = this.fc.showSaveDialog(this);
                        if (saveRet == 0) {
                            this.saveFile = this.fc.getSelectedFile();
                            if (!this.saveFile.getName().endsWith(".xml")) {
                                String path = this.saveFile.getPath();
                                path = path.concat(".xml");
                                this.saveFile = new File(path);
                            }
                        } else {
                            this.validateTree();
                            this.repaint();
                            return;
                        }
                    }
                    try {
                        this.configPanel.saveFile(this.saveFile);
                    }
                    catch (Exception ex) {
                        this.showErrDialog("Unable to Save File", ex);
                    }
                    for (int i = 1; i < this.getContentPane().getComponentCount(); ++i) {
                        this.getContentPane().remove(i);
                    }
                    this.configPanel = null;
                    try {
                        this.configPanel = new DynConfigPanel(this.saveFile);
                        this.setTitle("XML Configuration Editor - " + this.saveFile.getName());
                        this.btnSaveFile.setEnabled(true);
                        this.miSave.setEnabled(true);
                        this.miSaveAs.setEnabled(true);
                        if (this.configPanel.constructorEx == null) {
                            this.btnSource.setEnabled(true);
                            this.btnGUI.setEnabled(false);
                        } else {
                            this.btnSource.setEnabled(false);
                            this.btnGUI.setEnabled(true);
                            this.showErrDialog("Schema Location Error", this.configPanel.constructorEx);
                        }
                        if (this.configPanel != null) {
                            this.loadContent();
                        }
                    }
                    catch (Exception ex) {
                        this.showErrDialog("Unable convert file to GUI Mode", ex);
                        this.btnSaveFile.setEnabled(false);
                        this.miSaveAs.setEnabled(false);
                        this.btnSource.setEnabled(false);
                        this.miSave.setEnabled(false);
                    }
                    catch (Error er) {
                        this.showErrDialog("Unable convert file to GUI Mode", er);
                        this.btnSaveFile.setEnabled(false);
                        this.miSaveAs.setEnabled(false);
                        this.btnSource.setEnabled(false);
                        this.miSave.setEnabled(false);
                    }
                }
                this.validateTree();
                this.repaint();
            }
        }
    }

    private String showSchemaDialog() {
        InputStream is = ConfigFrame.class.getResourceAsStream("schemas/schemaList.xsd");
        BufferedReader in = new BufferedReader(new InputStreamReader(is));
        Vector<String> v = new Vector<String>();
        try {
            String fN;
            while ((fN = in.readLine()) != null) {
                v.add(fN);
            }
        }
        catch (IOException ex) {
            this.showErrDialog("Unable to access list of available schemas", ex);
        }
        Object[] opts = new Object[v.size()];
        opts = v.toArray();
        String fileName = (String)JOptionPane.showInputDialog(this, "Which schema would you like to use to create your configuration file?", "Schema Choice Dialog", -1, null, opts, "");
        if (fileName != null) {
            return fileName;
        }
        return "";
    }

    private void showErrDialog(String s, Object o) {
        if (o instanceof Exception) {
            Exception e = (Exception)o;
            System.out.println(e.getMessage());
        }
        String errMsg = "An Error Occurred\n" + s + "\nSee Terminal Output for More Information";
        JOptionPane.showMessageDialog(this, errMsg, "An Error Has Occurred", 0);
    }

    public void saveBeforeClose() {
        if (this.configPanel != null) {
            try {
                boolean b = this.configPanel.hasFileChanged(this.saveFile);
                if (b) {
                    int ret;
                    int doSave = JOptionPane.showConfirmDialog(this, "The file contents have changed.  Save before exiting?");
                    if (doSave == 1) {
                        return;
                    }
                    if (doSave == 2) {
                        return;
                    }
                    if (this.saveFile == null && (ret = this.fc.showSaveDialog(this)) == 0) {
                        File file = this.fc.getSelectedFile();
                        if (!file.getName().endsWith(".xml")) {
                            String path = file.getPath();
                            path = path.concat(".xml");
                            file = new File(path);
                        }
                        if (this.configPanel != null) {
                            this.configPanel.saveFile(file);
                        }
                    }
                }
            }
            catch (Exception ex) {
                this.showErrDialog("Unable to Save File", ex);
            }
        }
    }

    class SchemaFilter
    implements FileFilter {
        SchemaFilter() {
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return false;
            }
            int dotIndex = f.getName().lastIndexOf(".");
            if (dotIndex == -1) {
                return false;
            }
            String extension = f.getName().substring(dotIndex);
            if (extension != null) {
                return extension.endsWith("xsd");
            }
            return false;
        }
    }
}

