/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.config;

import chemaxon.config.struct.ConfigTreeNode;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class ConfigInstance {
    Document doc;
    JTree tree;

    public ConfigInstance(Element root) {
        this.doc = DocumentHelper.createDocument((Element)root);
        this.tree = new JTree(new ConfigTreeNode(root));
    }

    public ConfigInstance(Document indoc) {
        this.doc = indoc;
        ConfigTreeNode root = new ConfigTreeNode(this.doc.getRootElement());
        this.recurseBuildTree(root, this.doc.getRootElement());
        this.tree = new JTree(root);
    }

    private void recurseBuildTree(ConfigTreeNode node, Element element) {
        Iterator kids = element.elementIterator();
        while (kids.hasNext()) {
            Element nextEl = (Element)kids.next();
            ConfigTreeNode newNode = new ConfigTreeNode(nextEl);
            node.add(newNode);
            this.recurseBuildTree(newNode, nextEl);
        }
    }

    public JTree getTree() {
        return this.tree;
    }

    public void addChild(Element child) {
        DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
        ConfigTreeNode selNode = (ConfigTreeNode)this.tree.getLastSelectedPathComponent();
        int kidCount = selNode.getChildCount();
        String xPath = selNode.getNodePath();
        Element selEl = (Element)this.doc.selectSingleNode(xPath);
        selEl.add(child);
        ConfigTreeNode childNode = new ConfigTreeNode(child);
        selNode.add(childNode);
        model.insertNodeInto(childNode, selNode, kidCount);
        this.tree.scrollPathToVisible(new TreePath(childNode.getPath()));
        this.tree.setSelectionPath(new TreePath(childNode.getPath()));
    }

    public void remove() {
        ConfigTreeNode selNode = (ConfigTreeNode)this.tree.getLastSelectedPathComponent();
        int index = selNode.getParent().getIndex(selNode);
        Element parentEl = (Element)this.doc.selectSingleNode(selNode.getNodePath() + "/parent::*");
        List matchingEls = parentEl.elements();
        Element forRemoval = (Element)matchingEls.get(index);
        DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
        model.removeNodeFromParent(selNode);
        forRemoval.detach();
    }

    public int getElementCount(String xPath) {
        List nArray = this.doc.selectNodes(xPath);
        if (nArray == null) {
            return -1;
        }
        return nArray.size();
    }

    public Document getDocument() {
        return this.doc;
    }

    public String getXML() {
        return this.doc.asXML();
    }

    public String getSchemaLocation() {
        Element root = this.doc.getRootElement();
        String sL = root.attributeValue("schemaLocation");
        return sL;
    }
}

