/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.config;

import chemaxon.config.DynConfigPanel;
import chemaxon.config.converter.Converter;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.util.List;
import java.util.Vector;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class ConfigSchema {
    Document schemaDoc;
    Element instanceRoot;

    public ConfigSchema(String fileName, boolean createInstance) {
        String ss;
        String schemaXSD = ss = "schemas/" + fileName;
        try {
            InputStream is = DynConfigPanel.class.getResourceAsStream(ss);
            if (is != null) {
                int c;
                File tempFile = File.createTempFile("schematemp", ".xsd");
                FileWriter fw = new FileWriter(tempFile);
                while ((c = is.read()) != -1) {
                    fw.write(c);
                }
                fw.close();
                is.close();
                schemaXSD = tempFile.getPath();
            }
            Converter convert = new Converter(schemaXSD);
            convert.convert();
            this.schemaDoc = convert.getObject();
            if (createInstance) {
                Element rootDesc = (Element)this.schemaDoc.selectSingleNode("/xsd:schema/xsd:element");
                String rootName = rootDesc.attributeValue("name");
                this.instanceRoot = DocumentHelper.createElement((String)rootName);
                this.instanceRoot.addAttribute("schemaLocation", fileName);
            } else {
                this.instanceRoot = null;
            }
        }
        catch (Exception ex) {
            this.instanceRoot = DocumentHelper.createElement((String)"No_dice");
            ex.printStackTrace();
        }
    }

    public List getSiblingList(String elXPath) {
        Vector siblingVect = new Vector();
        return siblingVect;
    }

    public List getChildList(String elXPath) {
        Vector<String> pathEls = new Vector<String>();
        int o_slashIndex = elXPath.indexOf("/");
        while (o_slashIndex != elXPath.length() && o_slashIndex != -1) {
            int n_slashIndex = elXPath.indexOf("/", o_slashIndex + 1);
            if (n_slashIndex == -1) {
                n_slashIndex = elXPath.length();
            }
            pathEls.add(elXPath.substring(o_slashIndex + 1, n_slashIndex));
            o_slashIndex = n_slashIndex;
        }
        Element seekEl = this.schemaDoc.getRootElement();
        for (int i = 0; i < pathEls.size(); ++i) {
            seekEl = (Element)seekEl.selectSingleNode(".//xsd:element[@name='" + pathEls.get(i) + "']");
        }
        List childList = this.getChildElements(seekEl);
        return childList;
    }

    private List getChildElements(Element el) {
        List children = el.elements();
        if (!children.isEmpty()) {
            Element firstChild = (Element)children.get(0);
            String firstType = firstChild.getName();
            if (firstType.equals("element")) {
                children = el.elements("element");
                return children;
            }
            if (firstType.equals("attribute")) {
                return null;
            }
            children = this.getChildElements(firstChild);
            return children;
        }
        return null;
    }

    public Element getRoot() {
        return this.instanceRoot;
    }

    public Element getSchemaFromInstance(String elXPath) {
        Vector<String> pathEls = new Vector<String>();
        int o_slashIndex = elXPath.indexOf("/");
        while (o_slashIndex != elXPath.length() && o_slashIndex != -1) {
            int n_slashIndex = elXPath.indexOf("/", o_slashIndex + 1);
            if (n_slashIndex == -1) {
                n_slashIndex = elXPath.length();
            }
            pathEls.add(elXPath.substring(o_slashIndex + 1, n_slashIndex));
            o_slashIndex = n_slashIndex;
        }
        Element seekEl = this.schemaDoc.getRootElement();
        for (int i = 0; i < pathEls.size(); ++i) {
            seekEl = (Element)seekEl.selectSingleNode(".//xsd:element[@name='" + pathEls.get(i) + "']");
        }
        return seekEl;
    }

    public class ElementInfo {
        private Element el;
        private int instCount;

        ElementInfo(Element schemaEl) {
        }

        public String getName() {
            return "Element name";
        }

        public int getCount() {
            return 1;
        }

        public boolean isRequired() {
            return false;
        }

        public String getDefaultValue() {
            return "Default";
        }
    }
}

