/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.config;

import chemaxon.config.MarvinFrame;
import chemaxon.config.converter.Converter;
import chemaxon.config.converter.SchemaToInstance;
import chemaxon.config.struct.ActChoiceBox;
import chemaxon.config.struct.Control;
import chemaxon.config.struct.Dom4jListModel;
import chemaxon.config.struct.MolTextBox;
import chemaxon.marvin.beans.MViewPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.XPath;
import org.dom4j.swing.BranchTreeNode;
import org.dom4j.swing.DocumentTreeModel;

public class DynConfigPanel
extends JPanel
implements TreeSelectionListener,
ActionListener {
    private String sep = System.getProperty("file.separator");
    private Hashtable controlsHash;
    private Document schemaDoc;
    private String schemaXSD;
    private Document instDoc;
    private File instFile;
    private Hashtable panelsHash;
    private JTree panelTree;
    private JEditorPane jePane;
    private SchemaToInstance schemaConverter = new SchemaToInstance();
    private Hashtable buttonTextHash;
    private String fileName;
    private File lastSaved;
    private String schemaLocation;
    private Document idealInstance;
    public static final int PHARMA = 0;
    public static final int NUMSCHEMAS = 1;
    public boolean hasSchema;
    private boolean hasInstance;
    public Exception constructorEx;
    private String[] schemaList;
    private static final String fileSeparator = System.getProperty("file.separator");

    public DynConfigPanel(int panelType) throws Exception {
        this.buttonTextHash = new Hashtable();
        this.schemaList = new String[]{"/jchemsite/conf/pharma_schema.xsd"};
        this.hasInstance = false;
        this.lastSaved = null;
        System.setProperty("saved.file", "");
        if (panelType == -1 || panelType >= 1) {
            this.hasSchema = false;
            this.createEditor(null);
        } else {
            this.hasSchema = true;
            this.schemaLocation = this.schemaList[panelType];
            this.schemaXSD = DynConfigPanel.class.getResource(this.schemaList[panelType]).getFile();
            this.schemaDoc = this.convertFile(this.schemaXSD);
            this.instDoc = this.schemaConverter.convert(this.schemaDoc);
            this.idealInstance = (Document)this.instDoc.clone();
            if (this.instDoc == null) {
                this.writeSchemaError(this, "Your schema does not use appropriate namespaces");
                this.hasSchema = false;
            }
            this.panelsHash = new Hashtable();
            this.controlsHash = new Hashtable();
            this.createPanel(this.schemaDoc);
        }
    }

    /*
     * Unable to fully structure code
     */
    public DynConfigPanel(int panelType, File iFile) throws Exception {
        super();
        this.buttonTextHash = new Hashtable<K, V>();
        this.schemaList = new String[]{"/jchemsite/conf/pharma_schema.xsd"};
        this.hasInstance = true;
        this.lastSaved = iFile;
        System.setProperty("saved.file", iFile.getPath());
        if (panelType == -1) ** GOTO lbl-1000
        if (panelType < 1) {
            this.instDoc = this.convertFile(iFile.getPath());
        } else lbl-1000:
        // 2 sources

        {
            this.instDoc = null;
        }
        if (this.instDoc == null) {
            this.hasSchema = false;
            this.instFile = iFile;
            this.createEditor(iFile);
        } else {
            this.schemaXSD = DynConfigPanel.class.getResource(this.schemaList[panelType]).getFile();
            this.schemaDoc = this.convertFile(this.schemaXSD);
            if (this.rootsMatch(this.schemaDoc, this.instDoc)) {
                this.hasSchema = true;
                this.panelsHash = new Hashtable<K, V>();
                this.controlsHash = new Hashtable<K, V>();
                this.createPanel(this.schemaDoc);
            } else {
                this.hasSchema = false;
                this.createEditor(iFile);
            }
        }
    }

    public DynConfigPanel(File iFile) throws Exception {
        this.buttonTextHash = new Hashtable();
        this.schemaList = new String[]{"/jchemsite/conf/pharma_schema.xsd"};
        this.hasInstance = true;
        this.lastSaved = iFile;
        System.setProperty("saved.file", iFile.getPath());
        this.instDoc = this.convertFile(iFile.getPath());
        Element root = this.instDoc.getRootElement();
        String schemaXSD = root.attributeValue("schemaLocation");
        this.constructorEx = null;
        if (schemaXSD == null || schemaXSD == "") {
            this.hasSchema = false;
            this.createEditor(iFile);
            this.constructorEx = new Exception("You must specify a schema in the schemaLocation attribute of the root element.");
        } else {
            this.schemaLocation = schemaXSD.substring(schemaXSD.lastIndexOf(" ") + 1, schemaXSD.length());
            String ss = "schemas/" + this.schemaLocation;
            InputStream is = DynConfigPanel.class.getResourceAsStream(ss);
            if (is != null) {
                int c;
                File tempFile = File.createTempFile("schematemp", ".xsd");
                FileWriter fw = new FileWriter(tempFile);
                while ((c = is.read()) != -1) {
                    fw.write(c);
                }
                fw.close();
                is.close();
                schemaXSD = tempFile.getPath();
                this.schemaDoc = this.convertFile(schemaXSD);
                this.hasSchema = true;
                this.panelsHash = new Hashtable();
                this.controlsHash = new Hashtable();
                this.idealInstance = this.schemaConverter.convert(this.schemaDoc);
                this.createPanel(this.schemaDoc);
            } else {
                this.hasSchema = false;
                this.createEditor(iFile);
                this.constructorEx = new Exception("Your schemaLocation is not correctly specified");
            }
        }
    }

    public DynConfigPanel(String schemaName) throws Exception {
        this.buttonTextHash = new Hashtable();
        this.schemaList = new String[]{"/jchemsite/conf/pharma_schema.xsd"};
        this.hasInstance = false;
        this.lastSaved = null;
        System.setProperty("saved.file", "");
        this.hasSchema = true;
        this.schemaLocation = schemaName;
        String ss = "schemas/" + this.schemaLocation;
        InputStream is = DynConfigPanel.class.getResourceAsStream(ss);
        if (is != null) {
            int c;
            File tempFile = File.createTempFile("schematemp", ".xsd");
            FileWriter fw = new FileWriter(tempFile);
            while ((c = is.read()) != -1) {
                fw.write(c);
            }
            fw.close();
            is.close();
            this.schemaXSD = tempFile.getPath();
            this.schemaDoc = this.convertFile(this.schemaXSD);
            this.instDoc = this.schemaConverter.convert(this.schemaDoc);
            this.idealInstance = this.schemaConverter.convert(this.schemaDoc);
        }
        if (this.instDoc == null) {
            this.writeSchemaError(this, "Your schema does not use appropriate namespaces");
            this.hasSchema = false;
        }
        this.panelsHash = new Hashtable();
        this.controlsHash = new Hashtable();
        this.createPanel(this.schemaDoc);
    }

    private Document convertFile(String inFile) throws Exception {
        Converter con = new Converter(inFile);
        con.convert();
        Document doc = con.getObject();
        return doc;
    }

    private void createPanel(Document doc) {
        this.setPreferredSize(new Dimension(400, 400));
        if (doc == null) {
            this.setBackground(Color.white);
            JLabel l = new JLabel("There was no schema matching your request");
            this.setLayout(new BorderLayout());
            this.add((Component)l, "Center");
        } else {
            this.setBackground(Color.white);
            this.setLayout(new BoxLayout(this, 1));
            XPath search = DocumentHelper.createXPath((String)"/xsd:schema/xsd:element");
            List topElements = search.selectNodes((Object)doc);
            if (topElements.isEmpty()) {
                this.writeSchemaError(this, "Malformed Schema - possibly wrong namespace or missing root element");
                return;
            }
            Element root = (Element)topElements.get(0);
            String rootName = root.attributeValue("name");
            String eContentType = root.attributeValue("type");
            Element eChild = root.element("complexType");
            if (eChild == null && eContentType == null) {
                this.writeSchemaError(this, "Root element does not contain appropriate subelements");
                return;
            }
            if (eContentType != null) {
                this.writeSchemaError(this, "Root cannot be a simpleType");
                return;
            }
            Control co = new Control();
            Element tempEl = (Element)this.instDoc.selectSingleNode("/" + rootName);
            Element insEl = null;
            Element idealEl = (Element)this.idealInstance.selectSingleNode("/" + root.attributeValue("name"));
            String elPath = rootName;
            if (tempEl == null) {
                insEl = idealEl.createCopy();
                this.instDoc.add(insEl);
                elPath = insEl.getPath();
            } else {
                insEl = tempEl;
                elPath = tempEl.getPath();
            }
            co.setInstanceNode(insEl);
            co.setIdealNode(idealEl);
            JPanel rootChildPanel = new JPanel();
            this.makeSubPanel(rootChildPanel, root, 0, co);
            this.controlsHash.put(elPath, co);
            if (rootChildPanel.getComponentCount() > 0) {
                rootChildPanel.setBorder(null);
                JScrollPane js = new JScrollPane(rootChildPanel);
                this.panelsHash.put(elPath, js);
            }
            Enumeration conEn = this.controlsHash.elements();
            while (conEn.hasMoreElements()) {
                Control c = (Control)conEn.nextElement();
                c.fillControls();
            }
            DocumentTreeModel dtm = new DocumentTreeModel(this.idealInstance);
            this.panelTree = new JTree((TreeModel)dtm);
            ToolTipManager.sharedInstance().registerComponent(this.panelTree);
            this.panelTree.setCellRenderer(new ToolTipTreeRenderer());
            this.panelTree.addTreeSelectionListener(this);
            this.setBackground(Color.white);
            JLabel l = new JLabel("Please select the group of properties you wish to edit");
            if (this.hasSchema) {
                this.add(l);
            }
        }
    }

    private List getChildElements(Element el) {
        if (el.attributeValue("type") != null) {
            this.writeSchemaError(this, "Your schema has referenced element definitions");
            return null;
        }
        List children = el.elements();
        if (!children.isEmpty()) {
            Element firstChild = (Element)children.get(0);
            String firstType = firstChild.getName();
            if (firstType.equals("element")) {
                children = el.elements("element");
                return children;
            }
            if (firstType.equals("attribute")) {
                return null;
            }
            children = this.getChildElements(firstChild);
            return children;
        }
        return null;
    }

    private List getChildAttributes(Element el) {
        Element firstChild;
        String firstType;
        List children = el.elements();
        children = !children.isEmpty() ? ((firstType = (firstChild = (Element)children.get(0)).getName()).equals("complexType") || firstType.equals("complexContent") ? this.getChildAttributes(firstChild) : (firstType.equals("attribute") || firstType.equals("sequence") ? el.elements("attribute") : this.getChildElements(firstChild))) : null;
        return children;
    }

    private boolean hasTextContent(Element e) {
        boolean ret = false;
        if (e.attributeValue("type") != null) {
            ret = true;
        } else {
            Element ct = e.element("complexType");
            if (ct != null && ct.attribute("mixed") != null && ct.attributeValue("mixed").equals("true")) {
                ret = true;
            }
        }
        return ret;
    }

    private void writeSchemaError(JPanel p, String err) {
        this.removeAll();
        JLabel errLab1 = new JLabel("There was an error in your schema");
        JLabel errLab2 = new JLabel(err);
        this.add(errLab1);
        this.add(errLab2);
        this.hasSchema = false;
        this.addContainerListener(null);
    }

    private void makeSubPanel(JPanel pane, Element e, int level, Control con) {
        pane.setLayout(new BoxLayout(pane, 1));
        List subEls = this.getChildElements(e);
        List subAtts = this.getChildAttributes(e);
        if (subEls != null && !subEls.isEmpty()) {
            Iterator it = subEls.iterator();
            int numSibs = subEls.size();
            while (it.hasNext()) {
                Element par;
                Element inEl;
                Element tempEl;
                JPanel childPanel = new JPanel();
                Element nextEl = (Element)it.next();
                String elName = nextEl.attributeValue("name");
                childPanel.setBorder(BorderFactory.createTitledBorder(elName));
                con.addNode(elName);
                List moreChildren = this.getChildElements(nextEl);
                List moreAtts = this.getChildAttributes(nextEl);
                if (moreAtts != null && !moreAtts.isEmpty()) {
                    JPanel controls = this.makeControlPanel(nextEl, con);
                    controls.setAlignmentX(0.0f);
                    childPanel.add(controls);
                } else {
                    JPanel holder = this.makePlaceHolder(nextEl, con);
                    if (holder != null) {
                        holder.setAlignmentX(0.0f);
                        childPanel.add(holder);
                    }
                }
                if (moreChildren != null && !moreChildren.isEmpty()) {
                    Element par2;
                    tempEl = (Element)this.instDoc.selectSingleNode("//" + e.attributeValue("name") + "/" + elName);
                    inEl = null;
                    Element idealEl = (Element)this.idealInstance.selectSingleNode("//" + e.attributeValue("name") + "/" + elName);
                    String elPath = elName;
                    if (tempEl == null) {
                        inEl = idealEl.createCopy();
                        par2 = (Element)this.instDoc.selectSingleNode("//" + e.attributeValue("name"));
                        if (par2 != null) {
                            par2.add(inEl);
                        }
                        elPath = inEl.getPath();
                    } else if (this.isElementEmpty(tempEl)) {
                        par2 = (Element)this.instDoc.selectSingleNode(tempEl.getParent().getPath());
                        tempEl.detach();
                        inEl = idealEl.createCopy();
                        if (par2 != null) {
                            par2.add(inEl);
                        }
                        elPath = inEl.getPath();
                    } else {
                        inEl = tempEl;
                        elPath = tempEl.getPath();
                    }
                    Control con2 = new Control();
                    con2.setInstanceNode(inEl);
                    con2.setIdealNode(idealEl);
                    con.setChild(inEl.getName(), con2);
                    this.makeSubPanel(childPanel, nextEl, level + 1, con2);
                    this.controlsHash.put(elPath, con2);
                    childPanel.setAlignmentX(0.0f);
                    childPanel.setAlignmentY(0.0f);
                    if (numSibs >= 3 || numSibs > 1 && level > 0) {
                        JScrollPane js = new JScrollPane(childPanel);
                        if (childPanel.getComponentCount() <= 0) continue;
                        childPanel.setBorder(null);
                        this.panelsHash.put(elPath, js);
                        continue;
                    }
                    pane.add(childPanel);
                    continue;
                }
                tempEl = (Element)this.instDoc.selectSingleNode("//" + e.attributeValue("name") + "/" + elName);
                inEl = null;
                String elPath = elName;
                if (tempEl == null) {
                    inEl = (Element)this.idealInstance.selectSingleNode("//" + e.attributeValue("name") + "/" + elName);
                    par = (Element)this.instDoc.selectSingleNode("//" + e.attributeValue("name"));
                    if (par != null) {
                        inEl = inEl.createCopy();
                        par.add(inEl);
                    }
                    elPath = inEl.getPath();
                } else if (this.isElementEmpty(tempEl)) {
                    tempEl.detach();
                    inEl = (Element)this.idealInstance.selectSingleNode("//" + e.attributeValue("name") + "/" + elName);
                    par = (Element)this.instDoc.selectSingleNode(inEl.getParent().getPath());
                    if (par != null) {
                        inEl = inEl.createCopy();
                        par.add(inEl);
                    }
                    elPath = inEl.getPath();
                } else {
                    inEl = tempEl;
                    elPath = tempEl.getPath();
                }
                this.makeSubPanel(childPanel, nextEl, level + 1, con);
                childPanel.setAlignmentX(0.0f);
                childPanel.setAlignmentY(0.0f);
                if (childPanel.getComponentCount() <= 0) continue;
                pane.add(childPanel);
            }
        }
    }

    private JPanel makeTextControl(String name, Control con) {
        JPanel textPanel = new JPanel();
        textPanel.setLayout(new BorderLayout());
        JTextField tf = new JTextField(25);
        textPanel.add(tf);
        con.addNodeContent(name, tf);
        return textPanel;
    }

    private Element getDefinition(Document d, String type) {
        List defList = d.selectNodes("/xsd:schema/xsd:simpleType");
        for (int i = 0; i < defList.size(); ++i) {
            Element e = (Element)defList.get(i);
            if (!e.attributeValue("name").equals(type)) continue;
            return e;
        }
        return null;
    }

    private Vector createChoiceVector(Element e) {
        Vector<String> v = new Vector<String>();
        if (e == null) {
            return v;
        }
        Element detachedEl = e.createCopy();
        List choiceList = e.selectNodes(".//xsd:enumeration");
        for (int i = 0; i < choiceList.size(); ++i) {
            v.add(((Element)choiceList.get(i)).attributeValue("value"));
        }
        return v;
    }

    private JComponent makeControl(Element att, Control con) {
        String name = att.attributeValue("name");
        String type = att.attributeValue("type");
        String defVal = att.attributeValue("default");
        String fixVal = att.attributeValue("fixed");
        if (type.equals("xsd:boolean")) {
            JRadioButton vrai = new JRadioButton("True");
            JRadioButton faux = new JRadioButton("False");
            vrai.setActionCommand("true");
            faux.setActionCommand("false");
            ButtonGroup bool = new ButtonGroup();
            bool.add(vrai);
            bool.add(faux);
            con.addControl(name, bool);
            JPanel smallPane = new JPanel();
            smallPane.setLayout(new FlowLayout(0));
            smallPane.add(vrai);
            smallPane.add(faux);
            if (defVal != null) {
                if (defVal.equals("false")) {
                    faux.setSelected(true);
                } else {
                    vrai.setSelected(true);
                }
            } else if (fixVal != null) {
                if (fixVal.equals("false")) {
                    faux.setSelected(true);
                    vrai.setEnabled(false);
                    faux.setEnabled(false);
                } else if (fixVal.equals("true")) {
                    vrai.setSelected(true);
                    vrai.setEnabled(false);
                    faux.setEnabled(false);
                }
            } else {
                vrai.setSelected(true);
            }
            return smallPane;
        }
        if (type.equals("xsd:string")) {
            JPanel textPanel = new JPanel();
            textPanel.setLayout(new BorderLayout());
            JTextField tf = new JTextField(25);
            if (defVal != null) {
                tf.setText(defVal);
            }
            if (fixVal != null) {
                tf.setText(fixVal);
                tf.setEnabled(false);
            }
            textPanel.add(tf);
            con.addControl(name, tf);
            return textPanel;
        }
        if (type.equals("xsd:decimal")) {
            JPanel decPanel = new JPanel();
            decPanel.setLayout(new BorderLayout());
            JTextField tf = new JTextField(10);
            if (defVal != null) {
                tf.setText(defVal);
            }
            if (fixVal != null) {
                tf.setText(fixVal);
                tf.setEnabled(false);
            }
            con.addControl(name, tf);
            decPanel.add((Component)tf, "West");
            return decPanel;
        }
        if (type.equals("filename")) {
            MolTextBox tf = new MolTextBox();
            tf.setToolTipText("File Path must be absolute");
            JButton btnBrowse = new JButton("...");
            btnBrowse.setToolTipText("Browse file system");
            this.buttonTextHash.put(btnBrowse, tf);
            tf.setButton(btnBrowse);
            JPanel smallPane = new JPanel();
            con.addControl(name, tf);
            btnBrowse.addActionListener(this);
            btnBrowse.setActionCommand("browse");
            smallPane.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.insets = new Insets(1, 1, 1, 5);
            gbc.anchor = 17;
            gbc.fill = 2;
            gbc.gridx = 0;
            gbc.weightx = 1.0;
            gbc.gridy = 0;
            smallPane.add((Component)tf, gbc);
            gbc.insets = new Insets(1, 1, 1, 15);
            gbc.gridx = 1;
            gbc.weightx = 0.0;
            smallPane.add((Component)btnBrowse, gbc);
            return smallPane;
        }
        if (type.equals("filepath")) {
            JPanel textPanel = new JPanel();
            textPanel.setLayout(new FlowLayout(0));
            JTextField tf = new JTextField(25);
            textPanel.add(tf);
            JButton btnBrowse = new JButton("...");
            btnBrowse.setToolTipText("Browse file system");
            this.buttonTextHash.put(btnBrowse, tf);
            textPanel.add(btnBrowse);
            btnBrowse.addActionListener(this);
            btnBrowse.setActionCommand("fpBrowse");
            con.addControl(name, tf);
            if (defVal != null) {
                tf.setText(defVal);
            }
            if (fixVal != null) {
                tf.setText(fixVal);
                tf.setEnabled(false);
            }
            return textPanel;
        }
        if (type.equals("fileSelect")) {
            JPanel textPanel = new JPanel();
            textPanel.setLayout(new FlowLayout(0));
            JTextField tf = new JTextField(25);
            textPanel.add(tf);
            JButton btnBrowse = new JButton("...");
            btnBrowse.setToolTipText("Browse file system");
            this.buttonTextHash.put(btnBrowse, tf);
            textPanel.add(btnBrowse);
            btnBrowse.addActionListener(this);
            btnBrowse.setActionCommand("browse");
            con.addControl(name, tf);
            if (defVal != null) {
                tf.setText(defVal);
            }
            if (fixVal != null) {
                tf.setText(fixVal);
                tf.setEnabled(false);
            }
            return textPanel;
        }
        if (type.equals("smilesString")) {
            MolTextBox tf = new MolTextBox();
            tf.setToolTipText("Strings must be in SMILES format");
            JButton btnMarvin = new JButton("Edit");
            btnMarvin.setToolTipText("View/Edit structure in Marvin");
            btnMarvin.setActionCommand("marvin");
            btnMarvin.addActionListener(this);
            this.buttonTextHash.put(btnMarvin, tf);
            tf.setButton(btnMarvin);
            JPanel smallPane = new JPanel();
            con.addControl(name, tf);
            con.addViewer();
            smallPane.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.insets = new Insets(1, 1, 1, 5);
            gbc.anchor = 17;
            gbc.fill = 2;
            gbc.gridx = 0;
            gbc.weightx = 1.0;
            gbc.gridy = 0;
            smallPane.add((Component)tf, gbc);
            gbc.insets = new Insets(1, 1, 1, 1);
            gbc.gridx = 1;
            gbc.weightx = 0.0;
            smallPane.add((Component)btnMarvin, gbc);
            return smallPane;
        }
        if (type.equals("actChoice")) {
            Element def = this.getDefinition(this.schemaDoc, type);
            Vector choices = this.createChoiceVector(def);
            ActChoiceBox jc = new ActChoiceBox(choices);
            if (defVal != null) {
                jc.setSelectedItem(defVal);
            }
            if (fixVal != null) {
                jc.setSelectedItem(fixVal);
                jc.setEnabled(false);
            }
            con.addControl(name, jc);
            return jc;
        }
        if (type.equals("optChoice")) {
            Element def = this.getDefinition(this.schemaDoc, type);
            Vector choices = this.createChoiceVector(def);
            JComboBox jc = new JComboBox(choices);
            con.addControl(name, jc);
            return jc;
        }
        if (type.equals("structure")) {
            JTextField tf = new JTextField();
            tf.setToolTipText("Enter a SMILES string or file name");
            JButton btnMarvin = new JButton("Edit");
            btnMarvin.setToolTipText("View/Edit structure in Marvin");
            btnMarvin.setActionCommand("marvin");
            btnMarvin.addActionListener(this);
            this.buttonTextHash.put(btnMarvin, tf);
            JPanel smallPane = new JPanel();
            con.addControl(name, tf);
            con.addViewer();
            smallPane.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.insets = new Insets(1, 1, 1, 5);
            gbc.anchor = 17;
            gbc.fill = 2;
            gbc.gridx = 0;
            gbc.weightx = 1.0;
            gbc.gridy = 0;
            smallPane.add((Component)tf, gbc);
            gbc.insets = new Insets(1, 1, 1, 1);
            gbc.gridx = 1;
            gbc.weightx = 0.0;
            smallPane.add((Component)btnMarvin, gbc);
            return smallPane;
        }
        Element def = this.getDefinition(this.schemaDoc, type);
        if (def == null) {
            JLabel typeL = new JLabel(type);
            return typeL;
        }
        Vector choices = this.createChoiceVector(def);
        JComboBox jc = new JComboBox(choices);
        con.addControl(name, jc);
        return jc;
    }

    private JPanel makeControlPanel(Element e, Control con) {
        JPanel cP = new JPanel();
        String name = e.attributeValue("name");
        String minString = e.attributeValue("minOccurs");
        String maxString = e.attributeValue("maxOccurs");
        if (name == null || minString == null || maxString == null) {
            this.writeSchemaError(null, "One or more schema elements are missing required attributes" + name);
            return cP;
        }
        int min = Integer.parseInt(minString);
        int height = 0;
        if (maxString.equals("unbounded")) {
            height = 240;
            GridBagLayout gb = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            cP.setLayout(gb);
            List atts = this.getChildAttributes(e);
            Iterator it = atts.iterator();
            int i = 0;
            ButtonGroup rdoGroup = new ButtonGroup();
            i = 0;
            while (it.hasNext()) {
                JComponent labName;
                height += 30;
                Element att = (Element)it.next();
                String aName = att.attributeValue("name");
                String aType = att.attributeValue("type");
                JComponent control = this.makeControl(att, con);
                if (aType.equals("smilesString") || aType.equals("filename") || aType.equals("actChoice")) {
                    labName = new JRadioButton(this.splitLabelName(aName));
                    rdoGroup.add((AbstractButton)labName);
                    if (control instanceof JPanel) {
                        Component[] cArray = ((JPanel)control).getComponents();
                        for (int k = 0; k < cArray.length; ++k) {
                            JRadioButton rb;
                            if (cArray[k] instanceof MolTextBox) {
                                MolTextBox tb = (MolTextBox)cArray[k];
                                rb = (JRadioButton)labName;
                                tb.setRdo(rb);
                                rb.addItemListener(tb);
                                continue;
                            }
                            if (!(cArray[k] instanceof ActChoiceBox)) continue;
                            ActChoiceBox acb = (ActChoiceBox)cArray[k];
                            rb = (JRadioButton)labName;
                            acb.setRdo(rb);
                            rb.addItemListener(acb);
                        }
                    } else if (control instanceof ActChoiceBox) {
                        ActChoiceBox acb = (ActChoiceBox)control;
                        JComponent rb = labName;
                        acb.setRdo((JRadioButton)rb);
                        ((AbstractButton)rb).addItemListener(acb);
                    }
                } else {
                    labName = new JLabel(this.splitLabelName(aName));
                }
                c.gridx = 0;
                c.weightx = 0.0;
                c.gridy = i++;
                c.insets = new Insets(5, 5, 2, 2);
                c.fill = 0;
                c.anchor = 17;
                gb.setConstraints(labName, c);
                cP.add(labName);
                c.insets = new Insets(5, 5, 2, 2);
                c.gridx = 1;
                c.weightx = 1.0;
                c.fill = 2;
                gb.setConstraints(control, c);
                cP.add(control);
            }
            if (this.hasTextContent(e)) {
                JPanel control = this.makeTextControl(name, con);
                JLabel lab = new JLabel("Content");
                c.gridx = 0;
                c.gridy = i + 1;
                ++i;
                c.weightx = 0.0;
                c.gridwidth = 0;
                c.gridheight = 1;
                c.fill = 2;
                c.anchor = 17;
                c.insets = new Insets(5, 5, 2, 2);
                gb.setConstraints(lab, c);
                cP.add(lab);
                c.gridx = 1;
                gb.setConstraints(control, c);
                cP.add(control);
                height += 30;
            }
            if (con.needsViewer(name)) {
                MViewPane mvPane = new MViewPane();
                mvPane.setMinimumSize(new Dimension(150, 70));
                height += 150;
                mvPane.setDetachable(true);
                mvPane.setTabScale(-1.0);
                con.setViewer(name, mvPane);
                c.gridx = 0;
                c.gridy = i + 1;
                ++i;
                c.gridwidth = 2;
                c.weighty = 1.0;
                c.fill = 1;
                c.anchor = 18;
                c.insets = new Insets(0, 0, 0, 0);
                gb.setConstraints(mvPane, c);
                cP.add(mvPane);
                c.weighty = 0.0;
            }
            JButton btnAdd = new JButton("Add");
            JButton btnRemove = new JButton("Remove");
            JButton btnEdit = new JButton("Modify");
            btnAdd.setName(name);
            btnRemove.setName(name);
            btnEdit.setName(name);
            btnAdd.addActionListener(con);
            btnAdd.setActionCommand("add");
            btnAdd.setToolTipText("Add new element");
            btnRemove.addActionListener(con);
            btnRemove.setActionCommand("remove");
            btnRemove.setToolTipText("Remove selected element");
            btnEdit.addActionListener(con);
            btnEdit.setActionCommand("edit");
            btnEdit.setToolTipText("Modify selected element values");
            c.fill = 0;
            c.anchor = 17;
            c.insets = new Insets(2, 2, 1, 1);
            c.gridheight = 1;
            JPanel addEditPanel = new JPanel();
            addEditPanel.setLayout(new FlowLayout());
            addEditPanel.add(btnAdd);
            addEditPanel.add(btnEdit);
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.gridx = 0;
            c.gridy = i + 1;
            c.gridwidth = 2;
            gb.setConstraints(addEditPanel, c);
            cP.add(addEditPanel);
            c.gridx = 0;
            c.gridy = i + 3;
            c.gridwidth = 1;
            gb.setConstraints(btnRemove, c);
            cP.add(btnRemove);
            Dom4jListModel lm = new Dom4jListModel();
            JList attList = new JList(lm);
            attList.setSelectionMode(0);
            JScrollPane js = new JScrollPane(attList);
            js.setMinimumSize(new Dimension(200, 150));
            con.setList(attList, lm);
            attList.addListSelectionListener(con);
            c.gridx = 0;
            c.gridy = i + 2;
            c.fill = 1;
            c.gridwidth = 3;
            gb.setConstraints(js, c);
            cP.add(js);
        } else {
            GridBagLayout gb = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            cP.setLayout(gb);
            height = 20;
            int max = Integer.parseInt(maxString);
            int i = 0;
            if (min == 1) {
                min = 0;
            }
            for (int j = min; j < max; ++j) {
                List atts = this.getChildAttributes(e);
                Iterator it = atts.iterator();
                i = 0;
                while (it.hasNext()) {
                    height += 30;
                    Element att = (Element)it.next();
                    String aName = att.attributeValue("name");
                    String aType = att.attributeValue("type");
                    JLabel labName = new JLabel(this.splitLabelName(aName));
                    JComponent control = this.makeControl(att, con);
                    if (aType.equals("xsd:boolean")) {
                        height += 5;
                    } else if (aType.equals("fileSelect")) {
                        height += 10;
                    }
                    c.insets = new Insets(5, 5, 2, 2);
                    c.gridx = 0;
                    c.weightx = 0.0;
                    c.gridy = i++;
                    c.fill = 0;
                    c.anchor = 17;
                    gb.setConstraints(labName, c);
                    cP.add(labName);
                    c.fill = 2;
                    c.anchor = 17;
                    c.gridx = 1;
                    c.weightx = 1.0;
                    gb.setConstraints(control, c);
                    cP.add(control);
                }
            }
            if (this.hasTextContent(e)) {
                JPanel control = this.makeTextControl(name, con);
                JLabel lab = new JLabel("Content");
                c.gridx = 0;
                c.gridy = i + 1;
                ++i;
                c.weightx = 0.0;
                c.gridwidth = 0;
                c.gridheight = 1;
                c.fill = 0;
                c.anchor = 17;
                gb.setConstraints(lab, c);
                cP.add(lab);
                c.gridx = 1;
                c.weightx = 1.0;
                c.fill = 2;
                gb.setConstraints(control, c);
                cP.add(control);
                height += 30;
            }
        }
        cP.setMaximumSize(new Dimension(800, height));
        cP.setMinimumSize(new Dimension(250, height));
        cP.setPreferredSize(new Dimension(500, height));
        return cP;
    }

    private JPanel makePlaceHolder(Element e, Control con) {
        JPanel cP = new JPanel();
        String name = e.attributeValue("name");
        String minString = e.attributeValue("minOccurs");
        String maxString = e.attributeValue("maxOccurs");
        if (name == null || minString == null || maxString == null) {
            this.writeSchemaError(null, "One or more schema elements are missing required attributes" + name);
            return cP;
        }
        int min = Integer.parseInt(minString);
        if (maxString.equals("unbounded")) {
            GridBagLayout gb = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            cP.setLayout(gb);
            JLabel labName = new JLabel(this.splitLabelName(name));
            c.gridx = 0;
            c.weightx = 1.0;
            c.gridy = 0;
            c.insets = new Insets(5, 5, 2, 2);
            c.fill = 0;
            c.anchor = 17;
            gb.setConstraints(labName, c);
            cP.add(labName);
            JButton btnAdd = new JButton("Add");
            JButton btnRemove = new JButton("Remove");
            JButton btnEdit = new JButton("Modify");
            btnAdd.setName(name);
            btnRemove.setName(name);
            btnEdit.setName(name);
            btnAdd.addActionListener(con);
            btnAdd.setActionCommand("add");
            btnAdd.setToolTipText("Add new element");
            btnRemove.addActionListener(con);
            btnRemove.setActionCommand("remove");
            btnRemove.setToolTipText("Remove selected element");
            btnEdit.addActionListener(con);
            btnEdit.setActionCommand("edit");
            btnEdit.setToolTipText("Modify selected element values");
            c.fill = 0;
            c.anchor = 17;
            c.insets = new Insets(2, 2, 1, 1);
            c.gridheight = 1;
            JPanel addEditPanel = new JPanel();
            addEditPanel.setLayout(new FlowLayout());
            addEditPanel.add(btnAdd);
            addEditPanel.add(btnEdit);
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.gridx = 0;
            c.gridy = 1;
            c.gridwidth = 2;
            gb.setConstraints(addEditPanel, c);
            cP.add(addEditPanel);
            c.gridx = 0;
            c.gridy = 3;
            c.gridwidth = 1;
            gb.setConstraints(btnRemove, c);
            cP.add(btnRemove);
            Dom4jListModel lm = new Dom4jListModel();
            JList attList = new JList(lm);
            attList.setSelectionMode(0);
            JScrollPane js = new JScrollPane(attList);
            js.setMinimumSize(new Dimension(200, 150));
            con.setList(attList, lm);
            attList.addListSelectionListener(con);
            c.gridx = 0;
            c.gridy = 2;
            c.fill = 1;
            c.gridwidth = 3;
            gb.setConstraints(js, c);
            cP.add(js);
            cP.setMaximumSize(new Dimension(800, 300));
            cP.setMinimumSize(new Dimension(250, 250));
            cP.setPreferredSize(new Dimension(500, 250));
            return cP;
        }
        return null;
    }

    private void createEditor(File iFile) throws Exception {
        this.setBackground(Color.white);
        this.jePane = new JEditorPane();
        if (iFile != null) {
            URL fileURL = iFile.toURL();
            this.jePane.setPage(fileURL);
        }
        this.removeAll();
        this.setLayout(new BorderLayout());
        JScrollPane js = new JScrollPane(this.jePane);
        this.add((Component)js, "Center");
        this.revalidate();
        this.repaint();
    }

    private boolean rootsMatch(Document schemaDoc, Document instDoc) {
        Element sRoot = (Element)schemaDoc.selectSingleNode("/xsd:schema/xsd:element");
        if (sRoot == null) {
            return false;
        }
        Element iRoot = instDoc.getRootElement();
        return sRoot.attributeValue("name").equals(iRoot.getName());
    }

    private void changeElement(Element el) {
        String elName = el.getName();
        String elPath = el.getPath();
        Control c = (Control)this.controlsHash.get(elPath);
        if (c != null) {
            c.parseAllInput();
            Element tmp = c.getInstanceNode();
            List content = tmp.content();
            el.clearContent();
            el.setContent(content);
            List atts = tmp.attributes();
            el.setAttributes(atts);
        }
    }

    private boolean isElementEmpty(Element e) {
        boolean isEmpty = true;
        if (e.elements().isEmpty()) {
            if (e.attributeCount() == 0) {
                return true;
            }
            isEmpty = true;
            Iterator atIt = e.attributeIterator();
            while (atIt.hasNext()) {
                Attribute a = (Attribute)atIt.next();
                String aVal = a.getValue();
                if (aVal.equals("") || aVal == null) continue;
                isEmpty = false;
                break;
            }
            return isEmpty;
        }
        isEmpty = false;
        List els = e.elements();
        for (int i = 0; i < els.size() && (isEmpty = this.isElementEmpty((Element)els.get(i))); ++i) {
        }
        return isEmpty;
    }

    private void saveRecurse(Node n, Vector toDetach) {
        if (n instanceof Element) {
            Element e = (Element)n;
            for (int j = 0; j < e.nodeCount(); ++j) {
                Node n1 = e.node(j);
                this.saveRecurse(n1, toDetach);
            }
            this.changeElement(e);
            if (this.isElementEmpty(e)) {
                toDetach.add(e.getPath());
            }
        }
    }

    public void saveFile(File oFile) throws Exception {
        this.saveFile(oFile, false);
    }

    public void saveFile(File oFile, boolean chkFile) throws Exception {
        if (this.hasSchema) {
            Vector toDetach = new Vector();
            Document idealDoc = this.schemaConverter.convert(this.schemaDoc);
            Element root = idealDoc.getRootElement();
            for (int i = 0; i < root.nodeCount(); ++i) {
                Node n = root.node(i);
                this.saveRecurse(n, toDetach);
            }
            this.changeElement(root);
            root.addAttribute("schemaLocation", this.schemaLocation);
            for (int k = 0; k < toDetach.size(); ++k) {
                String elPath = (String)toDetach.elementAt(k);
                List elList = idealDoc.selectNodes(elPath);
                for (int j = 0; j < elList.size(); ++j) {
                    Element dEl = (Element)elList.get(j);
                    Element par = null;
                    if (dEl != null && this.isElementEmpty(dEl)) {
                        par = dEl.getParent();
                        dEl.detach();
                    }
                    if (par == null || !this.isElementEmpty(par)) continue;
                    par.detach();
                }
            }
            Converter c = new Converter(idealDoc, oFile);
            c.convert();
        } else {
            OutputStreamWriter outStream = null;
            try {
                outStream = new FileWriter(oFile.getPath());
                if (!oFile.canWrite()) {
                    oFile.createNewFile();
                }
                this.jePane.write(outStream);
                outStream.flush();
            }
            catch (Exception ex) {
                throw ex;
            }
            finally {
                outStream.close();
            }
        }
        this.lastSaved = oFile;
        System.setProperty("saved.file", oFile.getPath());
    }

    public boolean hasFileChanged(File oFile) throws Exception {
        String s1;
        if (oFile == null) {
            return true;
        }
        File tmpFile = File.createTempFile("svcheck", ".xml");
        this.saveFile(tmpFile);
        BufferedReader br1 = new BufferedReader(new FileReader(tmpFile));
        BufferedReader br2 = new BufferedReader(new FileReader(oFile));
        while ((s1 = br1.readLine()) != null) {
            String s2 = br2.readLine();
            if (s1.equals(s2)) continue;
            return true;
        }
        return false;
    }

    public JTree getTree() {
        return this.panelTree;
    }

    public String getFileName() {
        return this.fileName;
    }

    private String splitLabelName(String a) {
        String out = "";
        int last = 0;
        for (int i = 0; i < a.length() - 1; ++i) {
            String b = a.substring(i, i + 1);
            boolean matches = true;
            for (int x = 0; x < b.length(); ++x) {
                char ch = b.charAt(x);
                if (ch >= 'A' && ch <= 'Z') continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            out = out.concat(a.substring(last, i));
            out = out.concat(" ");
            last = i;
        }
        out = out.concat(a.substring(last, a.length()));
        return out;
    }

    @Override
    public void valueChanged(TreeSelectionEvent ev) {
        Object ob = this.panelTree.getLastSelectedPathComponent();
        if (ob instanceof BranchTreeNode) {
            BranchTreeNode node = (BranchTreeNode)ob;
            Node selNode = node.getXmlNode();
            String panelPath = selNode.getPath();
            Component selPanel = (Component)this.panelsHash.get(panelPath);
            while (selPanel == null && panelPath.length() > 0) {
                panelPath = panelPath.substring(0, panelPath.lastIndexOf("/"));
                selPanel = (Component)this.panelsHash.get(panelPath);
            }
            if (selPanel != null) {
                this.removeAll();
                this.add(selPanel);
                this.validateTree();
                this.repaint();
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        String comm = ev.getActionCommand();
        if (comm.equals("browse")) {
            JButton b = (JButton)ev.getSource();
            JTextField tf = (JTextField)this.buttonTextHash.get(b);
            JFileChooser fc = new JFileChooser();
            int ret = fc.showOpenDialog(this);
            if (ret == 0) {
                File file = fc.getSelectedFile();
                String filePath = file.getPath();
                tf.setText(filePath);
            }
        } else if (comm.equals("marvin")) {
            JButton b = (JButton)ev.getSource();
            JTextField tf = (JTextField)this.buttonTextHash.get(b);
            String smiles = tf.getText();
            MarvinFrame mf = new MarvinFrame(tf);
        } else if (comm.equals("fpBrowse")) {
            JButton b = (JButton)ev.getSource();
            JTextField tf = (JTextField)this.buttonTextHash.get(b);
            JFileChooser fc = new JFileChooser();
            int ret = fc.showOpenDialog(this);
            if (ret == 0) {
                File file = fc.getSelectedFile();
                String filePath = file.getName();
                tf.setText(filePath);
            }
        }
    }

    class ToolTipTreeRenderer
    extends DefaultTreeCellRenderer {
        ToolTipTreeRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (value instanceof BranchTreeNode) {
                String path = ((BranchTreeNode)value).getXmlNode().getPath();
                this.setToolTipText(path);
                Component selPanel = (Component)DynConfigPanel.this.panelsHash.get(path);
                if (selPanel != null) {
                    this.setFont(new Font(null, 1, 12));
                } else {
                    this.setFont(new Font(null, 0, 12));
                }
            } else {
                this.setToolTipText(value.toString());
            }
            return this;
        }
    }
}

