/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.core.calculations;

import chemaxon.core.calculations.FindAllRings;
import chemaxon.core.util.BondTable;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.QueryBond;
import chemaxon.struc.SelectionMolecule;
import chemaxon.struc.Sgroup;
import chemaxon.struc.sgroup.RepeatingUnitSgroup;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Aromata {
    private static final Logger logger = Logger.getLogger(Aromata.class.getName());
    private static boolean DEBUG_DAYLIGHT = true;
    private static boolean DEBUG_CXN = false;
    private static boolean DEBUG_RINGDET = false;
    private static final int[] ELECTRONS = new int[139];
    private static final int AROMBOND = 4;
    private MoleculeGraph m_orig = null;
    private MoleculeGraph m = null;
    private static int RINGNUMBERLIMIT = 10000;
    private boolean replaceANYandOR_AROMATICbonds = true;
    private boolean setQueryAromaticBonds = true;
    private ArrayList<int[]> aromRing;
    private ArrayList<int[]> nonAromRing;
    private int[][] aromRingIdx = null;
    private int[][] nonAromRingIdx = null;
    private int[] originalBondType = null;
    private long basicGrinvCC = 0L;
    private long generalGrinvCC = 0L;
    private long mdlGrinvCC = 0L;
    public static final String DO_NOT_AROMATIZE = "DO_NOT_AROMATIZE";
    public static final int DL_ALIPHATIC = -1;
    public static final int DL_AROMATIC = -2;
    public static final int DL_UNKNOWN = -3;
    public static final int DL_AMBIGUOUS = -4;
    private static final int NOT_CALCULATED = 0;
    private static final int ATOM_ADDING_2_ELECTRONS = 2;
    private static final int ATOM_ADDING_0_ELECTRON = -4;
    private static final int QUERYAROMATOM = -5;
    private static final int MARKUSH_AMBIGUOUS = -6;
    private static final int AMBIGUOUS_FIVEM_RA = -7;
    private static final int AROMATOM_ADDING_2_ELECTRONS = -8;
    private static final int AROMATOM_ADDING_0_ELECTRON = -9;
    private static final int AMBIGUOUS_N = -10;
    private static final int AMBIGUOUS_N_WITH_AROMBOND = -11;
    private static final int ATOM_W_AROMBOND = -12;
    private static final int ATOM_W_S_A_BOND = -13;
    private static final int ATOM_W_D_A_BOND = -14;
    private static final int ATOM_W_S_D_BOND = -15;
    private static final int ATOM_W_ANYBOND = -16;
    private static final int AMBIGUOUS_BOND = -17;
    private static final int AROM_BASIC = 1;
    private static final int AROM_GENERAL = 2;
    private static final int AROM_LOOSE = 3;
    private static final int AROM_SUBSTRUCTURE = 4;
    private static final int AROM_AMBIGUOUS = 5;
    private static final int DOUBLE_OR_AROMATIC = 7;
    private static final int SINGLE_OR_AROMATIC = 6;
    private static final int SINGLE_OR_DOUBLE = 5;
    private static final int ANYBOND = 0;
    private static final Integer MARKER;

    public Aromata() {
        this.init();
    }

    public Aromata(MoleculeGraph a) {
        this.m = a;
        this.m_orig = a;
        this.init();
    }

    public final void setAmbiguousGeneralAromatization(boolean b) {
        this.replaceANYandOR_AROMATICbonds = b;
    }

    public final void setQueryAromatization(boolean change) {
        this.setQueryAromaticBonds = change;
    }

    public final long getBasicGrinvCC() {
        return this.basicGrinvCC;
    }

    public final void setBasicGrinvCC(long cc) {
        this.basicGrinvCC = cc;
    }

    public final long getGeneralGrinvCC() {
        return this.generalGrinvCC;
    }

    public final void setGeneralGrinvCC(long cc) {
        this.generalGrinvCC = cc;
    }

    public final long getMDLGrinvCC() {
        return this.mdlGrinvCC;
    }

    public final void setMDLGrinvCC(long cc) {
        this.mdlGrinvCC = cc;
    }

    private final void init() {
        this.aromRingIdx = null;
        this.nonAromRingIdx = null;
        this.originalBondType = null;
    }

    public final void setMol(MoleculeGraph a) {
        this.m = a;
        this.m_orig = a;
        this.generalGrinvCC = this.basicGrinvCC = -1L;
        this.init();
    }

    public final int[][] getNonAromRings() {
        return this.nonAromRingIdx;
    }

    public final int[][] getAromRings() {
        return this.aromRingIdx;
    }

    public final int[][][] getRings() {
        int[][][] r = new int[][][]{this.aromRingIdx, this.nonAromRingIdx};
        return r;
    }

    public final void generalAromatize() {
        this.aromatize(true, true, -1, RINGNUMBERLIMIT, 2, false);
        this.generalGrinvCC = this.m.getGrinvCC();
    }

    public final void basicAromatize() {
        this.aromatize(true, true, 18, RINGNUMBERLIMIT, 1, false);
        this.basicGrinvCC = this.m.getGrinvCC();
    }

    public final void mdlAromatize() {
        this.aromatize(true, true, 18, RINGNUMBERLIMIT, 3, false);
        this.mdlGrinvCC = this.m.getGrinvCC();
    }

    public final void substrAromatize() {
        this.aromatize(true, true, 18, -1, 4, false);
    }

    public final void ambigAromatize() {
        this.aromatize(true, true, -1, RINGNUMBERLIMIT, 5, false);
    }

    public final void aromatize() {
        this.aromatize(true, true, -1, -1, 2, false);
    }

    public final void aromatize(boolean setbonds, boolean onlyAromAtoms, int ringSize, int ringNumberLimit, int aromType, boolean calcRingAtomIdxes) {
        boolean hasCoordinativeBond = false;
        for (int i = this.m.getBondCount() - 1; i >= 0; --i) {
            MolBond b = this.m.getBond(i);
            if (!b.isCoordinate()) continue;
            hasCoordinativeBond = true;
            break;
        }
        if (hasCoordinativeBond) {
            this.m = Aromata.removeCoordinativeBonds(this.m);
        }
        FindAllRings allringSearcher = null;
        BondTable btab = this.m.getBondTable();
        int bondCount = this.m.getBondCount();
        this.originalBondType = new int[bondCount];
        for (int i = 0; i < bondCount; ++i) {
            int bondType;
            MolBond bond = this.m.getBond(i);
            this.originalBondType[i] = bondType = bond.getType();
        }
        if (aromType == 2 || aromType == 5) {
            if (logger.isLoggable(Level.FINE) && DEBUG_DAYLIGHT) {
                logger.fine("General aromatization");
            }
            int[][] SSSR2 = this.m.getSSSR();
            BitSet aromBondBitSet = null;
            aromBondBitSet = Aromata.daylightAromatizationWithBitSet(this.m, setbonds, onlyAromAtoms, ringNumberLimit, SSSR2, calcRingAtomIdxes, btab, this.originalBondType, this.replaceANYandOR_AROMATICbonds, aromType == 5, this.setQueryAromaticBonds);
            if (calcRingAtomIdxes) {
                allringSearcher = new FindAllRings(this.m);
                this.searchAromaticAliphaticRings(allringSearcher, aromBondBitSet, ringSize, ringNumberLimit, btab);
            }
        } else if (aromType == 1 || aromType == 3) {
            int size;
            int j;
            if (logger.isLoggable(Level.FINE) && DEBUG_CXN) {
                logger.fine("Chemaxon or Loose aromatization");
            }
            boolean queryMolecule = false;
            if (this.aromRing == null) {
                this.aromRing = new ArrayList();
            } else {
                this.aromRing.clear();
            }
            if (this.nonAromRing == null) {
                this.nonAromRing = new ArrayList();
            } else {
                this.nonAromRing.clear();
            }
            allringSearcher = new FindAllRings(this.m);
            allringSearcher.startRingSearch(ringSize, onlyAromAtoms, ringNumberLimit);
            int[][] ringIdxes = allringSearcher.getRings();
            if (this.replaceANYandOR_AROMATICbonds) {
                for (j = ringIdxes.length - 1; j >= 0; --j) {
                    int[] r = ringIdxes[j];
                    queryMolecule |= Aromata.replaceBonds(r, this.m, btab);
                }
            }
            for (j = ringIdxes.length - 1; j >= 0; --j) {
                if (aromType == 3 ? Aromata.isMDLAromatic(ringIdxes[j], this.m, btab) : Aromata.isCxnAromatic(ringIdxes[j], this.m, btab)) {
                    this.aromRing.add(ringIdxes[j]);
                    Aromata.setAromRing(this.m, ringIdxes[j], btab);
                    continue;
                }
                this.nonAromRing.add(ringIdxes[j]);
            }
            do {
                size = this.nonAromRing.size();
                for (int i = size - 1; i >= 0; --i) {
                    int[] ring = this.nonAromRing.get(i);
                    if (!Aromata.isAromatic(aromType, ring, this.m, btab)) continue;
                    Aromata.setAromRing(this.m, ring, btab);
                    this.aromRing.add(ring);
                    this.nonAromRing.remove(i);
                }
            } while (size > this.nonAromRing.size());
            if (!setbonds) {
                Aromata.resetToOriginal(this.originalBondType, this.m);
            } else {
                int aromS = this.aromRing.size();
                for (int i = 0; i < aromS; ++i) {
                    Aromata.setAromAtoms(this.m, this.aromRing.get(i));
                }
                if (queryMolecule) {
                    if (this.setQueryAromaticBonds) {
                        Aromata.setQueryAromaticBonds(this.m, this.aromRing, this.originalBondType);
                    }
                    int nonaromS = this.nonAromRing.size();
                    for (int i = 0; i < nonaromS; ++i) {
                        Aromata.resetChangedBonds(this.m, this.nonAromRing.get(i), this.originalBondType, btab);
                    }
                }
            }
            if (!onlyAromAtoms) {
                this.nonAromRingIdx = new int[this.nonAromRing.size()][];
                this.nonAromRing.toArray((T[])this.nonAromRingIdx);
            } else {
                this.nonAromRingIdx = new int[0][];
            }
            this.aromRingIdx = new int[this.aromRing.size()][];
            this.aromRing.toArray((T[])this.aromRingIdx);
        } else if (aromType == 4) {
            if (logger.isLoggable(Level.FINE) && DEBUG_CXN) {
                logger.fine("Substructure aromatization");
            }
            if (this.aromRing == null) {
                this.aromRing = new ArrayList();
            } else {
                this.aromRing.clear();
            }
            if (this.nonAromRing == null) {
                this.nonAromRing = new ArrayList();
            } else {
                this.nonAromRing.clear();
            }
            allringSearcher = new FindAllRings(this.m);
            allringSearcher.startRingSearch(9, true, -1);
            int[][] ringIdxes = allringSearcher.getRings();
            for (int j = ringIdxes.length - 1; j >= 0; --j) {
                if (Aromata.isSubstrAromatic(ringIdxes[j], this.m, btab)) {
                    this.aromRing.add(ringIdxes[j]);
                    Aromata.setAromRing(this.m, ringIdxes[j], btab);
                    continue;
                }
                this.nonAromRing.add(ringIdxes[j]);
            }
        } else {
            if (logger.isLoggable(Level.FINE) && DEBUG_RINGDET) {
                logger.fine("No aromatization just aromatic and aliphatic ring detection.");
            }
            if (calcRingAtomIdxes) {
                BitSet aromBondBitSet = new BitSet(bondCount);
                for (int i = 0; i < bondCount; ++i) {
                    if (this.m.getBond(i).getType() != 4) continue;
                    aromBondBitSet.set(i);
                }
                allringSearcher = new FindAllRings(this.m);
                this.searchAromaticAliphaticRings(allringSearcher, aromBondBitSet, ringSize, ringNumberLimit, btab);
            }
        }
        if (this.m != this.m_orig) {
            Aromata.transferInfo(this.m, this.m_orig);
        }
    }

    void searchAromaticAliphaticRings(FindAllRings allringSearcher, BitSet aromBondBitSet, int ringSize, int ringNumberLimit, BondTable btab) {
        allringSearcher.startRingSearch(ringSize, false, ringNumberLimit);
        int[][] allrings = allringSearcher.getRings();
        if (Aromata.isEmpty(aromBondBitSet)) {
            this.aromRingIdx = new int[0][0];
            this.nonAromRingIdx = allrings;
        } else {
            this.aromRing = new ArrayList();
            this.nonAromRing = new ArrayList();
            Aromata.separateAromNonaromRings(allrings, this.aromRing, this.nonAromRing, aromBondBitSet, btab);
            this.aromRingIdx = new int[this.aromRing.size()][];
            this.aromRing.toArray((T[])this.aromRingIdx);
            this.nonAromRingIdx = new int[this.nonAromRing.size()][];
            this.nonAromRing.toArray((T[])this.nonAromRingIdx);
        }
    }

    static final BitSet daylightAromatizationWithBitSet(MoleculeGraph m, boolean setbonds, boolean onlyAromAtoms, int ringNumberLimit, int[][] SSSR2, boolean calcRingAtomIdxes, BondTable btab, int[] originalBondType, boolean replaceANYandOR_AROMATICbonds, boolean ambig5, boolean setQueryAromaticBonds) {
        int sssrL;
        if (logger.isLoggable(Level.FINE) && DEBUG_DAYLIGHT) {
            logger.fine("General aromatization with bitset");
        }
        if ((sssrL = SSSR2.length) == 0) {
            return null;
        }
        boolean queryMolecule = false;
        int atomCount = m.getAtomCount();
        int[] aromValue = new int[sssrL];
        int[] edonation = new int[atomCount];
        int[] ringL = new int[sssrL];
        BitSet[] sssrAtomSetUA = new BitSet[sssrL];
        int[] conversion = new int[sssrL];
        int n = 0;
        boolean[] isRingAtom = new boolean[atomCount];
        Aromata.setAllRingAtomIdxes(isRingAtom, SSSR2);
        for (int i = 0; i < sssrL; ++i) {
            int dlArom;
            int rl;
            int[] r = SSSR2[i];
            ringL[i] = rl = r.length;
            BitSet s = new BitSet(atomCount);
            for (int j = 0; j < rl; ++j) {
                int idx = r[j];
                s.set(idx);
            }
            aromValue[i] = dlArom = Aromata.isDaylightAromatic(s, m, isRingAtom, edonation, null, ambig5);
            if (dlArom == -2) {
                conversion[n] = i;
                sssrAtomSetUA[n++] = s;
            } else if (dlArom == -1) {
                if (queryMolecule) {
                    Aromata.resetChangedBonds(m, r, originalBondType, btab);
                }
            } else if (dlArom == -3) {
                conversion[n] = i;
                sssrAtomSetUA[n++] = s;
            }
            if (!logger.isLoggable(Level.FINER) || !DEBUG_DAYLIGHT) continue;
            logger.finer("Ring " + Aromata.toString(r) + " " + (dlArom == -2 ? "aromatic" : (dlArom == -1 ? "aliphatic" : " other")));
        }
        Aromata.generateRingSets(m, n, sssrAtomSetUA, conversion, aromValue, isRingAtom, edonation, ringNumberLimit, ambig5);
        if (setbonds || calcRingAtomIdxes) {
            BitSet aromBondSet = new BitSet(m.getBondCount());
            Aromata.setAromRing(aromValue, m, SSSR2, btab, setbonds, calcRingAtomIdxes, aromBondSet, setQueryAromaticBonds);
            m.valenceCheck();
            return aromBondSet;
        }
        return null;
    }

    static final void generateRingSets(MoleculeGraph m, int n, BitSet[] sssrAtomSetUA, int[] conv, int[] aromVal, boolean[] isRingAtom, int[] edonation, int ringNumberLimit, boolean ambig5) {
        ArrayList ringSystem;
        int i;
        int ac = m.getAtomCount();
        int sssrSetL = n;
        boolean hasNonAromring = n > 1;
        int generatedRingN = n;
        if (ringNumberLimit >= 0 && generatedRingN >= ringNumberLimit || !hasNonAromring) {
            return;
        }
        boolean[] noNewringGenerated = new boolean[sssrSetL];
        boolean someRingGenerated = true;
        ArrayList<ArrayList> generatedRingSystems = new ArrayList<ArrayList>(sssrSetL);
        for (i = 0; i < sssrSetL; ++i) {
            ringSystem = new ArrayList();
            ringSystem.add(sssrAtomSetUA[i]);
            BitSet sssrGenerator = new BitSet(sssrSetL);
            sssrGenerator.set(i);
            ringSystem.add(sssrGenerator);
            generatedRingSystems.add(ringSystem);
        }
        block1: while (someRingGenerated) {
            for (i = 0; i < sssrSetL; ++i) {
                if (aromVal[conv[i]] == -3 && !noNewringGenerated[i]) {
                    ringSystem = (ArrayList)generatedRingSystems.get(i);
                    Aromata.generateRingsBitSets(ac, sssrSetL, sssrAtomSetUA, ringSystem);
                    for (int j = ringSystem.size() - 1; j >= 0; --j) {
                        BitSet s = (BitSet)ringSystem.get(j - 1);
                        BitSet g = (BitSet)ringSystem.get(j);
                        int dlArom = Aromata.isDaylightAromatic(s, m, isRingAtom, edonation, null, ambig5);
                        if (dlArom == -2) {
                            Aromata.setSSSRtoAromatic(g, aromVal, conv);
                        }
                        --j;
                        if (ringNumberLimit <= 0 || ++generatedRingN < ringNumberLimit) continue;
                        return;
                    }
                    noNewringGenerated[i] = ringSystem.size() == 0;
                    continue;
                }
                ((ArrayList)generatedRingSystems.get(i)).clear();
                noNewringGenerated[i] = true;
            }
            someRingGenerated = false;
            for (i = 0; i < sssrSetL; ++i) {
                boolean bl = someRingGenerated = !noNewringGenerated[i];
                if (someRingGenerated) continue block1;
            }
        }
    }

    static final void generateRingsBitSets(int ac, int sssrSetL, BitSet[] sssrA, ArrayList<BitSet> generated) {
        for (int i = generated.size() - 1; i >= 0; --i) {
            BitSet generator = generated.get(i);
            generated.remove(i);
            BitSet s = generated.get(--i);
            generated.remove(i);
            BitSet orSet = (BitSet)s.clone();
            BitSet andSet = (BitSet)s.clone();
            for (int j = 0; j < sssrSetL; ++j) {
                andSet.and(sssrA[j]);
                if (!Aromata.isEmpty(andSet) && !generator.get(j)) {
                    orSet.or(sssrA[j]);
                    BitSet g = (BitSet)generator.clone();
                    g.set(j);
                    if (Aromata.notYetGenerated(generated, g)) {
                        generated.add(orSet);
                        generated.add(g);
                    }
                    orSet = (BitSet)s.clone();
                }
                andSet.or(s);
            }
        }
    }

    static final boolean notYetGenerated(ArrayList<BitSet> generated, BitSet g) {
        for (int i = generated.size() - 1; i > 0; --i) {
            if (!g.equals(generated.get(i--))) continue;
            return false;
        }
        return true;
    }

    static final boolean isAromatic(int type, int[] r, MoleculeGraph mol, BondTable btab) {
        if (type == 3) {
            return Aromata.isMDLAromatic(r, mol, btab);
        }
        return Aromata.isCxnAromatic(r, mol, btab) || Aromata.hasOnlyAromBonds(r, mol, btab) || Aromata.isAzuleneRing(r, mol, btab);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static final boolean isCxnAromatic(int[] r, MoleculeGraph mol, BondTable btab) {
        int sum = 0;
        int pplusze = 0;
        int charge = 0;
        int queryaromAtom = 0;
        int rl = r.length;
        if (rl < 5) {
            return false;
        }
        for (int i = 0; i < rl; ++i) {
            int k;
            int[] list;
            int c;
            MolAtom atom = mol.getAtom(r[i]);
            if (!Aromata.sp2(atom)) {
                return false;
            }
            int atomnumber = atom.getAtno();
            if (!FindAllRings.aromAtom(atom)) {
                return false;
            }
            int ndbs = Aromata.doubleBondNumberInRing(i, r, mol, btab);
            if (ndbs == 1) {
                if (atomnumber == 128) {
                    c = 1;
                    list = null;
                    list = atom.getList();
                    c = list.length;
                    for (k = 0; k < c; ++k) {
                        if (!FindAllRings.aromElements(list[k])) continue;
                        ++sum;
                        break;
                    }
                } else {
                    ++sum;
                }
            } else {
                if (ndbs != 0) return false;
                if (Aromata.doubleBond(atom, mol) > 1) {
                    return false;
                }
                if (atom.getQueryAromaticity() == 1) {
                    ++queryaromAtom;
                }
                if (atomnumber == 129) {
                    return false;
                }
                c = 1;
                list = null;
                if (atomnumber == 128) {
                    list = atom.getList();
                    c = list.length;
                }
                for (k = 0; k < c; ++k) {
                    atomnumber = list != null ? list[k] : atomnumber;
                    charge = atom.getCharge();
                    int plusze = 0;
                    if (charge == 0 && atom.getValence() < 4 && atomnumber < 139) {
                        plusze = ELECTRONS[atomnumber];
                    }
                    if (k != 0 && plusze != pplusze) {
                        return false;
                    }
                    if (plusze != 0) {
                        if (k == 0) {
                            sum += plusze;
                        }
                    } else if (atomnumber == 5) {
                        if (charge != 0) {
                            return false;
                        }
                    } else if (atomnumber == 6) {
                        if (charge == -1 && k == 0) {
                            sum += 2;
                        } else if (charge != 1) {
                            return false;
                        }
                    } else {
                        if (atomnumber != 7) return false;
                        if (charge != -1 || k != 0) return false;
                        sum += 2;
                    }
                    pplusze = plusze;
                }
            }
            if (!logger.isLoggable(Level.FINEST) || !DEBUG_CXN) continue;
            Aromata.logEDonation(r[i], ndbs);
        }
        int huckelNo = sum % 4;
        if (logger.isLoggable(Level.FINE) && DEBUG_CXN) {
            logger.fine("Ossz e- " + sum + " huckelNo " + huckelNo);
        }
        if (huckelNo != 2) return huckelNo < queryaromAtom;
        return true;
    }

    static final boolean isSubstrAromatic(int[] r, MoleculeGraph mol, BondTable btab) {
        int sum = 0;
        int rl = r.length;
        if (rl < 5) {
            return false;
        }
        for (int i = 0; i < rl; ++i) {
            MolAtom atom = mol.getAtom(r[i]);
            int atno = atom.getAtno();
            if (atno == 1) {
                return false;
            }
            int ndbs = Aromata.doubleBondNumberInRing(i, r, mol, btab);
            if (ndbs == 1) {
                ++sum;
                continue;
            }
            return false;
        }
        int huckelNo = sum % 4;
        return huckelNo == 2;
    }

    static final boolean isMDLAromatic(int[] r, MoleculeGraph mol, BondTable btab) {
        int sum = 0;
        int rl = r.length;
        if (rl < 5) {
            return false;
        }
        for (int i = 0; i < rl; ++i) {
            MolAtom atom = mol.getAtom(r[i]);
            int atno = atom.getAtno();
            if (atno == 1 || Aromata.getSmallestRepeatingUnitSgroupForAtom(atom) != null) {
                return false;
            }
            int ndbs = Aromata.doubleBondNumberInRing(i, r, mol, btab);
            if (ndbs == 1) {
                ++sum;
                continue;
            }
            if (ndbs == 0) {
                if (atno != 6 || atom.getCharge() == -1) {
                    sum += 2;
                    continue;
                }
                return false;
            }
            return false;
        }
        int huckelNo = sum % 4;
        return huckelNo == 2;
    }

    public static final int isDaylightAromatic(BitSet s, MoleculeGraph mol, boolean[] isRingAtom, int[] edonation, String ms) {
        return Aromata.isDaylightAromatic(s, mol, isRingAtom, edonation, ms, false);
    }

    private static final int isDaylightAromatic(BitSet s, MoleculeGraph mol, boolean[] isRingAtom, int[] edonation, String ms, boolean ambig5) {
        if (logger.isLoggable(Level.FINER) && DEBUG_DAYLIGHT) {
            logger.finer("START new ring, size " + s.cardinality());
        }
        int sum = 0;
        int queryaromAtom = 0;
        int aromN = 0;
        int atom_SA = 0;
        boolean ambiguous_surely = false;
        boolean ambigInFiveM = false;
        boolean anybond = false;
        int atomCount = mol.getAtomCount();
        Sgroup smallestSgroup = null;
        boolean start = true;
        boolean sameSgroup = true;
        int i = s.nextSetBit(0);
        while (i < atomCount && i >= 0) {
            if (start) {
                smallestSgroup = Aromata.getSmallestRepeatingUnitSgroupForAtom(mol.getAtom(i));
                start = false;
            } else if (sameSgroup && smallestSgroup != Aromata.getSmallestRepeatingUnitSgroupForAtom(mol.getAtom(i))) {
                sameSgroup = false;
            }
            int e = edonation[i];
            if (e == 0 && (e = Aromata.calculateElectronDonation(s, mol, isRingAtom, edonation, ms, ambig5, i)) == -1) {
                return -1;
            }
            if (e == -1) {
                return -1;
            }
            if (e == -3) {
                ambiguous_surely = true;
            } else if (e == -5) {
                ++queryaromAtom;
            } else if (e == -10) {
                ++queryaromAtom;
                ++sum;
            } else if (e == -11) {
                ++sum;
                ++aromN;
            } else if (e == -6) {
                ambiguous_surely = true;
            } else if (e == -12) {
                ++sum;
            } else if (e == -13) {
                ++queryaromAtom;
                ++atom_SA;
            } else if (e == -14) {
                ++sum;
            } else if (e == -15) {
                ++queryaromAtom;
                ambiguous_surely = true;
            } else if (e == -16) {
                anybond = true;
                ++queryaromAtom;
            } else if (e != -4 && e != -9) {
                if (e == -8) {
                    sum += 2;
                } else if (e == -7) {
                    sum += 2;
                    ambigInFiveM = true;
                } else {
                    sum += e;
                }
            }
            if (!sameSgroup) {
                ambiguous_surely = true;
            }
            i = s.nextSetBit(i + 1);
        }
        if (ambiguous_surely) {
            return -4;
        }
        int huckelNo = sum % 4;
        queryaromAtom %= 4;
        int specialCaseReturn = Aromata.checkSpecialCases(s, edonation, sum, aromN, atom_SA, ambigInFiveM, anybond, atomCount, huckelNo);
        if (specialCaseReturn != 0) {
            return specialCaseReturn;
        }
        if (queryaromAtom > 0 && huckelNo + queryaromAtom >= 2) {
            return -4;
        }
        return -3;
    }

    private static int calculateElectronDonation(BitSet s, MoleculeGraph mol, boolean[] isRingAtom, int[] edonation, String ms, boolean ambig5, int i) {
        int e = -1;
        MolAtom a = mol.getAtom(i);
        int atno = a.getAtno();
        if (Aromata.isDaylightAromaticAtom(atno)) {
            edonation[i] = e = Aromata.electronsAddednew(mol, i, isRingAtom, edonation, s, ms, ambig5);
        } else if (Aromata.aromElementsMarkushExt(a)) {
            if (ms != null) {
                a.putProperty(ms, MARKER);
            }
            e = -6;
        } else {
            return -1;
        }
        return e;
    }

    private static int checkSpecialCases(BitSet s, int[] edonation, int sum, int aromN, int atom_SA, boolean ambigInFiveM, boolean anybond, int atomCount, int huckelNo) {
        if (atom_SA == 0) {
            int ringLength = s.cardinality();
            int allowed_electron_diff = (ringLength / 8 + 1) * 3;
            if (huckelNo == 2) {
                Aromata.setAromN(s, edonation, 1);
                return ambigInFiveM || anybond ? -4 : -2;
            }
            if (huckelNo + aromN == 2 && sum <= ringLength + allowed_electron_diff && sum >= ringLength - allowed_electron_diff) {
                if (aromN == 1) {
                    int i = s.nextSetBit(0);
                    while (i < atomCount && i >= 0) {
                        int e = edonation[i];
                        if (e == -11) {
                            edonation[i] = -8;
                            break;
                        }
                        i = s.nextSetBit(i + 1);
                    }
                }
                return -2;
            }
        }
        return 0;
    }

    static final void setAromN(BitSet s, int[] edonation, int type) {
        int i = s.nextSetBit(0);
        while (i < s.length() && i >= 0) {
            int e = edonation[i];
            if (e == -11) {
                edonation[i] = type;
            }
            i = s.nextSetBit(i + 1);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static final int electronsAddednew(MoleculeGraph mol, int idx, boolean[] isRingAtom, int[] edonation, BitSet s, String ms, boolean ambig5) {
        MolAtom atom = mol.getAtom(idx);
        if (atom.getBondCount() > 3) {
            return -1;
        }
        int e = 0;
        int charge = atom.getCharge();
        int atno = atom.getAtno();
        int[] idxes = new int[]{idx, -1};
        int type = Aromata.sp2new(idxes, s, mol, isRingAtom, ms);
        int ext = idxes[1];
        if (type == -12) {
            return -12;
        }
        if (type == -16) {
            return -16;
        }
        if (type == -15) {
            return -15;
        }
        if (type == -13) {
            return -13;
        }
        if (type == -14) {
            return -14;
        }
        if (type == -9) {
            return -9;
        }
        if (type == -8) {
            return -8;
        }
        if (type == -10) {
            return -10;
        }
        if (type == -11) {
            return -11;
        }
        if (type == -4) {
            return -4;
        }
        if (type == 2) {
            return 2;
        }
        if (type == -1) {
            return -1;
        }
        if (type == -6) {
            return -6;
        }
        if (type == 1) {
            if (atno == 16) {
                if (charge != 1 || atom.getValence() != 3) return -1;
                return 1;
            }
            if (atno == 7 || atno == 15) {
                if (charge == 1 && atom.getValence() <= 5 || charge == 0 && (atom.getValence() <= 3 || atom.getValence() == 5 && ext != -1 && mol.getAtom(ext).getAtno() == 8)) {
                    return 1;
                }
                if (atom.getBondCount() <= 2) return e;
                return -1;
            }
            if (atno != 128) return 1;
            int[] list = null;
            list = atom.getList();
            int l = list.length;
            for (int k = 0; k < l; ++k) {
                if (!MolAtom.isAromaticSMILESSubset(list[k])) continue;
                return 1;
            }
            return -1;
        }
        if (atom.getQueryAromaticity() == 1) {
            return -5;
        }
        if (atno == 129) {
            return -3;
        }
        int plusze = Aromata.electronsWithoutDoubleBond(atom, mol, ms, ambig5);
        if (plusze < 0) {
            return plusze;
        }
        e = plusze;
        if (e != 0) return e;
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final int sp2new(int[] idxes, BitSet s, MoleculeGraph m, boolean[] ringAtoms, String ms) {
        int charge;
        String str;
        int idx = idxes[0];
        MolAtom a = m.getAtom(idx);
        if (a.containsPropertyKey(DO_NOT_AROMATIZE)) {
            return -1;
        }
        if (Aromata.aromElementsMarkushExt(a)) {
            if (ms == null) return -1;
            a.putProperty(ms, MARKER);
            return -6;
        }
        if (a.getBondCount() > 3) {
            return -1;
        }
        if (a.isPseudo() && (str = a.getAliasstr()) != null && (str.startsWith("M") || str.startsWith("X"))) {
            return -1;
        }
        int atno = a.getAtno();
        if ((atno == 15 || atno == 7) && a.getValence() > 5) {
            return -1;
        }
        if (atno == 16 && a.twicesumbonds(true, false) > 8) {
            return -1;
        }
        int arombc = 0;
        int queryarombc = 0;
        int dbbc = 0;
        int edbbc = 0;
        int s_d_b = 0;
        int anyB = 0;
        int singleBondCount = 0;
        boolean singleOrAromBondCount = false;
        int bc = a.getBondCount();
        for (int i = bc - 1; i >= 0; --i) {
            QueryBond qb;
            String querystr;
            MolBond b = a.getBond(i);
            if (!m.contains(b)) continue;
            int t = b.getType();
            if (b instanceof QueryBond && (querystr = (qb = (QueryBond)b).getQuerystr()) != null && querystr.equals("NONAROMATIC") && Aromata.isBondInRing(a, idx, s, b, m)) {
                return -1;
            }
            if (t == 1) {
                ++singleBondCount;
                continue;
            }
            if (t == 4) {
                ++arombc;
                continue;
            }
            if (t == 2) {
                MolAtom a2;
                int i2;
                ++dbbc;
                if (ringAtoms == null || (i2 = m.indexOf(a2 = b.getOtherAtom(a))) < 0 || ringAtoms[i2]) continue;
                ++edbbc;
                idxes[1] = i2;
                continue;
            }
            if (t == 3) {
                return -1;
            }
            if (t == 0) {
                if (ms != null) {
                    a.putProperty(ms, MARKER);
                }
                ++anyB;
                continue;
            }
            if (t == 6) {
                if (ms != null) {
                    a.putProperty(ms, MARKER);
                }
                ++queryarombc;
                continue;
            }
            if (t == 7) {
                if (ms != null) {
                    a.putProperty(ms, MARKER);
                }
                ++dbbc;
                ++queryarombc;
                continue;
            }
            if (t != 5) continue;
            if (ms != null) {
                a.putProperty(ms, MARKER);
            }
            ++s_d_b;
        }
        if (a.getAtno() == 7) {
            if (arombc == 2) {
                if (anyB == 0 && s_d_b == 0) {
                    if (queryarombc == 0 && (a.getCharge() == 0 && (a.getImplicitHcount() == 1 || singleBondCount == 1) || a.getCharge() == -1)) {
                        return 2;
                    }
                    if (!singleOrAromBondCount) return 1;
                    return 2;
                }
            } else {
                if (arombc == 3) {
                    charge = a.getCharge();
                    if (charge == 0) {
                        return 2;
                    }
                    if (charge != 1) return -1;
                    return 1;
                }
                if (dbbc == 0) {
                    int rs = s.cardinality() % 2;
                    if (queryarombc > 0 && rs == 1) {
                        return 2;
                    }
                    if (arombc > 0 && bc < 3) {
                        return -11;
                    }
                    if (anyB > 0 && bc < 4) {
                        return -10;
                    }
                } else if (dbbc == 1 && queryarombc > 0) {
                    return -10;
                }
            }
        }
        if (dbbc == 1) {
            if (edbbc == 1) {
                if (a.getRadical() != 0) {
                    return -1;
                }
                charge = a.getCharge();
                if (atno == 7 || atno == 15) {
                    if (charge == 1) return 1;
                    return -1;
                }
                if (charge != 0) return -3;
                MolAtom ext = m.getAtom(idxes[1]);
                int extAtno = ext.getAtno();
                if (atno == 16) {
                    if (charge != 0 || extAtno != 8) return -1;
                    return 2;
                }
                if (atno != 6) return -1;
                if (ms != null && (Aromata.aromElementsMarkushExt(ext) || extAtno == 128)) {
                    ext.putProperty(ms, MARKER);
                    return -6;
                }
                if (extAtno != 6) return -4;
                return 1;
            }
            if (queryarombc <= 0) return 1;
            return -14;
        }
        if (dbbc == 0) {
            if (arombc > 1) {
                int plusze = Aromata.twoAromBondConnection(a, m, ringAtoms);
                if (plusze == 2) {
                    return -8;
                }
                if (plusze == -4) {
                    return -9;
                }
                if (plusze != 2) return -12;
                return -8;
            }
            if (arombc > 0) {
                return -12;
            }
            if (s_d_b > 0) {
                return -15;
            }
            if (queryarombc > 0) {
                return -13;
            }
            if (anyB <= 0) return 0;
            return -16;
        }
        if (dbbc <= true) return -3;
        if (edbbc <= 1 && dbbc - edbbc <= 1) return 1;
        return -1;
    }

    private static boolean isBondInRing(MolAtom a, int idx, BitSet s, MolBond b, MoleculeGraph m) {
        int i2 = m.indexOf(b.getOtherAtom(a));
        return s.get(idx) && s.get(i2);
    }

    static final int exocyclicDoubleBondCheck(MolAtom atom, MolAtom ext, String ms) {
        int e = 0;
        int atno = atom.getAtno();
        int charge = atom.getCharge();
        if (atom.getRadical() != 0) {
            return -1;
        }
        if (atno == 7 || atno == 15) {
            if (charge != 1) {
                return -1;
            }
            ++e;
        } else if (charge == 0) {
            int extAtno = ext.getAtno();
            if (atno == 16) {
                if (charge == 0 && ext.getAtno() == 8) {
                    return 2;
                }
                return -1;
            }
            if (ms != null && (Aromata.aromElementsMarkushExt(ext) || extAtno == 128)) {
                ext.putProperty(ms, MARKER);
                return -6;
            }
            if (ext.getAtno() == 6) {
                ++e;
            }
        }
        return e;
    }

    static final int electronsWithoutDoubleBond(MolAtom a, MoleculeGraph mol, String ms, boolean ambig5) {
        int e = 0;
        int atno = a.getAtno();
        if (ambig5 && (atno == 131 || atno == 132 || atno == 129 || Aromata.ambig5AdditionalAtom(a))) {
            return -7;
        }
        int charge = a.getCharge();
        int c = 1;
        int[] list = null;
        if (atno == 128) {
            list = a.getList();
            c = list.length;
        }
        for (int k = 0; k < c; ++k) {
            int n = atno = list != null ? list[k] : atno;
            if (!ambig5 && atno == 16 && Aromata.getRealEdgeCount(a, mol) > 2) {
                return -1;
            }
            if (charge <= 0 && Aromata.getRealValence(a, mol) < 4 && atno < 139) {
                if (k == 0) {
                    e = ELECTRONS[atno];
                    if (ambig5 && e == 2) {
                        return -7;
                    }
                } else if (ambig5) {
                    e = ELECTRONS[atno];
                    if (e == 2) {
                        return -7;
                    }
                } else if (e != ELECTRONS[atno]) {
                    if (ms == null) {
                        return -1;
                    }
                    a.putProperty(ms, MARKER);
                    return -6;
                }
            }
            if (c != 1 || atno != 6) continue;
            if (charge == -1) {
                return 2;
            }
            if (charge == 1) {
                return -4;
            }
            return -1;
        }
        return e;
    }

    static final int twoAromBondConnection(MolAtom a, MoleculeGraph mol, boolean[] isRingAtom) {
        int atno = a.getAtno();
        int charge = a.getCharge();
        int e = 1;
        if ((atno != 16 || Aromata.getRealEdgeCount(a, mol) <= 2) && charge <= 0 && Aromata.getRealValence(a, mol) < 4 && atno < 139) {
            e = ELECTRONS[atno];
        }
        int bc = a.getBondCount();
        if ((atno == 7 || atno == 15) && charge >= 0 && bc + a.getImplicitHcount() != 3) {
            e = 1;
        } else if (atno == 7 && charge == -1 && bc == 3) {
            e = 2;
        } else {
            if (atno == 6) {
                if (charge == -1) {
                    if (a.getImplicitHcount() == 1 || bc == 3) {
                        return 2;
                    }
                    return 1;
                }
                if (charge == 1) {
                    if (a.getImplicitHcount() == 1 || bc == 3) {
                        return -4;
                    }
                    return 1;
                }
            }
            if (isRingAtom != null) {
                MolAtom ext;
                int[] dbb = new int[3];
                Aromata.hasDoubleBond(dbb, a, mol, isRingAtom, null);
                int id = dbb[2];
                if (id == -17) {
                    return -17;
                }
                MolAtom molAtom = ext = id >= 0 ? mol.getAtom(id) : null;
                if (id >= 0) {
                    e = Aromata.exocyclicDoubleBondCheck(a, ext, null);
                    e = e == 0 ? -4 : e;
                }
            }
        }
        return e;
    }

    static final int doubleBondNumberInRing(int x, int[] ring, MoleculeGraph mol, BondTable btab) {
        QueryBond qb;
        String querystr;
        QueryBond qb2;
        String querystr2;
        int size = ring.length;
        int h = ring[x];
        int p = ring[(x + size - 1) % size];
        int n = ring[(x + 1) % size];
        MolBond b = mol.getBond(btab.getBondIndex(h, n));
        if (b instanceof QueryBond && (querystr2 = (qb2 = (QueryBond)b).getQuerystr()) != null && querystr2.equals("NONAROMATIC")) {
            return 10;
        }
        int typen = b.getType();
        b = mol.getBond(btab.getBondIndex(h, p));
        if (b instanceof QueryBond && (querystr = (qb = (QueryBond)b).getQuerystr()) != null && querystr.equals("NONAROMATIC")) {
            return 10;
        }
        int typep = b.getType();
        if (typep == 1 && typen == 1) {
            return 0;
        }
        if (!(typen != 2 && typen != 4 || typep != 1 && typep != 4)) {
            return 1;
        }
        if (!(typep != 2 && typep != 4 || typen != 1 && typen != 4)) {
            return 1;
        }
        return 2;
    }

    static final int hasDoubleBond(int[] ret, MolAtom a, MoleculeGraph m, boolean[] r, String ms) {
        int dbbc = 0;
        int e = 0;
        int el = -1;
        boolean arombond = false;
        int edgeCount = a.getBondCount();
        for (int i = 0; i < edgeCount; ++i) {
            MolBond b = a.getBond(i);
            if (!m.contains(b)) continue;
            int t = b.getType();
            if (t == 2) {
                int l;
                ++dbbc;
                if (r == null || (l = m.indexOf(a.getLigand(i))) < 0 || r[l]) continue;
                ++e;
                el = l;
                continue;
            }
            if (t == 4 || ms == null && t == 7) {
                arombond = true;
                continue;
            }
            if (ms == null || t != 7) continue;
            ret[0] = 1;
            ret[1] = 0;
            ret[2] = -17;
            if (ms != null) {
                a.putProperty(ms, MARKER);
                a.getLigand(i).putProperty(ms, MARKER);
            }
            return 1;
        }
        ret[0] = dbbc == 0 && arombond ? 1 : dbbc;
        ret[1] = e;
        ret[2] = el;
        return ret[0];
    }

    static final int doubleBond(MolAtom a, MoleculeGraph m) {
        int s = 0;
        int edgeCount = a.getBondCount();
        for (int i = 0; i < edgeCount; ++i) {
            int t;
            MolBond b = a.getBond(i);
            if (!m.contains(b) || (t = b.getType()) != 2 && t != 7) continue;
            ++s;
        }
        return s;
    }

    static final boolean isAzuleneRing(int[] ring, MoleculeGraph mol, BondTable btab) {
        int size = ring.length;
        if (size != 5) {
            return false;
        }
        int x = 0;
        for (int i = 0; i < size; ++i) {
            int h = ring[i];
            int n = ring[(i + 1) % size];
            MolBond b = mol.getBond(btab.getBondIndex(h, n));
            if (b.getType() == 1) {
                ++x;
                continue;
            }
            if (b.getType() == 4) continue;
            return false;
        }
        return x == 1;
    }

    static final boolean hasOnlyAromBonds(int[] ring, MoleculeGraph mol, BondTable btab) {
        int size = ring.length;
        for (int i = 0; i < size; ++i) {
            int h = ring[i];
            int n = ring[(i + 1) % size];
            MolBond b = mol.getBond(btab.getBondIndex(h, n));
            if (b.getType() == 4) continue;
            return false;
        }
        return true;
    }

    static final int getRealEdgeCount(MolAtom a, MoleculeGraph m) {
        if (m instanceof SelectionMolecule) {
            int n = 0;
            int edgeCount = a.getBondCount();
            for (int i = 0; i < edgeCount; ++i) {
                MolBond e = a.getBond(i);
                if (!m.contains(e)) continue;
                ++n;
            }
            return n;
        }
        return a.getBondCount();
    }

    static final int getRealValence(MolAtom a, MoleculeGraph m) {
        if (m instanceof SelectionMolecule) {
            int n = 0;
            int edgeCount = a.getBondCount();
            for (int i = 0; i < edgeCount; ++i) {
                MolBond b = a.getBond(i);
                if (!m.contains(b)) continue;
                int t = b.getType();
                n += t < 3 ? 2 * t : (t == 4 ? 3 : 0);
            }
            return n / 2;
        }
        return a.getValence();
    }

    static final void setAromRing(MoleculeGraph m, int[] r, BondTable btab) {
        int rl = r.length;
        for (int i = 0; i < rl; ++i) {
            int h = r[i];
            int n = i == r.length - 1 ? r[0] : r[i + 1];
            int bIdx = btab.getBondIndex(h, n);
            Aromata.setToAromatic(m.getBond(bIdx), false);
        }
    }

    private static final void setToQueryAromatic(MolBond bond) {
        int bondflag = bond.getFlags();
        int bt = bondflag & 0xF;
        if (bt == 4 || bt == 6 || bt == 7) {
            return;
        }
        bondflag &= 0xFFFFFFF0;
        switch (bt) {
            case 1: {
                bt = 6;
                break;
            }
            case 2: {
                bt = 7;
            }
        }
        bond.setFlags(bondflag | bt);
    }

    private static final void setToAromatic(MolBond bond, boolean ambig5) {
        int bondflag = bond.getFlags();
        int bt = bondflag & 0xF;
        if (!(ambig5 || bt != 4 && bt != 6 && bt != 7)) {
            return;
        }
        Aromata.setToAromatic(bond);
    }

    private static final void setToAromatic(MolBond bond) {
        int bondflag = bond.getFlags();
        bond.setFlags((bondflag &= 0xFFFFFE30) | 4);
    }

    static final void setAromRing(int[] aromVal, MoleculeGraph m, int[][] rIdxes, BondTable btab, boolean setbonds, boolean calcRingAtomIdxes, BitSet aromBondSet, boolean setQueryAromaticBonds) {
        int l = rIdxes.length;
        for (int j = 0; j < l; ++j) {
            int arom = aromVal[j];
            if (arom != -2 && arom != -4) continue;
            int[] r = rIdxes[j];
            int rl = r.length;
            if (logger.isLoggable(Level.FINER) && DEBUG_DAYLIGHT) {
                logger.finer("GENERAL aromatic " + Aromata.toString(r));
            }
            for (int i = 0; i < rl; ++i) {
                int h = r[i];
                int n = i == r.length - 1 ? r[0] : r[i + 1];
                int bIdx = btab.getBondIndex(h, n);
                if (calcRingAtomIdxes) {
                    aromBondSet.set(bIdx);
                }
                if (!setbonds) continue;
                if (arom == -4) {
                    if (setQueryAromaticBonds) {
                        Aromata.setToQueryAromatic(m.getBond(bIdx));
                    }
                } else {
                    Aromata.setToAromatic(m.getBond(bIdx));
                }
                MolAtom a = m.getAtom(h);
                a.setQueryAromaticity(0);
            }
        }
    }

    static final void setAromRing(MoleculeGraph m, int[] r, BondTable btab, boolean setbonds, boolean calcRingAtomIdxes, BitSet aromBondSet, boolean ambig5, boolean setQueryAromaticBonds) {
        int rl = r.length;
        for (int i = 0; i < rl; ++i) {
            int h = r[i];
            int n = i == r.length - 1 ? r[0] : r[i + 1];
            int bIdx = btab.getBondIndex(h, n);
            if (calcRingAtomIdxes) {
                aromBondSet.set(bIdx);
            }
            if (!setbonds) continue;
            if (ambig5 && rl == 5) {
                if (setQueryAromaticBonds) {
                    Aromata.setToQueryAromatic(m.getBond(bIdx));
                }
            } else {
                Aromata.setToAromatic(m.getBond(bIdx), ambig5);
            }
            MolAtom a = m.getAtom(h);
            a.setQueryAromaticity(0);
        }
    }

    static final void setAromAtoms(MoleculeGraph m, int[] r) {
        int rl = r.length;
        for (int i = 0; i < rl; ++i) {
            MolAtom a = m.getAtom(r[i]);
            a.setQueryAromaticity(0);
        }
    }

    static final boolean sp2(MolAtom a) {
        String str;
        if (Aromata.getSmallestRepeatingUnitSgroupForAtom(a) != null) {
            return false;
        }
        if (a.getBondCount() > 3) {
            return false;
        }
        if (a.containsPropertyKey(DO_NOT_AROMATIZE)) {
            return false;
        }
        int atno = a.getAtno();
        if (atno == 15 || atno == 7) {
            return a.getValence() < 6;
        }
        if (atno == 16) {
            return a.twicesumbonds(true, false) < 9;
        }
        if (atno == 6) {
            return a.getBondCount() + a.getImplicitHcount() < 4;
        }
        return !a.isPseudo() || (str = a.getAliasstr()) == null || !str.startsWith("M") && !str.startsWith("X");
    }

    private static Sgroup getSmallestRepeatingUnitSgroupForAtom(MolAtom a) {
        Molecule m;
        MoleculeGraph g = a.getParent();
        Sgroup sg = null;
        if (g instanceof Molecule && !((sg = (m = (Molecule)g).findSmallestSgroupContaining(a)) instanceof RepeatingUnitSgroup)) {
            sg = null;
        }
        return sg;
    }

    static final boolean isDaylightAromaticAtom(int atno) {
        return MolAtom.isAromaticSMILESSubset(atno) || atno == 128 || atno == 129 || atno == 132 || atno == 136;
    }

    static final boolean ambig5AdditionalAtom(MolAtom a) {
        String s;
        return a.isPseudo() && ((s = a.getAliasstr()).equals("AH") || s.equals("QH"));
    }

    static final MoleculeGraph removeCoordinativeBonds(MoleculeGraph m) {
        MoleculeGraph mol = (MoleculeGraph)m.clone();
        for (int i = mol.getBondCount() - 1; i >= 0; --i) {
            MolBond b = mol.getBond(i);
            if (!b.isCoordinate()) continue;
            mol.removeBond(b);
        }
        return mol;
    }

    public static final MoleculeGraph toAromatic(MoleculeGraph m) {
        Aromata ar = new Aromata(m);
        ar.aromatize();
        return m;
    }

    static final void resetToOriginal(int[] bondData, MoleculeGraph mol) {
        MolBond b = null;
        int bl = bondData.length;
        for (int i = 0; i < bl; ++i) {
            b = mol.getBond(i);
            b.setFlags(bondData[i], 15);
        }
    }

    static final int getOnes(boolean[] s, int l) {
        int n = 0;
        for (int i = 0; i < l; ++i) {
            if (!s[i]) continue;
            ++n;
        }
        return n;
    }

    static final int[] toInt(boolean[] s, int l) {
        int[] r = new int[Aromata.getOnes(s, l)];
        int n = 0;
        for (int j = 0; j < l; ++j) {
            if (!s[j]) continue;
            r[n++] = j;
        }
        return r;
    }

    static final boolean hasTwoCommonAtom(boolean[] s, int[] r) {
        int n = 0;
        int rl = r.length;
        for (int i = 0; i < rl; ++i) {
            if (!s[r[i]] || ++n != 2) continue;
            return true;
        }
        return false;
    }

    static final long set(long s, int i) {
        if (i >= 0 && i < 64) {
            s |= 1L << i;
        }
        return s;
    }

    static final boolean get(long s, int i) {
        return (s & 1L << i) != 0L;
    }

    static final boolean isEmpty(BitSet s) {
        return s == null || s.isEmpty();
    }

    static final void separateAromNonaromRings(int[][] rings, ArrayList<int[]> aromRing, ArrayList<int[]> nonAromRing, BitSet s, BondTable btab) {
        if (logger.isLoggable(Level.FINE) && DEBUG_RINGDET) {
            logger.fine("separateAromNonaromRings");
        }
        int l = rings.length;
        for (int i = 0; i < l; ++i) {
            boolean aromatic = true;
            int[] r = rings[i];
            int rl = r.length;
            for (int j = 0; j < rl; ++j) {
                int bidx = btab.getBondIndex(r[j], r[(j + 1) % rl]);
                if (s.get(bidx)) continue;
                aromatic = false;
                break;
            }
            if (logger.isLoggable(Level.FINER) && DEBUG_RINGDET) {
                logger.finer("ring " + Aromata.toString(r) + " aromatic " + aromatic);
            }
            if (aromatic) {
                aromRing.add(r);
                continue;
            }
            nonAromRing.add(r);
        }
    }

    static final void setSSSRtoAromatic(BitSet s, int[] aromVal, int[] conv) {
        int i = s.nextSetBit(0);
        while (i >= 0) {
            aromVal[conv[i]] = -2;
            i = s.nextSetBit(i + 1);
        }
    }

    static final boolean aromElementsMarkushExt(MolAtom a) {
        if (a.isLinkNode()) {
            return true;
        }
        int atno = a.getAtno();
        return atno == 134;
    }

    public static final void setAllRingAtomIdxes(boolean[] AAidxes, int[][] sssr) {
        for (int[] r : sssr) {
            for (int idx : r) {
                AAidxes[idx] = true;
            }
        }
    }

    static final void transferInfo(MoleculeGraph from, MoleculeGraph to) {
        int n = 0;
        for (int i = 0; i < to.getBondCount(); ++i) {
            MolBond b = to.getBond(i);
            if (b.isCoordinate()) continue;
            int t = from.getBond(n).getType();
            if (t == 4) {
                int flags = b.getFlags();
                flags = flags & 0xFFFFFFF0 | t & 0xF;
                b.setFlags(flags &= 0xFFFFFE3F);
            }
            ++n;
        }
    }

    static final boolean replaceBonds(int[] r, MoleculeGraph m, BondTable btab) {
        int rl = r.length;
        boolean queryMolecule = false;
        for (int i = 0; i < rl; ++i) {
            int idx = r[i];
            MolBond bond = m.getBond(btab.getBondIndex(idx, r[(i + 1) % rl]));
            int t = bond.getType();
            if (t == 0 || t == 7) {
                bond.setFlags(4, 15);
                queryMolecule = true;
                continue;
            }
            if (t != 6) continue;
            MolAtom a = m.getAtom(idx);
            int atno = a.getAtno();
            boolean addH = false;
            if ((atno == 7 || atno == 15) && a.getBondCount() == 2 && a.getImplicitHcount() == 0) {
                addH = true;
            }
            bond.setFlags(4, 15);
            if (addH) {
                a.setImplicitHcount(1);
            }
            queryMolecule = true;
        }
        return queryMolecule;
    }

    static final void setQueryAromaticBonds(MoleculeGraph m, ArrayList<int[]> rings, int[] t) {
        BondTable btab = m.getBondTable();
        int l = rings.size();
        for (int i = 0; i < l; ++i) {
            int[] r = rings.get(i);
            Aromata.setQueryAromaticBonds(m, r, t, btab);
        }
    }

    static final void setQueryAromaticBonds(MoleculeGraph m, int[] r, int[] t, BondTable btab) {
        boolean changeBonds = false;
        int rl = r.length;
        for (int j = 0; j < rl; ++j) {
            int idx_next = (j + 1) % rl;
            int bidx = btab.getBondIndex(r[j], r[idx_next]);
            int t_orig = t[bidx];
            int t_act = m.getBond(bidx).getType();
            if (t_orig != 0 && t_orig != 6 && t_orig != 7 || t_act == t_orig) continue;
            changeBonds = true;
        }
        if (changeBonds) {
            boolean[] modifiedAtoms = new boolean[m.getAtomCount()];
            block8: for (int j = 0; j < rl; ++j) {
                int idx_next = (j + 1) % rl;
                int bidx = btab.getBondIndex(r[j], r[idx_next]);
                MolBond b = m.getBond(bidx);
                switch (t[bidx]) {
                    case 1: {
                        b.setFlags(6, 15);
                        modifiedAtoms[r[j]] = true;
                        modifiedAtoms[r[idx_next]] = true;
                        continue block8;
                    }
                    case 2: {
                        b.setFlags(7, 15);
                        modifiedAtoms[r[j]] = true;
                        modifiedAtoms[r[idx_next]] = true;
                        continue block8;
                    }
                    case 0: {
                        b.setFlags(0, 15);
                        modifiedAtoms[r[j]] = true;
                        modifiedAtoms[r[idx_next]] = true;
                        continue block8;
                    }
                    case 6: {
                        b.setFlags(6, 15);
                        modifiedAtoms[r[j]] = true;
                        modifiedAtoms[r[idx_next]] = true;
                        continue block8;
                    }
                    case 7: {
                        b.setFlags(7, 15);
                        modifiedAtoms[r[j]] = true;
                        modifiedAtoms[r[idx_next]] = true;
                    }
                }
            }
            for (int i = 0; i < modifiedAtoms.length; ++i) {
                if (!modifiedAtoms[i]) continue;
                m.getAtom(i).valenceCheck();
            }
        }
    }

    static final void resetChangedBonds(MoleculeGraph m, int[] r, int[] t, BondTable btab) {
        int bidx;
        int idx_next;
        int j;
        boolean changeBonds = false;
        int rl = r.length;
        for (j = 0; j < rl; ++j) {
            idx_next = (j + 1) % rl;
            bidx = btab.getBondIndex(r[j], r[idx_next]);
            int t_orig = t[bidx];
            int t_act = m.getBond(bidx).getType();
            if (t_orig != 0 && t_orig != 6 && t_orig != 7 || t_act == t_orig) continue;
            changeBonds = true;
        }
        if (changeBonds) {
            for (j = 0; j < rl; ++j) {
                idx_next = (j + 1) % rl;
                bidx = btab.getBondIndex(r[j], r[idx_next]);
                MolBond b = m.getBond(bidx);
                int type = t[bidx];
                if (type != 0 && type != 6 && type != 7) continue;
                b.setFlags(type, 15);
            }
        }
    }

    static String toString(int[] r) {
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < r.length; ++i) {
            s.append(r[i] + " ");
        }
        return s.toString();
    }

    private static void logEDonation(int i, int e) {
        logger.finest(" atom " + i + " " + (e == -1 ? "DL_ALIPHATIC" : (e == -3 ? "DL+UNKNOWN" : (e == -5 ? "QUERYAROMATOM" : (e == -6 ? "AMBIGUOUS_ATOM" : (e == -17 ? "AMBIGUOUS_BOND" : (e == -4 ? "ATOM_ADDING_0_ELECTRONS" : (e == -9 ? "AROMATOM_ADDING_0_ELECTRONS" : (e == -8 ? "AROMATOM_ADDING_2_ELECTRONS" : "electrons " + e)))))))));
    }

    static {
        for (int i = 0; i < 139; ++i) {
            Aromata.ELECTRONS[i] = 0;
        }
        Aromata.ELECTRONS[7] = 2;
        Aromata.ELECTRONS[8] = 2;
        Aromata.ELECTRONS[15] = 2;
        Aromata.ELECTRONS[16] = 2;
        Aromata.ELECTRONS[34] = 2;
        Aromata.ELECTRONS[52] = 2;
        MARKER = new Integer(1);
    }
}

