/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.core.calculations;

import chemaxon.core.util.GeomUtil;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;

public class AtomBranchCoords {
    public static DPoint3 branch2d(MolAtom a, double blen) {
        double[] res = AtomBranchCoords.branchAngles2d(a, 1);
        double phi = res[0] + res[1];
        return new DPoint3(a.getX() + blen * Math.cos(phi), a.getY() + blen * Math.sin(phi), a.getZ());
    }

    public static DPoint3 branch3d(MolAtom a, double blen) {
        return AtomBranchCoords.branchCoords3d(a, 1, blen)[0];
    }

    public static double[] branchAngles2d(MolAtom a, int count) {
        double dphi;
        double phi0 = 0.0;
        int nb = a.getBondCount();
        if (nb == 0) {
            dphi = Math.PI * 2 / (double)count;
        } else {
            double f0 = 0.0;
            MolBond b0 = a.getBond(0);
            MolAtom a0 = b0.getOtherAtom(a);
            if (b0.getLength() >= 5.0E-5) {
                f0 = Math.atan2(a0.getY() - a.getY(), a0.getX() - a.getX());
            }
            if (nb == 1) {
                phi0 = f0;
                dphi = Math.PI * 2 / (double)(count + 1);
            } else {
                double[] largest = GeomUtil.getLargestBondAngle2D(a);
                phi0 = largest[0];
                dphi = largest[1] / (double)(count + 1);
            }
        }
        return new double[]{phi0, dphi};
    }

    public static DPoint3[] branchCoords3d(MolAtom a, int count, double blen) {
        int nb = a.getBondCount();
        DPoint3[] X = new DPoint3[count];
        for (int i = 0; i < count; ++i) {
            X[i] = a.getLocation();
        }
        if (nb == 0) {
            AtomBranchCoords.branchFromSingleAtom3d(a, X, count, blen);
        } else if (nb == 1) {
            AtomBranchCoords.branchFromOneBonded3d(a, X, count, blen);
        } else if (nb == 2 && count == 2) {
            AtomBranchCoords.doubleBranchFromTwoBonded3d(a, X, blen);
        } else if ((nb == 2 || nb == 3) && count == 1) {
            AtomBranchCoords.singleBranch3d(a, X, blen);
        }
        return X;
    }

    private static void branchFromSingleAtom3d(MolAtom a, DPoint3[] X, int count, double blen) {
        X[0].y += blen;
        if (count == 2) {
            X[1].y -= blen;
        } else if (count == 3) {
            double dx = blen * Math.sqrt(0.75);
            X[1].x -= dx;
            X[2].x += dx;
            X[1].y = X[2].y = a.getY() - blen / 2.0;
        } else if (count == 4) {
            double dx = Math.sqrt(0.6666666666666666) * blen;
            X[2].x -= dx;
            X[3].x += dx;
            X[2].y = X[3].y = a.getY() - blen / 3.0;
            X[1].y = X[3].y;
        }
    }

    private static void branchFromOneBonded3d(MolAtom a, DPoint3[] X, int count, double blen) {
        MolAtom a0 = a.getLigand(0);
        DPoint3 e1 = a.getLocation();
        e1.x -= a0.getX();
        e1.y -= a0.getY();
        e1.z -= a0.getZ();
        DPoint3 e2 = new DPoint3();
        DPoint3 e3 = new DPoint3();
        AtomBranchCoords.mkOrth(e1, e2, e3);
        if (count == 1) {
            X[0].x += e1.x * blen;
            X[0].y += e1.y * blen;
            X[0].z += e1.z * blen;
        } else if (count == 2) {
            double c1 = 0.5 * blen;
            double c2 = Math.sqrt(0.75) * blen;
            double x0 = a.getX() + e1.x * c1;
            double y0 = a.getY() + e1.y * c1;
            double z0 = a.getZ() + e1.z * c1;
            X[0].x = x0 - e2.x * c2;
            X[0].y = y0 - e2.y * c2;
            X[0].z = z0 - e2.z * c2;
            X[1].x = x0 + e2.x * c2;
            X[1].y = y0 + e2.y * c2;
            X[1].z = z0 + e2.z * c2;
        } else if (count == 3) {
            double x0 = a.getX() + e1.x * blen / 3.0;
            double y0 = a.getY() + e1.y * blen / 3.0;
            double z0 = a.getZ() + e1.z * blen / 3.0;
            double c3 = Math.sqrt(0.8888888888888888) * blen;
            X[0].x = x0 + e3.x * c3;
            X[0].y = y0 + e3.y * c3;
            X[0].z = z0 + e3.z * c3;
            double c2 = Math.sqrt(0.6666666666666666) * blen;
            X[1].x = (x0 -= e3.x * c3 / 2.0) - e2.x * c2;
            X[1].y = (y0 -= e3.y * c3 / 2.0) - e2.y * c2;
            X[1].z = (z0 -= e3.z * c3 / 2.0) - e2.z * c2;
            X[2].x = x0 + e2.x * c2;
            X[2].y = y0 + e2.y * c2;
            X[2].z = z0 + e2.z * c2;
        }
    }

    private static void doubleBranchFromTwoBonded3d(MolAtom a, DPoint3[] X, double blen) {
        DPoint3 e1 = new DPoint3();
        DPoint3 e2 = new DPoint3();
        DPoint3 e3 = new DPoint3();
        MolAtom a1 = a.getLigand(0);
        MolAtom a2 = a.getLigand(1);
        e1.x = 2.0 * a.getX() - a1.getX() - a2.getX();
        e1.y = 2.0 * a.getY() - a1.getY() - a2.getY();
        e1.z = 2.0 * a.getZ() - a1.getZ() - a2.getZ();
        double e1r = Math.sqrt(e1.x * e1.x + e1.y * e1.y + e1.z * e1.z);
        if (e1r < 5.0E-5) {
            e1.x = a.getX() - a1.getX();
            e1.y = a.getY() - a1.getY();
            e1.z = a.getZ() - a1.getZ();
            AtomBranchCoords.mkOrth(e1, e2, e3);
            X[0].x -= e2.x * blen;
            X[0].y -= e2.y * blen;
            X[0].z -= e2.z * blen;
            X[1].x += e2.x * blen;
            X[1].y += e2.y * blen;
            X[1].z += e2.z * blen;
        } else {
            DPoint3 e4 = new DPoint3();
            e1.x /= e1r;
            e1.y /= e1r;
            e1.z /= e1r;
            e2.x = (a1.getY() - a.getY()) * (a2.getZ() - a.getZ()) - (a1.getZ() - a.getZ()) * (a2.getY() - a.getY());
            e2.y = (a1.getZ() - a.getZ()) * (a2.getX() - a.getX()) - (a1.getX() - a.getX()) * (a2.getZ() - a.getZ());
            e2.z = (a1.getX() - a.getX()) * (a2.getY() - a.getY()) - (a1.getY() - a.getY()) * (a2.getX() - a.getX());
            AtomBranchCoords.mkOrth(e2, e3, e4);
            double c2 = Math.sqrt(0.75) * blen;
            double x0 = a.getX() + e1.x * blen / 2.0;
            double y0 = a.getY() + e1.y * blen / 2.0;
            double z0 = a.getZ() + e1.z * blen / 2.0;
            X[0].x = x0 - e2.x * c2;
            X[0].y = y0 - e2.y * c2;
            X[0].z = z0 - e2.z * c2;
            X[1].x = x0 + e2.x * c2;
            X[1].y = y0 + e2.y * c2;
            X[1].z = z0 + e2.z * c2;
        }
    }

    private static void singleBranch3d(MolAtom a, DPoint3[] X, double blen) {
        int nb = a.getBondCount();
        DPoint3 e1 = new DPoint3();
        DPoint3 e2 = new DPoint3();
        DPoint3 e3 = new DPoint3();
        e1.x = 0.0;
        e1.y = 0.0;
        e1.z = 0.0;
        for (int i = 0; i < nb; ++i) {
            MolAtom ai = a.getLigand(i);
            e1.x += a.getX() - ai.getX();
            e1.y += a.getY() - ai.getY();
            e1.z += a.getZ() - ai.getZ();
        }
        MolAtom a1 = a.getLigand(0);
        MolAtom a2 = a.getLigand(1);
        double e1r = Math.sqrt(e1.x * e1.x + e1.y * e1.y + e1.z * e1.z);
        if (e1r > 5.0E-5) {
            e1.x /= e1r;
            e1.y /= e1r;
            e1.z /= e1r;
        } else if (nb == 3) {
            e1.x = (a1.getY() - a.getY()) * (a2.getZ() - a.getZ()) - (a1.getZ() - a.getZ()) * (a2.getY() - a.getY());
            e1.y = (a1.getZ() - a.getZ()) * (a2.getX() - a.getX()) - (a1.getX() - a.getX()) * (a2.getZ() - a.getZ());
            e1.z = (a1.getX() - a.getX()) * (a2.getY() - a.getY()) - (a1.getY() - a.getY()) * (a2.getX() - a.getX());
            e1r = Math.sqrt(e1.x * e1.x + e1.y * e1.y + e1.z * e1.z);
            if (e1r >= 5.0E-5) {
                e1.x /= e1r;
                e1.y /= e1r;
                e1.z /= e1r;
            }
        }
        if (e1r < 5.0E-5) {
            e1.x = a.getX() - a1.getX();
            e1.y = a.getY() - a1.getY();
            e1.z = a.getZ() - a1.getZ();
            AtomBranchCoords.mkOrth(e1, e2, e3);
            e1.x = e2.x;
            e1.y = e2.y;
            e1.z = e2.z;
        }
        AtomBranchCoords.mkOrth(e1, e2, e3);
        X[0].x = a.getX() + e1.x * blen;
        X[0].y = a.getY() + e1.y * blen;
        X[0].z = a.getZ() + e1.z * blen;
    }

    private static void mkOrth(DPoint3 e1, DPoint3 e2, DPoint3 e3) {
        double e1r = Math.sqrt(e1.x * e1.x + e1.y * e1.y + e1.z * e1.z);
        if (e1r < 5.0E-5) {
            e1.x = 1.0;
            e1.y = 0.0;
            e1.z = 0.0;
        } else {
            e1.x /= e1r;
            e1.y /= e1r;
            e1.z /= e1r;
        }
        if (e1.x * e1.x + e1.y * e1.y > 0.5) {
            double r = Math.sqrt(e1.x * e1.x + e1.y * e1.y);
            e2.x = -e1.y / r;
            e2.y = e1.x / r;
            e2.z = 0.0;
        } else {
            double r = Math.sqrt(e1.x * e1.x + e1.z * e1.z);
            e2.x = -e1.z / r;
            e2.y = 0.0;
            e2.z = e1.x / r;
        }
        e3.x = e1.y * e2.z - e1.z * e2.y;
        e3.y = e1.z * e2.x - e1.x * e2.z;
        e3.z = e1.x * e2.y - e1.y * e2.x;
    }
}

