/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.core.calculations;

import chemaxon.struc.MolAtom;

final class DiGraphElement {
    static final int CHIRALITY_MASK = 24;
    static final int CHIRALITY_R = 8;
    static final int CHIRALITY_S = 16;
    private MolAtom node;
    private int idx = -1;
    private DiGraphElement[] branches;
    private int branchLength = 0;
    private DiGraphElement parent = null;
    private int weight = 0;
    static final int PHANTOM_DENOMINATOR = 100;
    private int order = 0;
    private int topology = 0;

    public DiGraphElement() {
    }

    public DiGraphElement(MolAtom a, int id) {
        this.node = a;
        this.idx = id;
        this.topology = 0;
        this.weight = DiGraphElement.calcWeight(a);
    }

    public DiGraphElement(MolAtom a, int id, int c, int ez, DiGraphElement p) {
        this.node = a;
        this.idx = id;
        c = (c & 0x18) != 0 ? c ^ 0x18 : c;
        this.topology = c + ez;
        this.weight = DiGraphElement.calcWeight(a);
        this.parent = p;
    }

    public DiGraphElement(MolAtom a, int id, int c, int ez, int w) {
        this.node = a;
        this.idx = id;
        c = (c & 0x18) != 0 ? c ^ 0x18 : c;
        this.topology = c + ez;
        this.weight = w;
    }

    public DiGraphElement(MolAtom a, int id, boolean phantom) {
        this.node = phantom ? null : a;
        this.idx = phantom ? -1 : id;
        this.topology = 0;
        this.weight = DiGraphElement.calcWeight(a);
    }

    public DiGraphElement(MolAtom a, int id, int c, int ez, boolean phantom) {
        this.node = a;
        this.idx = phantom ? -1 : id;
        c = (c & 0x18) != 0 ? c ^ 0x18 : c;
        this.topology = c + ez;
        this.weight = DiGraphElement.calcWeight(a);
    }

    public DiGraphElement(int w) {
        this.node = null;
        this.idx = -1;
        this.topology = 0;
        this.weight = w;
    }

    public int getTopology() {
        return this.topology;
    }

    public int getIdx() {
        return this.idx;
    }

    public void setIdx(int i) {
        this.idx = i;
    }

    public DiGraphElement[] getBranches() {
        return this.branches;
    }

    public DiGraphElement getBranch(int i) {
        if (i < this.branches.length) {
            return this.branches[i];
        }
        return null;
    }

    public DiGraphElement getBranch(MolAtom n) {
        for (int i = 0; i < this.branches.length; ++i) {
            if (this.branches[i].getNode() != n) continue;
            return this.branches[i];
        }
        return null;
    }

    public void setBranches(DiGraphElement[] br) {
        this.branches = br;
    }

    public void addBranch(DiGraphElement b) {
        if (this.branches == null) {
            this.branches = new DiGraphElement[4];
        } else if (this.branchLength == this.branches.length) {
            DiGraphElement[] tmp = new DiGraphElement[this.branchLength + 4];
            System.arraycopy(this.branches, 0, tmp, 0, this.branchLength);
            this.branches = tmp;
        }
        this.branches[this.branchLength++] = b;
    }

    public DiGraphElement getParent() {
        return this.parent;
    }

    public void setNode(MolAtom a, int id) {
        this.node = a;
        this.idx = id;
        this.weight = DiGraphElement.calcWeight(a);
    }

    public void setToPhantom() {
        this.idx = -1;
        this.branches = null;
        this.branchLength = 0;
        this.weight = DiGraphElement.calcWeight(this.node) / 10;
    }

    public MolAtom getNode() {
        return this.node;
    }

    public int getWeight() {
        return this.weight;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int w) {
        this.order = w;
    }

    static int calcWeight(MolAtom a) {
        int w = 0;
        int atno = a.getAtno();
        atno = atno == 130 ? 0 : atno;
        w += atno * 10000;
        return w += a.getMassno() * 100;
    }

    int getNodeCount() {
        int n = this.branches == null ? 0 : this.branches.length;
        for (int i = n - 1; i >= 0; --i) {
            if (this.branches[i] == null) continue;
            n += this.branches[i].getNodeCount();
        }
        return n;
    }
}

