/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.core.calculations;

import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.PeriodicSystem;
import chemaxon.struc.Sgroup;
import chemaxon.struc.Smolecule;
import chemaxon.struc.sgroup.MulticenterSgroup;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ElementalAnalysisCalc {
    private static final int ELEMENT_COUNT = PeriodicSystem.getElementCount();
    private static final String REGEX_FORMULA = "((((\\[[1-9][0-9]*[A-Z][a-z]\\])|(\\[[1-9][0-9]*[A-Z]\\])|([A-Z][a-z])|([A-Z]))([1-9][0-9]*)*)+)((\\.(((\\[[1-9][0-9]*[A-Z][a-z]\\])|(\\[[1-9][0-9]*[A-Z]\\])|([A-Z][a-z])|([A-Z]))([1-9][0-9]*)*)*)*)";
    private static final String REGEX_FORMULA_ELEMENT = "((\\[[1-9][0-9]*[A-Z][a-z]\\])|(\\[[1-9][0-9]*[A-Z]\\])|([A-Z][a-z])|([A-Z]))([1-9][0-9]*)*";
    private static final String REGEX_ELEMENT_SYMBOL = "([A-Z][a-z])|([A-Z])";
    private static final String REGEX_MASSNO = "((?<=\\[)[1-9][0-9]*)";
    private static final String REGEX_POSITIVE_INTEGER_AT_END = "([1-9][0-9]*)$";
    private int[] atno;
    private int[] massno;
    private int[] count;
    private int length = -1;
    private int multicenterConnectionCount = 0;
    private Smolecule mol;
    private boolean hasCarbon = false;
    private boolean sorted = false;
    private boolean initialized = false;
    private boolean[] filter;
    private String inputFormula;
    private Pattern formulaPattern = null;
    private Pattern formulaElementPattern = null;
    private Pattern elementSymbolPattern = null;
    private Pattern massNoPattern = null;
    private Pattern countPattern = null;

    private void initialize() {
        boolean filtered;
        int c = this.mol.getAtomCount();
        boolean bl = filtered = this.filter != null;
        if (this.length == -1 || this.atno.length < c + 1) {
            this.atno = new int[c + 1];
            this.massno = new int[c + 1];
            this.count = new int[c + 1];
        }
        this.length = 0;
        int implicit = 0;
        this.hasCarbon = false;
        for (int i = 0; i < c; ++i) {
            int z;
            if (filtered && !this.filter[i] || (z = this.mol.getAtomType(i)) <= 0 || z >= ELEMENT_COUNT) continue;
            int m = this.mol.getMassno(i);
            this.storeAtom(z, m, 1);
            implicit += this.mol.getImplicitHcount(i);
            if (z != 6) continue;
            this.hasCarbon = true;
        }
        if ((implicit -= this.multicenterConnectionCount) > 0) {
            this.storeAtom(1, 0, implicit);
        }
        this.sorted = false;
        this.initialized = true;
    }

    private boolean initializeFromFormula() {
        if (this.inputFormula == null) {
            return false;
        }
        this.initializeRegexPatterns();
        Matcher formulaMatcher = this.formulaPattern.matcher(this.inputFormula);
        if (!formulaMatcher.matches()) {
            return false;
        }
        Matcher formulaElementMatcher = this.formulaElementPattern.matcher(this.inputFormula);
        ArrayList<String> elementsInFormula = new ArrayList<String>();
        while (formulaElementMatcher.find()) {
            elementsInFormula.add(formulaElementMatcher.group());
        }
        this.atno = new int[elementsInFormula.size()];
        this.massno = new int[elementsInFormula.size()];
        this.count = new int[elementsInFormula.size()];
        for (int i = 0; i < elementsInFormula.size(); ++i) {
            String elementInfo = (String)elementsInFormula.get(i);
            Matcher elementSymbolMatcher = this.elementSymbolPattern.matcher(elementInfo);
            Matcher massNoMatcher = this.massNoPattern.matcher(elementInfo);
            Matcher countMatcher = this.countPattern.matcher(elementInfo);
            if (elementSymbolMatcher.find()) {
                this.atno[i] = PeriodicSystem.getAtomicNumber(elementSymbolMatcher.group());
                if (this.atno[i] == -1) {
                    this.atno = null;
                    this.massno = null;
                    this.count = null;
                    this.initialized = false;
                    return false;
                }
            }
            this.massno[i] = massNoMatcher.find() ? Integer.parseInt(massNoMatcher.group()) : 0;
            this.count[i] = countMatcher.find() ? Integer.parseInt(countMatcher.group()) : 1;
        }
        this.length = this.atno.length;
        return this.length > 0;
    }

    private void initializeRegexPatterns() {
        if (this.formulaPattern == null) {
            this.formulaPattern = Pattern.compile(REGEX_FORMULA);
            this.formulaElementPattern = Pattern.compile(REGEX_FORMULA_ELEMENT);
            this.elementSymbolPattern = Pattern.compile(REGEX_ELEMENT_SYMBOL);
            this.massNoPattern = Pattern.compile(REGEX_MASSNO);
            this.countPattern = Pattern.compile(REGEX_POSITIVE_INTEGER_AT_END);
        }
    }

    private int indexOf(int z, int m) {
        for (int i = 0; i < this.length; ++i) {
            if (this.atno[i] != z || this.massno[i] != m) continue;
            return i;
        }
        return -1;
    }

    private void storeAtom(int z, int m, int c) {
        int i = this.indexOf(z, m);
        if (i == -1) {
            i = this.length++;
            this.atno[i] = z;
            this.massno[i] = m;
            this.count[i] = 0;
        }
        int n = i;
        this.count[n] = this.count[n] + c;
    }

    private void sort() {
        if (this.length > 1) {
            this.quickSort(0, this.length - 1);
        }
        this.sorted = true;
    }

    private int compare(int i, int j) {
        if (this.atno[i] == this.atno[j]) {
            return this.massno[i] - this.massno[j];
        }
        if (this.hasCarbon) {
            if (this.atno[i] == 6) {
                return -1;
            }
            if (this.atno[j] == 6) {
                return 1;
            }
            if (this.atno[i] == 1) {
                return this.atno[j] == 6 ? 1 : -1;
            }
            if (this.atno[j] == 1) {
                return this.atno[i] == 6 ? -1 : 1;
            }
        }
        return PeriodicSystem.getSymbol(this.atno[i]).compareTo(PeriodicSystem.getSymbol(this.atno[j]));
    }

    private void swap(int i, int j) {
        int t = this.atno[i];
        this.atno[i] = this.atno[j];
        this.atno[j] = t;
        t = this.massno[i];
        this.massno[i] = this.massno[j];
        this.massno[j] = t;
        t = this.count[i];
        this.count[i] = this.count[j];
        this.count[j] = t;
    }

    private void quickSort(int min, int max) {
        if (min >= max) {
            return;
        }
        this.swap(min, (min + max) / 2);
        int last = min;
        for (int i = min + 1; i <= max; ++i) {
            if (this.compare(min, i) <= 0) continue;
            if (last + 1 == i) {
                ++last;
                continue;
            }
            this.swap(++last, i);
        }
        if (min != last) {
            this.swap(min, last);
        }
        this.quickSort(min, last - 1);
        this.quickSort(last + 1, max);
    }

    private double round(double value, int precision) {
        double p = Math.pow(10.0, precision);
        return (double)Math.round(value * p) / p;
    }

    public Smolecule getSmolecule() {
        return this.mol;
    }

    public void setMolecule(String formula) throws IllegalArgumentException {
        this.setMolecule(null, null, true);
        this.inputFormula = formula;
        this.initialized = this.initializeFromFormula();
        if (!this.initialized) {
            throw new IllegalArgumentException("Invalid formula: " + this.inputFormula);
        }
    }

    public void setMolecule(MoleculeGraph mol) {
        Molecule m;
        this.multicenterConnectionCount = 0;
        if (mol.isMolecule() && (m = (Molecule)mol).getSgroupCount() > 0) {
            this.multicenterConnectionCount = this.countMultiCenterConnections(m);
            m = m.cloneMolecule();
            m.ungroupSgroups();
            mol = m;
        }
        this.setMolecule(mol.smol(), null, false);
    }

    private int countMultiCenterConnections(Molecule m) {
        int result = 0;
        for (Sgroup sg : m.getSgroupArray()) {
            if (!(sg instanceof MulticenterSgroup)) continue;
            MulticenterSgroup mcsg = (MulticenterSgroup)sg;
            result += mcsg.getCentralAtom().getBondCount();
        }
        return result;
    }

    public void setMolecule(Smolecule mol) {
        this.setMolecule(mol, null, true);
    }

    private void setMolecule(Smolecule mol, boolean[] filter, boolean resetMulticenterCount) {
        this.mol = mol;
        this.filter = filter;
        this.initialized = false;
        this.inputFormula = null;
        if (resetMulticenterCount) {
            this.multicenterConnectionCount = 0;
        }
    }

    public int atomCount() {
        if (!this.initialized) {
            this.initialize();
        }
        int result = 0;
        for (int i = 0; i < this.length; ++i) {
            result += this.count[i];
        }
        return result;
    }

    public int atomCount(int z) {
        if (!this.initialized) {
            this.initialize();
        }
        int result = 0;
        for (int i = 0; i < this.length; ++i) {
            if (this.atno[i] != z) continue;
            result += this.count[i];
        }
        return result;
    }

    public int atomCount(int z, int m) {
        int i;
        if (!this.initialized) {
            this.initialize();
        }
        if ((i = this.indexOf(z, m)) >= 0) {
            return this.count[i];
        }
        return 0;
    }

    public double mass() {
        if (!this.initialized) {
            this.initialize();
        }
        double result = 0.0;
        for (int i = 0; i < this.length; ++i) {
            result += PeriodicSystem.getMass(this.atno[i], this.massno[i]) * (double)this.count[i];
        }
        return this.round(result, this.massPrecision());
    }

    public int massPrecision() {
        if (!this.initialized) {
            this.initialize();
        }
        int result = 0;
        if (this.length > 0) {
            result = PeriodicSystem.getMassPrecision(this.atno[0], this.massno[0]);
        }
        for (int i = 1; i < this.length; ++i) {
            if (result <= PeriodicSystem.getMassPrecision(this.atno[i], this.massno[i])) continue;
            result = PeriodicSystem.getMassPrecision(this.atno[i], this.massno[i]);
        }
        return result;
    }

    public double exactMass() {
        if (!this.initialized) {
            this.initialize();
        }
        double result = 0.0;
        for (int i = 0; i < this.length; ++i) {
            int m;
            if (this.massno[i] > 0) {
                m = this.massno[i];
            } else {
                m = PeriodicSystem.getMostFrequentNaturalIsotope(this.atno[i]);
                if (m == -1) {
                    m = 0;
                }
            }
            result += PeriodicSystem.getMass(this.atno[i], m) * (double)this.count[i];
        }
        return this.round(result, this.exactMassPrecision());
    }

    public int exactMassPrecision() {
        if (!this.initialized) {
            this.initialize();
        }
        int result = 0;
        if (this.length > 0) {
            int m = this.massno[0] == 0 ? PeriodicSystem.getMostFrequentNaturalIsotope(this.atno[0]) : this.massno[0];
            result = PeriodicSystem.getMassPrecision(this.atno[0], m);
            for (int i = 1; i < this.length; ++i) {
                m = this.massno[i] == 0 ? PeriodicSystem.getMostFrequentNaturalIsotope(this.atno[i]) : this.massno[i];
                if (result <= PeriodicSystem.getMassPrecision(this.atno[i], m)) continue;
                result = PeriodicSystem.getMassPrecision(this.atno[i], m);
            }
        }
        return result;
    }

    public String formula() {
        return this.formula(0);
    }

    public String formula(int digits) {
        if (!this.initialized) {
            this.initialize();
        }
        if (!this.sorted) {
            this.sort();
        }
        NumberFormat formatter = NumberFormat.getInstance();
        formatter.setMinimumIntegerDigits(digits);
        formatter.setGroupingUsed(false);
        StringBuffer result = new StringBuffer();
        int z = 0;
        int c = 0;
        for (int i = 0; i < this.length; ++i) {
            if (z != this.atno[i]) {
                if (digits <= 1) {
                    if (c > 1) {
                        result.append(c);
                    }
                } else if (c > 0) {
                    result.append(formatter.format(c));
                }
                c = 0;
                result.append(PeriodicSystem.getSymbol(this.atno[i]));
            }
            c += this.count[i];
            z = this.atno[i];
        }
        if (digits <= 1) {
            if (c > 1) {
                result.append(c);
            }
        } else if (c > 0) {
            result.append(formatter.format(c));
        }
        return result.toString();
    }

    public String isotopeFormula() {
        return this.isotopeFormula(true);
    }

    public String isotopeFormula(boolean symbolD) {
        if (!this.initialized) {
            this.initialize();
        }
        if (!this.sorted) {
            this.sort();
        }
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < this.length; ++i) {
            if (symbolD && this.atno[i] == 1 && this.massno[i] == 2) {
                result.append('D');
            } else if (symbolD && this.atno[i] == 1 && this.massno[i] == 3) {
                result.append('T');
            } else {
                if (this.massno[i] > 0) {
                    result.append('[');
                    result.append(this.massno[i]);
                }
                result.append(PeriodicSystem.getSymbol(this.atno[i]));
                if (this.massno[i] > 0) {
                    result.append(']');
                }
            }
            if (this.count[i] <= 1) continue;
            result.append(this.count[i]);
        }
        return result.toString();
    }

    public String dotDisconnectedFormula() {
        return this.dotFormula(false, true);
    }

    public String dotDisconnectedIsotopeFormula() {
        return this.dotFormula(true, true);
    }

    public String dotDisconnectedIsotopeFormula(boolean symbolD) {
        return this.dotFormula(true, symbolD);
    }

    private String dotFormula(boolean isotopeFormula, boolean symbolD) {
        if (this.mol == null && this.inputFormula != null) {
            return this.generateDotFormulaFromInputFormula(isotopeFormula);
        }
        int fragCount = this.mol.gearch().fragCount(2);
        if (fragCount < 2) {
            if (isotopeFormula) {
                return this.isotopeFormula(symbolD);
            }
            return this.formula();
        }
        ElementalAnalysisCalc elemanal = new ElementalAnalysisCalc();
        boolean[] filter = new boolean[this.mol.getAtomCount()];
        String[] formulas = new String[fragCount];
        int[] carbons = new int[fragCount];
        int[] atoms = new int[fragCount];
        for (int i = 0; i < fragCount; ++i) {
            int nfrags = this.mol.getAtomCount();
            for (int j = 0; j < nfrags; ++j) {
                filter[j] = this.mol.gearch().fragId(2, j) == i;
            }
            elemanal.setMolecule(this.mol, filter, true);
            formulas[i] = isotopeFormula ? elemanal.isotopeFormula(symbolD) : elemanal.formula();
            atoms[i] = elemanal.atomCount();
            carbons[i] = elemanal.atomCount(6);
        }
        int[] order = new int[fragCount];
        int i = 1;
        while (i < fragCount) {
            int pos;
            for (pos = i; pos > 0 && carbons[i] > carbons[order[pos - 1]]; --pos) {
                order[pos] = order[pos - 1];
            }
            while (pos > 0 && carbons[i] == carbons[order[pos - 1]] && atoms[i] > atoms[order[pos - 1]]) {
                order[pos] = order[pos - 1];
                --pos;
            }
            while (pos > 0 && carbons[i] == carbons[order[pos - 1]] && atoms[i] == atoms[order[pos - 1]] && formulas[i].compareTo(formulas[order[pos - 1]]) < 0) {
                order[pos] = order[pos - 1];
                --pos;
            }
            order[pos] = i++;
        }
        StringBuffer result = new StringBuffer(formulas[order[0]]);
        for (int i2 = 1; i2 < fragCount; ++i2) {
            result.append(".");
            result.append(formulas[order[i2]]);
        }
        return result.toString();
    }

    private String generateDotFormulaFromInputFormula(boolean isotopeFormula) {
        if (!this.inputFormula.contains(".")) {
            return isotopeFormula ? this.isotopeFormula() : this.formula();
        }
        String[] fragments = this.inputFormula.split("\\.");
        StringBuilder sb = new StringBuilder();
        for (String formula : fragments) {
            ElementalAnalysisCalc elemanal = new ElementalAnalysisCalc();
            elemanal.setMolecule(formula);
            sb.append(sb.length() > 0 ? "." : "");
            sb.append(isotopeFormula ? elemanal.isotopeFormula() : elemanal.formula());
        }
        return sb.toString();
    }

    public String composition(int precision) {
        double mm = this.mass();
        if (!this.sorted) {
            this.sort();
        }
        StringBuffer result = new StringBuffer();
        int z = 0;
        double m = 0.0;
        NumberFormat formatter = NumberFormat.getInstance();
        formatter.setMaximumFractionDigits(precision);
        for (int i = 0; i < this.length; ++i) {
            if (z != this.atno[i]) {
                if (m > 0.0) {
                    result.append(" (");
                    result.append(formatter.format(m / mm * 100.0));
                    result.append("%)");
                }
                m = 0.0;
                if (i > 0) {
                    result.append(", ");
                }
                result.append(PeriodicSystem.getSymbol(this.atno[i]));
            }
            m += PeriodicSystem.getMass(this.atno[i], this.massno[i]) * (double)this.count[i];
            z = this.atno[i];
        }
        if (this.length > 0) {
            result.append(" (");
            result.append(formatter.format(m / mm * 100.0));
            result.append("%)");
        }
        return result.toString();
    }

    public String isotopeComposition(int precision) {
        return this.isotopeComposition(precision, true);
    }

    public String isotopeComposition(int precision, boolean symbolD) {
        double mm = this.mass();
        if (!this.sorted) {
            this.sort();
        }
        StringBuffer result = new StringBuffer();
        NumberFormat formatter = NumberFormat.getInstance();
        formatter.setMaximumFractionDigits(precision);
        for (int i = 0; i < this.length; ++i) {
            if (i > 0) {
                result.append(", ");
            }
            if (symbolD && this.atno[i] == 1 && this.massno[i] == 2) {
                result.append('D');
            } else if (symbolD && this.atno[i] == 1 && this.massno[i] == 3) {
                result.append('T');
            } else {
                if (this.massno[i] > 0) {
                    result.append('[');
                    result.append(this.massno[i]);
                }
                result.append(PeriodicSystem.getSymbol(this.atno[i]));
                if (this.massno[i] > 0) {
                    result.append(']');
                }
            }
            result.append(" (");
            double m = PeriodicSystem.getMass(this.atno[i], this.massno[i]) * (double)this.count[i] / mm * 100.0;
            result.append(formatter.format(m));
            result.append("%)");
        }
        return result.toString();
    }
}

