/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.core.calculations;

import chemaxon.common.util.IntVector;
import chemaxon.core.util.BondTable;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.RgMolecule;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.logging.Logger;

public class FindAllRings {
    private static final Logger logger = Logger.getLogger(FindAllRings.class.getName());
    public static final int MAXRINGSIZE = 18;
    private int maxRingSize = 18;
    public static final int MAXNUMBEROFRINGS = 1000;
    private int maxNumberOfRings = 1000;
    private boolean keepLongestR = false;
    private int largestRingSize = 0;
    public static final int SUGGESTED_STEP_LIMIT = 50;
    private int maxSteps = 0;
    int counter = 0;
    public static int MEMORY_LIMIT = Integer.MAX_VALUE;
    private int maxMemory = MEMORY_LIMIT;
    private int capacity = 0;
    private int byteSizeForNodes = 0;
    private int byteSizeForEdges = 0;
    boolean ringCountLimitReached = false;
    boolean stepCountLimitReached = false;
    private MoleculeGraph m;
    private int medges;
    private int mnodes;
    private IntVector[][] pctab;
    private ArrayList<BitSet> labelEdge;
    private ArrayList<BitSet> labelNode;
    private IntVector edgeNumber;
    private int[][] tab;
    private IntVector freeEdges;
    private int[] edgeLength;
    protected ArrayList<BitSet> rings = new ArrayList();
    protected int[][] ringIdxes = null;
    private int pnodeLength;

    public FindAllRings() {
        this.freeEdges = new IntVector();
        this.maxMemory = MEMORY_LIMIT;
    }

    public FindAllRings(MoleculeGraph a) {
        this();
        this.setGraph(a);
    }

    public static void setMemoryLimit(int b) {
        MEMORY_LIMIT = b;
    }

    public void setGraph(MoleculeGraph a) {
        this.m = a instanceof RgMolecule ? a.getGraphUnion() : a;
        this.mnodes = this.m.getAtomCount();
        this.medges = this.m.getBondCount();
        this.byteSizeForNodes = (this.mnodes / 64 + 1) * 8;
        this.byteSizeForEdges = (this.medges / 64 + 1) * 8;
        this.rings.clear();
        this.freeEdges.removeAllElements();
        this.pnodeLength = 0;
        this.ringIdxes = null;
        this.keepLongestR = false;
        this.largestRingSize = 0;
    }

    public int[][] getRings() {
        return this.ringIdxes;
    }

    public int getRingsize() {
        return this.rings.size();
    }

    public void startRingSearch(int maxRingSize) {
        this.startRingSearch(maxRingSize, true, 1000);
    }

    public void startRingSearch(int maxRingSize, boolean aromatize) {
        this.startRingSearch(maxRingSize, aromatize, 1000);
    }

    public void startRingSearch(int maxRingSize, boolean aromatize, int maxNumberOfRing) {
        this.startRingSearch(maxRingSize, aromatize, maxNumberOfRing, 0, false);
    }

    public void startRingSearch(int maxRingSize, boolean aromatize, int maxNumberOfRing, int maxSteps) {
        this.startRingSearch(maxRingSize, aromatize, maxNumberOfRing, maxSteps, false);
    }

    public void startRingSearch(int maxRingSize, boolean aromatize, int maxNumberOfRing, int maxSteps, boolean keepLongestOnly) {
        this.maxRingSize = maxRingSize;
        this.maxNumberOfRings = maxNumberOfRing;
        this.maxSteps = maxSteps * 1000000;
        this.keepLongestR = keepLongestOnly;
        this.counter = 0;
        this.capacity = 0;
        this.ringCountLimitReached = false;
        this.stepCountLimitReached = false;
        this.convertGraph(aromatize);
        boolean cont = true;
        try {
            while (this.pnodeLength > 0 && cont) {
                int x = this.chooseNode();
                cont = this.removeAtom(x);
            }
        }
        catch (TimeoutException e) {
            logger.warning("Timeout reached in ringsearch.");
            this.stepCountLimitReached = true;
        }
        catch (MemoryoutException e) {
            logger.warning("Memory limit reached in ringsearch.");
            this.stepCountLimitReached = true;
        }
        this.ringIdxes = this.convertRings(this.m, this.rings);
        this.tab = null;
        this.pctab = null;
        this.labelEdge = null;
        this.labelNode = null;
        this.edgeLength = null;
    }

    public boolean ringCountLimitReached() {
        return this.ringCountLimitReached;
    }

    public boolean stepCountLimitReached() {
        return this.stepCountLimitReached;
    }

    public boolean timeoutReached() {
        return this.ringCountLimitReached || this.stepCountLimitReached;
    }

    private void convertGraph(boolean aromatize) {
        int i;
        this.rings.clear();
        this.freeEdges.removeAllElements();
        this.pctab = new IntVector[this.mnodes][];
        this.tab = new int[this.mnodes][];
        this.edgeLength = new int[this.mnodes];
        for (i = 0; i < this.mnodes; ++i) {
            MolAtom atom = this.m.getAtom(i);
            if (!aromatize || FindAllRings.aromAtom(atom)) {
                int count = atom.getBondCount() + 1;
                this.pctab[i] = new IntVector[count];
                this.tab[i] = new int[count];
                for (int j = 0; j < count; ++j) {
                    this.tab[i][j] = -1;
                }
                ++this.pnodeLength;
                continue;
            }
            this.edgeLength[i] = -1;
        }
        this.labelEdge = new ArrayList();
        for (i = 0; i < this.medges; ++i) {
            this.labelEdge.add(null);
        }
        this.labelNode = new ArrayList();
        for (i = 0; i < this.medges; ++i) {
            this.labelNode.add(null);
        }
        this.edgeNumber = new IntVector(this.medges);
        for (i = 0; i < this.medges; ++i) {
            this.edgeNumber.add(1);
        }
        for (int i2 = 0; i2 < this.medges; ++i2) {
            int endp2;
            MolBond actedge = this.m.getBond(i2);
            int endp1 = this.m.indexOf(actedge.getAtom1());
            if (endp1 == (endp2 = this.m.indexOf(actedge.getAtom2())) || this.pctab[endp1] == null || this.pctab[endp2] == null) continue;
            this.createEdge(endp1, endp2, i2);
        }
    }

    private void createEdge(int endp1, int endp2, int edgeIdx) {
        this.createEdge1(endp1, endp2, edgeIdx);
        this.createEdge1(endp2, endp1, edgeIdx);
    }

    private void createEdge1(int endp1, int endp2, int edgeIdx) {
        int index = this.getTabIndex(endp1, endp2, true);
        IntVector edgeidxes = this.pctab[endp1][index];
        if (edgeidxes == null) {
            this.pctab[endp1][index] = edgeidxes = new IntVector();
        }
        edgeidxes.addElement(edgeIdx);
        int n = endp1;
        this.edgeLength[n] = this.edgeLength[n] + 1;
    }

    private int chooseNode() {
        int minVal = Integer.MAX_VALUE;
        int minIdx = -1;
        for (int i = 0; i < this.pctab.length; ++i) {
            int el = this.edgeLength[i];
            if (el < 0 || el >= minVal) continue;
            minVal = el;
            minIdx = i;
        }
        return minIdx;
    }

    private boolean removeAtom(int idx) throws TimeoutException, MemoryoutException {
        IntVector[] etab = this.pctab[idx];
        for (int i = 0; i < etab.length; ++i) {
            IntVector edgeidxes1 = etab[i];
            int e1OtherIdx = this.tab[idx][i];
            if (edgeidxes1 == null) continue;
            if (e1OtherIdx != idx) {
                for (int j = i; j < etab.length; ++j) {
                    IntVector edgeidxes2 = etab[j];
                    int e2OtherIdx = this.tab[idx][j];
                    if (edgeidxes2 == null || e2OtherIdx == idx) continue;
                    this.mergeEdges(edgeidxes1, edgeidxes2, idx, e1OtherIdx, e2OtherIdx);
                }
                int index = this.getTabIndex(e1OtherIdx, idx);
                int n = e1OtherIdx;
                this.edgeLength[n] = this.edgeLength[n] - this.pctab[e1OtherIdx][index].size();
                this.pctab[e1OtherIdx][index] = null;
                this.tab[e1OtherIdx][index] = -1;
                continue;
            }
            int size = edgeidxes1.size();
            for (int j = 0; j < size; ++j) {
                if (this.maxNumberOfRings > 0 && this.rings.size() >= this.maxNumberOfRings) {
                    this.ringCountLimitReached = true;
                    return false;
                }
                BitSet r = this.labelEdge.get(edgeidxes1.elementAt(j));
                if (this.keepLongestR) {
                    int rs = r.cardinality();
                    if (rs == this.largestRingSize) {
                        this.rings.add(r);
                        continue;
                    }
                    if (rs <= this.largestRingSize) continue;
                    this.largestRingSize = rs;
                    this.rings.clear();
                    this.rings.add(r);
                    continue;
                }
                this.rings.add(r);
            }
        }
        this.freeNode(idx);
        return true;
    }

    private void freeNode(int idx) {
        IntVector[] etab = this.pctab[idx];
        for (int i = 0; i < etab.length; ++i) {
            if (etab[i] == null) continue;
            for (int j = etab[i].size() - 1; j >= 0; --j) {
                int edge = etab[i].elementAt(j);
                this.setFreeEdge(edge);
            }
            etab[i] = null;
        }
        this.pctab[idx] = null;
        this.tab[idx] = null;
        this.edgeLength[idx] = -1;
        --this.pnodeLength;
    }

    private void setFreeEdge(int edge) {
        this.labelEdge.set(edge, null);
        this.edgeNumber.set(edge, 1);
        this.labelNode.set(edge, null);
        this.freeEdges.addElement(edge);
    }

    private int getFreeEdge() {
        int edge = -1;
        int top = this.freeEdges.size() - 1;
        this.capacity = top * (this.byteSizeForEdges + this.byteSizeForNodes);
        if (top >= 0) {
            edge = this.freeEdges.elementAt(top);
            this.freeEdges.removeElementAt(top);
            this.labelEdge.set(edge, this.newEdgeLabel());
            this.edgeNumber.set(edge, 0);
            this.labelNode.set(edge, this.newNodeLabel());
        } else {
            edge = this.labelEdge.size();
            this.labelEdge.add(this.newEdgeLabel());
            this.edgeNumber.add(edge, 0);
            this.labelNode.add(this.newNodeLabel());
        }
        return edge;
    }

    private BitSet newEdgeLabel() {
        return new BitSet(this.medges);
    }

    private BitSet newNodeLabel() {
        return new BitSet(this.mnodes);
    }

    private boolean checkEdges(int e1, int e2, int idx, int e1OtherIdx, int e2OtherIdx) throws TimeoutException, MemoryoutException {
        BitSet labelN2;
        if (this.maxSteps > 0 && this.counter++ > this.maxSteps) {
            throw new TimeoutException();
        }
        if (this.capacity > this.maxMemory) {
            throw new MemoryoutException();
        }
        int size1 = this.getEdgeNumber(e1);
        int size2 = this.getEdgeNumber(e2);
        if (this.maxRingSize > 0 && size1 + size2 > this.maxRingSize) {
            return false;
        }
        BitSet labelN1 = this.labelNode.get(e1);
        if (!this.disjointLabels(labelN1, labelN2 = this.labelNode.get(e2))) {
            return false;
        }
        return this.checkEdgeCompatibility(labelN1, labelN2, idx, e1OtherIdx, e2OtherIdx);
    }

    private int getEdgeNumber(int e1) {
        BitSet labelE1 = this.labelEdge.get(e1);
        if (labelE1 == null) {
            return 1;
        }
        int res = this.edgeNumber.get(e1);
        return res;
    }

    protected boolean checkEdgeCompatibility(BitSet labelN1, BitSet labelN2, int idx, int e1OtherIdx, int e2OtherIdx) {
        return true;
    }

    private void mergeEdges(IntVector edgeIdxes1, IntVector edgeIdxes2, int idx, int e1OtherIdx, int e2OtherIdx) throws TimeoutException, MemoryoutException {
        int size1 = edgeIdxes1.size();
        int size2 = edgeIdxes2.size();
        for (int i = 0; i < size1; ++i) {
            int k;
            int edge1 = edgeIdxes1.elementAt(i);
            for (int j = k = edgeIdxes1 == edgeIdxes2 ? i + 1 : 0; j < size2; ++j) {
                int edge2 = edgeIdxes2.elementAt(j);
                if (!this.checkEdges(edge1, edge2, idx, e1OtherIdx, e2OtherIdx)) continue;
                this.mergeEdges(edge1, edge2, idx, e1OtherIdx, e2OtherIdx);
            }
        }
    }

    private void mergeEdges(int e1, int e2, int idx, int e1OtherIdx, int e2OtherIdx) {
        int bindex;
        BitSet labelE1 = this.labelEdge.get(e1);
        BitSet labelE2 = this.labelEdge.get(e2);
        BitSet labelN1 = this.labelNode.get(e1);
        BitSet labelN2 = this.labelNode.get(e2);
        int newedge = this.getFreeEdge();
        BitSet resultE = this.labelEdge.get(newedge);
        BitSet resultN = this.labelNode.get(newedge);
        FindAllRings.mergeLabels(resultE, labelE1, labelE2);
        this.edgeNumber.set(newedge, this.edgeNumber.get(e1) + this.edgeNumber.get(e2));
        FindAllRings.mergeLabels(resultN, labelN1, labelN2);
        if (labelE1 == null) {
            bindex = this.m.indexOf(this.m.getAtom(idx).getBondTo(this.m.getAtom(e1OtherIdx)));
            resultE.set(bindex);
        }
        if (labelE2 == null) {
            bindex = this.m.indexOf(this.m.getAtom(idx).getBondTo(this.m.getAtom(e2OtherIdx)));
            resultE.set(bindex);
        }
        resultN.set(idx);
        this.addEdge(e1OtherIdx, e2OtherIdx, newedge);
        if (e1OtherIdx != e2OtherIdx) {
            this.addEdge(e2OtherIdx, e1OtherIdx, newedge);
        }
    }

    private void addEdge(int node1, int node2, int edge) {
        int index = this.getTabIndex(node1, node2, true);
        IntVector edges = this.pctab[node1][index];
        if (edges == null) {
            this.pctab[node1][index] = edges = new IntVector();
        }
        edges.addElement(edge);
        int n = node1;
        this.edgeLength[n] = this.edgeLength[n] + 1;
    }

    private int getTabIndex(int endp1, int endp2) {
        return this.getTabIndex(endp1, endp2, false);
    }

    private int getTabIndex(int endp1, int endp2, boolean extend) {
        int f = -1;
        int[] t = this.tab[endp1];
        for (int i = 0; i < t.length; ++i) {
            if (t[i] == endp2) {
                return i;
            }
            if (f != -1 || t[i] != -1) continue;
            f = i;
        }
        if (!extend) {
            return -1;
        }
        if (f != -1) {
            t[f] = endp2;
            return f;
        }
        int len = t.length;
        int newlen = len * 2;
        int[] tmp = new int[newlen];
        System.arraycopy(t, 0, tmp, 0, len);
        this.tab[endp1] = tmp;
        IntVector[] ptmp = new IntVector[newlen];
        System.arraycopy(this.pctab[endp1], 0, ptmp, 0, len);
        this.pctab[endp1] = ptmp;
        this.tab[endp1][len] = endp2;
        for (int i = len + 1; i < newlen; ++i) {
            this.tab[endp1][i] = -1;
        }
        return len;
    }

    private boolean disjointLabels(BitSet labelN1, BitSet labelN2) {
        if (labelN1 == null || labelN2 == null) {
            return true;
        }
        return !labelN1.intersects(labelN2);
    }

    private static void mergeLabels(BitSet result, BitSet label1, BitSet label2) {
        if (label1 != null) {
            result.or(label1);
        }
        if (label2 != null) {
            result.or(label2);
        }
    }

    public static boolean aromAtom(MolAtom a) {
        if (a.hasValenceError()) {
            return false;
        }
        int atno = a.getAtno();
        if (a.containsPropertyKey("DO_NOT_AROMATIZE")) {
            return false;
        }
        int qarom = a.getQueryAromaticity();
        if (qarom == 2) {
            return false;
        }
        if (atno == 128 || atno == 129) {
            return true;
        }
        if (atno == 6) {
            if (a.getCharge() == 0) {
                int doubleb = 0;
                for (int j = 0; j < a.getBondCount(); ++j) {
                    MolBond b = a.getBond(j);
                    int type = b.getType();
                    if (type == 2 || type == 7) {
                        ++doubleb;
                    }
                    if (type != 4) continue;
                    return true;
                }
                return doubleb == 1;
            }
            return true;
        }
        if (FindAllRings.aromElements(atno)) {
            return a.getBondCount() < 5;
        }
        return false;
    }

    public static boolean aromElements(int atno) {
        return atno > 4 && atno < 9 || atno > 13 && atno < 17 || atno == 33 || atno == 34 || atno == 52 || atno == 128 || atno == 129 || atno == 131 || atno == 132 || atno == 136;
    }

    private int[][] convertRings(MoleculeGraph m, ArrayList<BitSet> rings) {
        int[][] ctab = m.getCtab();
        BondTable btab = m.getBondTable();
        int[][] ringIdxes = new int[rings.size()][];
        int edgeCount = m.getBondCount();
        int[] tmp = new int[edgeCount];
        for (int i = 0; i < ringIdxes.length; ++i) {
            BitSet ebits = rings.get(i);
            int s = ebits.nextSetBit(0);
            int size = ebits.cardinality();
            int nr = 0;
            MolAtom atom1 = m.getBond(s).getAtom1();
            int idx1 = m.indexOf(atom1);
            boolean lostConn = false;
            do {
                boolean found = false;
                int idx2 = -1;
                int[] an = ctab[idx1];
                for (int j = an.length - 1; j >= 0 && !found; --j) {
                    idx2 = an[j];
                    int b = btab.getBondIndex(idx1, idx2);
                    if (ebits.get(b)) {
                        tmp[nr++] = idx2;
                        ebits.clear(b);
                        found = true;
                    }
                    lostConn = !found && j == 0;
                }
                idx1 = idx2;
            } while (nr < size && !lostConn);
            int[] tmp2 = new int[nr];
            System.arraycopy(tmp, 0, tmp2, 0, tmp2.length);
            ringIdxes[i] = tmp2;
        }
        return ringIdxes;
    }

    public int[][][] getAromaticAndAliphaticRings() {
        ArrayList<int[]> arom = new ArrayList<int[]>(this.ringIdxes.length);
        ArrayList<int[]> aliph = new ArrayList<int[]>(this.ringIdxes.length);
        for (int i = 0; i < this.ringIdxes.length; ++i) {
            if (this.isAromatic(this.ringIdxes[i])) {
                arom.add(this.ringIdxes[i]);
                continue;
            }
            aliph.add(this.ringIdxes[i]);
        }
        int[][] aromRingIdxes = new int[arom.size()][];
        arom.toArray((T[])aromRingIdxes);
        int[][] nonAromRingIdxes = new int[aliph.size()][];
        aliph.toArray((T[])nonAromRingIdxes);
        int[][][] result = new int[][][]{aromRingIdxes, nonAromRingIdxes};
        return result;
    }

    protected boolean isAromatic(int[] idxes) {
        MoleculeGraph mol = this.getGraph();
        for (int i = 0; i < idxes.length; ++i) {
            int j = (i + 1) % idxes.length;
            MolBond bond = mol.getAtom(idxes[i]).getBondTo(mol.getAtom(idxes[j]));
            if (bond.getType() == 4) continue;
            return false;
        }
        return true;
    }

    protected MoleculeGraph getGraph() {
        return this.m;
    }

    private class MemoryoutException
    extends Exception {
        private MemoryoutException() {
        }
    }

    private class TimeoutException
    extends Exception {
        private TimeoutException() {
        }
    }
}

