/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.core.calculations;

import chemaxon.common.util.ArrayTools;
import chemaxon.core.util.BondTable;
import chemaxon.struc.Gearch;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.SelectionMolecule;
import chemaxon.struc.StereoConstants;
import java.util.Arrays;

public final class GraphInvariants
implements StereoConstants {
    private static final int[] MIN_MASSNO = new int[110];
    private static long[] primeNumbers0 = new long[]{2L};
    public static final int MASK_UNIQUE_SMILES = 1;
    public static final int MASK_IGNORE_EXPLICIT_H = 2;
    public static final int MASK_INCLUDE_ATOM_MAPS = 4;
    private int modeFlag = 0;
    private int[] stereo = null;
    static final int NO_STEREO = 0;
    static final int STEREO_PAR = 11;
    private static final int STEREO_DBS = 12;
    static final int POSSIBLE_STEREO_PAR = 1;
    private static final int POSSIBLE_STEREO_DBS = 2;
    private int[] calculatedChirality = null;

    private void init() {
        this.modeFlag &= 0xFFFFFFFD;
        this.modeFlag &= 0xFFFFFFFB;
        this.calculatedChirality = null;
    }

    public int calculate(MoleculeGraph mol, int[] ranks) {
        this.init();
        long[] flags = this.makeInitial(mol);
        return GraphInvariants.makeRanks(mol.getCtab(), flags, ranks, this.isNoHydro());
    }

    public int calculate(MoleculeGraph mol, int[] ranks, String s) {
        this.init();
        return this.makeStereoRanks(ranks, mol);
    }

    public int calculate(MoleculeGraph mol, int[] ranks, int options) {
        this.init();
        if ((options & 1) != 0) {
            this.modeFlag |= 2;
        }
        if ((options & 2) != 0) {
            return this.makeStereoRanks(ranks, mol);
        }
        if ((options & 4) != 0) {
            this.modeFlag |= 1;
        }
        if ((options & 0x20) != 0) {
            this.modeFlag |= 4;
        }
        long[] flags = this.makeInitial(mol, this.isUniqueNeeded(), this.isNoHydro());
        return GraphInvariants.makeRanks(mol.getCtab(), flags, ranks, this.isNoHydro());
    }

    public int calculate(MoleculeGraph mol, int[] ranks, boolean b) {
        this.init();
        this.modeFlag = b ? (this.modeFlag |= 1) : (this.modeFlag &= 0xFFFFFFFE);
        long[] flags = this.makeInitial(mol, this.isUniqueNeeded(), this.isNoHydro());
        return GraphInvariants.makeRanks(mol.getCtab(), flags, ranks, this.isNoHydro());
    }

    private Integer makeStereoRanks(int[] ranks, MoleculeGraph mol) {
        long[] flags = this.makeInitial(mol);
        GraphInvariants.correctGrinvCalc(flags, mol, this.isNoHydro());
        int old_n = 0;
        int new_n = GraphInvariants.makeRanks(mol.getCtab(), flags, ranks, this.isNoHydro());
        if (this.stereo == null) {
            int an = mol.getAtomCount();
            this.stereo = this.findStereoAtoms(an, mol, ranks);
        }
        while (old_n != new_n && GraphInvariants.consideringStereoMakesSense(mol, ranks, this.stereo)) {
            GraphInvariants.updateStereoWithNewGrinv(mol, ranks, this.stereo);
            for (int i = 0; i < mol.getAtomCount(); ++i) {
                if (ranks[i] == -1) continue;
                flags[i] = 100 * ranks[i] + this.stereoAdjustment(mol, i, ranks);
            }
            old_n = new_n;
            new_n = GraphInvariants.makeRanks(mol.getCtab(), flags, ranks, this.isNoHydro());
        }
        this.stereo = null;
        return new Integer(new_n);
    }

    static void updateStereoWithNewGrinv(MoleculeGraph mol, int[] ranks, int[] stereo) {
        for (int i = 0; i < stereo.length; ++i) {
            if (stereo[i] == 2) {
                if (!GraphInvariants.hasDiffGrinvNeighbors(mol, i, ranks)) continue;
                stereo[i] = 12;
                continue;
            }
            if (stereo[i] != 1 || !GraphInvariants.hasDiffGrinvNeighbors(mol, i, ranks)) continue;
            stereo[i] = 11;
        }
    }

    private int stereoAdjustment(MoleculeGraph mol, int i, int[] ranks) {
        if (this.stereo[i] < 10) {
            return 0;
        }
        if (this.stereo[i] == 11) {
            int chirality;
            if (this.calculatedChirality == null) {
                this.calculatedChirality = new int[mol.getAtomCount()];
            }
            if ((chirality = GraphInvariants.getChirality(mol, i, ranks, this.calculatedChirality)) == 16) {
                return 1;
            }
            if (chirality == 8) {
                return 2;
            }
        } else if (this.stereo[i] == 12) {
            int[] neighbs = mol.getCtab()[i];
            for (int j = 0; j < neighbs.length; ++j) {
                int neighb = neighbs[j];
                int bondIdx = mol.getBondTable().getBondIndex(i, neighb);
                MolBond bond = mol.getBond(bondIdx);
                if (bond.getType() != 2) continue;
                if (mol.isRingBond(bondIdx)) {
                    this.stereo[i] = 0;
                    return 0;
                }
                int st2 = GraphInvariants.calcGrinvBasedEZ(mol, bond, i, neighb, ranks);
                if (st2 == 64) {
                    return 3;
                }
                if (st2 != 128) continue;
                return 4;
            }
        }
        return 0;
    }

    private static int getChirality(MoleculeGraph mol, int idx, int[] ranks, int[] cc) {
        int[][] atomInRings;
        if (cc[idx] != 0) {
            return cc[idx];
        }
        MolAtom a = mol.getAtom(idx);
        if (a.getAtno() == 7 && (atomInRings = mol.getSSSRIdxesForAtoms())[idx].length < 3) {
            return 0;
        }
        int[][] ctab = mol.getCtab();
        int[] an = ctab[idx];
        int anl = an.length;
        int chirality = mol.getLocalParity(idx);
        if (anl > 2 && chirality != 0 && chirality != 3) {
            int[] g = new int[4];
            int i = 0;
            for (i = 0; i < an.length && i < 4; ++i) {
                int ligIdx = an[i];
                MolAtom lig = mol.getAtom(ligIdx);
                int mass = lig.getMassno();
                g[i] = lig.getAtno() == 1 && (mass == 0 || mass == 1) ? -1 : ranks[ligIdx];
            }
            while (i < 4) {
                g[i] = -1;
                ++i;
            }
            int s1 = MolAtom.paritySign(an[0], an[1], an[2], anl > 3 ? an[3] : -1);
            int s2 = MolAtom.paritySign(g[0], g[1], g[2], g[3]);
            int n = chirality = chirality == 1 ? 8 : 16;
            if (s1 == 0 || s2 == 0) {
                chirality = 0;
            } else if (s1 != s2) {
                chirality ^= 0x18;
            }
        }
        if (chirality != 3) {
            cc[idx] = chirality;
        }
        return chirality;
    }

    static int calcGrinvBasedEZ(MoleculeGraph m, MolBond b, int idx1, int idx2, int[] ranks) {
        if (!m.canBeCT(idx1, idx2, false)) {
            return 0;
        }
        int[][] ctab = m.getCtab();
        int[] an = ctab[idx1];
        int l = an.length;
        int maxId = -1;
        int maxVal = -10;
        for (int i = 0; i < l; ++i) {
            int lig = an[i];
            int g = ranks[lig];
            if (lig == idx2) continue;
            if (g > maxVal) {
                maxId = lig;
                maxVal = g;
                continue;
            }
            if (g != maxVal) continue;
        }
        int lig0 = maxId;
        an = ctab[idx2];
        l = an.length;
        maxId = -1;
        maxVal = -10;
        for (int i = 0; i < l; ++i) {
            int lig = an[i];
            int g = ranks[lig];
            if (lig == idx1) continue;
            if (g > maxVal) {
                maxId = lig;
                maxVal = g;
                continue;
            }
            if (g != maxVal) continue;
        }
        int lig3 = maxId;
        int dim = m.getDim();
        int stereo = 0;
        MolAtom a1 = m.getAtom(lig0);
        MolAtom a4 = m.getAtom(lig3);
        if (dim < 2) {
            stereo = b.getFlags() & 0x1C0;
            stereo = b.transformCT(a1, a4, stereo);
        } else {
            stereo = b.calcStereo2(a1, a4);
        }
        return stereo;
    }

    static boolean consideringStereoMakesSense(MoleculeGraph mol, int[] ranks, int[] stereo) {
        int an = mol.getAtomCount();
        block0: for (int i = 0; i < an; ++i) {
            if (stereo[i] <= 0) continue;
            for (int j = i + 1; j < an; ++j) {
                if (stereo[j] <= 0 || ranks[i] != ranks[j]) continue;
                if (stereo[i] % 10 == 2 && GraphInvariants.isRingDoubleAtom(mol, i)) {
                    stereo[i] = 0;
                    continue block0;
                }
                if (stereo[j] % 10 == 2 && GraphInvariants.isRingDoubleAtom(mol, j)) {
                    stereo[j] = 0;
                    continue;
                }
                return true;
            }
        }
        return false;
    }

    private static boolean isRingDoubleAtom(MoleculeGraph mol, int j) {
        BondTable btab = mol.getBondTable();
        int[] neighb = mol.getCtab()[j];
        for (int i = 0; i < neighb.length; ++i) {
            int bondIdx = btab.getBondIndex(neighb[i], j);
            MolBond bond = mol.getBond(bondIdx);
            if (bond.getType() != 2) continue;
            return mol.isRingBond(bondIdx);
        }
        return false;
    }

    private int[] findStereoAtoms(int an, MoleculeGraph mol, int[] ranks) {
        int[] parity = new int[an];
        for (int i = 0; i < an; ++i) {
            int p;
            if (ranks[i] == -1 || (p = mol.getLocalParity(i)) != 2 && p != 1) continue;
            parity[i] = GraphInvariants.hasDiffGrinvNeighbors(mol, i, ranks) ? 11 : 1;
        }
        int bondCount = mol.getBondCount();
        for (int i = 0; i < bondCount; ++i) {
            int stereo2;
            MolBond bond = mol.getBond(i);
            if (bond.getType() != 2 || (stereo2 = bond.calcStereo2()) == 192 || stereo2 == 0 || (stereo2 = mol.getStereo2(bond, bond.getCTAtom1(), bond.getCTAtom4())) != 128 && stereo2 != 64) continue;
            if (GraphInvariants.hasDiffGrinvNeighbors(mol, mol.indexOf(bond.getAtom1()), ranks) && GraphInvariants.hasDiffGrinvNeighbors(mol, mol.indexOf(bond.getAtom2()), ranks)) {
                parity[mol.indexOf((MolAtom)bond.getAtom1())] = 12;
                parity[mol.indexOf((MolAtom)bond.getAtom2())] = 12;
                continue;
            }
            parity[mol.indexOf((MolAtom)bond.getAtom1())] = 2;
            parity[mol.indexOf((MolAtom)bond.getAtom2())] = 2;
        }
        return parity;
    }

    static boolean hasDiffGrinvNeighbors(MoleculeGraph mol, int i, int[] ranks) {
        int[] neighbors = mol.getCtab()[i];
        for (int j = 0; j < neighbors.length; ++j) {
            int n1 = neighbors[j];
            for (int k = j + 1; k < neighbors.length; ++k) {
                int n2 = neighbors[k];
                if (ranks[n1] != ranks[n2]) continue;
                return false;
            }
        }
        return true;
    }

    public long[] makeInitial(MoleculeGraph mol, boolean uniqueFlag, boolean noHydro) {
        this.modeFlag = uniqueFlag ? (this.modeFlag |= 1) : (this.modeFlag &= 0xFFFFFFFE);
        this.modeFlag = noHydro ? (this.modeFlag |= 2) : (this.modeFlag &= 0xFFFFFFFD);
        return this.makeInitial(mol);
    }

    public long[] makeInitial(MoleculeGraph mol, boolean isNoHydro) {
        return this.makeInitial(mol, false, isNoHydro);
    }

    public long[] makeInitial(MoleculeGraph mol) {
        mol = mol.getGraphUnion();
        long[] flags = GraphInvariants.getInitialInvariants(mol, this.isNoHydro(), this.isMappingConsidered());
        if (this.isUniqueNeeded() && mol.getGrinvCC() != 0L && !(mol instanceof SelectionMolecule)) {
            GraphInvariants.correctGrinvCalc(flags, mol, this.isNoHydro());
            mol.adjustMultiChiralFlag();
            if (mol.isMultiChiral()) {
                flags = this.addChiralityToGraphInvariants(flags, mol);
            }
        }
        return flags;
    }

    public long[] recalcCanInv(MoleculeGraph mol) {
        int grinvOptions = (mol = mol.getGraphUnion()).getGrinvOptions();
        if ((grinvOptions & 1) != 0) {
            this.modeFlag |= 2;
        }
        if ((grinvOptions & 4) != 0) {
            this.modeFlag |= 1;
        }
        if ((grinvOptions & 0x20) != 0) {
            this.modeFlag |= 4;
        }
        long[] flags = GraphInvariants.getInitialInvariants(mol, this.isNoHydro(), this.isMappingConsidered());
        if (this.isUniqueNeeded() && mol.getGrinvCC() != 0L && !(mol instanceof SelectionMolecule)) {
            mol.adjustMultiChiralFlag();
            if (mol.isMultiChiral()) {
                flags = this.addChiralityToGraphInvariants(flags, mol);
            }
        }
        return flags;
    }

    private static long[] getInitialInvariants(MoleculeGraph mol, boolean isNoHydro, boolean isMappingConsidered) {
        MoleculeGraph gUnion = mol.getGraphUnion();
        int[] fragIDs = gUnion.getFragIds(1);
        int[] nn = GraphInvariants.getFragSizes(fragIDs);
        int[] sr = GraphInvariants.generateSmallestRingToIdx(gUnion);
        int[][] ctab = gUnion.getCtab();
        BondTable btab = gUnion.getBondTable();
        int na = ctab.length;
        long[] flags = new long[na];
        for (int i = 0; i < na; ++i) {
            int[] ctabi = ctab[i];
            MolAtom a = gUnion.getAtom(i);
            if (isNoHydro && GraphInvariants.isPlainH(a)) {
                flags[i] = -1L;
                continue;
            }
            int n = i;
            flags[n] = flags[n] | (long)nn[fragIDs[i]] << 48;
            int conn = ctabi.length < 7 ? ctabi.length : 7;
            int x = 0;
            for (int j = 0; j < ctabi.length; ++j) {
                MolAtom neighbour = gUnion.getAtom(ctabi[j]);
                if (neighbour.getAtno() != 1) {
                    int t = gUnion.getBond(btab.getBondIndex(i, ctabi[j])).getType();
                    x += t == 4 ? 3 : (t <= 3 ? 2 * t : 0);
                    continue;
                }
                if (!isNoHydro || !GraphInvariants.isPlainH(neighbour)) continue;
                --conn;
            }
            int n2 = i;
            flags[n2] = flags[n2] | (long)(x & 0xF) << 41;
            int n3 = i;
            flags[n3] = flags[n3] | (long)conn << 45;
            x = a.getAtno();
            if (x == 134) {
                x = 127 + a.getRgroup();
            }
            int n4 = i;
            flags[n4] = flags[n4] | (long)(x & 0xFF) << 34;
            x = a.getCharge();
            if (x < -7) {
                x = -7;
            } else if (x > 7) {
                x = 7;
            }
            int n5 = i;
            flags[n5] = flags[n5] | (long)((x < 0 ? 8 - x : x) & 0xF) << 30;
            x = a.getImplicitHcount() + a.getExplicitHcount();
            int n6 = i;
            flags[n6] = flags[n6] | (long)((x < 15 ? x : 15) << 26);
            x = a.getMassno();
            if (x != 0) {
                int Z = a.getAtno();
                int n7 = Z < MIN_MASSNO.length ? Z : 0;
                int n8 = i;
                flags[n8] = flags[n8] | (long)(((x -= MIN_MASSNO[n7]) & 0x3F) << 20);
            }
            if (isMappingConsidered && (x = a.getAtomMap()) > 0) {
                long mapShift = (x & 0xFF) << 10;
                int n9 = i;
                flags[n9] = flags[n9] | mapShift;
            }
            if (sr[i] <= 2) continue;
            int s = sr[i] - 2;
            s = s > 7 ? 7 : s;
            int n10 = i;
            flags[n10] = flags[n10] | (long)(s << 6);
        }
        return flags;
    }

    private boolean isNoHydro() {
        return (this.modeFlag & 2) == 2;
    }

    private boolean isMappingConsidered() {
        return (this.modeFlag & 4) == 4;
    }

    private boolean isUniqueNeeded() {
        return (this.modeFlag & 1) == 1;
    }

    private static boolean isPlainH(MolAtom a) {
        return a.getAtno() == 1 && a.getMassno() == 0;
    }

    public static int makeRanks(int[][] ctab, long[] caninv, int[] ranks, boolean noHydro) {
        boolean changed;
        int na = ctab.length;
        long[] primeNumbers = GraphInvariants.getPrimeNumbers(na);
        int rankCount = GraphInvariants.genRanks(caninv, ranks, noHydro, na);
        int[] newRanks = new int[na];
        do {
            int i;
            for (int i2 = 0; i2 < na; ++i2) {
                if (ranks[i2] == -1) continue;
                int[] neighbors = ctab[i2];
                int nb = neighbors.length;
                long x = 1L;
                for (int j = 0; j < nb; ++j) {
                    int k = neighbors[j];
                    if (ranks[k] == -1) continue;
                    x *= primeNumbers[ranks[k]];
                }
                caninv[i2] = x;
            }
            int newRankCount = 0;
            for (i = 0; i < na; ++i) {
                newRanks[i] = -1;
            }
            for (int r = 0; r < rankCount; ++r) {
                int nr;
                do {
                    int i3;
                    nr = 0;
                    long min = Long.MAX_VALUE;
                    int until = 0;
                    for (i3 = 0; i3 < na; ++i3) {
                        if (newRanks[i3] != -1 || ranks[i3] != r) continue;
                        ++nr;
                        if (caninv[i3] > min) continue;
                        min = caninv[i3];
                        until = i3;
                    }
                    if (nr == 0) continue;
                    ++until;
                    for (i3 = 0; i3 < until; ++i3) {
                        if (ranks[i3] != r || caninv[i3] != min) continue;
                        newRanks[i3] = newRankCount;
                    }
                    ++newRankCount;
                } while (nr != 0);
            }
            changed = false;
            for (i = 0; i < na && !changed; ++i) {
                changed = newRanks[i] != ranks[i];
            }
            System.arraycopy(newRanks, 0, ranks, 0, na);
            rankCount = newRankCount;
        } while (changed);
        return rankCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long[] getPrimeNumbers(int na) {
        Class<GraphInvariants> clazz = GraphInvariants.class;
        synchronized (GraphInvariants.class) {
            long[] primeNumbers = primeNumbers0;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            int nprimes = primeNumbers.length;
            if (nprimes >= na) return primeNumbers;
            long n = primeNumbers[nprimes - 1];
            long[] newarr = new long[na];
            System.arraycopy(primeNumbers, 0, newarr, 0, nprimes);
            primeNumbers = newarr;
            block6: while (nprimes < na) {
                long p;
                long max = ++n / 2L;
                int k = 0;
                while (n % (p = primeNumbers[k]) != 0L) {
                    ++k;
                    if (p < max) continue;
                    primeNumbers[nprimes++] = n;
                    continue block6;
                }
            }
            Class<GraphInvariants> clazz2 = GraphInvariants.class;
            synchronized (GraphInvariants.class) {
                if (na <= primeNumbers0.length) return primeNumbers;
                primeNumbers0 = primeNumbers;
                // ** MonitorExit[var6_8] (shouldn't be in output)
                return primeNumbers;
            }
        }
    }

    public static int genRanks(long[] caninv, int[] ranks, boolean noHydro, int na) {
        if (na == 0) {
            return 0;
        }
        int l = ranks.length;
        int[] idx = new int[l];
        for (int i = 0; i < na; ++i) {
            idx[i] = i;
        }
        ArrayTools.sort(caninv, idx, 0, na);
        int rankCount = 0;
        long p = -1L;
        int s = 0;
        for (int i = 0; i < na; ++i) {
            long inv = caninv[i];
            if (noHydro && inv == -1L) {
                ranks[idx[i]] = -1;
                s = i + 1;
                continue;
            }
            if (i <= s || p != inv) {
                // empty if block
            }
            ranks[idx[i]] = ++rankCount;
            p = inv;
        }
        Arrays.fill(caninv, -1L);
        return ++rankCount;
    }

    private long[] addChiralityToGraphInvariants(long[] invFlags, MoleculeGraph mg) {
        mg = mg.getGraphUnion();
        int atomCount = mg.getAtomCount();
        int shift = 18;
        int[] ranks = new int[atomCount];
        long[] caninv = new long[atomCount];
        System.arraycopy(invFlags, 0, caninv, 0, atomCount);
        int rankCount = GraphInvariants.genRanks(caninv, ranks, true, atomCount);
        block5: for (int atomIdx = 0; atomIdx < atomCount; ++atomIdx) {
            if (this.isNoHydro() && invFlags[atomIdx] == -1L) continue;
            if (this.calculatedChirality == null) {
                this.calculatedChirality = new int[mg.getAtomCount()];
            }
            int chirality = GraphInvariants.getChirality(mg, atomIdx, ranks, this.calculatedChirality);
            switch (chirality) {
                case 3: {
                    int n = atomIdx;
                    invFlags[n] = invFlags[n] | 0x40000L;
                    continue block5;
                }
                case 8: {
                    int n = atomIdx;
                    invFlags[n] = invFlags[n] | 0x80000L;
                    continue block5;
                }
                case 16: {
                    int n = atomIdx;
                    invFlags[n] = invFlags[n] | 0xC0000L;
                    continue block5;
                }
            }
        }
        return invFlags;
    }

    public static int[] generateSmallestRingToIdx(MoleculeGraph m) {
        int[] aSR = new int[m.getAtomCount()];
        Gearch gearch = m.smol().gearch();
        int sssrl = gearch.getSSSRCount();
        for (int i = 0; i < sssrl; ++i) {
            int rlen = gearch.getSSSRAtomCount(i);
            for (int k = 0; k < rlen; ++k) {
                int idx = gearch.getSSSRAtom(i, k);
                if (aSR[idx] != 0 && aSR[idx] <= rlen) continue;
                aSR[idx] = rlen;
            }
        }
        return aSR;
    }

    private static int[] getFragSizes(int[] fragIDs) {
        int l = fragIDs.length;
        int[] fragLength = new int[l];
        int max = -1;
        for (int i = 0; i < l; ++i) {
            int n;
            int n2 = n = fragIDs[i];
            fragLength[n2] = fragLength[n2] + 1;
            if (n <= max) continue;
            max = n;
        }
        int[] t = new int[++max];
        System.arraycopy(fragLength, 0, t, 0, max);
        return t;
    }

    static void correctGrinvCalc(long[] caninv, MoleculeGraph m, boolean noHydro) {
        int i;
        int[][] sssr = m.getCSSR();
        int sssrl = sssr.length;
        if (sssrl == 0) {
            return;
        }
        int[] atomInRing = new int[m.getAtomCount()];
        for (int i2 = 0; i2 < sssrl; ++i2) {
            int[] r = sssr[i2];
            int rl = r.length;
            for (int j = 0; j < rl; ++j) {
                int idx;
                int n = idx = r[j];
                atomInRing[n] = atomInRing[n] + 1;
            }
        }
        int[] g = new int[caninv.length];
        int[][] ctab = m.getCtab();
        GraphInvariants.makeRanks(ctab, caninv, g, noHydro);
        int l = g.length;
        for (i = 0; i < l; ++i) {
            caninv[i] = g[i] == -1 ? -1L : (long)(g[i] * l);
        }
        for (i = 0; i < sssrl; ++i) {
            int[] r = sssr[i];
            int rl = r.length;
            for (int j = 0; j < rl; ++j) {
                int idx = r[j];
                if (atomInRing[idx] >= 3 || GraphInvariants.hasDiffGrinvNeighbors(m, idx, g)) continue;
                int n = idx;
                caninv[n] = caninv[n] + (long)GraphInvariants.convertRingParity(j, ctab[idx], g, m, r);
            }
        }
        GraphInvariants.makeRanks(ctab, caninv, g, noHydro);
        for (i = 0; i < l; ++i) {
            caninv[i] = g[i];
        }
    }

    static int convertRingParity(int i, int[] an, int[] g, MoleculeGraph m, int[] r) {
        int idx = r[i];
        int parity = m.getLocalParity(idx);
        if (parity == 0 || parity == 3) {
            return 0;
        }
        int l = r.length;
        int i0 = r[(l + i - 1) % l];
        int i1 = r[(i + 1) % l];
        int i2 = -1;
        int i3 = -1;
        for (int lig : an) {
            if (lig == i0 || lig == i1) continue;
            if (i2 < 0) {
                i2 = lig;
                continue;
            }
            i3 = lig;
        }
        if (i3 >= 0) {
            if (g[i2] < g[i3]) {
                int t = i2;
                i2 = i3;
                i3 = t;
            } else if (g[i2] == g[i3]) {
                return 0;
            }
        }
        i3 = i3 < 0 ? Integer.MAX_VALUE : i3;
        int cs = MolAtom.paritySign(i0, i1, i2, i3);
        parity = cs > 0 ? parity : parity ^ 3;
        return parity;
    }

    static {
        GraphInvariants.MIN_MASSNO[0] = 0;
        for (int Z = 1; Z < MIN_MASSNO.length; ++Z) {
            int A = Z;
            while (MolAtom.isotopeType(Z, A) == 0) {
                ++A;
            }
            GraphInvariants.MIN_MASSNO[Z] = A;
        }
    }
}

