/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.core.calculations;

import chemaxon.common.util.ArrayTools;
import chemaxon.common.util.IntVector;
import chemaxon.core.calculations.DiGraphElement;
import chemaxon.core.calculations.GraphInvariants;
import chemaxon.core.util.BondTable;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.SelectionMolecule;
import chemaxon.struc.StereoConstants;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Vector;

public final class Parity
implements StereoConstants {
    static final int ATOM_LIST = 128;
    static final int ATOM_NOTLIST = 129;
    static final int ATOM_ANY = 131;
    static final int ATOM_HETERO = 132;
    static final int ATOM_RGROUP = 134;
    static final int CHIRALITY_MP = 384;
    static final int BOND_UP = 16;
    static final int BOND_DOWN = 32;
    static final int BOND_EITHER = 48;
    static final int BOND_ANY = 0;
    static final int STEREO1_MASK = 48;
    static final int STEP_LIMIT = 1000000;
    static final int LP = 130;
    static final int H_ORDER = Integer.MAX_VALUE;
    static final int LP_ORDER = 0x7FFFFFFE;
    static final int ALLENIC_IMPL_H2 = 0x7FFFFFFD;
    static final int UPPERMASK = 0x7FFF0000;
    static final double DET2_THRESHOLD = 1.0E-16;
    static final int MIN_RING_SIZE_FOR_TRANS_DB = 8;
    static final int UNIQUE_MASK = 1;
    static final int CIB_MASK = 2;
    static final int EZINFO = 1;
    static final int WEIGHT = 2;
    static final int RS = 3;
    static final int LIKE = 2;
    static final int UNLIKE = 1;
    private MoleculeGraph mol = null;
    private MoleculeGraph origmol = null;
    private int[] bondIndexToExpanded = null;
    private int[] atomIndexToExpanded = null;
    private long lastGrinvCC = 0L;
    private int[][] ctab = null;
    private BondTable btab = null;
    int[] stereoInfo = null;
    static final int PARITY_TYPEMASK = 3;
    static final int ASYMMETRIC = 4;
    static final int CHIRALCENTER = 8;
    static final int EQGRINV = 16;
    static final int HASWEDGE = 32;
    static final int RINGATOM = 64;
    static final int TWOEQGRINVINRING = 128;
    static final int CHECKED = 256;
    static final int HASPARITYVALUE = 512;
    static final int SPIRO = 1024;
    static final int SPIROPARITY = 2048;
    private boolean[] isRingBond = null;
    private int[] grinv = null;
    private int[] parity0D = null;
    private double[] xyz = null;
    private int[] hydrogenInfo = null;
    private static final int ISHYDROGEN = 65536;
    private static final int HMASK = 255;
    private static final int EXPLICITHOFFSET = 8;
    private static final int SPHERIC = 1;
    private static final int AUXINFO = 2;
    private static final int HYDROGEN_ORDER = 4;
    private boolean[] isLP = null;
    private int[] parity3D = null;
    private MoleculeGraph arommol = null;
    private boolean stereocalculated = false;
    private boolean axchiralityCalculated = false;
    private int[] chirality = null;
    private int[] ez = null;
    private int[] ringCount = null;
    private int[] atomInSmallestRing = null;
    private boolean hasContractedGroup = false;
    private boolean useOnlyFirstAtom = true;

    public long getGrinvCC() {
        return this.lastGrinvCC;
    }

    public int getCTStereoforBond(int bidx) {
        if (!this.stereocalculated) {
            this.stereogenicCenterCalculation();
        }
        return this.ez[bidx];
    }

    public static int getLocalParity(MoleculeGraph m, MolAtom atom, int parityType, boolean useOnlyFirstAtom) {
        int dim = m.getDim();
        int[] ringCount = new int[m.getAtomCount()];
        Parity.calculateRingCount(m, ringCount, null, null, null);
        int p = 0;
        if (parityType == 1) {
            p = dim < 2 ? atom.getFlags() & 7 : Parity.localParityTH(m, atom, ringCount, useOnlyFirstAtom);
        } else if (parityType == 2) {
            p = dim < 2 ? atom.getFlags() & 7 : Parity.localParityAL(m, atom, ringCount, useOnlyFirstAtom);
        }
        return p;
    }

    public static void clearParityInfo(MoleculeGraph m) {
        block3: {
            int dim;
            block2: {
                dim = m.getDim();
                if (dim != 0) break block2;
                for (int i = 0; i < m.getAtomCount(); ++i) {
                    MolAtom a = m.getAtom(i);
                    a.setFlags(0, 7);
                }
                break block3;
            }
            if (dim != 2) break block3;
            for (int i = 0; i < m.getBondCount(); ++i) {
                MolBond b = m.getBond(i);
                b.setFlags(0, 48);
            }
        }
    }

    public static boolean[] asymmetricAtoms(MoleculeGraph m) {
        Parity p = new Parity();
        p.setMolecule(m);
        int ac = m.getAtomCount();
        boolean[] aa = new boolean[ac];
        int[] si = p.stereoInfo;
        for (int i = 0; i < ac; ++i) {
            if ((si[i] & 4) <= 0) continue;
            aa[i] = true;
        }
        return aa;
    }

    public static boolean[] chiralAtoms(MoleculeGraph m) {
        int ac = m.getAtomCount();
        boolean[] cc = new boolean[ac];
        Parity p = new Parity();
        p.setMolecule(m);
        int[] si = p.stereoInfo;
        for (int i = 0; i < ac; ++i) {
            if ((si[i] & 8) <= 0) continue;
            cc[i] = true;
        }
        return cc;
    }

    public void useOnlyFirstAtom(boolean f) {
        if (f != this.useOnlyFirstAtom) {
            this.useOnlyFirstAtom = f;
            ++this.lastGrinvCC;
        }
    }

    static boolean isTHParityLocalConditionFulfilled(MolAtom a) {
        int atno = a.getAtno();
        if (atno == 1) {
            return false;
        }
        int ec = a.getBondCount();
        if (ec < 3 || ec > 4) {
            return false;
        }
        int impH = a.getImplicitHcount();
        if (impH > 1 || ec == 3 && impH == 0 && atno != 16 && (atno != 7 || a.twicesumbonds(true, false) != 6)) {
            return false;
        }
        int expH = 0;
        boolean centerS = atno == 16 || atno == 15;
        int dbbc = 0;
        for (int j = ec - 1; j >= 0; --j) {
            MolBond b;
            int t;
            MolAtom l = a.getLigand(j);
            if (l.getAtno() == 1 && l.getMassno() == 0) {
                ++expH;
            }
            if ((t = (b = a.getBond(j)).getType()) == 2) {
                ++dbbc;
                if (!centerS) continue;
                MolAtom n = a.getLigand(j);
                if (dbbc <= 1 && (n.getBondCount() == 1 || n.getCharge() != 0)) continue;
                return false;
            }
            if (t <= 2) continue;
            return false;
        }
        return impH + expH <= 1;
    }

    public boolean canHaveParity(int atomIndex) {
        if (this.mol.getAtomCount() < 4) {
            return false;
        }
        return (this.stereoInfo[atomIndex] & 3) > 0;
    }

    public int getParity(int atomIndex) {
        if (this.mol.getAtomCount() < 4) {
            return 0;
        }
        if (this.mol.getDim() == 0) {
            return this.parity0D[atomIndex];
        }
        return this.parity3D[atomIndex];
    }

    public boolean resetParity() {
        boolean success;
        int[] parity = new int[this.mol.getAtomCount()];
        for (int i = 0; i < this.mol.getAtomCount(); ++i) {
            parity[i] = this.getParity(i);
        }
        int d = this.mol.getDim();
        boolean bl = d == 2 ? this.setParity2D(parity) : (success = d == 1 ? this.setParity0D(parity) : false);
        if (this.mol != this.origmol) {
            Parity.copyInfoToOriginal(this.mol, this.origmol, this.atomIndexToExpanded, this.bondIndexToExpanded, null);
        }
        return success;
    }

    public boolean setParity(int[] parity, boolean useActualWedges) {
        Parity.correctCanhaveparity(this.stereoInfo, parity);
        if (parity.length != this.mol.getAtomCount()) {
            return false;
        }
        this.stereocalculated = false;
        this.axchiralityCalculated = false;
        if (this.mol.getDim() == 0) {
            return this.setParity0D(parity);
        }
        if (this.mol.getDim() == 2) {
            boolean[] bondSwap = new boolean[this.mol.getBondCount()];
            int[] bondFlags = Parity.getBondFlags(this.mol);
            boolean[] isBridgeAtom = Parity.setBridgeAtoms(parity, this.mol);
            if (useActualWedges) {
                boolean allOK = true;
                BitSet usedBonds = new BitSet(this.mol.getBondCount());
                for (int i = 0; i < parity.length && allOK; ++i) {
                    allOK = Parity.setParityUsingActualWedges(i, this.mol, parity, this.stereoInfo, this.isRingBond, isBridgeAtom, this.atomInSmallestRing, bondSwap, this.ringCount, this.useOnlyFirstAtom, usedBonds);
                }
                if (allOK) {
                    Parity.copyInfoToOriginal(this.mol, this.origmol, this.atomIndexToExpanded, this.bondIndexToExpanded, bondSwap);
                    return true;
                }
                Vector<int[]> chiralClusters = this.findChiralClusters(parity);
                for (int i = 0; i < chiralClusters.size(); ++i) {
                    int[] cluster = chiralClusters.elementAt(i);
                    if (Parity.isParityEqual(cluster, parity, this.mol)) continue;
                    Parity.clearWedges(this.mol, cluster);
                    boolean[] twoWedge = new boolean[cluster.length];
                    MolBond[][] bondArray = Parity.setupStereoBonds(cluster, isBridgeAtom, this.stereoInfo, this.ringCount, this.atomInSmallestRing, parity, bondSwap, twoWedge, this.mol, this.ctab, this.btab, this.useOnlyFirstAtom);
                    if (!Parity.setStereoAtoms(bondArray, cluster, 0, parity, this.mol, this.stereoInfo)) {
                        Parity.restoreWedges(this.mol, bondFlags, bondSwap);
                        Parity.copyInfoToOriginal(this.mol, this.origmol, this.atomIndexToExpanded, this.bondIndexToExpanded, null);
                        return false;
                    }
                    Parity.setupSecondWedge(twoWedge, bondArray, cluster, parity, bondSwap, this.mol);
                }
                Parity.copyInfoToOriginal(this.mol, this.origmol, this.atomIndexToExpanded, this.bondIndexToExpanded, bondSwap);
                return true;
            }
            return this.setParity2D(parity);
        }
        return false;
    }

    public static boolean setLocalParity(MoleculeGraph m, int[] idxes, int[] p, boolean useActualWedges) {
        int l;
        int ac = m.getAtomCount();
        int n = l = idxes == null ? ac : idxes.length;
        if (l != p.length) {
            return false;
        }
        int dim = m.getDim();
        if (dim == 0) {
            for (int i = l - 1; i >= 0; --i) {
                int idx = idxes == null ? i : idxes[i];
                MolAtom a = m.getAtom(idx);
                a.setFlags(p[i], 7);
            }
            return true;
        }
        if (dim == 2) {
            int i;
            if (Parity.allValueEquals(p, 0)) {
                Parity.resetUpDownFlags(idxes, m);
                return true;
            }
            boolean success = true;
            int[] pt = new int[ac];
            int[] cp = new int[ac];
            int[] localp = new int[ac];
            for (i = ac - 1; i >= 0; --i) {
                int lp;
                pt[i] = m.getParityType(i);
                cp[i] = lp = m.getLocalParity(i);
                localp[i] = pt[i] != 0 ? lp : 0;
            }
            if (idxes != null) {
                for (i = 0; i < l; ++i) {
                    int idx = idxes[i];
                    cp[idx] = p[i];
                }
            } else {
                cp = p;
            }
            boolean[] isRingBond = new boolean[m.getBondCount()];
            int[] sr = new int[ac];
            int[] rc = new int[ac];
            Parity.calculateRingCount(m, rc, isRingBond, sr, null);
            boolean[] isBridgeAtom = Parity.setBridgeAtoms(cp, m);
            int[][] ctab = m.getCtab();
            if (useActualWedges) {
                BitSet usedBonds = new BitSet(m.getBondCount());
                for (int i2 = l - 1; i2 >= 0; --i2) {
                    MolBond b2;
                    MolBond b;
                    int idx = idxes == null ? i2 : idxes[i2];
                    MolAtom a = m.getAtom(idx);
                    int par = cp[idx];
                    int lp = localp[idx];
                    if (par != lp) {
                        b = null;
                        if (lp == 0) {
                            b = Parity.locateFirstBondForParitySettings(m, idx, ctab, pt, isRingBond, isBridgeAtom, sr, cp, useActualWedges, usedBonds);
                            if (b == null) {
                                success = false;
                                break;
                            }
                            usedBonds.set(m.indexOf(b));
                            success = Parity.setWedgeLocal(b, par, lp, a, rc, m);
                        } else {
                            b = Parity.changeOneWedge(a, par, m, rc);
                            boolean bl = success = b != null;
                        }
                        if (b != null) {
                            b2 = null;
                            if (a.getBondCount() == 4 && par != 0 && par != 3) {
                                b2 = Parity.locateNextBondForParitySettings(m, b, idx, ctab, pt, isRingBond, isBridgeAtom, sr, null, usedBonds);
                            }
                            if (b2 != null) {
                                usedBonds.set(m.indexOf(b2));
                                Parity.setWedgeLocal(b2, par, lp, a, rc, m);
                            }
                        }
                    } else if (par > 0 && par != 3 && Parity.numberOfWedgeSet(a, true) == 1 && (b = Parity.getWedge(a)) != null) {
                        b2 = null;
                        if (a.getBondCount() == 4) {
                            b2 = Parity.locateNextBondForParitySettings(m, b, idx, ctab, pt, isRingBond, isBridgeAtom, sr, null, usedBonds);
                        }
                        if (b2 != null) {
                            usedBonds.set(m.indexOf(b2));
                            Parity.setWedgeLocal(b2, par, lp, a, rc, m);
                        }
                    }
                    if (success) {
                        continue;
                    }
                    break;
                }
            } else {
                Parity.resetUpDownFlags(idxes, m);
                BitSet usedBonds = new BitSet(m.getBondCount());
                for (int i3 = l - 1; i3 >= 0; --i3) {
                    int idx = idxes == null ? i3 : idxes[i3];
                    MolAtom a = m.getAtom(idx);
                    int lp = 0;
                    int par = cp[idx];
                    MolBond b = Parity.locateBondAccordingToPriority(m, null, a, idx, ctab, pt, isRingBond, isBridgeAtom, sr, null, usedBonds);
                    if (b == null) {
                        success = false;
                    } else {
                        usedBonds.set(m.indexOf(b));
                        success = Parity.setWedgeLocal(b, par, lp, a, rc, m);
                        if (b != null) {
                            MolBond b2 = null;
                            if (a.getBondCount() == 4 && par != 0 && par != 3) {
                                b2 = Parity.locateNextBondForParitySettings(m, b, idx, ctab, pt, isRingBond, isBridgeAtom, sr, null, usedBonds);
                            }
                            if (b2 != null) {
                                usedBonds.set(m.indexOf(b2));
                                Parity.setWedgeLocal(b2, par, lp, a, rc, m);
                            }
                        }
                        if (success) {
                            continue;
                        }
                    }
                    break;
                }
            }
            if (!success) {
                success = Parity.recursive2DLocalParitySet(m, cp, pt, isBridgeAtom, rc);
            }
            return success;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean setParityUsingActualWedges(int i, MoleculeGraph mol, int[] parity, int[] stereoInfo, boolean[] isRingBond, boolean[] isBridgeAtom, int[] atomInSmallestRing, boolean[] bondSwap, int[] ringCount, boolean useOnlyFirstAtom, BitSet usedBonds) {
        MolBond b;
        MolAtom a = mol.getAtom(i);
        int[][] ctab = mol.getCtab();
        int p = parity[i];
        p = p == 3 ? 0 : p;
        int lp = mol.getLocalParity(i);
        int n = lp = lp == 3 ? 0 : lp;
        if (p != lp) {
            if (useOnlyFirstAtom && Parity.flipWedges(i, p, mol)) {
                return true;
            }
            MolBond b2 = Parity.locateFirstBondForParitySettings(mol, i, ctab, stereoInfo, isRingBond, isBridgeAtom, atomInSmallestRing, parity, useOnlyFirstAtom, usedBonds);
            if (b2 == null || !useOnlyFirstAtom) return false;
            usedBonds.set(mol.indexOf(b2));
            MolBond b22 = null;
            if (a.getBondCount() == 4 && p != 0) {
                b22 = Parity.locateNextBondForParitySettings(mol, b2, i, ctab, stereoInfo, isRingBond, isBridgeAtom, atomInSmallestRing, parity, usedBonds);
            }
            if (!Parity.setWedge(i, b2, p, mol, bondSwap)) {
                return false;
            }
            if (b22 == null) return true;
            usedBonds.set(mol.indexOf(b22));
            if (Parity.setWedge(i, b22, p, mol, bondSwap, true)) return true;
            return false;
        }
        if (p <= 0 || Parity.numberOfWedgeSet(a, useOnlyFirstAtom) != 1 || (b = Parity.getWedge(a)) == null || !useOnlyFirstAtom) return true;
        MolBond b2 = null;
        if (a.getBondCount() == 4) {
            b2 = Parity.locateNextBondForParitySettings(mol, b, i, ctab, stereoInfo, isRingBond, isBridgeAtom, atomInSmallestRing, parity, usedBonds);
        }
        if (b2 == null) return true;
        usedBonds.set(mol.indexOf(b2));
        Parity.setWedgeLocal(b2, p, lp, a, ringCount, mol);
        return true;
    }

    static boolean flipWedges(int idx, int p, MoleculeGraph m) {
        MolAtom a = m.getAtom(idx);
        int n = 0;
        int bc = a.getBondCount();
        int[] tmp = new int[bc];
        for (int i = 0; i < bc; ++i) {
            MolBond b = a.getBond(i);
            if (!Parity.isUpDownBond(b, a)) continue;
            tmp[n] = i;
            b.setFlags(0, 48);
            ++n;
        }
        int[] wedges = new int[n];
        System.arraycopy(tmp, 0, wedges, 0, n);
        for (int i = 0; i < n; ++i) {
            MolBond b = a.getBond(wedges[i]);
            Parity.setWedge(idx, b, p, m, null, true);
        }
        return false;
    }

    static boolean recursive2DLocalParitySet(MoleculeGraph m, int[] p, int[] pt, boolean[] ba, int[] rc) {
        Parity.resetUpDownFlags(m);
        int[][] ctab = m.getCtab();
        BondTable btab = m.getBondTable();
        int l = p.length;
        int[] stereoInf = new int[l];
        boolean[] usedAtom = new boolean[l];
        for (int i = 0; i < l; ++i) {
            int par = p[i];
            if (usedAtom[i] || par == 0 || par == 3) continue;
            int[] cluster = Parity.findChiralClusters(p, i, m, ctab);
            for (int j = 0; j < cluster.length; ++j) {
                int k = cluster[j];
                usedAtom[k] = true;
            }
            boolean[] twoWedge = new boolean[cluster.length];
            MolBond[][] bondArray = Parity.setupStereoBonds(cluster, ba, pt, rc, rc, p, null, twoWedge, m, ctab, btab, true);
            if (!Parity.setStereoAtoms(bondArray, cluster, 0, p, m, stereoInf)) {
                return false;
            }
            Parity.setupSecondWedge(twoWedge, bondArray, cluster, p, null, m);
        }
        return true;
    }

    static int numberOfWedgeSet(MolAtom a, boolean useOnlyFirstAtom) {
        int n = 0;
        for (int i = a.getBondCount() - 1; i >= 0; --i) {
            MolBond b = a.getBond(i);
            int f = b.getFlags() & 0x30;
            if (f == 0) continue;
            if (useOnlyFirstAtom) {
                if (b.getAtom1() != a) continue;
                ++n;
                continue;
            }
            ++n;
        }
        return n;
    }

    static MolBond changeOneWedge(MolAtom a, int p, MoleculeGraph m, int[] rc) {
        int localp;
        MolBond b = Parity.getWedge(a);
        if (b == null) {
            return null;
        }
        int f = b.getFlags() & 0x30;
        if (f == 48) {
            b.setFlags(16, 48);
            localp = Parity.localParityTH(m, a, rc, true);
            if (localp == p) {
                return b;
            }
            b.setFlags(32, 48);
        } else if (p == 0) {
            b.setFlags(0, 48);
        } else {
            if (p == 3) {
                b.setFlags(48, 48);
                return b;
            }
            b.setFlags(f ^ 0x30, 48);
        }
        localp = Parity.localParityTH(m, a, rc, true);
        if (localp == p) {
            return b;
        }
        return null;
    }

    static MolBond getWedge(MolAtom a) {
        for (int i = a.getBondCount() - 1; i >= 0; --i) {
            int f;
            MolBond b = a.getBond(i);
            if (b.getAtom1() != a || (f = b.getFlags() & 0x30) == 0) continue;
            return b;
        }
        return null;
    }

    static boolean setWedgeLocal(MolBond b, int p, int lp, MolAtom a, int[] rc, MoleculeGraph m) {
        b.setFlags(0, 48);
        if (p == 0) {
            return true;
        }
        if (p == 3) {
            b.setFlags(48, 48);
        } else {
            boolean notsuccess = true;
            boolean step = true;
            if (b.getAtom1() != a) {
                b.swap();
            }
            do {
                step = b.stepWedge();
            } while ((notsuccess = p != (lp = (lp = Parity.localParityTH(m, a, rc, true)) == 3 ? 0 : lp)) && step);
            if (notsuccess) {
                return false;
            }
        }
        return true;
    }

    static boolean isParityEqual(int[] cluster, int[] parity, MoleculeGraph m) {
        for (int i = 0; i < cluster.length; ++i) {
            int idx = cluster[i];
            int p = parity[idx];
            p = p == 3 ? 0 : p;
            int lp = m.getLocalParity(idx);
            int n = lp = lp == 3 ? 0 : lp;
            if (p == lp) continue;
            return false;
        }
        return true;
    }

    static void clearWedges(MoleculeGraph mol, int[] cluster) {
        for (int j = 0; j < cluster.length; ++j) {
            int idx = cluster[j];
            MolAtom a = mol.getAtom(idx);
            for (int i = 0; i < a.getBondCount(); ++i) {
                MolBond b = a.getBond(i);
                b.setFlags(0, 48);
            }
        }
    }

    boolean setParity0D(int[] parity) {
        if (parity.length != this.mol.getAtomCount()) {
            return false;
        }
        for (int i = 0; i < this.mol.getAtomCount(); ++i) {
            MolAtom a = this.mol.getAtom(i);
            a.setFlags(parity[i], 7);
        }
        Parity.copyInfoToOriginal(this.mol, this.origmol, this.atomIndexToExpanded, this.bondIndexToExpanded, null);
        return true;
    }

    boolean setParity2D(int[] parity) {
        if (parity.length != this.mol.getAtomCount() || this.mol.getAtomCount() < 4) {
            return false;
        }
        Parity.correctCanhaveparity(this.stereoInfo, parity);
        Parity.resetUpDownFlags(this.mol);
        for (int i = 0; i < this.mol.getAtomCount(); ++i) {
            if (this.mol.getAtom(i).hasWedgedBond()) {
                int n = i;
                this.stereoInfo[n] = this.stereoInfo[n] | 0x20;
                continue;
            }
            int n = i;
            this.stereoInfo[n] = this.stereoInfo[n] & 0xFFFFFFDF;
        }
        Vector<int[]> chiralClusters = this.findChiralClusters(parity);
        boolean[] isBridgeAtom = Parity.setBridgeAtoms(parity, this.mol);
        boolean[] bondSwap = new boolean[this.mol.getBondCount()];
        int[] bondFlags = Parity.getBondFlags(this.mol);
        for (int i = 0; i < chiralClusters.size(); ++i) {
            boolean[] twoWedge;
            int[] cluster = chiralClusters.elementAt(i);
            MolBond[][] bondArray = Parity.setupStereoBonds(cluster, isBridgeAtom, this.stereoInfo, this.ringCount, this.atomInSmallestRing, parity, bondSwap, twoWedge = new boolean[cluster.length], this.mol, this.ctab, this.btab, this.useOnlyFirstAtom);
            if (!Parity.setStereoAtoms(bondArray, cluster, 0, parity, this.mol, this.stereoInfo)) {
                Parity.restoreWedges(this.mol, bondFlags, bondSwap);
                Parity.copyInfoToOriginal(this.mol, this.origmol, this.atomIndexToExpanded, this.bondIndexToExpanded, null);
                return false;
            }
            Parity.setupSecondWedge(twoWedge, bondArray, cluster, parity, bondSwap, this.mol);
        }
        Parity.copyInfoToOriginal(this.mol, this.origmol, this.atomIndexToExpanded, this.bondIndexToExpanded, bondSwap);
        return true;
    }

    static void resetUpDownFlags(MoleculeGraph m) {
        for (int i = m.getBondCount() - 1; i >= 0; --i) {
            MolBond b = m.getBond(i);
            if ((b.getFlags() & 0x30) == 48) continue;
            b.setFlags(0, 48);
        }
    }

    static void resetUpDownFlags(int[] idxes, MoleculeGraph m) {
        int i;
        if (idxes == null) {
            Parity.resetUpDownFlags(m);
            return;
        }
        BitSet ids = new BitSet();
        for (i = 0; i < idxes.length; ++i) {
            ids.set(idxes[i]);
        }
        for (i = m.getBondCount() - 1; i >= 0; --i) {
            MolBond b = m.getBond(i);
            int atom1Idx = m.indexOf(b.getAtom1());
            if (atom1Idx < 0 || !ids.get(atom1Idx) || (b.getFlags() & 0x30) == 48) continue;
            b.setFlags(0, 48);
        }
    }

    public boolean setParity(int idxAtom, int val) {
        if (this.mol.getAtomCount() < 4) {
            return false;
        }
        this.stereocalculated = false;
        this.axchiralityCalculated = false;
        if (this.mol.getDim() == 0) {
            MolAtom a = this.mol.getAtom(idxAtom);
            a.setFlags(val, 7);
            int n = idxAtom;
            this.stereoInfo[n] = this.stereoInfo[n] | 0x200;
            this.mol.incGrinvCCOnly();
            Parity.copyInfoToOriginal(this.mol, this.origmol, this.atomIndexToExpanded, this.bondIndexToExpanded, null);
            return true;
        }
        if (this.mol.getDim() == 2) {
            int c = this.getParity(idxAtom);
            if (c == val) {
                return true;
            }
            int[] parity = new int[this.mol.getAtomCount()];
            for (int i = 0; i < this.mol.getAtomCount(); ++i) {
                parity[i] = this.getParity(i);
            }
            parity[idxAtom] = val;
            int[] cluster = Parity.findChiralClusters(parity, idxAtom, this.mol, this.ctab);
            for (int i = 0; i < cluster.length; ++i) {
                MolAtom a = this.mol.getAtom(cluster[i]);
                for (int j = 0; j < a.getBondCount(); ++j) {
                    MolBond b = a.getBond(j);
                    if ((b.getFlags() & 0x30) == 48) continue;
                    b.setFlags(0, 48);
                }
                if (this.mol.getAtom(cluster[i]).hasWedgedBond()) {
                    int n = cluster[i];
                    this.stereoInfo[n] = this.stereoInfo[n] | 0x20;
                    continue;
                }
                int n = cluster[i];
                this.stereoInfo[n] = this.stereoInfo[n] & 0xFFFFFFDF;
            }
            boolean[] isBridgeAtom = Parity.setBridgeAtoms(parity, this.mol);
            boolean[] bondSwap = new boolean[this.mol.getBondCount()];
            int[] bondFlags = Parity.getBondFlags(this.mol);
            boolean[] twoWedge = new boolean[cluster.length];
            MolBond[][] bondArray = Parity.setupStereoBonds(cluster, isBridgeAtom, this.stereoInfo, this.ringCount, this.atomInSmallestRing, parity, bondSwap, twoWedge, this.mol, this.ctab, this.btab, this.useOnlyFirstAtom);
            if (!Parity.setStereoAtoms(bondArray, cluster, 0, parity, this.mol, this.stereoInfo)) {
                Parity.restoreWedges(this.mol, bondFlags, bondSwap);
                Parity.copyInfoToOriginal(this.mol, this.origmol, this.atomIndexToExpanded, this.bondIndexToExpanded, null);
                return false;
            }
            Parity.setupSecondWedge(twoWedge, bondArray, cluster, parity, bondSwap, this.mol);
            for (int i = 0; i < cluster.length; ++i) {
                int lp = this.mol.getLocalParity(cluster[i]);
                int n = cluster[i];
                this.stereoInfo[n] = this.stereoInfo[n] & 0xFFFFFDFF;
                if (lp != 1 && lp != 2) continue;
                int n2 = cluster[i];
                this.stereoInfo[n2] = this.stereoInfo[n2] | 0x200;
            }
            Parity.copyInfoToOriginal(this.mol, this.origmol, this.atomIndexToExpanded, this.bondIndexToExpanded, bondSwap);
        }
        return true;
    }

    static int[] findChiralClusters(int[] parity, int idx, MoleculeGraph m, int[][] ctab) {
        int[] chirc = new int[m.getAtomCount()];
        for (int i = 0; i < chirc.length; ++i) {
            if (parity[i] > 0 && parity[i] != 3) {
                int chiralConn = 0;
                for (int j = 0; j < ctab[i].length; ++j) {
                    int aNu = ctab[i][j];
                    if (parity[aNu] <= 0) continue;
                    ++chiralConn;
                }
                chirc[i] = chiralConn;
                continue;
            }
            chirc[i] = -1;
        }
        chirc[idx] = -1;
        int[] cluster = new int[]{idx};
        for (int i = 0; i < cluster.length; ++i) {
            cluster = Parity.findChiralAtoms(i, chirc, cluster, ctab);
        }
        return cluster;
    }

    Vector<int[]> findChiralClusters(int[] parity) {
        int startatom;
        Vector<int[]> r = new Vector<int[]>();
        int[] chirc = new int[this.mol.getAtomCount()];
        for (int i = 0; i < chirc.length; ++i) {
            if (parity[i] > 0 && parity[i] != 3) {
                int chiralConn = 0;
                for (int j = 0; j < this.ctab[i].length; ++j) {
                    int aNu = this.ctab[i][j];
                    if (parity[aNu] <= 0) continue;
                    ++chiralConn;
                }
                chirc[i] = chiralConn;
                continue;
            }
            chirc[i] = -1;
        }
        while ((startatom = Parity.findMaxNu(chirc)) > -1) {
            chirc[startatom] = -1;
            int[] cluster = new int[]{startatom};
            for (int i = 0; i < cluster.length; ++i) {
                cluster = Parity.findChiralAtoms(i, chirc, cluster, this.ctab);
            }
            r.addElement(cluster);
        }
        return r;
    }

    static int[] findChiralAtoms(int i, int[] chirc, int[] cluster, int[][] ctab) {
        int aNu = cluster[i];
        int plusAtom = 0;
        for (int j = 0; j < ctab[aNu].length; ++j) {
            int nextANu = ctab[aNu][j];
            if (chirc[nextANu] <= -1) continue;
            ++plusAtom;
        }
        int[] temp = new int[cluster.length + plusAtom];
        System.arraycopy(cluster, 0, temp, 0, cluster.length);
        int n = 0;
        for (int j = 0; j < ctab[aNu].length; ++j) {
            int nextANu = ctab[aNu][j];
            if (chirc[nextANu] <= -1) continue;
            chirc[nextANu] = -1;
            temp[cluster.length + n] = nextANu;
            ++n;
        }
        return temp;
    }

    static boolean[] setBridgeAtoms(int[] p, MoleculeGraph m) {
        boolean[] ba = new boolean[m.getAtomCount()];
        int[][] ctab = m.getCtab();
        for (int i = 0; i < m.getAtomCount(); ++i) {
            int neighbourWithParity = 0;
            for (int j = 0; j < ctab[i].length; ++j) {
                if (p[ctab[i][j]] <= 0) continue;
                ++neighbourWithParity;
            }
            if (neighbourWithParity <= true) continue;
            ba[i] = true;
        }
        return ba;
    }

    static MolBond[][] setupStereoBonds(int[] c, boolean[] isBridgeAtom, int[] pt, int[] ringCount, int[] atomInSmallestRing, int[] parity, boolean[] swap, boolean[] twoWedge, MoleculeGraph m, int[][] ctab, BondTable btab, boolean useF) {
        MolBond[][] bondArray = new MolBond[c.length][];
        boolean[] usedbonds = new boolean[m.getBondCount()];
        for (int i = 0; i < c.length; ++i) {
            int aNu = c[i];
            MolAtom a = m.getAtom(aNu);
            int[] ct = ctab[aNu];
            int k = 0;
            int[] tmp = new int[a.getBondCount()];
            int chainLigandNo = 0;
            for (int j = 0; j < ct.length; ++j) {
                int a2 = ct[j];
                int bNu = btab.getBondIndex(aNu, a2);
                MolBond b = a.getBond(j);
                if (b.getType() == 1 && !usedbonds[bNu] && (useF || parity[a2] != 3)) {
                    tmp[k++] = j;
                    usedbonds[bNu] = true;
                }
                if (ringCount[a2] != 0) continue;
                ++chainLigandNo;
            }
            int[] temp = new int[k];
            System.arraycopy(tmp, 0, temp, 0, k);
            int n = 0;
            n = Parity.rearrangeBondToTerminal(m, temp, n, a, ct, pt);
            n = Parity.rearrangeBondBasedOnAtno(m, temp, n, a, ct, pt, ringCount, true, useF);
            n = Parity.rearrangeBridgeBond(m, temp, n, a, ct, pt, isBridgeAtom);
            n = Parity.rearrangeSmallestRingBond(m, temp, n, a, ct, pt, atomInSmallestRing);
            n = Parity.rearrangeBondBasedOnAtno(m, temp, n, a, ct, pt, ringCount, false, useF);
            for (int j = 0; j < k; ++j) {
                int lidx = temp[j];
                MolBond b = a.getBond(lidx);
                int a2 = ct[lidx];
                int bNu = btab.getBondIndex(aNu, a2);
                Parity.swapBond(a, b, bNu, swap);
            }
            MolBond[] potBonds = new MolBond[k];
            for (int j = 0; j < k; ++j) {
                potBonds[j] = a.getBond(temp[j]);
            }
            bondArray[i] = potBonds;
            twoWedge[i] = parity[aNu] != 3 && ct.length == 4 && chainLigandNo > 1;
        }
        return bondArray;
    }

    static boolean setStereoAtoms(MolBond[][] bondarray, int[] c, int i, int[] parity, MoleculeGraph m, int[] stereoInfo) {
        MolBond[] bonds = bondarray[i];
        boolean OK = true;
        while (true) {
            if (!Parity.parityCheck(i, c, parity, m)) {
                if (!MolBond.stepWedge(bonds)) {
                    int n = c[i];
                    stereoInfo[n] = stereoInfo[n] & 0xFFFFFFDF;
                    return false;
                }
                int n = c[i];
                stereoInfo[n] = stereoInfo[n] | 0x20;
                continue;
            }
            if (i + 1 < c.length && !(OK = Parity.setStereoAtoms(bondarray, c, i + 1, parity, m, stereoInfo))) {
                if (!MolBond.stepWedge(bonds)) {
                    int n = c[i];
                    stereoInfo[n] = stereoInfo[n] & 0xFFFFFFDF;
                    return false;
                }
                int n = c[i];
                stereoInfo[n] = stereoInfo[n] | 0x20;
            }
            if (OK) break;
        }
        return true;
    }

    static boolean setupSecondWedge(boolean[] twoWedge, MolBond[][] bondarray, int[] c, int[] parity, boolean[] swap, MoleculeGraph m) {
        boolean allSuccess = true;
        for (int i = c.length - 1; i >= 0; --i) {
            MolBond[] bonds;
            if (!twoWedge[i] || (bonds = bondarray[i]).length <= 1) continue;
            MolBond b0 = bonds[0];
            MolBond b1 = bonds[1];
            if ((b0.getFlags() & 0x30) == 0 || (b1.getFlags() & 0x30) != 0) continue;
            boolean parityOK = false;
            boolean moreStep = false;
            Parity.swapBond(m.getAtom(c[i]), b1, m.indexOf(b1), swap);
            do {
                moreStep = b1.stepWedge();
                parityOK = Parity.parityCheck(i, c, parity, m);
            } while (moreStep && !parityOK);
            allSuccess &= parityOK;
        }
        return allSuccess;
    }

    public int getChirality(int idxAtom) {
        if (this.mol.getAtomCount() < 4) {
            return 0;
        }
        if (this.mol.getAtom(idxAtom).getBondCount() == 2) {
            return this.getAlleneLikeChirality(idxAtom);
        }
        this.stereogenicCenterCalculation();
        if (this.mol.getDim() != 2) {
            return (this.stereoInfo[idxAtom] & 8) > 0 ? this.chirality[idxAtom] : 0;
        }
        return (this.stereoInfo[idxAtom] & 8) > 0 ? ((this.stereoInfo[idxAtom] & 0x20) > 0 ? this.chirality[idxAtom] : 3) : 0;
    }

    public boolean setChirality(int idxAtom, int val) {
        int c = this.getChirality(idxAtom);
        if (this.mol.getDim() <= 2) {
            if (c == val) {
                return true;
            }
            if ((val & 0x18) != 0 && val != 24) {
                int p = this.getParity(idxAtom);
                boolean success = false;
                if ((c & 0x18) != 0) {
                    success = this.setParity(idxAtom, p ^ 3);
                } else {
                    success = this.setParity(idxAtom, 1);
                    c = this.getChirality(idxAtom);
                    if (c != val) {
                        success = this.setParity(idxAtom, 2);
                    }
                }
                if (this.getChirality(idxAtom) != val) {
                    this.setParity(idxAtom, 0);
                    success = false;
                }
                return success;
            }
            return this.setParity(idxAtom, val);
        }
        return false;
    }

    private void stereogenicCenterCalculation() {
        if (!this.stereocalculated) {
            this.arommol = (MoleculeGraph)this.mol.clone();
            if (this.arommol instanceof Molecule) {
                ((Molecule)this.arommol).expandSgroups();
            }
            this.arommol.aromatize();
            MoleculeGraph m = this.arommol;
            Parity.replaceDoubleBondsForTH(m);
            Parity.fillHydrogenInfo(this.hydrogenInfo, m);
            int ac = m.getAtomCount();
            int bc = m.getBondCount();
            this.ez = new int[bc];
            int[] grinv0 = new int[ac];
            m.getGrinv(grinv0, 9);
            IntVector tmp1 = new IntVector(ac);
            IntVector tmp2 = new IntVector(ac);
            for (int i = 0; i < ac; ++i) {
                if ((this.stereoInfo[i] & 8) <= 0 || !Parity.bondConditionForParity(m.getAtom(i))) continue;
                if (Parity.hasEqualGriv(this.ctab[i], grinv0)) {
                    tmp2.add(i);
                    continue;
                }
                tmp1.add(i);
            }
            int[] constitutionalTH = tmp1.toArray();
            int[] topographicalTH = tmp2.toArray();
            tmp1.clear();
            tmp2.clear();
            boolean[] grDiffer = new boolean[2];
            int[] sssrSize = m.getSmallestRingSizeForIdx();
            for (int i = 0; i < bc; ++i) {
                MolBond b = m.getBond(i);
                int t = b.getType();
                if (t != 2 && t != 4 && t != 7) continue;
                grDiffer[0] = false;
                grDiffer[1] = false;
                MolAtom a1 = b.getAtom1();
                MolAtom a2 = b.getAtom2();
                int idx1 = m.indexOf(a1);
                int idx2 = m.indexOf(a2);
                int minRS1 = sssrSize[idx1];
                int minRS2 = sssrSize[idx2];
                if (!Parity.checkLigandAndBonds(a1, this.ctab[idx1], idx2, 0, grDiffer, grinv0, this.hydrogenInfo, idx1) || !Parity.checkLigandAndBonds(a2, this.ctab[idx2], idx1, 1, grDiffer, grinv0, this.hydrogenInfo, idx2) || minRS1 != 0 && minRS1 < 8 && minRS2 != 0 && minRS2 < 8) continue;
                if (grDiffer[0] && grDiffer[1]) {
                    tmp1.add(i);
                    continue;
                }
                tmp2.add(i);
            }
            int[] constitutionalEZ = tmp1.toArray();
            int[] topographicalEZ = tmp2.toArray();
            Parity.calculateTHChirality(m, constitutionalTH, this.ctab, this.stereoInfo, this.ringCount, this.useOnlyFirstAtom, this.chirality, null, this.hydrogenInfo);
            int[] ez_atoms = new int[ac];
            Parity.calculateEZ(m, constitutionalEZ, this.ctab, null, ez_atoms, this.ez, this.hydrogenInfo, this.stereoInfo);
            boolean changed = false;
            do {
                changed = false;
                changed |= Parity.calculateTHChirality(m, topographicalTH, this.ctab, this.stereoInfo, this.ringCount, this.useOnlyFirstAtom, this.chirality, ez_atoms, this.hydrogenInfo);
            } while (changed |= Parity.calculateEZ(m, topographicalEZ, this.ctab, this.chirality, ez_atoms, this.ez, this.hydrogenInfo, this.stereoInfo));
            this.closeSgroups(this.mol);
        }
        this.stereocalculated = true;
    }

    private static boolean calculateTHChirality(MoleculeGraph m, int[] idxes, int[][] ctab, int[] stereoInfo, int[] ringCount, boolean useOnlyFirstAtom, int[] chirality, int[] ez, int[] hinfo) {
        boolean success = false;
        boolean[] pseudo_asymm = new boolean[1];
        int dim = m.getDim();
        for (int i = 0; i < idxes.length; ++i) {
            pseudo_asymm[0] = false;
            int idx = idxes[i];
            if (idx < 0) continue;
            int[] an = ctab[idx];
            int c = 0;
            if (!Parity.hasAmbiguousLigand(an, m)) {
                int[] order = null;
                if ((stereoInfo[idx] & 0x200) > 0) {
                    order = ez == null ? Parity.orderCIPConstitutional(an, idx, m, hinfo) : Parity.orderCIPTopographical(an, idx, m, chirality, ez, pseudo_asymm, hinfo, stereoInfo);
                }
                c = Parity.calculateChiralirtyFromOrder(order, dim, m, idx, an, ringCount, useOnlyFirstAtom, pseudo_asymm[0]);
            }
            chirality[idx] = c == 0 ? 3 : c;
            success |= c != 0;
            idxes[i] = -1;
        }
        return success;
    }

    private static boolean hasAmbiguousLigand(int[] idxes, MoleculeGraph m) {
        for (int idx : idxes) {
            MolAtom a = m.getAtom(idx);
            if (a.getAtno() <= 109) continue;
            return true;
        }
        return false;
    }

    private static boolean calculateEZ(MoleculeGraph m, int[] idxes, int[][] ctab, int[] chirality, int[] ezAtoms, int[] ezBonds, int[] hinfo, int[] stereoInfo) {
        boolean success = false;
        for (int i = 0; i < idxes.length; ++i) {
            int ct;
            MolAtom a4;
            MolAtom a3;
            int i3;
            MolBond b;
            MolAtom a2;
            int i2;
            MolAtom a1;
            int idx = idxes[i];
            if (idx < 0 || (a1 = Parity.getCTLigand(i2 = m.indexOf(a2 = (b = m.getBond(idx)).getAtom1()), ctab[i2], i3 = m.indexOf(a3 = b.getAtom2()), m, chirality, ezAtoms, hinfo, stereoInfo)) == null || (a4 = Parity.getCTLigand(i3, ctab[i3], i2, m, chirality, ezAtoms, hinfo, stereoInfo)) == null) continue;
            ezBonds[idx] = ct = m.getStereo2(b, a1, a4);
            ezAtoms[i2] = ct;
            ezAtoms[i3] = ct;
            success |= ct != 0;
            idxes[i] = -1;
        }
        return success;
    }

    static int getLocalChirality(MoleculeGraph m, int idx, int[] calculatedChirality, int[] ez, int[] ringCount, boolean useOnlyFirstAtom, boolean topographical, int[] hinfo) {
        int ptype = m.getParityType(idx);
        if (ptype == 0) {
            return 0;
        }
        MolAtom atom = m.getAtom(idx);
        int dim = m.getDim();
        int[] an = m.getCtab()[idx];
        int[] order = null;
        if (dim == 2 && atom.hasWedgedBond() || dim != 2) {
            order = topographical ? Parity.orderCIPTopographical(an, idx, m, calculatedChirality, ez, null, hinfo, null) : Parity.orderCIPConstitutional(an, idx, m, hinfo);
        }
        return Parity.calculateChiralirtyFromOrder(order, dim, m, idx, an, ringCount, useOnlyFirstAtom, false);
    }

    private int getAlleneLikeChirality(int idxAtom) {
        int ptype = this.mol.getParityType(idxAtom);
        if (ptype != 2) {
            return 0;
        }
        if (!this.axchiralityCalculated) {
            if (this.arommol == null) {
                this.openSgroups(this.mol);
                this.arommol = (MoleculeGraph)this.mol.clone();
                this.arommol.aromatize();
            }
            Parity.fillHydrogenInfo(this.hydrogenInfo, this.arommol);
            int ac = this.mol.getAtomCount();
            for (int i = 0; i < ac; ++i) {
                int ch;
                ptype = this.mol.getParityType(i);
                int p = this.mol.getLocalParity(i);
                if (ptype != 2 || p == 0) continue;
                int n = p == 1 ? 128 : (ch = p == 2 ? 256 : p);
                if ((ch & 3) != 0) {
                    ch = 384;
                } else {
                    int[] lidxs = new int[4];
                    int[] clids = new int[4];
                    int[] o_p = new int[4];
                    int n2 = Parity.getAllenicLigandsAndBondFlags(i, lidxs, clids, this.ctab, this.arommol, null, o_p, this.useOnlyFirstAtom);
                    if (n2 == 0) continue;
                    int[] o_c = Parity.orderCIPConstitutionalAL(lidxs, clids, this.arommol, idxAtom, this.hydrogenInfo);
                    for (int j = 0; j < 4; ++j) {
                        int idx = lidxs[j];
                        if (idx < 0) continue;
                        o_c[j] = (this.hydrogenInfo[idx] & 0x10000) != 0 ? 4 : o_c[j];
                    }
                    ch = Parity.calculateAlleneChiralityFromOrder(o_c, o_p, ch);
                }
                this.chirality[i] = ch;
            }
            this.closeSgroups(this.mol);
            this.arommol = null;
        }
        this.axchiralityCalculated = true;
        return this.chirality[idxAtom];
    }

    private static int calculateAlleneChiralityFromOrder(int[] o_c, int[] o_p, int ch) {
        Parity.fixAxialLigands(o_c);
        int sign_c = MolAtom.paritySign(o_c[0], o_c[1], o_c[2], o_c[3]);
        int sign_p = MolAtom.paritySign(o_p[0], o_p[1], o_p[2], o_p[3]);
        ch = sign_c == 0 ? 0 : (sign_c == sign_p ? ch ^ 0x180 : ch);
        return ch;
    }

    static void fixAxialLigands(int[] o) {
        int min_val = Integer.MAX_VALUE;
        int min_idx = -1;
        for (int j = 0; j < 4; ++j) {
            int o_c = o[j];
            if (o_c >= min_val) continue;
            min_val = o_c;
            min_idx = j;
        }
        int pair = min_idx % 2;
        pair ^= 1;
        pair = min_idx / 2 * 2 + pair;
        o[pair] = min_val + 1;
        int n = min_val + 1;
        for (int j = 0; j < 4; ++j) {
            if (j == min_idx || j == pair) continue;
            int n2 = j;
            o[n2] = o[n2] + n;
        }
    }

    static boolean checkLigandAndBonds(MolAtom a, int[] an, int oidx, int v, boolean[] grinvDiffer, int[] grinv, int[] hinfo, int c) {
        int l = an.length;
        if (l < 2 || l > 3) {
            return false;
        }
        int expH = hinfo[c] >> 8 & 0xFF;
        if (l == 2) {
            if (expH > 0) {
                return false;
            }
            grinvDiffer[v] = true;
        }
        int[] g = new int[2];
        int n = 0;
        int numberOfDoubleBonds = 0;
        for (int i = 0; i < l; ++i) {
            MolBond b = a.getBond(i);
            int t = b.getType();
            int idx = an[i];
            if (idx != oidx && (t < 2 || t == 4)) {
                if (l > 2) {
                    MolAtom al = a.getLigand(i);
                    int atno = al.getAtno();
                    if (al.isQuery() || atno == 128 || atno == 129 || atno == 131 || atno == 132 || atno == 134) {
                        return false;
                    }
                }
                g[n++] = grinv[idx];
                continue;
            }
            ++numberOfDoubleBonds;
        }
        if (numberOfDoubleBonds > 1) {
            return false;
        }
        int n2 = v;
        grinvDiffer[n2] = grinvDiffer[n2] | g[0] != g[1];
        return true;
    }

    static MolAtom getCTLigand(int i1, int[] an, int i2, MoleculeGraph m, int[] chirality, int[] ez, int[] hinfo, int[] stereoInfo) {
        if (an.length == 2) {
            int i = an[0] == i2 ? an[1] : an[0];
            return m.getAtom(i);
        }
        boolean[] pseudo_asymm = new boolean[]{false};
        int[] anr = new int[2];
        int[] c = new int[2];
        int n = 0;
        for (int j = 0; j < 3; ++j) {
            int lidx = an[j];
            if (lidx == i2) continue;
            c[n] = i1;
            anr[n++] = lidx;
        }
        int[] order = null;
        order = chirality == null ? Parity.orderCIPConstitutional(anr, i1, m, hinfo) : Parity.orderCIPTopographical(anr, i1, m, chirality, ez, pseudo_asymm, hinfo, stereoInfo);
        if (order != null && !Parity.allEquals(order, 2)) {
            return m.getAtom(anr[Parity.minimumOf(order)]);
        }
        return null;
    }

    static int calculateChiralirtyFromOrder(int[] o, int dim, MoleculeGraph m, int idx, int[] an, int[] ringCount, boolean useOnlyFirstAtom, boolean psa) {
        if (Parity.allDifferentIn(o)) {
            int p = 0;
            if (dim < 2) {
                int[] ans = new int[an.length];
                for (int i = 0; i < an.length; ++i) {
                    MolAtom a = m.getAtom(an[i]);
                    ans[i] = Parity.isHydrogen(a) ? Integer.MAX_VALUE : (a.getAtno() == 130 ? 0x7FFFFFFE : an[i]);
                }
                ArrayTools.sortDescending(ans, o);
                MolAtom a = m.getAtom(idx);
                p = a.getFlags() & 7;
                int o4 = an.length != 4 ? -1 : o[3];
                int sign = MolAtom.paritySign(o[0], o[1], o[2], o4);
                p = sign < 0 ? p ^ 3 : p;
                p = p == 0 ? 3 : p;
            } else {
                int o4;
                int i4;
                if (an.length == 4) {
                    i4 = an[3];
                    o4 = o[3];
                } else {
                    MolAtom a = m.getAtom(idx);
                    i4 = -1;
                    o4 = Parity.isSulfoxideType(a) ? 0x7FFFFFFE : Integer.MAX_VALUE;
                }
                p = Parity.stereoCalculationTH(m, idx, an[0], an[1], an[2], i4, o[0], o[1], o[2], o4, ringCount, useOnlyFirstAtom);
            }
            int c = p & 3;
            c = c == 1 ? (psa ? 32 : 8) : (c == 2 ? (psa ? 64 : 16) : c);
            return c |= p & 4;
        }
        return 0;
    }

    static int localParityTH(MoleculeGraph m, MolAtom c, int[] ringCount, boolean useOnlyFirstAtom) {
        int i4;
        int idxatom = m.indexOf(c);
        int[] an = m.getCtab()[idxatom];
        int[] order = new int[4];
        if (an.length == 4) {
            MolAtom a = m.getAtom(an[3]);
            order[3] = Parity.isHydrogen(a) ? Integer.MAX_VALUE : (a.getAtno() == 130 ? 0x7FFFFFFE : an[3]);
            i4 = an[3];
        } else if (an.length == 3) {
            order[3] = Parity.isSulfoxideType(c) ? 0x7FFFFFFE : Integer.MAX_VALUE;
            i4 = -1;
        } else {
            return 0;
        }
        Parity.explicitHorder(m, an, order);
        return Parity.stereoCalculationTH(m, idxatom, an[0], an[1], an[2], i4, order[0], order[1], order[2], order[3], ringCount, useOnlyFirstAtom);
    }

    private static void explicitHorder(MoleculeGraph m, int[] an, int[] order) {
        MolAtom a = m.getAtom(an[0]);
        order[0] = Parity.isHydrogen(a) ? Integer.MAX_VALUE : (a.getAtno() == 130 ? 0x7FFFFFFE : an[0]);
        a = m.getAtom(an[1]);
        order[1] = Parity.isHydrogen(a) ? Integer.MAX_VALUE : (a.getAtno() == 130 ? 0x7FFFFFFE : an[1]);
        a = m.getAtom(an[2]);
        order[2] = Parity.isHydrogen(a) ? Integer.MAX_VALUE : (a.getAtno() == 130 ? 0x7FFFFFFE : an[2]);
    }

    static int localParityAL(MoleculeGraph m, MolAtom c, int[] ringCount, boolean useOnlyFirstAtom) {
        int p;
        boolean chp;
        int idxAtom = m.indexOf(c);
        int[][] ctab = m.getCtab();
        int[] f = new int[4];
        Arrays.fill(f, 0);
        int[] o = new int[4];
        int[] an = new int[4];
        int[] an_c = new int[4];
        int n = Parity.getAllenicLigandsAndBondFlags(idxAtom, an, an_c, ctab, m, f, o, useOnlyFirstAtom);
        if (n > 1) {
            if (!Parity.checkLocalALCondition(an, m, o)) {
                return 0;
            }
            Parity.rearrangeAlleneLigands(an, an_c, o, f);
            if (m.getDim() == 2) {
                for (int i = 0; i < 4; ++i) {
                    if (f[i] != 48) continue;
                    return 3;
                }
            }
        } else {
            return 0;
        }
        MolAtom a_z = c;
        MolAtom a1 = an[0] >= 0 ? m.getAtom(an[0]) : null;
        MolAtom a2 = an[1] >= 0 ? m.getAtom(an[1]) : null;
        MolAtom a3 = an[2] >= 0 ? m.getAtom(an[2]) : null;
        double z_x = a_z.getX();
        double z_y = a_z.getY();
        double z_z = a_z.getZ();
        double[][] refFrame_coords = new double[][]{{a1.getX(), a1.getY(), a1.getZ()}, {a2.getX(), a2.getY(), a2.getZ()}, {a3 == null ? 0.0 : a3.getX(), a3 == null ? 0.0 : a3.getY(), a3 == null ? 0.0 : a3.getZ()}};
        int dim = m.getDim();
        if (n == 2 && !(chp = Parity.twoImplicitHcaseCoordinateCalc(m, idxAtom, f, o, an, an_c, dim, refFrame_coords))) {
            return 0;
        }
        if (dim == 2) {
            for (int i = 0; i < 4; ++i) {
                if (f[i] != 48) continue;
                return 3;
            }
        }
        return (p = Parity.determinantToParity(dim, idxAtom, an[0], an[1], an[2], an[3], o[0], o[1], o[2], o[3], f, refFrame_coords[0][0], refFrame_coords[0][1], refFrame_coords[0][2], refFrame_coords[1][0], refFrame_coords[1][1], refFrame_coords[1][2], refFrame_coords[2][0], refFrame_coords[2][1], refFrame_coords[2][2], z_x, z_y, z_z, m, ringCount, 2)) == 3 ? 0 : p;
    }

    private static boolean twoImplicitHcaseCoordinateCalc(MoleculeGraph m, int idxAtom, int[] f, int[] o, int[] an, int[] an_c, int dim, double[][] refFrame_coords) {
        if (dim == 2 && f[0] == 0 && f[1] == 0) {
            return false;
        }
        if (dim == 2) {
            double[] coords = Parity.getWedgedProjection(idxAtom, an, an_c, f, m);
            if (f[0] > 0) {
                refFrame_coords[0][0] = coords[0];
                refFrame_coords[0][1] = coords[1];
            } else if (f[1] > 0) {
                refFrame_coords[1][0] = coords[0];
                refFrame_coords[1][1] = coords[1];
            }
        }
        if (o[2] == 0x7FFFFFFD ^ an[2] == -an[0] - 1) {
            int refIdx = 0;
            refFrame_coords[2][0] = refFrame_coords[refIdx][0];
            refFrame_coords[2][1] = refFrame_coords[refIdx][1];
            refFrame_coords[2][2] = 0.0;
            if (dim == 3) {
                DPoint3 p = Parity.mirrorPointToLine(an[refIdx], idxAtom, an_c[refIdx], m);
                refFrame_coords[2][0] = p.x;
                refFrame_coords[2][1] = p.y;
                refFrame_coords[2][2] = p.z;
            }
        } else {
            int refIdx = 1;
            refFrame_coords[2][0] = refFrame_coords[refIdx][0];
            refFrame_coords[2][1] = refFrame_coords[refIdx][1];
            refFrame_coords[2][2] = 0.0;
            if (dim == 3) {
                DPoint3 p = Parity.mirrorPointToLine(an[refIdx], idxAtom, an_c[refIdx], m);
                refFrame_coords[2][0] = p.x;
                refFrame_coords[2][1] = p.y;
                refFrame_coords[2][2] = p.z;
            }
        }
        return true;
    }

    static void rearrangeAlleneLigands(int[] an, int[] an_c, int[] o, int[] f) {
        for (int i = 0; i < 3; ++i) {
            if (an[i] >= 0) continue;
            Parity.putToTheBottom(an, i);
            Parity.putToTheBottom(an_c, i);
            Parity.putToTheBottom(o, i);
            Parity.putToTheBottom(f, i);
        }
        if (an[2] < 0 && f[3] > 0) {
            Parity.change(an, 2, 3);
            Parity.change(an_c, 2, 3);
            Parity.change(o, 2, 3);
            Parity.change(f, 2, 3);
        }
    }

    static double[] getWedgedProjection(int idx, int[] an, int[] an_c, int[] f, MoleculeGraph m) {
        int i;
        for (i = 0; i < 2 && f[i] <= 0; ++i) {
        }
        MolAtom c = m.getAtom(idx);
        MolAtom e1 = m.getAtom(an_c[i]);
        MolAtom li = m.getAtom(an[i]);
        double cx = c.getX();
        double cy = c.getY();
        double[] cli = new double[]{li.getX() - cx, li.getY() - cy};
        double[] ce1 = new double[]{e1.getX() - cx, e1.getY() - cy};
        double len = cli[0] * ce1[0] + cli[1] * ce1[1];
        return new double[]{len * ce1[0] + cx, len * ce1[1] + cy};
    }

    static boolean checkLocalALCondition(int[] an, MoleculeGraph m, int[] o) {
        int sideH = 0;
        int allH = 0;
        for (int i = 0; i < 4; ++i) {
            if (i == 2) {
                sideH = 0;
            }
            if (o[i] >= 0x7FFFFFFE) {
                ++sideH;
                ++allH;
            }
            if (sideH != 2 && allH != 3) continue;
            return false;
        }
        return true;
    }

    private int parity3D(int idxAtom) {
        int paritytype = this.stereoInfo[idxAtom] & 3;
        int[] an = null;
        int[] an_c = null;
        int[] f = new int[4];
        Arrays.fill(f, 0);
        int o1 = -1;
        int o2 = -1;
        int o3 = -1;
        int o4 = -1;
        int base = -1;
        int t = -1;
        if (paritytype == 1) {
            an = this.ctab[idxAtom];
            int l = an.length;
            MolAtom c = this.mol.getAtom(idxAtom);
            f[0] = Parity.getBondFlag(this.mol.getBond(this.btab.getBondIndex(idxAtom, an[0])), c, this.useOnlyFirstAtom);
            f[1] = Parity.getBondFlag(this.mol.getBond(this.btab.getBondIndex(idxAtom, an[1])), c, this.useOnlyFirstAtom);
            f[2] = Parity.getBondFlag(this.mol.getBond(this.btab.getBondIndex(idxAtom, an[2])), c, this.useOnlyFirstAtom);
            int n = (this.hydrogenInfo[an[0]] & 0x10000) != 0 ? Integer.MAX_VALUE : (o1 = this.isLP[an[0]] ? 0x7FFFFFFE : an[0]);
            int n2 = (this.hydrogenInfo[an[1]] & 0x10000) != 0 ? Integer.MAX_VALUE : (o2 = this.isLP[an[1]] ? 0x7FFFFFFE : an[1]);
            int n3 = (this.hydrogenInfo[an[2]] & 0x10000) != 0 ? Integer.MAX_VALUE : (o3 = this.isLP[an[2]] ? 0x7FFFFFFE : an[2]);
            if (l == 4) {
                t = an[3];
                f[3] = Parity.getBondFlag(this.mol.getBond(this.btab.getBondIndex(idxAtom, t)), c, this.useOnlyFirstAtom);
                o4 = (this.hydrogenInfo[t] & 0x10000) != 0 ? Integer.MAX_VALUE : (this.isLP[t] ? 0x7FFFFFFE : t);
                base = (t << 1) + t;
            } else if (l == 3) {
                MolAtom a = this.mol.getAtom(idxAtom);
                o4 = Parity.isSulfoxideType(a) ? 0x7FFFFFFE : Integer.MAX_VALUE;
                base = (idxAtom << 1) + idxAtom;
            } else {
                return 0;
            }
            an = new int[4];
            Arrays.fill(an, -1);
            System.arraycopy(this.ctab[idxAtom], 0, an, 0, l);
        } else if (paritytype == 2) {
            an = new int[4];
            an_c = new int[4];
            int[] o = new int[4];
            int n = Parity.getAllenicLigandsAndBondFlags(idxAtom, an, an_c, this.ctab, this.mol, f, o, this.useOnlyFirstAtom);
            if (n <= 1) {
                return 0;
            }
            Parity.rearrangeAlleneLigands(an, an_c, o, f);
            o1 = o[0];
            o2 = o[1];
            o3 = o[2];
            o4 = o[3];
            base = (idxAtom << 1) + idxAtom;
        }
        if (this.mol.getDim() == 2) {
            for (int i = 0; i < 4; ++i) {
                if (f[i] != 48) continue;
                return 3;
            }
        }
        return this.stereoCalculation(idxAtom, an, an_c, o1, o2, o3, o4, base, f, paritytype);
    }

    private int stereoCalculation(int idxAtom, int[] an, int[] an_c, int o1, int o2, int o3, int o4, int base, int[] bf, int paritytype) {
        int dim = this.mol.getDim();
        int[] o = new int[]{o1, o2, o3, o4};
        double zx = this.xyz[base];
        double zy = this.xyz[base + 1];
        double zz = this.xyz[base + 2];
        base = (an[0] << 1) + an[0];
        double a1_x = this.xyz[base];
        double a1_y = this.xyz[base + 1];
        double a1_z = this.xyz[base + 2];
        base = (an[1] << 1) + an[1];
        double a2_x = this.xyz[base];
        double a2_y = this.xyz[base + 1];
        double a2_z = this.xyz[base + 2];
        double a3_x = 0.0;
        double a3_y = 0.0;
        double a3_z = 0.0;
        double[][] refFrame_coords = new double[][]{{a1_x, a1_y, a1_z}, {a2_x, a2_y, a2_z}, {a3_x, a3_y, a3_z}};
        if (an[2] >= 0) {
            base = (an[2] << 1) + an[2];
            refFrame_coords[2][0] = this.xyz[base];
            refFrame_coords[2][1] = this.xyz[base + 1];
            refFrame_coords[2][2] = this.xyz[base + 2];
        } else {
            boolean chp = Parity.twoImplicitHcaseCoordinateCalc(this.mol, idxAtom, bf, o, an, an_c, dim, refFrame_coords);
            if (!chp) {
                return 0;
            }
        }
        return Parity.determinantToParity(dim, idxAtom, an[0], an[1], an[2], an[3], o[0], o[1], o[2], o[3], bf, refFrame_coords[0][0], refFrame_coords[0][1], refFrame_coords[0][2], refFrame_coords[1][0], refFrame_coords[1][1], refFrame_coords[1][2], refFrame_coords[2][0], refFrame_coords[2][1], refFrame_coords[2][2], zx, zy, zz, this.mol, this.ringCount, paritytype);
    }

    public static DPoint3 mirrorPointToLine(int x, int p1, int p2, MoleculeGraph m) {
        DPoint3 x0 = m.getAtom(x).getLocation();
        DPoint3 x1 = m.getAtom(p1).getLocation();
        DPoint3 x2 = m.getAtom(p2).getLocation();
        DPoint3 x1_x0 = new DPoint3(x1);
        x1_x0.subtract(x0);
        DPoint3 x2_x1 = new DPoint3(x2);
        x2_x1.subtract(x1);
        double t = -(x1_x0.x * x2_x1.x + x1_x0.y * x2_x1.y + x1_x0.z * x2_x1.z) / (x2_x1.x * x2_x1.x + x2_x1.y * x2_x1.y + x2_x1.z * x2_x1.z);
        DPoint3 q = new DPoint3(t * x2_x1.x, t * x2_x1.y, t * x2_x1.z);
        q.add(x1);
        DPoint3 x0q = new DPoint3(q);
        x0q.subtract(x0);
        DPoint3 p = new DPoint3(q);
        p.add(x0q);
        return p;
    }

    private static int getBondFlag(MolBond b, MolAtom c, boolean useOnlyFirstAtom) {
        int f = b.getStereo1(c);
        if (useOnlyFirstAtom && b.getAtom1() != c) {
            f = 0;
        }
        return f;
    }

    private static int getAllenicLigandsAndBondFlags(int idx, int[] ligIdxes, int[] cLigIdxes, int[][] ctab, MoleculeGraph m, int[] f, int[] o, boolean useOnlyFirstAtom) {
        int n = 0;
        int cn = 0;
        int realLigandCount = 0;
        int[] an = ctab[idx];
        int depth = 0;
        for (int i = 0; i < an.length; ++i) {
            int wedgeCount = 0;
            int storedWedgeFlag = 0;
            int lig = an[i];
            int from = idx;
            int d = 0;
            BitSet used = new BitSet();
            do {
                used.set(lig);
                int[] an_l = ctab[lig];
                MolAtom ligand = m.getAtom(lig);
                int an_ll = an_l.length;
                if (an_ll == 2 && Parity.hasOnlyDoubleBond(ligand)) {
                    int next = Parity.getIndexNotTo(from, an_l);
                    from = lig;
                    lig = next;
                    ++d;
                    if (!used.get(lig)) continue;
                    return 0;
                }
                if (an_ll < 4) {
                    int j;
                    for (j = 0; j < an_ll; ++j) {
                        int index = an_l[j];
                        if (index == from) continue;
                        ligIdxes[n] = index;
                        int n2 = Parity.isHydrogen(m.getAtom(index)) ? (n < 2 ? Integer.MAX_VALUE : 0x7FFFFFFD) : (o[n] = index);
                        if (f != null) {
                            f[n] = Parity.getBondFlag(ligand.getBond(j), ligand, useOnlyFirstAtom);
                            if (f[n] != 0) {
                                ++wedgeCount;
                                storedWedgeFlag = f[n];
                            }
                        }
                        ++realLigandCount;
                        ++n;
                        if (cLigIdxes == null) continue;
                        cLigIdxes[cn++] = lig;
                    }
                    if (an_ll == 2) {
                        ligIdxes[n] = -ligIdxes[n - 1] - 1;
                        o[n] = n < 2 ? Integer.MAX_VALUE : 0x7FFFFFFD;
                        ++n;
                        if (cLigIdxes != null) {
                            cLigIdxes[cn++] = lig;
                        }
                    } else if (an_ll < 2) {
                        return 0;
                    }
                    if (f != null && wedgeCount == 1) {
                        for (j = 0; j < 2; ++j) {
                            if (f[n - 1 - j] != 0) continue;
                            f[n - 1 - j] = storedWedgeFlag ^ 0x30;
                        }
                    }
                    from = -1;
                    continue;
                }
                return 0;
            } while (from >= 0);
            if (i == 0) {
                depth = d;
                continue;
            }
            if (depth == d) continue;
            return 0;
        }
        return realLigandCount;
    }

    private static boolean hasOnlyDoubleBond(MolAtom a) {
        int bc = a.getBondCount();
        for (int i = 0; i < bc; ++i) {
            MolBond b = a.getBond(i);
            if (b.getType() == 2) continue;
            return false;
        }
        return true;
    }

    private static int getIndexNotTo(int idx, int[] an) {
        int l = an.length;
        for (int i = 0; i < l; ++i) {
            if (an[i] == idx) continue;
            return an[i];
        }
        return -1;
    }

    private static int stereoCalculationTH(MoleculeGraph m, int i0, int i1, int i2, int i3, int i4, int o1, int o2, int o3, int o4, int[] ringCount, boolean useOnlyFirstAtom) {
        int i;
        MolAtom c = m.getAtom(i0);
        MolAtom a_z = i4 == -1 ? c : c.getLigand(3);
        MolAtom a1 = c.getLigand(0);
        MolAtom a2 = c.getLigand(1);
        MolAtom a3 = c.getLigand(2);
        double z_x = a_z.getX();
        double z_y = a_z.getY();
        double z_z = a_z.getZ();
        double a1_x = a1.getX();
        double a1_y = a1.getY();
        double a1_z = a1.getZ();
        double a2_x = a2.getX();
        double a2_y = a2.getY();
        double a2_z = a2.getZ();
        double a3_x = a3.getX();
        double a3_y = a3.getY();
        double a3_z = a3.getZ();
        int dim = m.getDim();
        int[] f = new int[4];
        for (i = 0; i < 3; ++i) {
            f[i] = Parity.getBondFlag(c.getBond(i), c, useOnlyFirstAtom);
        }
        f[3] = i4 >= 0 ? Parity.getBondFlag(c.getBond(3), c, useOnlyFirstAtom) : -1;
        if (m.getDim() == 2) {
            for (i = 0; i < 4; ++i) {
                if (f[i] != 48) continue;
                return 3;
            }
        }
        return Parity.determinantToParity(dim, i0, i1, i2, i3, i4, o1, o2, o3, o4, f, a1_x, a1_y, a1_z, a2_x, a2_y, a2_z, a3_x, a3_y, a3_z, z_x, z_y, z_z, m, ringCount, 1);
    }

    private static int determinantToParity(int dim, int i0, int i1, int i2, int i3, int i4, int o1, int o2, int o3, int o4, int[] bf, double a1x, double a1y, double a1z, double a2x, double a2y, double a2z, double a3x, double a3y, double a3z, double zx, double zy, double zz, MoleculeGraph m, int[] ringCount, int paritytype) {
        int rot;
        MolAtom c = m.getAtom(i0);
        int unspec = c.getFlags() & 4;
        double ax = a1x - zx;
        double ay = a1y - zy;
        double az = a1z - zz;
        double bx = a2x - zx;
        double by = a2y - zy;
        double bz = a2z - zz;
        double cx = a3x - zx;
        double cy = a3y - zy;
        double cz = a3z - zz;
        int ups = 0;
        int downs = 0;
        if (dim == 2) {
            zz = 0.0;
            int f = bf[3];
            if (i4 >= 0 && f != 0) {
                if (f == 16) {
                    zz = 1.0;
                    ++ups;
                } else if (f == 32) {
                    zz = -1.0;
                    ++downs;
                } else if (f == 48) {
                    return 3;
                }
            }
            az = -zz;
            f = bf[0];
            if (f != 0) {
                if (f == 16) {
                    az += 1.0;
                    ++ups;
                } else if (f == 32) {
                    az -= 1.0;
                    ++downs;
                } else if (f == 48) {
                    return 3;
                }
            }
            bz = -zz;
            f = bf[1];
            if (f != 0) {
                if (f == 16) {
                    bz += 1.0;
                    ++ups;
                } else if (f == 32) {
                    bz -= 1.0;
                    ++downs;
                } else if (f == 48) {
                    return 3;
                }
            }
            cz = -zz;
            f = bf[2];
            if (f != 0) {
                if (f == 16) {
                    cz += 1.0;
                    ++ups;
                } else if (f == 32) {
                    cz -= 1.0;
                    ++downs;
                } else if (f == 48) {
                    return 3;
                }
            }
            if (paritytype == 1 && i4 < 0) {
                if (cz != 0.0 && ax * by == ay * bx && ax * bz == az * bx) {
                    az = -cz;
                    bz = -cz;
                } else if (bz != 0.0 && ax * cy == ay * cx && ax * cz == az * cx) {
                    az = -bz;
                    cz = -bz;
                } else if (az != 0.0 && bx * cy == by * cx && bx * cz == bz * cx) {
                    bz = -az;
                    cz = -az;
                }
            }
            if (ups == 0 && downs == 0) {
                return 3;
            }
            if (ups == 4 || downs == 4) {
                return 3;
            }
            if (paritytype == 1 && (i4 >= 0 ? ups != 3 && downs != 3 && ups + downs > 1 : ups != 0 && downs != 0)) {
                return Parity.keepOneWedgeOnly(dim, i0, i1, i2, i3, i4, o1, o2, o3, o4, bf, a1x, a1y, a1z, a2x, a2y, a2z, a3x, a3y, a3z, zx, zy, zz, m, ringCount);
            }
        }
        if ((rot = Parity.determinantToParity(ax, ay, az, bx, by, bz, cx, cy, cz, dim)) == 3) {
            return 3;
        }
        int sign = MolAtom.paritySign(o1, o2, o3, o4);
        if (rot < 0) {
            sign = -sign;
        }
        return sign > 0 ? 2 | unspec : (sign < 0 ? 1 | unspec : 3);
    }

    static int determinantToParity(double ax, double ay, double az, double bx, double by, double bz, double cx, double cy, double cz, int dim) {
        double rot;
        double ab_x = ay * bz - az * by;
        double ab_y = az * bx - ax * bz;
        double ab_z = ax * by - ay * bx;
        double ac_x = ay * cz - az * cy;
        double ac_y = az * cx - ax * cz;
        double ac_z = ax * cy - ay * cx;
        double a_sq = ax * ax + ay * ay + az * az;
        double b_sq = bx * bx + by * by + bz * bz;
        double c_sq = cx * cx + cy * cy + cz * cz;
        if (dim > 2) {
            double dz;
            double dy;
            double ac_l;
            double ab_sq = ab_x * ab_x + ab_y * ab_y + ab_z * ab_z;
            double ac_sq = ac_x * ac_x + ac_y * ac_y + ac_z * ac_z;
            double ab_l = Math.sqrt(ab_sq);
            double dx = ab_x / ab_l - ac_x / (ac_l = Math.sqrt(ac_sq));
            double distance = Math.sqrt(dx * dx + (dy = ab_y / ab_l - ac_y / ac_l) * dy + (dz = ab_z / ab_l - ac_z / ac_l) * dz);
            double d = distance = distance < Math.abs(distance - 2.0) ? distance : Math.abs(distance - 2.0);
            if (distance < 0.1) {
                return 3;
            }
        }
        if ((rot = ab_x * cx + ab_y * cy + ab_z * cz) * rot < 1.0E-16 * a_sq * b_sq * c_sq) {
            return 3;
        }
        return rot > 0.0 ? 1 : -1;
    }

    private static int keepOneWedgeOnly(int dim, int i0, int i1, int i2, int i3, int i4, int o1, int o2, int o3, int o4, int[] f, double a1x, double a1y, double a1z, double a2x, double a2y, double a2z, double a3x, double a3y, double a3z, double zx, double zy, double zz, MoleculeGraph m, int[] ringCount) {
        int parity;
        int[] fn = new int[4];
        int[] p = new int[4];
        int n = 0;
        if (f[0] > 0) {
            fn[0] = f[0];
            fn[3] = 0;
            fn[2] = 0;
            fn[1] = 0;
            p[n++] = Parity.determinantToParity(dim, i0, i1, i2, i3, i4, o1, o2, o3, o4, fn, a1x, a1y, a1z, a2x, a2y, a2z, a3x, a3y, a3z, zx, zy, zz, m, ringCount, 1);
        }
        if (f[1] > 0) {
            fn[1] = f[1];
            fn[3] = 0;
            fn[2] = 0;
            fn[0] = 0;
            p[n++] = Parity.determinantToParity(dim, i0, i1, i2, i3, i4, o1, o2, o3, o4, fn, a1x, a1y, a1z, a2x, a2y, a2z, a3x, a3y, a3z, zx, zy, zz, m, ringCount, 1);
        }
        if (f[2] > 0) {
            fn[2] = f[2];
            fn[3] = 0;
            fn[1] = 0;
            fn[0] = 0;
            p[n++] = Parity.determinantToParity(dim, i0, i1, i2, i3, i4, o1, o2, o3, o4, fn, a1x, a1y, a1z, a2x, a2y, a2z, a3x, a3y, a3z, zx, zy, zz, m, ringCount, 1);
        }
        if (f[3] > 0) {
            fn[3] = f[3];
            fn[2] = 0;
            fn[1] = 0;
            fn[0] = 0;
            p[n++] = Parity.determinantToParity(dim, i0, i1, i2, i3, i4, o1, o2, o3, o4, fn, a1x, a1y, a1z, a2x, a2y, a2z, a3x, a3y, a3z, zx, zy, zz, m, ringCount, 1);
        }
        int n2 = parity = Parity.allEquals(p, n) ? p[0] : 3;
        if (parity == 3 && ringCount != null && ringCount[i0] > 1) {
            fn[0] = ringCount[i1] > 0 ? 0 : f[0];
            fn[1] = ringCount[i2] > 0 ? 0 : f[1];
            fn[2] = ringCount[i3] > 0 ? 0 : f[2];
            int n3 = fn[3] = i4 >= 0 && ringCount[i4] > 0 ? 0 : f[3];
            if (fn[0] == f[0] && fn[1] == f[1] && fn[2] == f[2] && fn[3] == f[3]) {
                return parity;
            }
            parity = Parity.determinantToParity(dim, i0, i1, i2, i3, i4, o1, o2, o3, o4, fn, a1x, a1y, a1z, a2x, a2y, a2z, a3x, a3y, a3z, zx, zy, zz, m, ringCount, 1);
        }
        return parity;
    }

    static boolean hasEqualGriv(int[] an, int[] g) {
        int d;
        int a = g[an[0]];
        int b = g[an[1]];
        int c = g[an[2]];
        if (an.length == 4 && (a == (d = g[an[3]]) || b == d || c == d)) {
            return true;
        }
        return a == b || a == c || b == c;
    }

    static boolean isDegenerateRingatom(int[] an, int[] g) {
        int d;
        int a = g[an[0]];
        int b = g[an[1]];
        int c = g[an[2]];
        if (an.length == 4 && (a == (d = g[an[3]]) && b == d || a == d && c == d || b == d && c == d)) {
            return true;
        }
        return a == b && a == c;
    }

    private static int equalGrinvinRing(int i, int[] an, BondTable btab, int[] g, boolean[] inR) {
        int l = an.length;
        int equalR = 0;
        for (int j = 0; j < l; ++j) {
            int g2;
            int bidx2;
            int idx2;
            int k;
            int idx1 = an[j];
            int bidx = btab.getBondIndex(i, idx1);
            int g1 = g[idx1];
            if (inR[bidx]) {
                for (k = j + 1; k < l; ++k) {
                    idx2 = an[k];
                    bidx2 = btab.getBondIndex(i, idx2);
                    if (!inR[bidx2] || g1 != (g2 = g[idx2])) continue;
                    ++equalR;
                }
                continue;
            }
            for (k = j + 1; k < l; ++k) {
                idx2 = an[k];
                bidx2 = btab.getBondIndex(i, idx2);
                if (inR[bidx2] || g1 != (g2 = g[idx2])) continue;
                return -1;
            }
        }
        return equalR + 1;
    }

    private void reset() {
        this.mol = null;
        this.xyz = null;
        this.grinv = null;
        this.stereoInfo = null;
        this.parity0D = null;
        this.parity3D = null;
        this.chirality = null;
        this.ctab = null;
        this.btab = null;
        this.stereocalculated = false;
        this.axchiralityCalculated = false;
        this.arommol = null;
        this.ringCount = null;
    }

    public void setMolecule(MoleculeGraph m) {
        MolAtom atom;
        int i;
        this.reset();
        m.valenceCheck();
        this.origmol = m;
        int dim = m.getDim();
        this.bondIndexToExpanded = new int[m.getBondCount()];
        this.atomIndexToExpanded = new int[m.getAtomCount()];
        this.mol = Parity.expandSgroup(m, this.bondIndexToExpanded, this.atomIndexToExpanded);
        int ac = this.mol.getAtomCount();
        int ec = this.mol.getBondCount();
        this.ctab = this.mol.getCtab();
        this.btab = this.mol.getBondTable();
        this.ringCount = new int[ac];
        this.isRingBond = new boolean[ec];
        this.atomInSmallestRing = new int[ac];
        this.hydrogenInfo = new int[ac];
        this.stereoInfo = new int[ac];
        if (ac < 4) {
            if (dim == 0) {
                this.parity0D = new int[ac];
            }
            this.lastGrinvCC = this.origmol.getGrinvCC();
            return;
        }
        int[] storedParity = new int[ac];
        if (dim == 0) {
            for (int i2 = 0; i2 < ac; ++i2) {
                int p;
                storedParity[i2] = p = this.mol.getAtom(i2).getFlags() & 7;
            }
            this.parity0D = new int[ac];
        }
        int[] bondInSmallestRing = new int[ec];
        ArrayList<BitSet> atomIdxSet = new ArrayList<BitSet>();
        Parity.calculateRingCount(this.mol, this.ringCount, this.isRingBond, this.atomInSmallestRing, atomIdxSet);
        this.grinv = new int[ac];
        this.mol.getGrinv(this.grinv, 3);
        if (dim != 0) {
            this.isLP = new boolean[ac];
            this.xyz = new double[(ac << 1) + ac];
            this.parity3D = new int[ac];
        }
        this.chirality = new int[ac];
        int[] allenicC = new int[ac];
        for (i = 0; i < ac; ++i) {
            atom = this.mol.getAtom(i);
            int atno = atom.getAtno();
            boolean canhTHpar = true;
            int[] an = this.ctab[i];
            int nLigands = an.length;
            int eH = 0;
            int dbC = 0;
            for (int j = 0; j < nLigands; ++j) {
                MolAtom a = this.mol.getAtom(an[j]);
                if (a.getAtno() == 1 && a.getMassno() == 0) {
                    ++eH;
                }
                MolBond b = atom.getBond(j);
                if (atno != 6 || b.getType() != 2 || a.getAtno() != 6) continue;
                ++dbC;
            }
            if (dbC == 2 && nLigands == 2) {
                allenicC[i] = 1;
                continue;
            }
            int iH = atom.getImplicitHcount();
            int lp = (atno == 16 || atno == 15) && an.length == 3 ? 1 : 0;
            boolean bl = canhTHpar = iH + eH < 2 && nLigands + iH + lp == 4 && Parity.bondConditionForParity(atom);
            if (atno == 7) {
                canhTHpar |= Parity.checkFixedN(atom, i, this.btab, this.ctab, this.ringCount, this.isRingBond, this.atomInSmallestRing, bondInSmallestRing);
            }
            if (!canhTHpar) continue;
            int n = i;
            this.stereoInfo[n] = this.stereoInfo[n] | (canhTHpar ? 9 : 0);
            int ringc = this.ringCount[i];
            if (ringc != 0) {
                int n2 = i;
                this.stereoInfo[n2] = this.stereoInfo[n2] | 0x40;
                if (ringc > 2 && Parity.isDegenerateRingatom(an, this.grinv)) {
                    this.stereoInfo[i] = 0;
                    continue;
                }
            }
            if (Parity.hasEqualGriv(an, this.grinv)) {
                int n3 = i;
                this.stereoInfo[n3] = this.stereoInfo[n3] | 0x10;
            } else {
                int n4 = i;
                this.stereoInfo[n4] = this.stereoInfo[n4] | 4;
            }
            if (dim == 0) {
                int f = atom.getFlags() & 7;
                if (f == 0) continue;
                int n5 = i;
                this.stereoInfo[n5] = this.stereoInfo[n5] | 0x200;
                continue;
            }
            if (dim == 2) {
                if (this.useOnlyFirstAtom) {
                    if (!Parity.hasWedge(atom)) continue;
                    int n6 = i;
                    this.stereoInfo[n6] = this.stereoInfo[n6] | 0x220;
                    continue;
                }
                if (!atom.hasWedgedBond()) continue;
                int n7 = i;
                this.stereoInfo[n7] = this.stereoInfo[n7] | 0x220;
                continue;
            }
            int n8 = i;
            this.stereoInfo[n8] = this.stereoInfo[n8] | 0x200;
        }
        Parity.setSpiroAtoms(this.stereoInfo, atomIdxSet);
        Parity.assignAlleneParity(this.ctab, this.stereoInfo, allenicC, this.grinv);
        Parity.checkTopographicTHAtoms(this.stereoInfo, this.grinv, this.ctab);
        Parity.checkTopographicRingAtoms(this.stereoInfo, this.grinv, this.ctab, this.btab, this.isRingBond);
        for (i = 0; i < ac; ++i) {
            boolean canhALpar;
            atom = this.mol.getAtom(i);
            boolean canhTHpar = (this.stereoInfo[i] & 8) > 0 || (this.stereoInfo[i] & 0x800) > 0;
            boolean bl = canhALpar = (this.stereoInfo[i] & 3) == 2;
            if (dim == 0) {
                int par = storedParity[i];
                this.parity0D[i] = canhTHpar || canhALpar ? (par == 0 ? 3 : par) : 0;
                continue;
            }
            int n = i;
            this.hydrogenInfo[n] = this.hydrogenInfo[n] | (Parity.isHydrogen(atom) ? 65536 : 0);
            boolean bl2 = this.isLP[i] = atom.getAtno() == 130;
            if (!canhTHpar) {
                int n9 = i;
                this.stereoInfo[n9] = this.stereoInfo[n9] & 0xFFFFFFDF;
            }
            int offset = (i << 1) + i;
            this.xyz[offset] = atom.getX();
            this.xyz[offset + 1] = atom.getY();
            this.xyz[offset + 2] = atom.getZ();
        }
        if (dim != 0) {
            boolean d3 = dim == 3;
            int p = 0;
            for (int i3 = 0; i3 < ac; ++i3) {
                boolean canhTHpar;
                int pt = this.stereoInfo[i3] & 3;
                boolean bl = canhTHpar = (this.stereoInfo[i3] & 8) > 0 || (this.stereoInfo[i3] & 0x800) > 0;
                if (pt == 1 && canhTHpar) {
                    this.parity3D[i3] = d3 ? ((p = this.parity3D(i3)) == 0 ? 3 : p) : ((this.stereoInfo[i3] & 0x20) > 0 ? this.parity3D(i3) : 3);
                    continue;
                }
                if (pt != 2) continue;
                p = this.parity3D(i3);
                this.parity3D[i3] = p == 0 ? 3 : p;
            }
        }
        this.lastGrinvCC = this.origmol.getGrinvCC();
    }

    static void replaceDoubleBondsForTH(MoleculeGraph m) {
        int ac = m.getAtomCount();
        for (int i = 0; i < ac; ++i) {
            MolAtom a = m.getAtom(i);
            int bc = a.getBondCount();
            if (bc != 4) continue;
            for (int j = bc - 1; j >= 0; --j) {
                MolBond b = a.getBond(j);
                if (b.getType() <= 1) continue;
                b.setType(1);
            }
        }
    }

    private static void checkTopographicTHAtoms(int[] si, int[] g, int[][] ctab) {
        int l = si.length;
        int[] caninv = new int[l];
        int[] idxes = new int[l];
        boolean changed = false;
        do {
            int i;
            int i2;
            changed = false;
            for (i2 = 0; i2 < l; ++i2) {
                idxes[i2] = i2;
                caninv[i2] = g[i2] * l;
            }
            ArrayTools.sortDescending(caninv, idxes);
            for (i2 = 0; i2 < l; ++i2) {
                int idx = idxes[i2];
                int n = 1;
                int g1 = caninv[i2];
                int info = si[idx];
                boolean stereo = (info & 8) > 0 && (info & 0x200) == 0;
                ++i2;
                while (i2 < l && stereo && g1 == caninv[i2]) {
                    int n2 = i2++;
                    caninv[n2] = caninv[n2] + n++;
                }
                --i2;
            }
            long[] ci = new long[l];
            for (i = 0; i < l; ++i) {
                ci[idxes[i]] = caninv[i];
            }
            GraphInvariants.makeRanks(ctab, ci, caninv, true);
            for (i = 0; i < l; ++i) {
                int[] an;
                boolean canbech;
                boolean bl = canbech = (si[i] & 8) > 0;
                if (!canbech || !Parity.hasEqualGriv(an = ctab[i], caninv)) continue;
                int n = i;
                si[n] = si[n] & 0xFFFFFFF7;
                changed = true;
            }
        } while (changed);
    }

    private static void checkTopographicRingAtoms(int[] si, int[] g, int[][] ctab, BondTable btab, boolean[] rb) {
        int info;
        int i;
        int l = si.length;
        for (i = 0; i < l; ++i) {
            int eqgrr;
            info = si[i];
            if ((info & 0x40) == 0 || (info & 1) == 0 || (info & 8) != 0 || (eqgrr = Parity.equalGrinvinRing(i, ctab[i], btab, g, rb)) != 2) continue;
            int n = i;
            si[n] = si[n] | 0x88;
        }
        i = 0;
        while (i < l) {
            info = si[i];
            if ((info & 0x40) != 0 && (info & 0x80) != 0 && (info & 0x100) == 0) {
                Parity.hasFacingChiralNode(i, ctab, btab, g, rb, si);
            }
            int n = i++;
            si[n] = si[n] & 0xFFFFFEFF;
        }
    }

    private static boolean hasFacingChiralNode(int idx, int[][] ctab, BondTable btab, int[] g, boolean[] rb, int[] si) {
        int l = ctab.length;
        BitSet used = new BitSet(l);
        BitSet start = new BitSet(l);
        BitSet spiro = (si[idx] & 0x200) > 0 ? new BitSet(l) : null;
        int[] next = new int[l];
        int[] an = ctab[idx];
        for (int i = 0; i < an.length; ++i) {
            int lidx = an[i];
            if (Parity.isUnique(i, an, g)) continue;
            start.set(lidx);
        }
        used.set(idx);
        boolean chiralFacingnode = false;
        while (!(chiralFacingnode = Parity.stepBranch(start, used, spiro, next, ctab, btab, rb, si)) && start.cardinality() > 0) {
        }
        if (!chiralFacingnode) {
            int n = idx;
            si[n] = si[n] & 0xFFFFFFF7;
        } else if (spiro != null) {
            int i = spiro.nextSetBit(0);
            while (i >= 0) {
                int n = i;
                si[n] = si[n] | 0x800;
                i = spiro.nextSetBit(i + 1);
            }
        }
        return chiralFacingnode;
    }

    private static boolean stepBranch(BitSet start, BitSet used, BitSet spiro, int[] next, int[][] ctab, BondTable btab, boolean[] rb, int[] si) {
        boolean hasChiralFacingNode = false;
        int i = start.nextSetBit(0);
        while (i >= 0) {
            for (int idx : ctab[i]) {
                if (used.get(idx)) continue;
                int bidx = btab.getBondIndex(i, idx);
                if (rb[bidx]) {
                    int n = idx;
                    next[n] = next[n] + 1;
                }
                if (spiro == null || (si[idx] & 0x400) <= 0) continue;
                spiro.set(idx);
            }
            i = start.nextSetBit(i + 1);
        }
        start.clear();
        int l = next.length;
        for (int i2 = 0; i2 < l; ++i2) {
            int pathCount = next[i2];
            if (pathCount <= 0) continue;
            if ((si[i2] & 8) != 0) {
                if (pathCount == 2) {
                    hasChiralFacingNode = true;
                    int n = i2;
                    si[n] = si[n] | 0x100;
                    if (spiro != null && (si[i2] & 0x200) == 0) {
                        spiro.clear();
                    }
                } else if (pathCount > 2) {
                    int n = i2;
                    si[n] = si[n] & 0xFFFFFFF7;
                    int n2 = i2;
                    si[n2] = si[n2] | 0x100;
                }
            }
            used.set(i2);
            start.set(i2);
            next[i2] = 0;
        }
        return hasChiralFacingNode;
    }

    static void setSpiroAtoms(int[] si, ArrayList<BitSet> ais) {
        BitSet t = new BitSet(si.length);
        int sssrCount = ais.size();
        for (int i = 0; i < sssrCount; ++i) {
            BitSet s1 = ais.get(i);
            for (int j = i + 1; j < sssrCount; ++j) {
                int idx;
                t.clear();
                BitSet s2 = ais.get(j);
                t.or(s2);
                t.and(s1);
                if (t.cardinality() != 1) continue;
                int n = idx = t.nextSetBit(0);
                si[n] = si[n] | 0x400;
            }
        }
    }

    static boolean isUnique(int x, int[] an, int[] g) {
        int l = an.length;
        int gx = g[an[x]];
        for (int i = 0; i < l; ++i) {
            int idx;
            int gidx;
            if (i == x || gx != (gidx = g[idx = an[i]])) continue;
            return false;
        }
        return true;
    }

    private static void assignAlleneParity(int[][] ctab, int[] stereoInfo, int[] allenicC, int[] grinv) {
        int lig;
        int i;
        int ac = ctab.length;
        boolean changed = false;
        int level = 1;
        BitSet s_0 = null;
        BitSet s_1 = null;
        do {
            changed = false;
            s_0 = s_1;
            s_1 = new BitSet();
            for (i = 0; i < ac; ++i) {
                if (allenicC[i] < level) continue;
                int[] an = ctab[i];
                int n = 0;
                for (int j = 0; j < an.length && n < 2; ++j) {
                    lig = an[j];
                    if (allenicC[lig] < level) continue;
                    ++n;
                }
                if (n != 2) continue;
                int n2 = i;
                allenicC[n2] = allenicC[n2] + 1;
                changed = true;
                s_1.set(i);
            }
            ++level;
        } while (changed && (s_0 == null || !s_1.equals(s_0)));
        for (i = 0; i < ac; ++i) {
            int alc = allenicC[i];
            if (ctab[i].length != 2 || alc <= 0) continue;
            boolean setP = true;
            int[] an = ctab[i];
            for (int j = 0; j < an.length; ++j) {
                int lig2 = an[j];
                if (allenicC[lig2] < alc) continue;
                setP = false;
                break;
            }
            if (!setP) continue;
            int n = i;
            stereoInfo[n] = stereoInfo[n] | 2;
        }
        block5: for (i = 0; i < ac; ++i) {
            if ((stereoInfo[i] & 2) <= 0) continue;
            int alc = allenicC[i];
            int[] an = ctab[i];
            for (int k = 0; k < 2; ++k) {
                lig = an[k];
                int from = i;
                int[] an_l = ctab[lig];
                int l = an_l.length;
                for (int j = 0; j < alc - 1; ++j) {
                    an_l = ctab[lig];
                    if (l != 2) {
                        int n = i;
                        stereoInfo[n] = stereoInfo[n] & 0xFFFFFFFD;
                        break;
                    }
                    if (an_l[0] == from) {
                        from = lig;
                        lig = an_l[1];
                        continue;
                    }
                    from = lig;
                    lig = an_l[0];
                }
                int[] grinvs = new int[l];
                for (int m = 0; m < l; ++m) {
                    grinvs[m] = grinv[an_l[m]];
                }
                if (!Parity.allDifferentIn(grinvs)) {
                    int n = i;
                    stereoInfo[n] = stereoInfo[n] & 0xFFFFFFFD;
                    continue block5;
                }
                if ((stereoInfo[i] & 3) == 0) continue block5;
            }
        }
    }

    private static MoleculeGraph expandSgroup(MoleculeGraph m, int[] bondIndexToExpanded, int[] atomIndexToExpanded) {
        MoleculeGraph mol = null;
        int dim = m.getDim();
        if (dim != 0 && m instanceof Molecule && ((Molecule)m).isExpandable(0)) {
            Molecule molecule = (Molecule)m;
            Molecule expandedMol = (Molecule)molecule.clone();
            SelectionMolecule origMol = new SelectionMolecule();
            expandedMol.clonelesscopy(origMol);
            expandedMol.setGUIContracted(false);
            Parity.createConversionIndexes(origMol, expandedMol, bondIndexToExpanded, atomIndexToExpanded);
            mol = expandedMol;
        } else {
            mol = m;
        }
        return mol;
    }

    static void createConversionIndexes(SelectionMolecule m, Molecule me, int[] bondIndex, int[] atomIndex) {
        int ac = m.getAtomCount();
        for (int i = 0; i < ac; ++i) {
            MolAtom a = m.getAtom(i);
            atomIndex[i] = me.indexOf(a);
        }
        int ec = m.getBondCount();
        for (int i = 0; i < ec; ++i) {
            MolBond b = m.getBond(i);
            bondIndex[i] = me.indexOf(b);
        }
    }

    static void copyInfoToOriginal(MoleculeGraph from, MoleculeGraph to, int[] aidx, int[] bidx, boolean[] swap) {
        if (from == to) {
            return;
        }
        int dim = from.getDim();
        if (dim == 0) {
            for (int i = to.getAtomCount() - 1; i >= 0; --i) {
                MolAtom t = to.getAtom(i);
                MolAtom f = from.getAtom(aidx[i]);
                t.setFlags(f.getFlags(), 7);
            }
            to.incGrinvCCOnly();
        } else if (dim == 2) {
            for (int i = to.getBondCount() - 1; i >= 0; --i) {
                if (bidx[i] < 0) continue;
                MolBond t = to.getBond(i);
                MolBond f = from.getBond(bidx[i]);
                if (swap != null && swap[bidx[i]]) {
                    t.swap();
                }
                t.setFlags(f.getFlags(), 48);
            }
        }
    }

    private static boolean parityCheck(int n, int[] c, int[] parity, MoleculeGraph m) {
        for (int i = 0; i <= n; ++i) {
            int p = parity[c[i]];
            p = p == 3 ? 0 : p;
            int lp = m.getLocalParity(c[i]);
            int n2 = lp = lp == 3 ? 0 : lp;
            if (p == lp) continue;
            return false;
        }
        return true;
    }

    static int[] orderCIPConstitutional(int[] an, int c, MoleculeGraph m, int[] hinfo) {
        int[][] ctab = m.getCtab();
        int level = 1;
        boolean ready = false;
        boolean leavesGenerated = true;
        BitSet used = new BitSet(m.getAtomCount());
        DiGraphElement graph = new DiGraphElement(m.getAtom(c), c);
        while (!ready && (leavesGenerated = Parity.generateDigraph(graph, level, c, -1, m, ctab, used, null, null, c, hinfo, 0))) {
            if (level == 1) {
                Parity.removeBranch(graph, an);
            }
            if (!(ready = Parity.compareLevel(graph, level, null, 2)) && level > 1) {
                Parity.resetAtomsAtAtoms(graph, level, false, null, null);
            }
            ++level;
        }
        if (!leavesGenerated) {
            return null;
        }
        int[] order = new int[an.length];
        for (int i = 0; i < an.length; ++i) {
            MolAtom a = m.getAtom(an[i]);
            order[i] = graph.getBranch(a).getOrder();
        }
        return order;
    }

    static void removeBranch(DiGraphElement g, int[] an) {
        DiGraphElement[] branches = g.getBranches();
        int n = 0;
        if (branches != null) {
            int l = branches.length;
            for (int i = 0; i < l; ++i) {
                if (branches[i] == null) continue;
                int idx = branches[i].getIdx();
                if (idx >= 0 && !Parity.contains(an, idx)) {
                    branches[i] = null;
                    continue;
                }
                ++n;
            }
            DiGraphElement[] br = new DiGraphElement[n];
            n = 0;
            for (int i = 0; i < l; ++i) {
                if (branches[i] == null) continue;
                br[n++] = branches[i];
            }
            g.setBranches(br);
        }
    }

    static int[] orderCIPConstitutionalAL(int[] an, int[] c, MoleculeGraph m, int cc, int[] hinfo) {
        int[][] ctab = m.getCtab();
        int level = 1;
        boolean ready = false;
        BitSet used = new BitSet(m.getAtomCount());
        DiGraphElement graph = new DiGraphElement(m.getAtom(cc), cc);
        DiGraphElement[] branch = new DiGraphElement[an.length];
        for (int i = 0; i < an.length; ++i) {
            int idx = an[i];
            if (idx >= 0) {
                MolAtom a = m.getAtom(idx);
                branch[i] = new DiGraphElement(a, idx, 0, 0, null);
                used.set(idx);
            } else {
                branch[i] = new DiGraphElement(1);
            }
            used.set(c[i]);
        }
        graph.setBranches(branch);
        ready = Parity.compareLevel(graph, level, c, 2);
        ++level;
        if (!ready) {
            Parity.resetAtomsAtAtoms(graph, level, false, null, null);
        }
        while (!ready && Parity.recurseDigraphGeneration(graph, level, c, m, ctab, used, null, null, 0, hinfo)) {
            ready = Parity.compareLevel(graph, level, null, 2);
            if (!ready && level > 1) {
                Parity.resetAtomsAtAtoms(graph, level, false, null, null);
            }
            ++level;
        }
        int[] order = new int[an.length];
        for (int i = 0; i < an.length; ++i) {
            int idx = an[i];
            if (idx >= 0) {
                MolAtom a = m.getAtom(an[i]);
                order[i] = graph.getBranch(a).getOrder();
                continue;
            }
            order[i] = 4;
        }
        return order;
    }

    static int[] orderCIPTopographical(int[] an, int c, MoleculeGraph m, int[] chirality, int[] ez, boolean[] psa, int[] hinfo, int[] stereoInfo) {
        int type = 3;
        int[][] ctab = m.getCtab();
        int level = 1;
        BitSet usedPL = new BitSet(m.getAtomCount());
        BitSet usedAL = new BitSet(m.getAtomCount());
        int[] fan = ctab[c];
        for (int i = 0; i < fan.length; ++i) {
            if (Parity.contains(an, fan[i])) continue;
            usedPL.set(fan[i]);
            usedAL.set(fan[i]);
        }
        DiGraphElement graph = new DiGraphElement(m.getAtom(c), c);
        while (Parity.generateDigraph(graph, level, c, -1, m, ctab, usedPL, usedAL, chirality, ez, c, hinfo, type, stereoInfo)) {
            Parity.compareLevel(graph, level, null, 2);
            if (level > 1) {
                Parity.resetAtomsAtAtoms(graph, level, true, usedPL, usedAL);
            }
            Parity.resetGraph(graph, level, m);
            ++level;
        }
        Parity.digraphTopoComparison(graph, level, psa);
        int[] order = new int[an.length];
        for (int i = 0; i < an.length; ++i) {
            MolAtom a = m.getAtom(an[i]);
            order[i] = graph.getBranch(a).getOrder();
        }
        return order;
    }

    private static void resetGraph(DiGraphElement g, int level, MoleculeGraph m) {
        int[] count = new int[m.getAtomCount()];
        Parity.setCountAtLevel(g, count, level - 1);
        ArrayList<DiGraphElement> commonIndexes = new ArrayList<DiGraphElement>();
        Parity.addCommonElements(g, count, commonIndexes);
        int size = commonIndexes.size();
        for (int i = 0; i < size; ++i) {
            DiGraphElement e = commonIndexes.get(i);
            DiGraphElement[] b = e.getBranches();
            if (b == null) continue;
            int l = b.length;
            for (int j = 0; j < l; ++j) {
                if (b[j] == null) continue;
                b[j].setIdx(-1);
            }
        }
    }

    private static void setCountAtLevel(DiGraphElement g, int[] c, int level) {
        DiGraphElement[] b = g.getBranches();
        if (b != null) {
            int l = b.length;
            for (int i = 0; i < l; ++i) {
                if (b[i] == null) continue;
                if (level == 1) {
                    int idx = b[i].getIdx();
                    if (idx < 0) continue;
                    int n = idx;
                    c[n] = c[n] + 1;
                    continue;
                }
                Parity.setCountAtLevel(b[i], c, level - 1);
            }
        }
    }

    private static void addCommonElements(DiGraphElement g, int[] count, ArrayList<DiGraphElement> cI) {
        DiGraphElement[] b = g.getBranches();
        if (b != null) {
            int l = b.length;
            for (int i = 0; i < l; ++i) {
                int idx;
                if (b[i] == null || (idx = b[i].getIdx()) < 0) continue;
                if (count[idx] > 1) {
                    cI.add(b[i]);
                    continue;
                }
                Parity.addCommonElements(b[i], count, cI);
            }
        }
    }

    private static boolean generateDigraph(DiGraphElement g, int level, int c, int f, MoleculeGraph m, int[][] ctab, BitSet used, int[] ch, int[] ez, int cc, int[] hydrogenInfo, int type) {
        return Parity.generateDigraph(g, level, c, f, m, ctab, used, null, ch, ez, cc, hydrogenInfo, type, null);
    }

    private static boolean generateDigraph(DiGraphElement g, int level, int c, int f, MoleculeGraph m, int[][] ctab, BitSet usedPL, BitSet usedAL, int[] ch, int[] ez, int cc, int[] hydrogenInfo, int type, int[] stereoInfo) {
        boolean digraphGenerated = false;
        boolean newElementCollision = false;
        usedPL.set(c);
        if (usedAL != null) {
            usedAL.set(c);
        }
        MolAtom a = m.getAtom(c);
        int ll = a.getBondCount();
        if (level == 1) {
            int i;
            int bl = ll;
            if (f != -1) {
                --bl;
            }
            int impH = hydrogenInfo[c] & 0xFF;
            bl += impH;
            if ((type & 1) == 0 && c != cc) {
                bl += Parity.numberOfImplicitAtoms(a, m.getAtom(cc), m.getAtom(f));
            }
            if (bl == 0) {
                if ((type & 1) == 0) {
                    usedPL.clear(c);
                }
                return false;
            }
            DiGraphElement[] branch = new DiGraphElement[bl];
            int n = 0;
            int[] an = ctab[c];
            for (i = 0; i < ll; ++i) {
                int idx = an[i];
                MolAtom l = m.getAtom(idx);
                if (idx == f) continue;
                int chi = 0;
                if (ch != null) {
                    chi = ch[idx];
                }
                int ezi = 0;
                if (ez != null) {
                    ezi = ez[idx];
                }
                if (!usedPL.get(idx)) {
                    chi &= 0x18;
                    int n2 = chi = stereoInfo == null || (stereoInfo[idx] & 4) != 0 ? 0 : chi;
                    if (chi == 0 && (type & 2) != 0) {
                        int aux;
                        chi = aux = Parity.generateAuxStereo(idx, l, g, cc, ch, ez, m, hydrogenInfo);
                    }
                    branch[n++] = new DiGraphElement(l, idx, chi, ezi, g);
                    if (usedAL == null) continue;
                    if (usedAL.get(idx)) {
                        newElementCollision = true;
                    }
                    usedAL.set(idx);
                    continue;
                }
                branch[n++] = new DiGraphElement(l, -1, chi, ezi, true);
            }
            if (c != cc && (type & 1) == 0) {
                int aromAtno = 0;
                int aromBondCount = 0;
                for (int i2 = 0; i2 < ll; ++i2) {
                    int l_idx = an[i2];
                    if (l_idx == cc && l_idx == f) continue;
                    MolAtom l = m.getAtom(l_idx);
                    MolBond b = a.getBond(i2);
                    int btype = b.getType();
                    if (btype == 3) {
                        branch[n++] = new DiGraphElement(l, -1, true);
                        branch[n++] = new DiGraphElement(l, -1, true);
                        continue;
                    }
                    if (btype == 2) {
                        branch[n++] = new DiGraphElement(l, -1, true);
                        continue;
                    }
                    if (btype != 4) continue;
                    aromAtno += l.getAtno();
                    ++aromBondCount;
                }
                if (aromAtno != 0) {
                    branch[n++] = new DiGraphElement(aromAtno * 10000 / aromBondCount);
                }
            }
            for (i = 0; i < impH; ++i) {
                branch[n++] = new DiGraphElement(10000);
            }
            g.setBranches(branch);
            digraphGenerated = true;
        } else {
            DiGraphElement[] branches = g.getBranches();
            int pidx = g.getIdx();
            if (branches != null) {
                for (int i = 0; i < branches.length; ++i) {
                    DiGraphElement gl = branches[i];
                    int idx = gl.getIdx();
                    if (idx < 0) continue;
                    digraphGenerated |= Parity.generateDigraph(gl, level - 1, idx, pidx, m, ctab, usedPL, usedAL, ch, ez, cc, hydrogenInfo, type, stereoInfo);
                }
            }
        }
        if ((type & 1) == 0) {
            usedPL.clear(c);
        }
        return digraphGenerated && !newElementCollision;
    }

    static int generateAuxStereo(int idx, MolAtom c, DiGraphElement g, int cc, int[] chirality, int[] ez, MoleculeGraph m, int[] hinfo) {
        int i;
        int lp = m.getLocalParity(idx);
        if (lp == 0 || lp == 3) {
            return 0;
        }
        int[][] ctab = m.getCtab();
        BitSet used = new BitSet(m.getAtomCount());
        DiGraphElement graph = new DiGraphElement(c, idx);
        for (int level = 1; level < 10 && Parity.generateDigraph(graph, level, idx, -1, m, ctab, used, chirality, ez, idx, hinfo, 0); ++level) {
            DiGraphElement[] branches = graph.getBranches();
            int brIdx = g.getIdx();
            if (brIdx < 0) {
                return 0;
            }
            for (i = branches.length - 1; i >= 0; --i) {
                DiGraphElement branch = branches[i];
                if (brIdx == branch.getIdx()) continue;
                Parity.replaceIdxWithPhantom(branch, cc);
            }
            Parity.compareLevel(graph, level, null, 2);
            if (level <= 1) continue;
            Parity.resetAtomsAtAtoms(graph, level, false, null, null);
        }
        int[] an = ctab[idx];
        int[] order = new int[an.length];
        for (i = 0; i < an.length; ++i) {
            MolAtom a = m.getAtom(an[i]);
            order[i] = graph.getBranch(a).getOrder();
        }
        int s = Parity.calculateChiralirtyFromOrder(order, m.getDim(), m, idx, an, null, true, false);
        return s;
    }

    static void replaceIdxWithPhantom(DiGraphElement g, int idx) {
        if (g == null) {
            return;
        }
        if (g.getIdx() == idx) {
            g.setToPhantom();
        } else {
            DiGraphElement[] branches = g.getBranches();
            if (branches == null) {
                return;
            }
            for (int j = branches.length - 1; j >= 0; --j) {
                Parity.replaceIdxWithPhantom(branches[j], idx);
            }
        }
    }

    static boolean recurseDigraphGeneration(DiGraphElement g, int level, int[] f, MoleculeGraph m, int[][] ctab, BitSet used, int[] ch, int[] ez, int type, int[] hinfo) {
        boolean digraphGenerated = false;
        DiGraphElement[] branches = g.getBranches();
        if (branches != null) {
            for (int i = 0; i < branches.length; ++i) {
                DiGraphElement gl = branches[i];
                int idx = gl.getIdx();
                if (idx < 0) continue;
                digraphGenerated |= Parity.generateDigraph(gl, level - 1, idx, f[i], m, ctab, used, ch, ez, g.getIdx(), hinfo, type);
            }
        }
        return digraphGenerated;
    }

    static boolean digraphTopoComparison(DiGraphElement g, int depth, boolean[] psa) {
        for (int subrule = 3; subrule < 6; ++subrule) {
            if (subrule == 3) {
                boolean ready = false;
                int level = 1;
                while (!ready && level < depth) {
                    ready = Parity.compareLevel(g, level++, null, 1);
                }
                if (!ready) continue;
                return true;
            }
            if (!Parity.compareDigraphBranches(subrule, g, depth, psa)) continue;
            return true;
        }
        return false;
    }

    static boolean compareDigraphBranches(int subrule, DiGraphElement g, int depth, boolean[] psa) {
        boolean moreStep = true;
        int level = 1;
        while ((moreStep = !Parity.compareUntilLevel(subrule, g, level, psa)) && ++level < depth) {
        }
        return !moreStep;
    }

    static boolean compareUntilLevel(int subrule, DiGraphElement g, int l, boolean[] psa) {
        if (subrule == 4) {
            return Parity.compareRule4(g, l);
        }
        if (subrule == 5) {
            boolean success = Parity.compareRule5(g, l);
            if (success) {
                psa[0] = true;
            }
            return success;
        }
        return false;
    }

    static boolean compareRule4(DiGraphElement g, int l) {
        int[] x = new int[l];
        Object[] an = g.getBranches();
        int anl = an.length;
        int[] w = new int[anl];
        for (int i = 0; i < anl; ++i) {
            w[i] = (4 - an[i].getOrder()) * 1000;
        }
        int[] step = new int[4];
        for (int i = 1; i < l; ++i) {
            int j;
            int stepLevel = 0;
            do {
                step[2] = Integer.MIN_VALUE;
                for (j = 0; j < anl; ++j) {
                    x[0] = j;
                    if (w[j] <= 0) continue;
                    step[0] = l;
                    step[1] = i;
                    int likeness = Parity.isLike(g, x, step);
                    if (likeness < 0) continue;
                    int n = j;
                    w[n] = w[n] + likeness;
                }
                stepLevel = step[2];
                if (stepLevel > 1) {
                    int n = stepLevel - 1;
                    x[n] = x[n] + 1;
                }
                for (int k = stepLevel; k < l; ++k) {
                    x[k] = 0;
                }
            } while (stepLevel > 1);
            Parity.sort(w, an);
            Parity.replaceNumbers(w);
            for (j = 0; j < an.length; ++j) {
                ((DiGraphElement)an[j]).setOrder(w[j]);
                w[j] = (4 - ((DiGraphElement)an[j]).getOrder()) * 1000;
            }
            g.setBranches((DiGraphElement[])an);
            if (!Parity.allDifferentIn(w)) continue;
            return true;
        }
        return false;
    }

    static boolean compareRule5(DiGraphElement g, int l) {
        return Parity.compareLevel(g, l, null, 3);
    }

    static int isLike(DiGraphElement g, int[] x, int[] s) {
        int l1 = s[0];
        int l2 = s[1];
        int t1 = Parity.getTopologyAtLevel(g, x, l1, 0);
        int t2 = Parity.getTopologyAtLevel(g, x, l2, 0);
        s[2] = t1 < 0 ? (-t1 > s[2] ? -t1 : s[2]) : l1;
        if (t1 < 0 || t2 < 0) {
            return -1;
        }
        if (t1 > 0 && t2 > 0) {
            if (t1 == t2) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    static int getTopologyAtLevel(DiGraphElement g, int[] x, int d, int i) {
        DiGraphElement[] an = g.getBranches();
        if (an == null || x[i] > an.length - 1) {
            return -i;
        }
        if (d == 1) {
            return an[x[i]].getTopology() & 0x18;
        }
        int w = Parity.getTopologyAtLevel(an[x[i]], x, d - 1, i + 1);
        if (w < 0 && x[i] > an.length - 1) {
            return -i;
        }
        return w;
    }

    static boolean compareLevel(DiGraphElement g, int l, int[] aarray, int type) {
        int i;
        Object[] an = g.getBranches();
        if (an == null) {
            return true;
        }
        if (l == 1) {
            int i2;
            int[] w = new int[an.length];
            for (i2 = 0; i2 < an.length; ++i2) {
                w[i2] = type != 2 ? (4 - ((DiGraphElement)an[i2]).getOrder()) * 256 : ((DiGraphElement)an[i2]).getWeight();
                if (type == 1) {
                    int n = i2;
                    w[n] = w[n] + (((DiGraphElement)an[i2]).getTopology() & 0x1C0);
                    continue;
                }
                if (type != 3) continue;
                int n = i2;
                w[n] = w[n] + (((DiGraphElement)an[i2]).getTopology() & 0x18);
            }
            if (aarray == null) {
                Parity.sort(w, an);
            } else {
                Parity.sort(w, an, aarray);
            }
            Parity.replaceNumbers(w);
            for (i2 = 0; i2 < an.length; ++i2) {
                ((DiGraphElement)an[i2]).setOrder(w[i2]);
            }
            return Parity.allDifferentIn(w);
        }
        for (int i3 = 0; i3 < an.length; ++i3) {
            Parity.compareLevel(an[i3], l - 1, null, type);
        }
        boolean alldiff = false;
        boolean more = true;
        int[] w = new int[an.length];
        int[][] x = new int[w.length][];
        for (i = 0; i < x.length; ++i) {
            x[i] = new int[l - 1];
        }
        do {
            for (i = 0; i < an.length; ++i) {
                w[i] = Parity.getWeight((DiGraphElement)an[i], x[i], l - 1, type);
            }
            if (Parity.allEqual(-(l - 1), w)) {
                more = false;
            } else if (Parity.allNegative(w)) {
                int d = Parity.getNegMax(w);
                int depth = -d;
                if (depth < l - 1) {
                    for (int i4 = 0; i4 < x.length; ++i4) {
                        if (w[i4] != d) continue;
                        int[] nArray = x[i4];
                        int n = depth;
                        nArray[n] = nArray[n] + 1;
                        for (int j = 0; j < depth; ++j) {
                            x[i4][j] = 0;
                        }
                    }
                } else {
                    more = false;
                }
            } else {
                for (i = 0; i < x.length; ++i) {
                    if (w[i] < 0) continue;
                    int[] nArray = x[i];
                    nArray[0] = nArray[0] + 1;
                }
            }
            alldiff = Parity.order(w, (DiGraphElement[])an, x);
        } while (more && !alldiff);
        return alldiff;
    }

    static int getWeight(DiGraphElement g, int[] x, int d, int type) {
        DiGraphElement[] an = g.getBranches();
        if (an == null || x[d - 1] > an.length - 1) {
            return -d;
        }
        if (d == 1) {
            int w = 0;
            w = type != 2 ? (4 - an[x[d - 1]].getOrder()) * 256 : an[x[d - 1]].getWeight();
            if (type == 1) {
                w += an[x[d - 1]].getTopology() & 0x1C0;
            } else if (type == 3) {
                w += an[x[d - 1]].getTopology() & 0x18;
            }
            return w;
        }
        int w = Parity.getWeight(an[x[d - 1]], x, d - 1, type);
        if (w < 0 && x[d - 1] > an.length - 1) {
            return -d;
        }
        return w;
    }

    static boolean order(int[] w, DiGraphElement[] an, int[][] x) {
        int i;
        if (Parity.allNegative(w)) {
            return false;
        }
        int o_max = 5;
        int w_max = Parity.getMax(w) + o_max;
        for (i = 0; i < w.length; ++i) {
            if (w[i] < 0) {
                w[i] = 0;
            }
            int n = i;
            w[n] = w[n] + w_max * (o_max - an[i].getOrder());
        }
        Parity.sort(w, (Object[])an, x);
        Parity.replaceNumbers(w);
        for (i = 0; i < w.length; ++i) {
            an[i].setOrder(w[i]);
        }
        return Parity.allDifferentIn(w);
    }

    static void resetAtomsAtAtoms(DiGraphElement g, int level, boolean spheric, BitSet used1, BitSet used2) {
        DiGraphElement[] branches = g.getBranches();
        if (branches == null) {
            return;
        }
        int l = branches.length;
        for (int i = 0; i < l; ++i) {
            int on;
            DiGraphElement branch = branches[i];
            int o = branch.getOrder();
            boolean unique = true;
            int n = 0;
            for (int j = i + 1; j < l && (on = branches[j].getOrder()) == o; ++j) {
                ++n;
                unique = false;
            }
            if (unique) {
                Parity.removeIdxes(branch, used1, used2);
                continue;
            }
            i += n;
        }
        if (!spheric) {
            int i;
            BitSet[] bottomIdxs = new BitSet[l];
            for (i = 0; i < l; ++i) {
                DiGraphElement branch = branches[i];
                bottomIdxs[i] = Parity.getBottomIdxSet(branch, level);
            }
            for (i = 0; i < l; ++i) {
                BitSet s1 = bottomIdxs[i];
                if (s1 == null || s1.cardinality() <= 0) continue;
                for (int j = i + 1; j < l; ++j) {
                    BitSet s2 = bottomIdxs[j];
                    if (!s1.equals(s2)) continue;
                    Parity.removeIdxes(branches[i], null, null);
                    Parity.removeIdxes(branches[j], null, null);
                }
            }
        }
    }

    static void removeIdxes(DiGraphElement g, BitSet used1, BitSet used2) {
        int idx;
        DiGraphElement[] branches = g.getBranches();
        int l = branches == null ? -1 : branches.length;
        for (int i = 0; i < l; ++i) {
            Parity.removeIdxes(branches[i], used1, used2);
        }
        if (used1 != null && (idx = g.getIdx()) >= 0) {
            used1.clear(idx);
            used2.clear(idx);
        }
        g.setIdx(-1);
    }

    static BitSet getBottomIdxSet(DiGraphElement g, int level) {
        BitSet s = new BitSet();
        Parity.setAtomIdxAtLevel(s, g, level - 1);
        return s;
    }

    static void setAtomIdxAtLevel(BitSet s, DiGraphElement g, int level) {
        DiGraphElement[] branches = g.getBranches();
        if (branches == null) {
            return;
        }
        int l = branches.length;
        if (level == 1) {
            for (int i = 0; i < l; ++i) {
                DiGraphElement branch = branches[i];
                int idx = -1;
                if (branch == null || (idx = branch.getIdx()) < 0) continue;
                s.set(idx);
            }
        } else {
            for (int i = 0; i < l; ++i) {
                DiGraphElement branch = branches[i];
                if (branch == null) continue;
                Parity.setAtomIdxAtLevel(s, branch, level - 1);
            }
        }
    }

    static int numberOfImplicitAtoms(MolAtom a, MolAtom c, MolAtom f) {
        int n = 0;
        boolean calcAromBond = true;
        for (int i = 0; i < a.getBondCount(); ++i) {
            MolBond b = a.getBond(i);
            MolAtom l = a.getLigand(i);
            if (l == c && l == f) continue;
            int t = b.getType();
            n += t > 0 && t < 4 ? t - 1 : 0;
            if (t != 4 || !calcAromBond) continue;
            ++n;
            calcAromBond = false;
        }
        return n;
    }

    static void replaceNumbers(int[] x) {
        int l = x.length;
        int[] tmp = new int[l];
        for (int i = 0; i < l; ++i) {
            int n = i;
            x[n] = x[n] + l;
            tmp[i] = x[i];
        }
        ArrayTools.sortDescending(tmp);
        int p = -1;
        for (int i = 0; i < tmp.length; ++i) {
            int a = tmp[i];
            if (p != a) {
                for (int j = 0; j < x.length; ++j) {
                    if (x[j] != a) continue;
                    x[j] = i + 1;
                }
            }
            p = a;
        }
    }

    static void sort(int[] a, Object[] b) {
        int n = a.length;
        for (int j = 1; j < n; ++j) {
            int x = a[j];
            Object y = b[j];
            for (int i = j - 1; i >= 0 && a[i] < x; --i) {
                a[i + 1] = a[i];
                b[i + 1] = b[i];
            }
            a[i + 1] = x;
            b[i + 1] = y;
        }
    }

    static void sort(int[] a, Object[] b, int[] c) {
        int n = a.length;
        for (int j = 1; j < n; ++j) {
            int x = a[j];
            Object y = b[j];
            int z = c[j];
            for (int i = j - 1; i >= 0 && a[i] < x; --i) {
                a[i + 1] = a[i];
                b[i + 1] = b[i];
                c[i + 1] = c[i];
            }
            a[i + 1] = x;
            b[i + 1] = y;
            c[i + 1] = z;
        }
    }

    static void sort(int[] a, Object[] b, int[][] c) {
        int n = a.length;
        for (int j = 1; j < n; ++j) {
            int x = a[j];
            Object y = b[j];
            int[] z = c[j];
            for (int i = j - 1; i >= 0 && a[i] < x; --i) {
                a[i + 1] = a[i];
                b[i + 1] = b[i];
                c[i + 1] = c[i];
            }
            a[i + 1] = x;
            b[i + 1] = y;
            c[i + 1] = z;
        }
    }

    static boolean allDifferentIn(int[] x) {
        if (x == null) {
            return false;
        }
        for (int i = 0; i < x.length; ++i) {
            int a = x[i];
            for (int j = i + 1; j < x.length; ++j) {
                int b = x[j];
                if (a != b) continue;
                return false;
            }
        }
        return true;
    }

    static int getNegMax(int[] x) {
        int max = Integer.MIN_VALUE;
        for (int i = 0; i < x.length; ++i) {
            int n = x[i];
            if (n >= 0 || n <= max) continue;
            max = x[i];
        }
        return max;
    }

    static int getMax(int[] x) {
        int max = Integer.MIN_VALUE;
        for (int i = 0; i < x.length; ++i) {
            if (x[i] <= max) continue;
            max = x[i];
        }
        return max;
    }

    static int getMin(int[] x) {
        int min = Integer.MAX_VALUE;
        for (int i = 0; i < x.length; ++i) {
            if (x[i] >= min) continue;
            min = x[i];
        }
        return min;
    }

    static boolean allNegative(int[] x) {
        for (int i = 0; i < x.length; ++i) {
            if (x[i] < 0) continue;
            return false;
        }
        return true;
    }

    static boolean allEqual(int n, int[] x) {
        for (int i = 0; i < x.length; ++i) {
            if (x[i] == n) continue;
            return false;
        }
        return true;
    }

    static boolean contains(MolBond[] pool, MolBond q) {
        for (int i = 0; i < pool.length; ++i) {
            if (pool[i] != q) continue;
            return true;
        }
        return false;
    }

    static boolean contains(int[] pool, int q) {
        for (int i = 0; i < pool.length; ++i) {
            if (pool[i] != q) continue;
            return true;
        }
        return false;
    }

    static boolean containsMoreTimes(int[] pool, int q) {
        int n = 0;
        for (int i = 0; i < pool.length; ++i) {
            if (pool[i] != q || ++n <= 1) continue;
            return true;
        }
        return false;
    }

    static boolean hasNoQuery(int[] ct, MoleculeGraph m) {
        for (int i = 0; i < ct.length; ++i) {
            MolAtom conn = m.getAtom(ct[i]);
            int atno = conn.getAtno();
            if (!conn.isQuery() && atno != 128 && atno != 129 && atno != 131 && atno != 132 && atno != 134) continue;
            return false;
        }
        return true;
    }

    static int minimumOf(int[] x) {
        int min = Integer.MAX_VALUE;
        int at = -1;
        boolean more = false;
        for (int i = 0; i < x.length; ++i) {
            if (x[i] == min) {
                more = true;
                continue;
            }
            if (x[i] >= min) continue;
            at = i;
            min = x[i];
        }
        return more ? -3 : at;
    }

    static void set(int i, int[] n) {
        if (i >= 0) {
            int n2 = i / 32;
            n[n2] = n[n2] | 1 << 31 - i % 32;
        }
    }

    static boolean get(int n, int[] r) {
        return (r[n / 32] & 1 << 31 - n % 32) != 0;
    }

    static boolean hasTwoDoubleBond(int n, int[][] ctab, int[][] btab, MoleculeGraph m) {
        int db = 0;
        for (int i = 0; i < ctab[n].length; ++i) {
            int lig = ctab[n][i];
            if (m.getBond(btab[n][lig]).getType() != 2) continue;
            ++db;
        }
        return db == 2;
    }

    static void change(int[] x, int i, int j) {
        int l = x.length;
        if (i > l - 1 || j > l - 1) {
            return;
        }
        int t = x[i];
        x[i] = x[j];
        x[j] = t;
    }

    static void putToTheBottom(int[] pool, int x) {
        int l = pool.length;
        int[] temp = new int[l];
        temp[l - 1] = pool[x];
        System.arraycopy(pool, 0, temp, 0, x);
        System.arraycopy(pool, x + 1, temp, x, l - x - 1);
        System.arraycopy(temp, 0, pool, 0, l);
    }

    static int[] putToTheTop(int[] pool, int x) {
        int l = pool.length;
        int[] temp = new int[l];
        temp[0] = pool[x];
        System.arraycopy(pool, 0, temp, 1, x);
        System.arraycopy(pool, x + 1, temp, x + 1, l - x - 1);
        return temp;
    }

    static MolBond[] putToTheTop(MolBond[] pool, int x) {
        MolBond[] temp = new MolBond[pool.length];
        temp[0] = pool[x];
        System.arraycopy(pool, 0, temp, 1, x);
        System.arraycopy(pool, x + 1, temp, x + 1, pool.length - x - 1);
        return temp;
    }

    static int findMaxNu(int[] pool) {
        int max = -1;
        int maxNu = -1;
        for (int i = 0; i < pool.length; ++i) {
            if (pool[i] <= max) continue;
            max = pool[i];
            maxNu = i;
        }
        return maxNu;
    }

    static void swapBond(MolAtom a, MolBond b, int bidx, boolean[] swap) {
        if (a != b.getAtom1()) {
            int f;
            b.swap();
            if (swap != null) {
                boolean bl = swap[bidx] = !swap[bidx];
            }
            if ((f = b.getFlags() & 0x30) == 16) {
                b.setFlags(32, 48);
            } else if (f == 32) {
                b.setFlags(16, 48);
            }
        }
    }

    void openSgroups(MoleculeGraph m) {
        if (m instanceof Molecule) {
            this.hasContractedGroup = ((Molecule)m).isGUIContracted();
            if (!this.hasContractedGroup) {
                ((Molecule)m).setGUIContracted(true);
            }
            if (this.hasContractedGroup || ((Molecule)m).isGUIContracted()) {
                ((Molecule)m).setGUIContracted(false, 16);
            }
        }
    }

    void closeSgroups(MoleculeGraph m) {
        if (this.hasContractedGroup) {
            ((Molecule)m).setGUIContracted(true);
            this.hasContractedGroup = false;
        }
    }

    static MolBond locateFirstBondForParitySettings(MoleculeGraph m, int idx, int[][] ctab, int[] stereoInfo, boolean[] isRingBond, boolean[] isBridgeAtom, int[] atomInSmallestRing, int[] p, boolean useActualWedges, BitSet usedBonds) {
        int i;
        MolAtom a = m.getAtom(idx);
        int[] ligands = ctab[idx];
        int nw = 0;
        for (i = 0; i < ligands.length; ++i) {
            MolBond b = a.getBond(i);
            if ((b.getFlags() & 0x30) == 0 || useActualWedges && b.getAtom1() != a) continue;
            ++nw;
        }
        if (ligands.length != 4 && nw > 1) {
            return null;
        }
        if (nw >= 1) {
            for (i = 0; i < ligands.length; ++i) {
                int l = ligands[i];
                MolBond b = a.getBond(i);
                if ((stereoInfo[l] & 1) != 0 || (b.getFlags() & 0x30) == 0) continue;
                b.setFlags(0, 48);
                return b;
            }
            return null;
        }
        return Parity.locateBondAccordingToPriority(m, null, a, idx, ctab, stereoInfo, isRingBond, isBridgeAtom, atomInSmallestRing, p, usedBonds);
    }

    static MolBond locateNextBondForParitySettings(MoleculeGraph m, MolBond ex, int idx, int[][] ctab, int[] stereoInfo, boolean[] isRingBond, boolean[] isBridgeAtom, int[] atomInSmallestRing, int[] p, BitSet usedBonds) {
        MolAtom a = m.getAtom(idx);
        int[] ligands = ctab[idx];
        for (int i = 0; i < ligands.length; ++i) {
            int l = ligands[i];
            MolBond b = a.getBond(i);
            if (b == ex || (stereoInfo[l] & 1) != 0 || (b.getFlags() & 0x30) == 0) continue;
            b.setFlags(0, 48);
            return b;
        }
        return Parity.locateBondAccordingToPriority(m, ex, a, idx, ctab, stereoInfo, isRingBond, isBridgeAtom, atomInSmallestRing, p, usedBonds);
    }

    static MolBond locateBondAccordingToPriority(MoleculeGraph m, MolBond ex, MolAtom a, int idx, int[][] ctab, int[] pt, boolean[] isRingBond, boolean[] isBridgeAtom, int[] atomInSmallestRing, int[] p, BitSet usedBonds) {
        MolBond b = null;
        b = Parity.locateBondToTerminal(m, ex, a, ctab[idx], pt);
        if (b != null) {
            return b;
        }
        b = Parity.locateBondBasedOnAtno(m, a, idx, ctab[idx], pt, isRingBond, true, p, usedBonds);
        if (b != null) {
            return b;
        }
        if (ex != null) {
            return null;
        }
        b = Parity.locateBridgeBond(m, a, ctab[idx], pt, isBridgeAtom);
        if (b != null) {
            return b;
        }
        b = Parity.locateSmallestRingBond(m, a, ctab[idx], pt, atomInSmallestRing);
        if (b != null) {
            return b;
        }
        b = Parity.locateBondBasedOnAtno(m, a, idx, ctab[idx], pt, isRingBond, false, p, usedBonds);
        return b;
    }

    static int rearrangeBondToTerminal(MoleculeGraph m, int[] bidx, int n, MolAtom a, int[] ct, int[] pt) {
        int l = bidx.length;
        int changed = 0;
        int[] order = new int[l - n];
        for (int i = n; i < l; ++i) {
            int bno = bidx[i];
            MolAtom lig = a.getLigand(bno);
            MolBond b = a.getBond(bno);
            int t = b.getType();
            int atno = lig.getAtno();
            int idx = ct[bno];
            if (t == 1) {
                if (atno == 1 || atno == 130) {
                    order[i - n] = 65536 + bno;
                    ++changed;
                    continue;
                }
                if ((pt[idx] & 1) == 0 && Parity.seemsTerminal(lig)) {
                    int o = atno == 6 ? 109 : atno;
                    order[i - n] = (o << 16) + bno;
                    ++changed;
                    continue;
                }
                order[i - n] = bno + 0x7FFF0000;
                continue;
            }
            order[i - n] = bno + 0x7FFF0000;
        }
        if (changed > 0) {
            Parity.changeOrder(bidx, order);
        }
        return n + changed;
    }

    static void changeOrder(int[] idx, int[] order) {
        int i;
        ArrayTools.sortDescending(order);
        int l = order.length;
        for (i = 0; i < l; ++i) {
            order[i] = order[i] & 0xFFFF;
        }
        for (i = 0; i < l / 2; ++i) {
            int t = order[i];
            order[i] = order[l - 1 - i];
            order[l - 1 - i] = t;
        }
        int start = idx.length - l;
        System.arraycopy(order, 0, idx, start, l);
    }

    static MolBond locateBondToTerminal(MoleculeGraph m, MolBond ex, MolAtom a, int[] ct, int[] pt) {
        int minatno = 99999;
        int bid = -1;
        int bToC = -1;
        for (int i = 0; i < ct.length; ++i) {
            MolAtom l = a.getLigand(i);
            MolBond b = a.getBond(i);
            int t = b.getType();
            int atno = l.getAtno();
            int idx = ct[i];
            if (b == ex || t != 1) continue;
            if (atno == 1 || atno == 130) {
                return b;
            }
            if (atno != 6) {
                if ((pt[idx] & 1) != 0 || atno >= minatno || !Parity.seemsTerminal(l)) continue;
                minatno = atno;
                bid = i;
                continue;
            }
            if ((pt[idx] & 1) != 0 || !Parity.seemsTerminal(l)) continue;
            bToC = i;
        }
        bid = bid != -1 ? bid : bToC;
        return bid != -1 ? a.getBond(bid) : null;
    }

    static boolean seemsTerminal(MolAtom a) {
        int notHligand = 0;
        for (int i = 0; i < a.getBondCount(); ++i) {
            MolAtom l = a.getLigand(i);
            if (l.getAtno() == 1) continue;
            ++notHligand;
        }
        return notHligand < 2;
    }

    static boolean isTerminal(MolAtom a) {
        return a.getBondCount() == 1;
    }

    static int rearrangeBondBasedOnAtno(MoleculeGraph m, int[] bidx, int n, MolAtom a, int[] ct, int[] pt, int[] ringCount, boolean inchain, boolean useF) {
        int l = bidx.length;
        int changed = 0;
        int[] order = new int[l - n];
        for (int i = n; i < l; ++i) {
            int bno = bidx[i];
            MolAtom lig = a.getLigand(bno);
            MolBond b = a.getBond(bno);
            int t = b.getType();
            int atno = lig.getAtno();
            int lidx = ct[bno];
            if (t == 1 && (useF || (pt[lidx] & 1) == 0) && (!inchain || inchain && ringCount[lidx] == 0)) {
                int o = atno == 6 ? 109 : atno;
                order[i - n] = ((o += (pt[lidx] & 1) > 0 ? 109 : 0) << 16) + bno;
                ++changed;
                continue;
            }
            order[i - n] = bno + 0x7FFF0000;
        }
        if (changed > 0) {
            Parity.changeOrder(bidx, order);
        }
        return n + changed;
    }

    static MolBond locateBondBasedOnAtno(MoleculeGraph m, MolAtom a, int idx, int[] ct, int[] pt, boolean[] isRingBond, boolean inchain, int[] p, BitSet usedBonds) {
        int minatno = 99999;
        int[] bid = new int[]{-1, -1, -1, -1, -1, -1};
        int n = 0;
        boolean wedgeFirst = m.isOnlyFirstAtomInStereoCalculation();
        for (int i = 0; i < ct.length; ++i) {
            MolAtom l = a.getLigand(i);
            MolBond b = a.getBond(i);
            int bidx = m.indexOf(b);
            int t = b.getType();
            int atno = l.getAtno();
            int lidx = ct[i];
            if (t != 1 || usedBonds.get(bidx) || inchain && (!inchain || isRingBond[bidx])) continue;
            if ((pt[lidx] & 1) == 0) {
                n = 0;
            } else if (p != null && (p[lidx] == 0 || p[lidx] == 3)) {
                n = 2;
            } else if (wedgeFirst) {
                n = 4;
            }
            if (atno != 6 && atno < minatno) {
                minatno = atno;
                bid[n] = i;
                continue;
            }
            bid[n + 1] = i;
        }
        int bidx = -1;
        for (int i = 0; i < 6 && bidx < 0; ++i) {
            bidx = bid[i];
        }
        return bidx != -1 ? a.getBond(bidx) : null;
    }

    static int rearrangeBridgeBond(MoleculeGraph m, int[] bidx, int n, MolAtom a, int[] ct, int[] pt, boolean[] isBridgeAtom) {
        int l = bidx.length;
        int changed = 0;
        int[] order = new int[l - n];
        for (int i = n; i < l; ++i) {
            int bno = bidx[i];
            int lidx = ct[bno];
            if ((pt[lidx] & 1) == 0 && isBridgeAtom[lidx]) {
                MolBond b = a.getBond(bno);
                int t = b.getType();
                if (t == 1) {
                    order[i - n] = 65536 + bno;
                    ++changed;
                    continue;
                }
                order[i - n] = bno + 0x7FFF0000;
                continue;
            }
            order[i - n] = bno + 0x7FFF0000;
        }
        if (changed > 0) {
            Parity.changeOrder(bidx, order);
        }
        return n + changed;
    }

    static MolBond locateBridgeBond(MoleculeGraph m, MolAtom a, int[] ct, int[] pt, boolean[] isBridgeAtom) {
        for (int i = 0; i < ct.length; ++i) {
            MolBond b;
            int t;
            int idx = ct[i];
            if ((pt[idx] & 1) != 0 || !isBridgeAtom[idx] || (t = (b = a.getBond(i)).getType()) != 1) continue;
            return b;
        }
        return null;
    }

    static int rearrangeSmallestRingBond(MoleculeGraph m, int[] bidx, int n, MolAtom a, int[] ct, int[] pt, int[] rs) {
        int l = bidx.length;
        int changed = 0;
        int[] order = new int[l - n];
        for (int i = n; i < l; ++i) {
            int bno = bidx[i];
            int idx = ct[bno];
            if ((pt[idx] & 1) == 0) {
                MolAtom lig = a.getLigand(bno);
                MolBond b = a.getBond(bno);
                int t = b.getType();
                int atno = lig.getAtno();
                if (t == 1) {
                    if (rs[idx] > 0) {
                        atno = atno == 6 ? 109 : atno;
                        int o = rs[idx] * 109 + atno;
                        order[i - n] = (o << 16) + bno;
                        ++changed;
                        continue;
                    }
                    order[i - n] = bno + 0x7FFF0000;
                    continue;
                }
                order[i - n] = bno + 0x7FFF0000;
                continue;
            }
            order[i - n] = bno + 0x7FFF0000;
        }
        if (changed > 0) {
            Parity.changeOrder(bidx, order);
        }
        return n + changed;
    }

    static MolBond locateSmallestRingBond(MoleculeGraph m, MolAtom a, int[] ct, int[] pt, int[] rs) {
        int minrings = 99999;
        int bid = -1;
        int bToC = -1;
        int minatno = 99999;
        for (int i = 0; i < ct.length; ++i) {
            int idx = ct[i];
            if ((pt[idx] & 1) != 0) continue;
            int atno = a.getLigand(i).getAtno();
            MolBond b = a.getBond(i);
            int t = b.getType();
            if (t != 1) continue;
            if (rs[idx] < minrings) {
                minrings = rs[idx];
                if (atno != 6) {
                    minatno = atno;
                    bid = i;
                    continue;
                }
                bToC = i;
                continue;
            }
            if (rs[idx] != minrings) continue;
            if (atno != 6 && atno < minatno) {
                minatno = atno;
                bid = i;
                continue;
            }
            bToC = i;
        }
        bid = bid != -1 ? bid : bToC;
        return bid != -1 ? a.getBond(bid) : null;
    }

    static boolean setWedge(int idx, MolBond b, int p, MoleculeGraph m, boolean[] swap) {
        return Parity.setWedge(idx, b, p, m, swap, false);
    }

    static boolean setWedge(int idx, MolBond b, int p, MoleculeGraph m, boolean[] swap, boolean wedgeStart) {
        MolAtom a = m.getAtom(idx);
        p = p == 3 ? 0 : p;
        b.setFlags(0, 48);
        if (swap != null) {
            Parity.swapBond(a, b, m.indexOf(b), swap);
        }
        boolean step = wedgeStart ? b.stepWedge() : true;
        boolean notsuccess = true;
        int lp = m.getLocalParity(idx);
        lp = lp == 3 ? 0 : lp;
        while ((notsuccess = p != lp) && step) {
            step = b.stepWedge();
            lp = m.getLocalParity(idx);
            lp = lp == 3 ? 0 : lp;
        }
        return !notsuccess;
    }

    static int indexOf(int x, int[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != x) continue;
            return i;
        }
        return -1;
    }

    static void fillHydrogenInfo(int[] h, MoleculeGraph m) {
        int ac = m.getAtomCount();
        for (int i = 0; i < ac; ++i) {
            MolAtom a = m.getAtom(i);
            if (Parity.isHydrogen(a)) {
                h[i] = 65536;
                continue;
            }
            int n = i;
            h[n] = h[n] | Parity.getExplicitHcount(a) << 8;
            int n2 = i;
            h[n2] = h[n2] | a.getImplicitHcount();
        }
    }

    static int getExplicitHcount(MolAtom a) {
        int l = a.getBondCount();
        int n = 0;
        for (int i = 0; i < l; ++i) {
            MolAtom ligand = a.getLigand(i);
            if (!Parity.isHydrogen(ligand)) continue;
            ++n;
        }
        return n;
    }

    static boolean isHydrogen(MolAtom atom) {
        int atno = atom.getAtno();
        return atno == 1 && atom.getMassno() == 0;
    }

    static boolean checkFixedN(MolAtom a, int idx, BondTable btab, int[][] ctab, int[] ringCount, boolean[] isRingBond, int[] atomInSmallestRing, int[] bondInSmallestRing) {
        int[] an = ctab[idx];
        int[] bn = btab.getBondIndexesToAtom(idx);
        int anl = an.length;
        if (a.getAtno() != 7 || anl < 3) {
            return false;
        }
        if (anl > 3) {
            return true;
        }
        if (ringCount[idx] == 0) {
            return false;
        }
        if (atomInSmallestRing[idx] == 3) {
            return true;
        }
        for (int i = 0; i < anl; ++i) {
            MolBond b = a.getBond(i);
            int t = b.getType();
            int lidx = an[i];
            if (isRingBond[bn[lidx]] && t == 1 && !Parity.bridgeHead(lidx, ctab[lidx], btab.getBondIndexesToAtom(lidx), isRingBond) && bondInSmallestRing[bn[lidx]] <= 12) continue;
            return false;
        }
        return true;
    }

    static boolean bridgeHead(int idx, int[] an, int[] bn, boolean[] isRingBond) {
        int anl = an.length;
        if (anl != 3) {
            return false;
        }
        int n = 0;
        for (int i = 0; i < anl; ++i) {
            int lidx = an[i];
            if (!isRingBond[bn[lidx]]) continue;
            ++n;
        }
        return n > 2;
    }

    static boolean bondConditionForParity(MolAtom a) {
        int atno = a.getAtno();
        boolean centerS = atno == 16 || atno == 15 || atno == 7;
        int l = a.getBondCount();
        int dbbc = 0;
        for (int i = 0; i < l; ++i) {
            MolBond b = a.getBond(i);
            int t = b.getType();
            if (t == 2) {
                ++dbbc;
                if (centerS) {
                    MolAtom n = a.getLigand(i);
                    int latno = n.getAtno();
                    if (dbbc <= 2 && (latno == 7 || latno == 8 || latno == 16 || latno == 15)) continue;
                    return false;
                }
                return false;
            }
            if (t <= 2) continue;
            return false;
        }
        return true;
    }

    static boolean isSulfoxideType(MolAtom a) {
        int atno = a.getAtno();
        if (atno == 16 || atno == 15) {
            int l = a.getBondCount();
            for (int i = 0; i < l; ++i) {
                MolAtom n;
                MolBond b = a.getBond(i);
                int t = b.getType();
                if (!(t == 2 ? (n = a.getLigand(i)).getBondCount() != 1 : t > 2)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    static boolean allValueEquals(int[] v, int x) {
        for (int i = 0; i < v.length; ++i) {
            if (v[i] == x) continue;
            return false;
        }
        return true;
    }

    static boolean allEquals(int[] x, int n) {
        int v = x[0];
        for (int i = 1; i < n; ++i) {
            if (v == x[i]) continue;
            return false;
        }
        return true;
    }

    static void correctCanhaveparity(int[] stereoInfo, int[] parity) {
        if (stereoInfo == null || stereoInfo.length != parity.length) {
            return;
        }
        for (int i = parity.length - 1; i >= 0; --i) {
            if (parity[i] == 0) continue;
            int n = i;
            stereoInfo[n] = stereoInfo[n] | 1;
        }
    }

    static int[] getBondFlags(MoleculeGraph m) {
        int[] flags = new int[m.getBondCount()];
        int bc = m.getBondCount();
        for (int i = 0; i < bc; ++i) {
            MolBond b = m.getBond(i);
            flags[i] = b.getFlags() & 0x30;
        }
        return flags;
    }

    static void restoreWedges(MoleculeGraph m, int[] wedge, boolean[] swap) {
        int l = wedge.length;
        for (int i = 0; i < l; ++i) {
            MolBond b = m.getBond(i);
            if (swap[i]) {
                b.swap();
            }
            b.setFlags(wedge[i], 48);
        }
    }

    static int calculateRingCount(MoleculeGraph m, int[] ringCount, boolean[] isRingBond, int[] atomInSmallestRing, ArrayList<BitSet> aIdxSet) {
        BondTable btab = null;
        if (isRingBond != null) {
            btab = m.getBondTable();
        }
        int[][] cssr = m.getCSSR();
        int cssrl = cssr.length;
        for (int i = 0; i < cssrl; ++i) {
            BitSet s = new BitSet(8);
            int[] r = cssr[i];
            int l = r.length;
            for (int j = 0; j < l; ++j) {
                int idx = r[j];
                s.set(idx);
                if (isRingBond != null) {
                    int nidx = r[(j + 1) % l];
                    int bidx = btab.getBondIndex(idx, nidx);
                    isRingBond[bidx] = true;
                }
                if (atomInSmallestRing != null && ringCount[idx] == 0) {
                    atomInSmallestRing[idx] = l;
                }
                if (aIdxSet != null) {
                    aIdxSet.add(s);
                }
                int n = idx;
                ringCount[n] = ringCount[n] + 1;
            }
        }
        return cssrl;
    }

    static int getFirstNegIdx(int[] x) {
        for (int i = 0; i < x.length; ++i) {
            if (x[i] >= 0) continue;
            return i;
        }
        return x.length;
    }

    static boolean isUpDownBond(MolBond b, MolAtom a) {
        if (b.getAtom1() != a) {
            return false;
        }
        int f = b.getFlags() & 0x30;
        if (f == 16) {
            return true;
        }
        return f == 32;
    }

    public static boolean convertFischerProjection(MoleculeGraph m) {
        if (m.getDim() != 2) {
            return false;
        }
        double FISCHER_TRESH = 0.077;
        boolean converted = false;
        Parity p = new Parity();
        p.setMolecule(m);
        MoleculeGraph molecule = p.mol;
        int[] stI = p.stereoInfo;
        int[][] ctab = p.ctab;
        int ac = molecule.getAtomCount();
        for (int i = 0; i < ac; ++i) {
            MolAtom a = molecule.getAtom(i);
            int[] an = ctab[i];
            if (a.getAtno() != 6 || (stI[i] & 8) <= 0 || (stI[i] & 0x20) != 0 || an.length != 4) continue;
            MolAtom a1 = a.getLigand(0);
            MolAtom a2 = a.getLigand(1);
            MolAtom a3 = a.getLigand(2);
            MolAtom a4 = a.getLigand(3);
            double a1x = a1.getX();
            double a1y = a1.getY();
            double a2x = a2.getX();
            double a2y = a2.getY();
            double a3x = a3.getX();
            double a3y = a3.getY();
            double a4x = a4.getX();
            double a4y = a4.getY();
            MolBond b = null;
            if (Math.abs(a1y - a2y) < 0.077 && Math.abs(a3x - a4x) < 0.077) {
                b = a.getBond(0);
            } else if (Math.abs(a1y - a3y) < 0.077 && Math.abs(a2x - a4x) < 0.077) {
                b = a.getBond(0);
            } else if (Math.abs(a1y - a4y) < 0.077 && Math.abs(a2x - a3x) < 0.077) {
                b = a.getBond(0);
            } else if (Math.abs(a2y - a3y) < 0.077 && Math.abs(a1x - a4x) < 0.077) {
                b = a.getBond(1);
            } else if (Math.abs(a2y - a4y) < 0.077 && Math.abs(a1x - a3x) < 0.077) {
                b = a.getBond(1);
            } else if (Math.abs(a3y - a4y) < 0.077 && Math.abs(a1x - a2x) < 0.077) {
                b = a.getBond(2);
            }
            if (b == null) continue;
            if (a != b.getAtom1()) {
                b.swap();
            }
            b.setFlags(16, 48);
            converted = true;
        }
        return converted;
    }

    static boolean hasWedge(MolAtom a) {
        int l = a.getBondCount();
        for (int i = 0; i < l; ++i) {
            MolBond b = a.getBond(i);
            int f = b.getFlags() & 0x30;
            if (f != 16 && f != 32 || b.getAtom1() != a) continue;
            return true;
        }
        return false;
    }

    static String toString(boolean[] x) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < x.length; ++i) {
            if (!x[i]) continue;
            sb.append(i + " ");
        }
        return sb.toString();
    }

    static String toString(int[] x) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < x.length; ++i) {
            sb.append(x[i] + " ");
        }
        return sb.toString();
    }

    static String toString(long[] x) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < x.length; ++i) {
            sb.append(x[i] + " ");
        }
        return sb.toString();
    }

    static void print(int[] x) {
        for (int i = 0; i < x.length; ++i) {
            System.err.print(i + "-" + x[i] + " ");
        }
        System.err.println();
    }

    static void printDiGraph(DiGraphElement p, int l, int l_max) {
        for (int j = 0; j < l; ++j) {
            System.err.print(" ");
        }
        System.err.print(p.getIdx() + 1 + " : " + p.getOrder() + " " + p.getWeight() + " \n");
        if (p.getBranches() == null || p.getBranches().length == 0) {
            return;
        }
        if (l < l_max) {
            for (int i = 0; i < p.getBranches().length; ++i) {
                Parity.printDiGraph(p.getBranch(i), l + 1, l_max);
            }
        }
    }

    static void printorders(DiGraphElement[] ge) {
        for (int i = 0; i < ge.length; ++i) {
            System.err.println("  idx " + (ge[i].getIdx() + 1) + ":" + ge[i].getOrder());
        }
        System.err.println();
    }

    static void printIdxes(DiGraphElement[] ge) {
        for (int i = 0; i < ge.length; ++i) {
            System.err.print(ge[i].getIdx() + 1 + " ");
        }
        System.err.println();
    }

    static void convertBranchesToAtoms(DiGraphElement p, MoleculeGraph m, MolAtom a0) {
        DiGraphElement[] an = p.getBranches();
        int l = an == null ? 0 : an.length;
        for (int i = 0; i < l; ++i) {
            DiGraphElement ge = an[i];
            if (ge == null) continue;
            MolAtom a = new MolAtom(131);
            int idx = ge.getIdx();
            String idxs = idx >= 0 ? "" + (idx + 1) : "p";
            int w = ge.getWeight() / 100;
            a.setAliasstr(idxs + " " + w);
            m.add(a);
            MolBond b = new MolBond(a, a0);
            m.add(b);
            Parity.convertBranchesToAtoms(ge, m, a);
        }
    }

    static String toStringHE(int l, int i, int h) {
        StringBuffer sb = new StringBuffer();
        sb.append("has element at level " + l + " " + ((h & 1) > 0) + "    at level " + i + " " + ((h & 2) > 0));
        return sb.toString();
    }

    static void printStereoInfo(int[] st) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < st.length; ++i) {
            int s = st[i];
            sb.append(i + " ");
            sb.append(Parity.stereoInfoToString(s) + "\n");
        }
        System.err.println(sb.toString());
    }

    private static String stereoInfoToString(int s) {
        return new String(((s & 1) > 0 ? "PARITY_TETRAHEDRAL " : "") + ((s & 2) > 0 ? "PARITY_ALLENE " : "") + ((s & 4) > 0 ? "ASYMMETRIC " : "") + ((s & 8) > 0 ? "CHIRALCENTER " : "") + ((s & 0x20) > 0 ? "HASWEDGE " : "") + ((s & 0x40) > 0 ? "RINGATOM " : "") + ((s & 0x80) > 0 ? "TWOEQGRINVINRING " : ""));
    }
}

