/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.core.calculations;

import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.MoleculeGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class RingSearch {
    public static List<Integer> getSmallestRingWithBondType(MolAtom startAtom, int type, int maxLength) {
        int current;
        int currentDist;
        MoleculeGraph parentMol = startAtom.getParent();
        if (parentMol == null) {
            return Collections.emptyList();
        }
        int[][] ctab = parentMol.getCtab();
        int startIndex = parentMol.indexOf(startAtom);
        int N = parentMol.getAtomCount();
        ArrayList path = new ArrayList();
        for (int i = 0; i < N; ++i) {
            path.add(new LinkedList());
        }
        LinkedList<Integer> queue = new LinkedList<Integer>();
        int[] parent = new int[N];
        for (int i = 0; i < N; ++i) {
            parent[i] = -1;
        }
        boolean[] reached = new boolean[N];
        int[] dist = new int[N];
        queue.add(startIndex);
        reached[startIndex] = true;
        dist[startIndex] = 0;
        int exitDist = -1;
        int maxStep = (maxLength + 1) / 2;
        List<Integer> result = null;
        while (!queue.isEmpty() && (currentDist = dist[current = ((Integer)queue.poll()).intValue()]) != exitDist && currentDist != maxStep) {
            for (int i = 0; i < parentMol.getAtom(current).getBondCount(); ++i) {
                int next = ctab[current][i];
                MolBond bond = parentMol.getAtom(current).getBondTo(parentMol.getAtom(next));
                if (next == parent[current] || bond != null && bond.getType() != type) continue;
                if (!reached[next]) {
                    queue.add(next);
                    reached[next] = true;
                    dist[next] = currentDist + 1;
                }
                if (((LinkedList)path.get(next)).isEmpty()) {
                    ((LinkedList)path.get(next)).addAll((Collection)path.get(current));
                    if (current == startIndex) {
                        ((LinkedList)path.get(next)).add(current);
                    }
                    ((LinkedList)path.get(next)).add(next);
                    parent[next] = current;
                    continue;
                }
                List<Integer> intersection = RingSearch.intersect((List)path.get(current), (List)path.get(next));
                if (intersection.size() != 1 || intersection.get(0) != startIndex) continue;
                List<Integer> ring = RingSearch.union((List)path.get(current), (List)path.get(next));
                if (result != null && ring.size() >= result.size()) continue;
                result = ring;
                exitDist = currentDist + 1;
            }
        }
        if (result == null) {
            result = Collections.emptyList();
        }
        return result;
    }

    public static List<MolAtom> getSmallestRingAtomsWithBondType(MolAtom startAtom, int type, int maxLength) {
        MoleculeGraph parentMol = startAtom.getParent();
        List<Integer> ring = RingSearch.getSmallestRingWithBondType(startAtom, type, maxLength);
        LinkedList<MolAtom> smallestRing = new LinkedList<MolAtom>();
        if (ring != null && parentMol != null) {
            for (int i : ring) {
                smallestRing.add(parentMol.getAtom(i));
            }
        }
        return smallestRing;
    }

    public static List<Integer> intersect(List<Integer> a, List<Integer> b) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i : a) {
            for (int j : b) {
                if (i != j) continue;
                result.add(j);
            }
        }
        return result;
    }

    public static List<Integer> union(List<Integer> a, List<Integer> b) {
        LinkedList<Integer> result = new LinkedList<Integer>();
        result.addAll(a);
        for (int i : b) {
            if (result.contains(i)) continue;
            result.add(i);
        }
        return result;
    }
}

