/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.core.calculations;

import chemaxon.struc.Gearch;
import chemaxon.struc.Smolecule;
import chemaxon.struc.StaticMolecule;
import chemaxon.struc.WSmolecule;
import java.util.BitSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class SSSR {
    private static final Logger logger = Logger.getLogger(SSSR.class.getName());
    static final int CAGELIMIT = 14;
    protected Smolecule m;
    private long grinvCC = 0L;
    INode[] nodes;
    int mmessages;
    IMessage[] unused;
    int unusedLength = 0;
    long[][] rings;
    long[] ringBonds;
    int[] ringBondsInt;
    int[][] ringBondIndexes;
    int ringsLength = 0;
    int ringLengthFragStart = 0;
    int fragSSSRLength = 0;
    long[][] upEchel;
    int nOfEchel = 0;
    int[][] ringIdxes;
    boolean ringIndexCalculated = false;
    boolean ringBondSetCalculated = false;
    boolean startRingSearchFinishedCSSR = false;
    boolean startRingSearchFinishedSSSR = false;
    IMessage[][] M;
    int[][] N;

    public SSSR() {
    }

    public SSSR(Smolecule g) {
        this();
        this.m = g;
    }

    public final void setGraph(Smolecule a) {
        this.ringIndexCalculated = false;
        this.ringBondSetCalculated = false;
        this.startRingSearchFinishedCSSR = false;
        this.startRingSearchFinishedSSSR = false;
        this.rings = null;
        this.ringsLength = 0;
        this.fragSSSRLength = 0;
        this.m = a;
    }

    public final int[][] getRings() {
        if (!this.ringIndexCalculated) {
            this.fillRingIdx(this.ringIdxes, this.rings);
        }
        return this.ringIdxes;
    }

    public final int getRingsize() {
        return this.ringsLength;
    }

    public final int getRingCount() {
        return this.ringsLength;
    }

    public final int[][] getBondIndexes() {
        this.setBondIndexes();
        return this.ringBondIndexes;
    }

    public final long[] getBondSet() {
        this.setBondSet();
        return this.ringBonds;
    }

    public final int[] getBondSetInt() {
        this.setBondSetInt();
        return this.ringBondsInt;
    }

    private final int[] networkInit(BitSet actualSet, int[] noOfEdges) {
        int mnodes = this.m.getAtomCount();
        int maxConn = this.cutBranch(actualSet, noOfEdges);
        if (maxConn < 2) {
            this.fragSSSRLength = 0;
            return new int[]{maxConn, 1};
        }
        if (maxConn == 2) {
            this.fragSSSRLength = 1;
            if (this.rings == null) {
                this.rings = new long[this.fragSSSRLength][];
            } else if (this.ringLengthFragStart + this.fragSSSRLength > this.rings.length) {
                long[][] tmp = new long[this.ringLengthFragStart + this.fragSSSRLength][];
                System.arraycopy(this.rings, 0, tmp, 0, this.ringsLength);
                this.rings = tmp;
            }
            return new int[]{maxConn, 1};
        }
        if (this.nodes == null || mnodes > this.nodes.length) {
            this.nodes = new INode[mnodes];
        }
        int edgeCount = 0;
        int nodeCount = 0;
        int i = actualSet.nextSetBit(0);
        while (i >= 0) {
            int ec = noOfEdges[i];
            if (ec > 0) {
                edgeCount += ec;
                ++nodeCount;
                int el = this.m.getNeighborCount(i);
                if (this.nodes[i] == null) {
                    this.nodes[i] = new INode(el);
                }
                for (int j = 0; j < el; ++j) {
                    int last = this.m.getNeighbor(i, j);
                    if (noOfEdges[last] <= 0) continue;
                    IMessage msg = this.getNewPmessage(null, last, this.m.getBondIndex(i, last));
                    this.nodes[i].addToSend(msg);
                }
            }
            i = actualSet.nextSetBit(i + 1);
        }
        this.fragSSSRLength = (edgeCount /= 2) - nodeCount + 1;
        int n = this.fragSSSRLength = this.fragSSSRLength > 0 ? this.fragSSSRLength : 0;
        if (this.rings == null) {
            this.rings = new long[this.fragSSSRLength][];
        } else if (this.ringLengthFragStart + this.fragSSSRLength > this.rings.length) {
            long[][] tmp = new long[this.ringLengthFragStart + this.fragSSSRLength][];
            System.arraycopy(this.rings, 0, tmp, 0, this.ringsLength);
            this.rings = tmp;
        }
        this.nOfEchel = 0;
        if (this.upEchel == null || this.fragSSSRLength > this.upEchel.length) {
            this.upEchel = new long[this.fragSSSRLength][];
        }
        if (this.N == null || this.mmessages > this.N.length) {
            this.N = new int[this.mmessages][2];
            this.M = new IMessage[this.mmessages][2];
        }
        return new int[]{maxConn, edgeCount};
    }

    public final void startRingSearch(boolean cssr) {
        if (cssr && this.startRingSearchFinishedCSSR) {
            return;
        }
        if (!cssr && this.startRingSearchFinishedSSSR) {
            return;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Start ring search cssr " + cssr);
        }
        this.ringIndexCalculated = false;
        this.ringBondSetCalculated = false;
        int[] fragID = SSSR.fillFragIDs(this.m);
        int ac = this.m.getAtomCount();
        BitSet actualSet = new BitSet(ac);
        for (int usedCount = 0; usedCount < ac; usedCount += SSSR.fillActualSet(fragID, actualSet)) {
            this.ringSearch(actualSet);
            actualSet.clear();
        }
        if (!this.ringIndexCalculated) {
            if (cssr && this.ringsLength > 1) {
                this.generateCSSRfromSSSR();
            }
            this.ringIdxes = new int[this.ringsLength][];
        }
        if (cssr) {
            this.startRingSearchFinishedCSSR = true;
        } else if (!cssr) {
            this.startRingSearchFinishedSSSR = true;
        }
    }

    private void ringSearch(BitSet actualSet) {
        int mnodes = actualSet.cardinality();
        this.mmessages = this.m.getBondCount();
        int[] noOfEdges = new int[this.m.getAtomCount()];
        this.ringLengthFragStart = this.ringsLength;
        int[] info = this.networkInit(actualSet, noOfEdges);
        int maxConnectivity = info[0];
        int medges = info[1];
        int maxSteps = mnodes < medges ? mnodes : medges;
        maxSteps = maxSteps / 2 + 1;
        boolean foundAllSSSR = false;
        if (this.fragSSSRLength > 0) {
            if (maxConnectivity == 2) {
                this.generateOneRingBondSet(this.rings, noOfEdges, this.m, this.mmessages);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Simple case, number of rings: " + this.fragSSSRLength);
                }
            } else {
                for (int step = 1; this.fragSSSRLength > this.ringsLength - this.ringLengthFragStart && step < maxSteps; ++step) {
                    int i = actualSet.nextSetBit(0);
                    while (i >= 0) {
                        this.send(i);
                        i = actualSet.nextSetBit(i + 1);
                    }
                    i = actualSet.nextSetBit(0);
                    while (i >= 0 && !foundAllSSSR) {
                        foundAllSSSR = this.receiveMerge(i);
                        i = actualSet.nextSetBit(i + 1);
                    }
                    i = actualSet.nextSetBit(0);
                    while (i >= 0 && !foundAllSSSR) {
                        foundAllSSSR = this.receiveNodeColl(i);
                        i = actualSet.nextSetBit(i + 1);
                    }
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Original case, number of rings: " + this.fragSSSRLength);
                }
            }
            this.freeup();
        }
        this.ringBondSetCalculated = true;
    }

    private static int fillActualSet(int[] fragID, BitSet actualSet) {
        actualSet.clear();
        int idx = -1;
        for (int i = 0; i < fragID.length; ++i) {
            if (fragID[i] < 0) continue;
            idx = i;
            break;
        }
        if (idx == -1) {
            return 0;
        }
        int n = 0;
        int id = fragID[idx];
        for (int i = idx; i < fragID.length; ++i) {
            if (fragID[i] != id) continue;
            fragID[i] = -1;
            actualSet.set(i);
            ++n;
        }
        return n;
    }

    private static int[] fillFragIDs(Smolecule m) {
        int ac = m.getAtomCount();
        Gearch g = m.gearch();
        int[] ids = new int[ac];
        for (int i = 0; i < ac; ++i) {
            ids[i] = g.fragId(0, i);
        }
        return ids;
    }

    final void send(int n) {
        INode nod = this.nodes[n];
        if (nod != null) {
            IMessage[] messages = nod.getSend();
            int ll = this.m.getNeighborCount(n);
            for (int j = 0; j < ll; ++j) {
                int nextNode = this.m.getNeighbor(n, j);
                if (this.nodes[nextNode] == null) continue;
                for (int i = 0; i < nod.getSendSize(); ++i) {
                    IMessage e = messages[i];
                    if (e.getLast().get(nextNode)) continue;
                    int bond = this.m.getBondIndex(n, nextNode);
                    IMessage newMessage = this.getNewPmessage(e, 0, 0);
                    newMessage.setLast(n);
                    newMessage.setMessage(bond);
                    this.nodes[nextNode].add(newMessage);
                }
            }
            for (int i = 0; i < nod.getSendSize(); ++i) {
                this.addToUnused(messages[i]);
            }
            nod.emptySendBuffer();
        }
    }

    final boolean receiveMerge(int n) {
        INode nod = this.nodes[n];
        if (nod != null) {
            int firstEdgeIdx;
            IMessage e;
            int i;
            IMessage[] messages = nod.getReceived();
            int recSize = nod.getReceivedSize();
            for (i = 0; i < recSize; ++i) {
                int firstNodeIdx;
                e = messages[i];
                firstEdgeIdx = e.getFirstEdge();
                int n2 = firstNodeIdx = this.m.getAtom1(firstEdgeIdx) == e.getFirst() ? 0 : 1;
                if (this.M[firstEdgeIdx][firstNodeIdx] == null) {
                    this.M[firstEdgeIdx][firstNodeIdx] = e;
                    this.N[firstEdgeIdx][firstNodeIdx] = i;
                    continue;
                }
                this.M[firstEdgeIdx][firstNodeIdx].mergeLast(e.getLast());
                this.addToUnused(e);
                messages[i] = null;
            }
            for (i = 0; i < recSize; ++i) {
                e = messages[i];
                if (e == null || this.M[firstEdgeIdx = e.getFirstEdge()][0] == null || this.M[firstEdgeIdx][1] == null) continue;
                if (this.join(this.M[firstEdgeIdx][0], this.M[firstEdgeIdx][1])) {
                    return true;
                }
                this.addToUnused(this.M[firstEdgeIdx][0]);
                this.addToUnused(this.M[firstEdgeIdx][1]);
                messages[this.N[firstEdgeIdx][0]] = null;
                messages[this.N[firstEdgeIdx][1]] = null;
            }
            for (i = 0; i < this.mmessages; ++i) {
                this.M[i][0] = null;
                this.M[i][1] = null;
            }
        }
        return false;
    }

    final boolean receiveNodeColl(int n) {
        INode nod = this.nodes[n];
        if (nod != null) {
            int i;
            IMessage[] messages = nod.getReceived();
            int recSize = nod.getReceivedSize();
            boolean[] foundRing = new boolean[recSize];
            for (i = 0; i < recSize; ++i) {
                IMessage e1 = messages[i];
                if (e1 == null) continue;
                int firstNodeIdx1 = e1.getFirst();
                for (int j = i + 1; j < recSize; ++j) {
                    int firstNodeIdx2;
                    IMessage e2 = messages[j];
                    if (e2 == null || firstNodeIdx1 != (firstNodeIdx2 = e2.getFirst())) continue;
                    if (this.join(e1, e2)) {
                        return true;
                    }
                    foundRing[i] = true;
                    foundRing[j] = true;
                }
            }
            for (i = 0; i < recSize; ++i) {
                IMessage e = messages[i];
                if (e != null && !foundRing[i]) {
                    nod.addToSend(e);
                    continue;
                }
                this.addToUnused(e);
            }
            nod.emptyReceivedBuffer();
        }
        return false;
    }

    final boolean join(IMessage e1, IMessage e2) {
        long[] beer = new long[this.mmessages / 64 + 1];
        long[] t = new long[this.mmessages / 64 + 1];
        SSSR.or(beer, e1.getLabel());
        SSSR.or(beer, e2.getLabel());
        SSSR.or(t, beer);
        SSSR.xor(t, e1.getLabel());
        SSSR.xor(t, e2.getLabel());
        SSSR.clear(e1.getFirstEdge(), t);
        SSSR.clear(e2.getFirstEdge(), t);
        if (!SSSR.isZero(t)) {
            return false;
        }
        return this.addToRing(beer, t);
    }

    final boolean addToRing(long[] beer, long[] beerc) {
        if (!this.contains(beer, false)) {
            System.arraycopy(beer, 0, beerc, 0, beer.length);
            if (this.gaussElim(beerc)) {
                this.rings[this.ringsLength++] = beer;
                return this.ringsLength - this.ringLengthFragStart == this.fragSSSRLength;
            }
        }
        return false;
    }

    final boolean gaussElim(long[] n) {
        if (this.nOfEchel == 0) {
            this.upEchel[this.nOfEchel++] = n;
            return true;
        }
        int firstSet = SSSR.getFirstSetBitPosition(n);
        int prevSet = -1;
        for (int i = 0; i < this.nOfEchel; ++i) {
            long[] actual = this.upEchel[i];
            int actualSet = SSSR.getFirstSetBitPosition(actual);
            if (prevSet < firstSet && firstSet < actualSet) {
                System.arraycopy(this.upEchel, i, this.upEchel, i + 1, this.nOfEchel - i);
                this.upEchel[i] = n;
                ++this.nOfEchel;
                return true;
            }
            if (firstSet != actualSet) continue;
            int nl = n.length;
            for (int z = 0; z < nl; ++z) {
                int n2 = z;
                n[n2] = n[n2] ^ actual[z];
            }
            firstSet = SSSR.getFirstSetBitPosition(n);
        }
        if (!SSSR.isZero(n)) {
            this.upEchel[this.nOfEchel++] = n;
            return true;
        }
        return false;
    }

    final boolean contains(long[] elem, boolean cssr) {
        if (this.ringsLength - this.ringLengthFragStart == 0) {
            return false;
        }
        if (!cssr && this.ringsLength - this.ringLengthFragStart == this.fragSSSRLength) {
            return true;
        }
        int eleml = elem.length;
        for (int i = this.ringsLength - 1; i >= this.ringLengthFragStart; --i) {
            long[] ring = this.rings[i];
            boolean equals = true;
            for (int j = 0; j < eleml && equals; ++j) {
                if ((elem[j] ^ ring[j]) == 0L) continue;
                equals = false;
            }
            if (!equals) continue;
            return true;
        }
        return false;
    }

    final void addToUnused(IMessage e) {
        if (e != null) {
            e.clear();
            if (this.unused == null) {
                this.unused = new IMessage[4];
            } else if (this.unusedLength >= this.unused.length) {
                IMessage[] tmp = new IMessage[this.unused.length * 2];
                System.arraycopy(this.unused, 0, tmp, 0, this.unused.length);
                this.unused = tmp;
            }
            this.unused[this.unusedLength++] = e;
        }
    }

    final IMessage getNewPmessage(IMessage e, int n, int fe) {
        IMessage ne;
        if (this.unusedLength > 0) {
            ne = this.unused[--this.unusedLength];
            this.unused[this.unusedLength] = null;
            ne.set(n, n, fe, this.mmessages);
            if (e != null) {
                ne.set(e);
            }
        } else {
            ne = new IMessage(n, n, fe, this.mmessages);
            if (e != null) {
                ne.set(e);
            }
        }
        return ne;
    }

    final void freeup() {
        int i;
        for (i = 0; this.nodes != null && i < this.nodes.length; ++i) {
            int j;
            INode nod = this.nodes[i];
            if (nod == null) continue;
            IMessage[] messages = nod.getSend();
            for (j = 0; j < nod.getSendSize(); ++j) {
                this.addToUnused(messages[j]);
            }
            nod.emptySendBuffer();
            messages = nod.getReceived();
            for (j = 0; j < nod.getReceivedSize(); ++j) {
                this.addToUnused(messages[j]);
            }
            nod.emptyReceivedBuffer();
        }
        for (i = 0; this.M != null && i < this.M.length; ++i) {
            this.M[i][0] = null;
            this.M[i][1] = null;
        }
        for (i = 0; i < this.nOfEchel; ++i) {
            this.upEchel[i] = null;
        }
    }

    final int cutBranch(BitSet actualSet, int[] edgeCount) {
        boolean changed;
        int i = actualSet.nextSetBit(0);
        while (i >= 0) {
            edgeCount[i] = this.m.getNeighborCount(i);
            i = actualSet.nextSetBit(i + 1);
        }
        do {
            changed = false;
            int i2 = actualSet.nextSetBit(0);
            while (i2 >= 0) {
                int conn = edgeCount[i2];
                if (conn == 1) {
                    SSSR.decreaseNeighbor(i2, this.m, edgeCount);
                    changed = true;
                }
                i2 = actualSet.nextSetBit(i2 + 1);
            }
        } while (changed);
        int maxConn = 0;
        int i3 = actualSet.nextSetBit(0);
        while (i3 >= 0) {
            int conn = edgeCount[i3];
            maxConn = conn > maxConn ? conn : maxConn;
            i3 = actualSet.nextSetBit(i3 + 1);
        }
        return maxConn;
    }

    static final void decreaseNeighbor(int i, Smolecule m, int[] edgeCount) {
        edgeCount[i] = 0;
        int ll = m.getNeighborCount(i);
        for (int j = 0; j < ll; ++j) {
            int ligand = m.getNeighbor(i, j);
            if (ligand == i) continue;
            int n = ligand;
            edgeCount[n] = edgeCount[n] - 1;
            if (edgeCount[n] != 1) continue;
            SSSR.decreaseNeighbor(ligand, m, edgeCount);
        }
    }

    final void generateCSSRfromSSSR() {
        if (this.ringsLength < 2) {
            return;
        }
        WSmolecule rg = SSSR.generateRingGraph(this.rings, this.ringsLength, this.mmessages);
        int bc = rg.getBondCount();
        for (int i = bc - 1; i >= 0; --i) {
            if (rg.getBondType(i) >= 3) continue;
            rg.removeBond(i);
        }
        int ac = rg.getAtomCount();
        for (int i = ac - 1; i >= 0; --i) {
            if (rg.getNeighborCount(i) != 0) continue;
            rg.removeAtom(i);
        }
        if (rg.getAtomCount() == 0) {
            return;
        }
        for (Smolecule rsystem : rg.gearch().findFrags(2, new StaticMolecule(), 256)) {
            int sl = rsystem.getAtomCount();
            int[] ridxes = new int[sl];
            for (int j = 0; j < sl; ++j) {
                ridxes[j] = rsystem.getAtomMap(j);
            }
            this.generateNewRing(ridxes);
        }
    }

    static final WSmolecule generateRingGraph(long[][] rings, int ringsLength, int mmessages) {
        StaticMolecule ringGraph = new StaticMolecule(ringsLength, ringsLength, 257);
        for (int i = 0; i < ringsLength; ++i) {
            ringGraph.addAtom(6);
            ringGraph.setAtomMap(i, i);
        }
        long[] commonBondSet = new long[mmessages / 64 + 1];
        for (int i = 0; i < ringsLength; ++i) {
            long[] set1 = rings[i];
            block6: for (int j = i + 1; j < ringsLength; ++j) {
                SSSR.clear(commonBondSet);
                SSSR.or(commonBondSet, set1);
                long[] set2 = rings[j];
                SSSR.and(commonBondSet, set2);
                switch (SSSR.cardinality(commonBondSet)) {
                    case 0: {
                        continue block6;
                    }
                    case 1: {
                        ringGraph.addBond(i, j, 2);
                        continue block6;
                    }
                    default: {
                        ringGraph.addBond(i, j, 3);
                    }
                }
            }
        }
        return ringGraph;
    }

    final void generateNewRing(int[] ridxes) {
        long[] possibleEdges = new long[this.mmessages / 64 + 1];
        SSSR.or(possibleEdges, this.rings[ridxes[0]]);
        int l = ridxes.length;
        for (int i = 1; i < l; ++i) {
            SSSR.xor(possibleEdges, this.rings[ridxes[i]]);
        }
        int newRingSize = SSSR.cardinality(possibleEdges);
        int lastRingSize = SSSR.cardinality(this.rings[ridxes[l - 1]]);
        if (newRingSize >= 14 || newRingSize > lastRingSize) {
            return;
        }
        long[] r = new long[this.mmessages / 64 + 1];
        SSSR.or(r, possibleEdges);
        int s = SSSR.getFirstSetBitPosition(r) - 1;
        int a1 = this.m.getAtom1(s);
        do {
            int j = 0;
            boolean found = false;
            int a2 = 0;
            do {
                int b;
                if (SSSR.get(b = this.m.getBondIndex(a1, a2 = this.m.getNeighbor(a1, j++)), r)) {
                    SSSR.clear(b, r);
                    found = true;
                }
                if (found || j != this.m.getNeighborCount(a1)) continue;
                return;
            } while (j < this.m.getNeighborCount(a1) && !found);
            a1 = a2;
        } while (!SSSR.isZero(r));
        if (this.ringsLength == this.rings.length) {
            long[][] tmp = new long[this.rings.length + 1][];
            System.arraycopy(this.rings, 0, tmp, 0, this.rings.length);
            this.rings = tmp;
        }
        this.rings[this.ringsLength++] = possibleEdges;
    }

    private static int cardinality(long[] x) {
        int l = x.length;
        int c = 0;
        for (int i = 0; i < l; ++i) {
            c += SSSR.cardinality(x[i]);
        }
        return c;
    }

    private static int cardinality(long val) {
        val -= (val & 0xAAAAAAAAAAAAAAAAL) >>> 1;
        val = (val & 0x3333333333333333L) + (val >>> 2 & 0x3333333333333333L);
        val = val + (val >>> 4) & 0xF0F0F0F0F0F0F0FL;
        val += val >>> 8;
        val += val >>> 16;
        return (int)val + (int)(val >>> 32) & 0xFF;
    }

    final void fillRingIdx(int[][] ri, long[][] rOrig) {
        if (this.ringIndexCalculated) {
            return;
        }
        if (this.ringsLength <= 0) {
            this.ringIdxes = new int[0][0];
            this.ringIndexCalculated = true;
            return;
        }
        int[] tmp = new int[this.m.getAtomCount()];
        int rl = this.mmessages / 64 + 1;
        long[] r = new long[rl];
        for (int z = 0; z < this.ringsLength; ++z) {
            System.arraycopy(rOrig[z], 0, r, 0, rl);
            int nr = 0;
            int s = SSSR.getFirstSetBitPosition(r) - 1;
            if (s > this.mmessages) {
                System.err.println("ERROR first set bit " + s);
            }
            int a1 = this.m.getAtom1(s);
            boolean lostConn = false;
            do {
                int j = 0;
                boolean found = false;
                int a2 = 0;
                do {
                    int b;
                    if (SSSR.get(b = this.m.getBondIndex(a1, a2 = this.m.getNeighbor(a1, j++)), r)) {
                        tmp[nr++] = a2;
                        SSSR.clear(b, r);
                        found = true;
                    }
                    boolean bl = lostConn = !found && j == this.m.getNeighborCount(a1);
                } while (j < this.m.getNeighborCount(a1) && !found);
                a1 = a2;
            } while (!SSSR.isZero(r) && !lostConn);
            int[] tmp2 = new int[nr];
            System.arraycopy(tmp, 0, tmp2, 0, tmp2.length);
            ri[z] = tmp2;
        }
        this.ringIndexCalculated = true;
    }

    static final void fillRingIdxFromAtoms(int[][] r, int[] noOfEdges, Smolecule m, int rl) {
        int l = noOfEdges.length;
        int n = 0;
        int[] tmp = new int[l];
        for (int z = 0; z < rl; ++z) {
            int idx = -1;
            for (int i = 0; i < l && idx < 0; ++i) {
                idx = noOfEdges[i] > 0 ? i : -1;
            }
            n = 0;
            noOfEdges[idx] = 0;
            tmp[n++] = idx;
            boolean found = false;
            do {
                found = false;
                int nc = m.getNeighborCount(idx);
                for (int i = 0; i < nc; ++i) {
                    int ligand = m.getNeighbor(idx, i);
                    if (noOfEdges[ligand] <= 0) continue;
                    idx = ligand;
                    found = true;
                    break;
                }
                if (!found) continue;
                noOfEdges[idx] = 0;
                tmp[n++] = idx;
            } while (found);
            int[] ring = new int[n];
            System.arraycopy(tmp, 0, ring, 0, n);
            r[z] = ring;
        }
    }

    final void setBondSet() {
        this.ringBonds = new long[this.m.getBondCount() / 64 + 1];
        int rbl = this.ringBonds.length;
        for (int z = 0; z < this.ringsLength; ++z) {
            for (int i = 0; i < rbl; ++i) {
                int n = i;
                this.ringBonds[n] = this.ringBonds[n] | this.rings[z][i];
            }
        }
    }

    final void setBondSetInt() {
        this.ringBondsInt = new int[this.m.getBondCount() / 32 + 1];
        int rbl = this.ringBondsInt.length;
        for (int z = 0; z < this.ringsLength; ++z) {
            for (int i = 0; i < rbl; ++i) {
                long l = this.rings[z][i / 2];
                int n = i;
                this.ringBondsInt[n] = this.ringBondsInt[n] | (i % 2 == 0 ? (int)(l >> 32) : (int)l);
            }
        }
    }

    final void setBondIndexes() {
        this.ringBondIndexes = new int[this.ringsLength][];
        int ec = this.m.getBondCount();
        int[] tmp = new int[ec];
        for (int z = 0; z < this.ringsLength; ++z) {
            int n = 0;
            for (int i = 0; i < ec; ++i) {
                if (!SSSR.get(i, this.rings[z])) continue;
                tmp[n++] = i;
            }
            this.ringBondIndexes[z] = new int[n];
            System.arraycopy(tmp, 0, this.ringBondIndexes[z], 0, n);
        }
    }

    final void generateOneRingBondSet(long[][] rings, int[] noOfEdges, Smolecule m, int mmessages) {
        long[] beer = new long[mmessages / 64 + 1];
        int l = noOfEdges.length;
        int startIdx = -1;
        for (int i = 0; i < l && startIdx < 0; ++i) {
            startIdx = noOfEdges[i] > 0 ? i : -1;
        }
        noOfEdges[startIdx] = 0;
        int idx = startIdx;
        boolean found = false;
        do {
            int b;
            found = false;
            int idx2 = -1;
            int nc = m.getNeighborCount(idx);
            for (int i = 0; i < nc; ++i) {
                int ligand = m.getNeighbor(idx, i);
                if (noOfEdges[ligand] <= 0) continue;
                idx2 = ligand;
                found = true;
                break;
            }
            if (found) {
                noOfEdges[idx] = 0;
                b = m.getBondIndex(idx, idx2);
                SSSR.set(b, beer);
                idx = idx2;
                idx2 = -1;
                if (!logger.isLoggable(Level.FINEST)) continue;
                logger.finest("bond index " + b);
                continue;
            }
            b = m.getBondIndex(idx, startIdx);
            SSSR.set(b, beer);
        } while (found);
        rings[this.ringsLength++] = beer;
    }

    static final int getFirstSetBitPosition(long[] x) {
        int xl = x.length;
        for (int k = 0; k < xl; ++k) {
            long bs = x[k];
            for (int i = 63; i >= 0; --i) {
                if ((bs & 1L << i) == 0L) continue;
                return 64 - i + k * 64;
            }
        }
        return x.length * 64;
    }

    static final boolean isZero(long[] x) {
        int xl = x.length;
        for (int k = 0; k < xl; ++k) {
            if (x[k] == 0L) continue;
            return false;
        }
        return true;
    }

    static final boolean get(int n, long[] r) {
        return (r[n / 64] & 1L << 63 - n % 64) != 0L;
    }

    private static final void set(int n, long[] a) {
        int n2 = n / 64;
        a[n2] = a[n2] | 1L << 63 - n % 64;
    }

    static final void clear(int n, long[] s) {
        int n2 = n / 64;
        s[n2] = s[n2] & (1L << 63 - n % 64 ^ 0xFFFFFFFFFFFFFFFFL);
    }

    static final void and(long[] x, long[] y) {
        int xl = x.length;
        for (int i = 0; i < xl; ++i) {
            int n = i;
            x[n] = x[n] & y[i];
        }
    }

    static final void or(long[] x, long[] y) {
        int xl = x.length;
        for (int i = 0; i < xl; ++i) {
            int n = i;
            x[n] = x[n] | y[i];
        }
    }

    static final void xor(long[] x, long[] y) {
        int xl = x.length;
        for (int i = 0; i < xl; ++i) {
            int n = i;
            x[n] = x[n] ^ y[i];
        }
    }

    private static final void clear(long[] x) {
        int xl = x.length;
        for (int i = 0; i < xl; ++i) {
            x[i] = 0L;
        }
    }

    public final long getGrinvCC() {
        return this.grinvCC;
    }

    public final void setGrinvCC(long value) {
        this.grinvCC = value;
    }

    final class IMessage {
        int first;
        BitSet last;
        int firstEdge;
        long[] beep;

        IMessage(int i, int j, int e, int k) {
            this.first = i;
            this.last = new BitSet();
            this.last.set(j);
            this.firstEdge = e;
            this.beep = new long[k / 64 + 1];
            SSSR.set(e, this.beep);
        }

        final int getFirst() {
            return this.first;
        }

        final BitSet getLast() {
            return this.last;
        }

        final void mergeLast(BitSet x) {
            this.last.or(x);
        }

        final int getFirstEdge() {
            return this.firstEdge;
        }

        final boolean hasPassedEdge(int x) {
            return (this.beep[x / 64] & 1L << 63 - x % 64) != 0L;
        }

        final long[] getLabel() {
            return this.beep;
        }

        final void setLabel(long[] l) {
            int length = this.beep.length < l.length ? this.beep.length : l.length;
            System.arraycopy(l, 0, this.beep, 0, length);
        }

        final void setLast(int n) {
            this.last.set(n);
        }

        final void clear() {
            this.last.clear();
        }

        final void setMessage(int n) {
            SSSR.set(n, this.beep);
        }

        final void set(IMessage e) {
            this.first = e.getFirst();
            this.last.or(e.getLast());
            this.firstEdge = e.getFirstEdge();
            long[] l = e.getLabel();
            if (l.length > this.beep.length) {
                this.beep = new long[l.length];
            }
            this.setLabel(l);
        }

        final void set(int i, int j, int e, int k) {
            this.first = i;
            this.last.clear();
            this.last.set(j);
            this.firstEdge = e;
            if (k / 64 + 1 > this.beep.length) {
                this.beep = new long[k / 64 + 1];
            } else {
                SSSR.clear(this.beep);
            }
            SSSR.set(e, this.beep);
        }
    }

    final class INode {
        private IMessage[] receiveB;
        private int recsize = 0;
        private IMessage[] sendB;
        private int sendsize = 0;

        INode() {
            this.receiveB = new IMessage[4];
        }

        INode(int i) {
            this.receiveB = new IMessage[i];
        }

        final void add(IMessage e) {
            if (this.receiveB == null) {
                this.receiveB = new IMessage[4];
            } else if (this.recsize >= this.receiveB.length) {
                IMessage[] tmp = new IMessage[this.recsize * 2];
                System.arraycopy(this.receiveB, 0, tmp, 0, this.recsize);
                this.receiveB = tmp;
            }
            this.receiveB[this.recsize++] = e;
        }

        final void addToSend(IMessage e) {
            if (this.sendB == null) {
                this.sendB = new IMessage[4];
            } else if (this.sendsize >= this.sendB.length) {
                IMessage[] tmp = new IMessage[this.sendsize * 2];
                System.arraycopy(this.sendB, 0, tmp, 0, this.sendsize);
                this.sendB = tmp;
            }
            this.sendB[this.sendsize++] = e;
        }

        final int getReceivedSize() {
            return this.recsize;
        }

        final IMessage[] getReceived() {
            return this.receiveB;
        }

        final int getSendSize() {
            return this.sendsize;
        }

        final IMessage[] getSend() {
            return this.sendB;
        }

        final void emptySendBuffer() {
            for (int i = 0; i < this.sendsize; ++i) {
                this.sendB[i] = null;
            }
            this.sendsize = 0;
        }

        final void emptyReceivedBuffer() {
            for (int i = 0; i < this.recsize; ++i) {
                this.receiveB[i] = null;
            }
            this.recsize = 0;
        }
    }
}

