/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.core.calculations;

import chemaxon.core.util.GeomUtil;
import chemaxon.struc.CTransform3D;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.SelectionMolecule;
import chemaxon.struc.Sgroup;
import chemaxon.struc.sgroup.SgroupAtom;
import chemaxon.struc.sgroup.SuperatomSgroup;
import java.util.ArrayList;
import java.util.List;

public class SuperatomSgroupCoords {
    private MoleculeGraph molecule = null;
    private MolBond[] sgroupBonds = null;
    private MoleculeGraph sgroupGraph = null;
    private int options = 0;
    private SelectionMolecule otherSgroup = null;

    public void setMolecule(MoleculeGraph molecule) {
        this.molecule = molecule;
    }

    public void setSgroupGraph(MoleculeGraph molecule) {
        this.sgroupGraph = molecule;
    }

    public void setSgroupBonds(MolBond[] bonds) {
        this.sgroupBonds = bonds;
    }

    public void setOptions(int options) {
        this.options = options;
        if ((this.options & 1) != 0) {
            this.options |= 8;
        }
    }

    public void setOtherSgroup(SelectionMolecule molecule) {
        this.otherSgroup = molecule;
    }

    public void contract(Sgroup sgroup) {
        SgroupAtom sa = ((SuperatomSgroup)sgroup).getSuperAtom();
        if (this.sgroupBonds.length == 1) {
            SuperatomSgroup sg = sa.getSgroup();
            MolAtom[] attachatoms = sg.getAttachAtoms();
            sa.setLocation(attachatoms[0].getLocation());
        } else {
            if (this.sgroupBonds.length == 0) {
                sa.setLocation(this.sgroupGraph.calcCenter());
            } else {
                SuperatomSgroup sg = sa.getSgroup();
                double x = 0.0;
                double y = 0.0;
                double z = 0.0;
                int n = this.sgroupBonds.length;
                MolAtom[] attachatoms = sg.getAttachAtoms();
                for (int i = 0; i < n; ++i) {
                    DPoint3 p = attachatoms[i].getLocation();
                    x += p.x;
                    y += p.y;
                    z += p.z;
                }
                sa.setXYZ(x / (double)n, y / (double)n, z / (double)n);
            }
            List<MolBond> skipped = this.translateUnconnectedParts(sa);
            int[] fragIds = this.molecule.getFragIds(1);
            for (int j1 = skipped.size() - 1; j1 >= 0; --j1) {
                MolBond b1 = skipped.get(j1);
                MolAtom a1 = b1.getOtherAtom(sa);
                int i1 = this.molecule.indexOf(a1);
                int id1 = fragIds[i1];
                MolBond b2 = null;
                int n = 1;
                int j2 = -1;
                for (int k = j1 - 1; k >= 0; --k) {
                    MolBond b = skipped.get(k);
                    MolAtom a = b.getOtherAtom(sa);
                    int i = this.molecule.indexOf(a);
                    int id = fragIds[i];
                    if (id1 != id) continue;
                    b2 = b;
                    j2 = k;
                    ++n;
                }
                if (n != 2) continue;
                this.contract2ConnectedAtoms(sa, b1, b2);
                skipped.remove(j1);
                skipped.remove(j2);
                --j1;
            }
        }
    }

    public void expand(SgroupAtom sa) {
        if (this.sgroupBonds.length == 1) {
            MolAtom a = this.getAtomInSgroup(this.sgroupBonds[0], sa);
            DPoint3 p = a.getLocation();
            DPoint3 psg = sa.getLocation();
            CTransform3D t0 = new CTransform3D();
            t0.setTranslation(psg.x - p.x, psg.y - p.y, psg.z - p.z);
            this.sgroupGraph.transform(t0);
            p.x = psg.x;
            p.y = psg.y;
            p.z = psg.z;
            MolAtom aa = this.sgroupBonds[0].getOtherAtom(a);
            double alpha = p.angle2D(aa.getX(), aa.getY());
            double[] largest = GeomUtil.getLargestBondAngle2D(a);
            double beta = largest[0] + largest[1] / 2.0;
            int nb = a.getBondCount();
            double phi = alpha - beta;
            double[] badness = new double[]{Double.MAX_VALUE};
            if ((this.options & 8) != 0) {
                t0.setIdentity();
                t0.setRotation(0.0, 0.0, 1.0, phi);
                t0.setRotationCenter(p);
                this.sgroupGraph.transform(t0);
            } else if (nb == 1) {
                t0.setIdentity();
                t0.setRotation(0.0, 0.0, 1.0, phi -= 1.0471975511965976);
                t0.setRotationCenter(p);
                this.sgroupGraph.transform(t0);
            } else {
                double dphi = Math.PI * 2 / (double)nb;
                CTransform3D t1 = new CTransform3D();
                double[] savedcoords = this.createSavedCoordsArray(this.sgroupGraph);
                int[] savedbflags = this.createSavedBondFlagsArray(this.sgroupGraph);
                if (Math.abs(largest[1] - dphi) < 0.1 * dphi) {
                    double gamma = 0.2617993877991494;
                    this.tryRotations(badness, t0, t1, p, phi += gamma, dphi, nb, savedcoords);
                } else {
                    t0.setIdentity();
                    t0.setRotation(0.0, 0.0, 1.0, phi);
                    t0.setRotationCenter(p);
                    this.sgroupGraph.transform(t0);
                    badness[0] = GeomUtil.calcBadness(this.molecule, this.sgroupGraph, null, this.sgroupBonds);
                }
                this.tryMirror(badness, t0, t1, alpha, p, savedcoords, savedbflags);
            }
        } else {
            DPoint3 center = this.sgroupGraph.calcCenter();
            DPoint3 origin = sa.getLocation();
            double dx = origin.x - center.x;
            double dy = origin.y - center.y;
            double dz = origin.z - center.z;
            CTransform3D t = new CTransform3D();
            t.setTranslation(dx, dy, dz);
            this.sgroupGraph.transform(t);
            if (this.sgroupBonds.length == 2) {
                MolAtom a1 = this.getAtomInSgroup(this.sgroupBonds[0], sa);
                MolAtom a2 = this.getAtomInSgroup(this.sgroupBonds[1], sa);
                MolAtom aa1 = this.sgroupBonds[0].getOtherAtom(a1);
                MolAtom aa2 = this.sgroupBonds[1].getOtherAtom(a2);
                DPoint3 p1 = a1.getLocation();
                DPoint3 pp1 = aa1.getLocation();
                double alpha = pp1.angle2D(aa2.getX(), aa2.getY());
                double beta = p1.angle2D(a2.getX(), a2.getY());
                t.setIdentity();
                t.setRotation(0.0, 0.0, 1.0, alpha - beta);
                t.setRotationCenter(origin);
                this.sgroupGraph.transform(t);
            }
            List<MolBond> skipped = this.translateUnconnectedParts(sa);
            int[] fragIds = this.molecule.getFragIds(1);
            for (int j1 = skipped.size() - 1; j1 >= 0; --j1) {
                MolBond b1 = skipped.get(j1);
                MolAtom aa1 = b1.getAtom1();
                MolAtom a1 = b1.getAtom2();
                if (this.sgroupGraph.contains(a1)) {
                    MolAtom tmp = a1;
                    a1 = aa1;
                    aa1 = tmp;
                }
                int i1 = this.molecule.indexOf(a1);
                int id1 = fragIds[i1];
                MolAtom aa2 = null;
                MolBond b2 = null;
                int n = 1;
                int j2 = -1;
                for (int k = j1 - 1; k >= 0; --k) {
                    int i;
                    int id;
                    MolBond b = skipped.get(k);
                    MolAtom aa = b.getAtom1();
                    MolAtom a = b.getAtom2();
                    if (this.sgroupGraph.contains(a)) {
                        MolAtom tmp = a;
                        a = aa;
                        aa = tmp;
                    }
                    if (id1 != (id = fragIds[i = this.molecule.indexOf(a)])) continue;
                    aa2 = aa;
                    b2 = b;
                    j2 = k;
                    ++n;
                }
                if (n != 2) continue;
                this.expand2ConnectedAtoms(aa1, b1, aa2, b2);
                skipped.remove(j1);
                skipped.remove(j2);
                --j1;
            }
        }
    }

    public void expandSgroups(SgroupAtom sa) {
        if (this.sgroupBonds.length == 1) {
            MolAtom a = this.getAtomInSgroup(this.sgroupBonds[0], sa);
            DPoint3 p = a.getLocation();
            DPoint3 psg = sa.getLocation();
            CTransform3D t0 = new CTransform3D();
            t0.setTranslation(psg.x - p.x, psg.y - p.y, psg.z - p.z);
            this.sgroupGraph.transform(t0);
            this.otherSgroup.transform(t0);
            p.x = psg.x;
            p.y = psg.y;
            p.z = psg.z;
            MolAtom aa = this.sgroupBonds[0].getOtherAtom(a);
            double alpha = p.angle2D(aa.getX(), aa.getY());
            double[] largest = GeomUtil.getLargestBondAngle2D(a);
            double beta = largest[0] + largest[1] / 2.0;
            int nb = a.getBondCount();
            double phi = alpha - beta;
            double[] badness = new double[]{Double.MAX_VALUE};
            if ((this.options & 8) != 0) {
                t0.setIdentity();
                t0.setRotation(0.0, 0.0, 1.0, phi);
                t0.setRotationCenter(p);
                this.sgroupGraph.transform(t0);
                this.otherSgroup.transform(t0);
            } else if (nb == 1) {
                t0.setIdentity();
                t0.setRotation(0.0, 0.0, 1.0, phi -= 1.0471975511965976);
                t0.setRotationCenter(p);
                this.sgroupGraph.transform(t0);
                this.otherSgroup.transform(t0);
            } else {
                double dphi = Math.PI * 2 / (double)nb;
                CTransform3D t1 = new CTransform3D();
                double[] savedcoords = this.createSavedCoordsArray(this.sgroupGraph);
                int[] savedbflags = this.createSavedBondFlagsArray(this.sgroupGraph);
                if (Math.abs(largest[1] - dphi) < 0.1 * dphi) {
                    double gamma = 0.2617993877991494;
                    boolean rotated = this.tryRotations(badness, t0, t1, p, phi += gamma, dphi, nb, savedcoords);
                    if (rotated) {
                        this.otherSgroup.transform(t0);
                    }
                } else {
                    t0.setIdentity();
                    t0.setRotation(0.0, 0.0, 1.0, phi);
                    t0.setRotationCenter(p);
                    this.sgroupGraph.transform(t0);
                    this.otherSgroup.transform(t0);
                    badness[0] = GeomUtil.calcBadness(this.molecule, this.sgroupGraph, null, this.sgroupBonds);
                }
                boolean mirrored = this.tryMirror(badness, t0, t1, alpha, p, savedcoords, savedbflags);
                if (mirrored) {
                    this.otherSgroup.transform(t0);
                }
            }
        }
    }

    public void expand(SuperatomSgroup sgroup) {
        this.expand(sgroup.getSuperAtom());
    }

    private void expand2ConnectedAtoms(MolAtom aa1, MolBond b1, MolAtom aa2, MolBond b2) {
        MolAtom a1 = b1.getOtherAtom(aa1);
        MolAtom a2 = b2.getOtherAtom(aa2);
        DPoint3 pa1 = aa1.getLocation();
        DPoint3 pa2 = aa2.getLocation();
        DPoint3 p1 = a1.getLocation();
        DPoint3 p2 = a2.getLocation();
        double dx1a1 = p1.x - pa1.x;
        double dy1a1 = p1.y - pa1.y;
        double dz1a1 = p1.z - pa1.z;
        double dx2a2 = p2.x - pa2.x;
        double dy2a2 = p2.y - pa2.y;
        double dz2a2 = p2.z - pa2.z;
        double dr1a1sq = dx1a1 * dx1a1 + dy1a1 * dy1a1 + dz1a1 * dz1a1;
        double dr2a2sq = dx2a2 * dx2a2 + dy2a2 * dy2a2 + dz2a2 * dz2a2;
        double R1 = this.molecule.getDesiredLength(b1);
        double R2 = this.molecule.getDesiredLength(b2);
        double a = R1 * R1 - R2 * R2 - dr1a1sq + dr2a2sq;
        double bx = 2.0 * (dx1a1 - dx2a2);
        double by = 2.0 * (dy1a1 - dy2a2);
        double c0 = by * by * (R1 * R1 - dr1a1sq) - a * a - 2.0 * by * a * dy1a1;
        double c1 = 2.0 * (a * bx - by * by * dx1a1 + bx * by * dy1a1);
        double c2 = -bx * bx - by * by;
        double d = c1 * c1 - 4.0 * c0 * c2;
        double eps2 = 2.3716E-12;
        SelectionMolecule g = new SelectionMolecule();
        this.molecule.findFrag(this.molecule.indexOf(a1), 1, g);
        double[] badness = new double[]{Double.MAX_VALUE};
        double[] savedcoords = this.createSavedCoordsArray(g);
        this.tryNewPosition(badness, new DPoint3(0.0, 0.0, 0.0), g, null, savedcoords);
        if ((this.options & 8) == 0 && d >= eps2 * eps2 * eps2 && Math.abs(c2) > eps2) {
            d = Math.sqrt(d);
            double dx = (-c1 - d) / (2.0 * c2);
            DPoint3 testdr = new DPoint3(dx, (a - bx * dx) / by, 0.0);
            this.tryNewPosition(badness, testdr, g, null, savedcoords);
            dx = (-c1 + d) / (2.0 * c2);
            testdr = new DPoint3(dx, (a - bx * dx) / by, 0.0);
            this.tryNewPosition(badness, testdr, g, null, savedcoords);
        }
    }

    private List<MolBond> translateUnconnectedParts(SgroupAtom sa) {
        int[] fragIds = this.molecule.getFragIds(1);
        ArrayList<MolBond> skipped = new ArrayList<MolBond>();
        for (int i = 0; i < this.sgroupBonds.length; ++i) {
            MolBond b1 = this.sgroupBonds[i];
            MolAtom aa1 = this.getAtomInSgroup(b1, sa);
            MolAtom a1 = b1.getOtherAtom(aa1);
            int i1 = this.molecule.indexOf(a1);
            for (int j = i + 1; j < this.sgroupBonds.length; ++j) {
                MolBond b2 = this.sgroupBonds[j];
                MolAtom aa2 = this.getAtomInSgroup(b2, sa);
                MolAtom a2 = b2.getOtherAtom(aa2);
                int i2 = this.molecule.indexOf(a2);
                if (fragIds[i1] != fragIds[i2]) continue;
                if (!skipped.contains(b1)) {
                    skipped.add(b1);
                }
                if (skipped.contains(b2)) continue;
                skipped.add(b2);
            }
        }
        if (skipped.size() != this.sgroupBonds.length) {
            DPoint3 psg = sa.getLocation();
            MolAtom ag1 = this.getAtomInSgroup(this.sgroupBonds[0], sa);
            MolAtom a1 = this.sgroupBonds[0].getOtherAtom(ag1);
            int i1 = this.molecule.indexOf(a1);
            DPoint3 p1 = a1.getLocation();
            CTransform3D t = new CTransform3D();
            for (int i = 0; i < this.sgroupBonds.length; ++i) {
                MolBond b = this.sgroupBonds[i];
                if (skipped.contains(b)) continue;
                MolAtom ag = this.getAtomInSgroup(b, sa);
                MolAtom a = b.getOtherAtom(ag);
                int j = this.molecule.indexOf(a);
                DPoint3 pg = ag.getLocation();
                DPoint3 p = a.getLocation();
                SelectionMolecule g = new SelectionMolecule();
                this.molecule.findFrag(this.molecule.indexOf(a), 1, g);
                double dx = p.x - psg.x;
                double dy = p.y - psg.y;
                double dz = p.z - psg.z;
                double dr = Math.sqrt(dx * dx + dy * dy + dz * dz);
                double epsilon = 0.0015400000000000001;
                epsilon *= epsilon;
                if (!(dr > epsilon)) continue;
                double q = 1.54 / dr - 1.0;
                dx *= q;
                dy *= q;
                dz *= q;
                t.setTranslation(dx += pg.x - psg.x, dy += pg.y - psg.y, dz += pg.z - psg.z);
                g.transform(t);
            }
        }
        return skipped;
    }

    private void contract2ConnectedAtoms(SgroupAtom sa, MolBond b1, MolBond b2) {
        DPoint3 q0;
        SuperatomSgroup sg = sa.getSgroup();
        MolAtom[] attachatoms = sg.getAttachAtoms();
        MolAtom aa1 = attachatoms[sa.indexOf(b1)];
        MolAtom aa2 = attachatoms[sa.indexOf(b2)];
        MolAtom a1 = b1.getOtherAtom(sa);
        MolAtom a2 = b2.getOtherAtom(sa);
        SelectionMolecule g = new SelectionMolecule();
        this.molecule.findFrag(this.molecule.indexOf(a1), 1, g);
        DPoint3 p1 = aa1.getLocation();
        DPoint3 p2 = aa2.getLocation();
        DPoint3 pos = sa.getLocation();
        DPoint3 testpos = new DPoint3((p1.x + p2.x) / 2.0, (p1.y + p2.y) / 2.0, (p1.z + p2.z) / 2.0);
        double[] badness = new double[]{Double.MAX_VALUE};
        double[] savedcoords = this.createSavedCoordsArray(g);
        this.tryNewPosition(badness, SuperatomSgroupCoords.minus(pos, testpos), g, sa, savedcoords);
        if ((this.options & 8) != 0) {
            return;
        }
        a1.getLocation(p1);
        a2.getLocation(p2);
        double dx = p2.x - p1.x;
        double dy = p2.y - p1.y;
        double dz = p2.z - p1.z;
        double dr = Math.sqrt(dx * dx + dy * dy + dz * dz);
        testpos = q0 = new DPoint3((p1.x + p2.x) / 2.0, (p1.y + p2.y) / 2.0, (p1.z + p2.z) / 2.0);
        this.tryNewPosition(badness, SuperatomSgroupCoords.minus(pos, testpos), g, sa, savedcoords);
        double rxy = Math.sqrt(dx * dx + dy * dy);
        double ex = -dy / rxy;
        double ey = dx / rxy;
        if (dr / 2.0 < 1.54) {
            double r = Math.sqrt(2.3716 - dr * dr / 4.0);
            testpos = new DPoint3(q0.x + ex * r, q0.y + ey * r, q0.z);
            this.tryNewPosition(badness, SuperatomSgroupCoords.minus(pos, testpos), g, sa, savedcoords);
            testpos = new DPoint3(q0.x - ex * r, q0.y - ey * r, q0.z);
            this.tryNewPosition(badness, SuperatomSgroupCoords.minus(pos, testpos), g, sa, savedcoords);
        }
    }

    private boolean tryNewPosition(double[] badness, DPoint3 dr, SelectionMolecule g, SgroupAtom sa, double[] savedcoords) {
        this.saveCoords(g, savedcoords);
        CTransform3D t = new CTransform3D();
        t.setTranslation(dr.x, dr.y, dr.z);
        g.transform(t);
        if ((this.options & 8) != 0) {
            return true;
        }
        double b = GeomUtil.calcBadness(this.molecule, g, sa, this.sgroupBonds);
        if (b < badness[0]) {
            badness[0] = b;
            return true;
        }
        this.restoreCoords(g, savedcoords);
        return false;
    }

    private boolean tryRotations(double[] badness, CTransform3D t0, CTransform3D t1, DPoint3 p, double phi0, double dphi, int n, double[] savedcoords) {
        this.saveCoords(this.sgroupGraph, savedcoords);
        double minbadness = badness[0];
        double phi = phi0;
        t1.setIdentity();
        for (int i = 0; i < n; ++i) {
            t1.setRotation(0.0, 0.0, 1.0, phi);
            t1.setRotationCenter(p);
            this.sgroupGraph.transform(t1);
            double b = GeomUtil.calcBadness(this.molecule, this.sgroupGraph, null, this.sgroupBonds);
            if (b < minbadness) {
                t0.set(t1);
                minbadness = b;
            }
            this.restoreCoords(this.sgroupGraph, savedcoords);
            phi += dphi;
        }
        if (minbadness < badness[0]) {
            this.sgroupGraph.transform(t0);
            badness[0] = minbadness;
            return true;
        }
        return false;
    }

    private boolean tryMirror(double[] badness, CTransform3D t0, CTransform3D t1, double phi, DPoint3 p, double[] savedcoords, int[] savedbflags) {
        this.saveCoords(this.sgroupGraph, savedcoords);
        this.saveBondFlags(this.sgroupGraph, savedbflags);
        t0.setIdentity();
        t0.setRotation(0.0, 0.0, 1.0, -phi);
        t1.setIdentity();
        t1.m11 = -1.0;
        t1.mul(t0);
        t0.setRotation(0.0, 0.0, 1.0, phi);
        t0.mul(t1);
        t0.setRotationCenter(p);
        this.sgroupGraph.transform(t0);
        double b = GeomUtil.calcBadness(this.molecule, this.sgroupGraph, null, this.sgroupBonds);
        if (b < badness[0] * 0.999) {
            badness[0] = b;
            this.flipUpDownWedges(this.sgroupGraph);
            return true;
        }
        this.restoreCoords(this.sgroupGraph, savedcoords);
        this.restoreBondFlags(this.sgroupGraph, savedbflags);
        return false;
    }

    private void flipUpDownWedges(MoleculeGraph sgg) {
        for (MolBond b : sgg.getBondArray()) {
            int f = b.getFlags() & 0x30;
            if (f == 16) {
                b.setFlags(32, 48);
                continue;
            }
            if (f != 32) continue;
            b.setFlags(16, 48);
        }
    }

    private MolAtom getAtomInSgroup(MolBond b, SgroupAtom sa) {
        MolAtom a1 = b.getAtom1();
        MolAtom a2 = b.getAtom2();
        if (a1 == sa || a2 == sa) {
            return sa;
        }
        if (this.sgroupGraph.contains(a1)) {
            return a1;
        }
        if (this.sgroupGraph.contains(a2)) {
            return a2;
        }
        return null;
    }

    private static DPoint3 minus(DPoint3 p, DPoint3 q) {
        return new DPoint3(p.x - q.x, p.y - q.y, p.z - q.z);
    }

    private double[] createSavedCoordsArray(MoleculeGraph g) {
        if ((this.options & 8) == 0) {
            return GeomUtil.createSavedCoordsArray(g);
        }
        return null;
    }

    private void saveCoords(MoleculeGraph g, double[] coords) {
        if ((this.options & 8) == 0) {
            GeomUtil.saveCoords(g, coords);
        }
    }

    private void restoreCoords(MoleculeGraph g, double[] coords) {
        if ((this.options & 8) == 0) {
            GeomUtil.restoreCoords(g, coords);
        }
    }

    private int[] createSavedBondFlagsArray(MoleculeGraph g) {
        if ((this.options & 8) == 0) {
            int nb = g.getBondCount();
            return new int[nb];
        }
        return null;
    }

    private void saveBondFlags(MoleculeGraph g, int[] bflags) {
        if ((this.options & 8) == 0) {
            int nb = g.getBondCount();
            for (int i = 0; i < nb; ++i) {
                bflags[i] = g.getBond(i).getFlags();
            }
        }
    }

    private void restoreBondFlags(MoleculeGraph g, int[] bflags) {
        if ((this.options & 8) == 0) {
            int nb = g.getBondCount();
            boolean k = false;
            for (int i = 0; i < nb; ++i) {
                g.getBond(i).setFlags(bflags[i]);
            }
        }
    }
}

