/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.core.calculations;

import chemaxon.core.calculations.AtomWithValence;
import chemaxon.core.calculations.HashMapValenceCollection;
import chemaxon.core.calculations.MoleculeWithValence;
import chemaxon.core.calculations.Valence;
import chemaxon.core.calculations.ValenceCollection;
import java.util.Iterator;

public class ValenceCalculator {
    private boolean isAromaticIgnored = false;

    public ValenceCalculator() {
    }

    public ValenceCalculator(boolean ignoreAmbiguousAromaticAtoms) {
        this.isAromaticIgnored = ignoreAmbiguousAromaticAtoms;
    }

    public void setIgnoreAmbiguousAromaticAtoms(boolean ignoreAmbiguousAromaticAtoms) {
        this.isAromaticIgnored = ignoreAmbiguousAromaticAtoms;
    }

    public int calculateFreeValenceElectronCount(AtomWithValence atom) {
        return 0;
    }

    private int[] calculateFreeValenceElectronCount(MoleculeWithValence molecule) {
        return new int[0];
    }

    private Valence calculateValence(AtomWithValence atom, int freeValenceElectronCount) {
        if (freeValenceElectronCount <= 0) {
            return new Valence(freeValenceElectronCount, 0);
        }
        return null;
    }

    public ValenceCollection calculateValence(MoleculeWithValence molecule) {
        int[] freeValenceElectrons = this.calculateFreeValenceElectronCount(molecule);
        HashMapValenceCollection toReturn = new HashMapValenceCollection();
        Iterator<AtomWithValence> atomIterator = molecule.getAtomIterator();
        for (int i : freeValenceElectrons) {
            AtomWithValence atom = atomIterator.next();
            toReturn.addValence(atom, this.calculateValence(atom, freeValenceElectrons[i]));
        }
        return toReturn;
    }
}

