/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.core.calculations;

import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;

public class ValenceCalculatorUtil {
    protected static int[] getPossibleDelocElectronCount(MolAtom atom) {
        int charge = atom.getCharge();
        if (charge * charge > 1) {
            // empty if block
        }
        int[] result = null;
        int correctedColumnNumber = ValenceCalculatorUtil.getCorrectedColumnNumber(atom);
        switch (correctedColumnNumber) {
            case 5: {
                result = ValenceCalculatorUtil.calculateBoronLikeDelocalizedElectronCount(atom);
                break;
            }
            case 6: {
                result = new int[]{1};
                break;
            }
            case 7: {
                result = ValenceCalculatorUtil.calculateNitrogenLikeDelocalizedElectronCount(atom);
                break;
            }
            case 8: {
                result = new int[]{2};
                break;
            }
            default: {
                result = new int[]{0};
            }
        }
        return result;
    }

    private static int[] calculateNitrogenLikeDelocalizedElectronCount(MolAtom atom) {
        if (atom.getRealBondCount() > 2 || atom.getRadicalCount() != 0) {
            return new int[]{2};
        }
        return new int[]{1, 2};
    }

    private static int[] calculateBoronLikeDelocalizedElectronCount(MolAtom atom) {
        if (atom.getBondCount() > 2 || atom.getRadicalCount() != 0) {
            return new int[]{0};
        }
        return new int[]{0, 1};
    }

    private static int getCorrectedColumnNumber(MolAtom atom) {
        int atNo = atom.getAtno();
        int charge = atom.getCharge();
        if (atNo > 8) {
            atNo -= 8;
        }
        return atNo - charge + ValenceCalculatorUtil.exocyclicBondCorrection(atom);
    }

    private static int exocyclicBondCorrection(MolAtom atom) {
        if (ValenceCalculatorUtil.hasDoubleBondedExocyclic(atom)) {
            return -1;
        }
        return 0;
    }

    private static boolean hasDoubleBondedExocyclic(MolAtom atom) {
        int atNo = atom.getAtno();
        for (int i = 0; i < atom.getBondCount(); ++i) {
            MolBond mb = atom.getBond(i);
            if (mb == null || mb.getType() != 2) continue;
            MolAtom ma = mb.getOtherAtom(atom);
            int ligandAtno = ma.getAtno();
            if (ligandAtno == 8 || ligandAtno == 16) {
                return true;
            }
            if (ligandAtno != 7 && ligandAtno != 15 || atNo != 7 && atNo != 15 && !ValenceCalculatorUtil.isExocyclic(ma)) continue;
            return true;
        }
        return false;
    }

    private static boolean isExocyclic(MolAtom atom) {
        return atom.sringsize() == Integer.MAX_VALUE;
    }
}

