/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.core.calculations;

import chemaxon.common.util.IntVector;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.PeriodicSystem;
import chemaxon.struc.Sgroup;
import chemaxon.struc.sgroup.SgroupAtom;
import chemaxon.struc.sgroup.SuperatomSgroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ValenceCheck {
    public static void check(MolAtom atom) {
        ValenceCheck.check(atom, false);
    }

    public static void check(MolAtom atom, boolean ignoreAmbiguousAromaticAtoms) {
        if ((atom.getFlags() & 0x4000) == 0) {
            atom.setFlags(atom.getFlags() | 0x4000);
        }
        if (atom.hasQueryBonds()) {
            atom.setValenceError(false);
            atom.setImplicitHcount(0);
            return;
        }
        if (ValenceCheck.qpropCheck(atom)) {
            return;
        }
        AtomClass a = null;
        int flags = atom.getFlags();
        int chSet = flags & 0x10000;
        boolean chargeNotSet = chSet == 0;
        int atomNumber = atom.getAtno();
        int valenceProp = atom.getValenceProp();
        if (valenceProp < 0) {
            int columnNumber = PeriodicSystem.getColumn(atomNumber);
            switch (columnNumber) {
                case 1: {
                    a = new AtomClass(atom, chargeNotSet);
                    ValenceCheck.checkAlkaliMetal(a);
                    break;
                }
                case 2: {
                    a = new AtomClass(atom, chargeNotSet);
                    ValenceCheck.checkAlkaliEarthMetal(a);
                    break;
                }
                case 13: {
                    a = new AtomClass(atom, chargeNotSet);
                    ValenceCheck.checkBoronFamily(a);
                    break;
                }
                case 14: {
                    a = new AtomClass(atom, chargeNotSet);
                    ValenceCheck.checkCarbonFamily(a);
                    break;
                }
                case 15: {
                    a = new AtomClass(atom, chargeNotSet);
                    ValenceCheck.checkNitrogenFamily(a, ignoreAmbiguousAromaticAtoms);
                    break;
                }
                case 16: {
                    a = new AtomClass(atom, chargeNotSet);
                    ValenceCheck.checkOxigenFamily(a);
                    break;
                }
                case 17: {
                    a = new AtomClass(atom, chargeNotSet);
                    ValenceCheck.checkHalogen(a);
                    break;
                }
                case 18: {
                    a = new AtomClass(atom, chargeNotSet);
                    ValenceCheck.checkNobleGas(a);
                    break;
                }
                default: {
                    atom.setValenceError(false);
                    atom.setImplicitHcount(0);
                    return;
                }
            }
        } else {
            a = new AtomClass(atom, chargeNotSet);
            int electronCountInBonds = ValenceCheck.getBondingElectronCount(atom);
            int nH = valenceProp - electronCountInBonds / 2;
            if (nH >= 0) {
                a.calculatedCharge = atom.getCharge();
                a.calculatedImplicitHCount = nH;
                atom.setValenceError(false);
                if (valenceProp == 4 && (atom.getAtno() == 7 || atom.getAtno() == 15) && chargeNotSet) {
                    a.calculatedCharge = 1;
                }
            } else {
                atom.setValenceError(true);
            }
        }
        if (chargeNotSet && a.calculatedCharge != atom.getCharge()) {
            atom.setCharge(a.calculatedCharge);
            atom.setFlags(atom.getFlags() & 0xFFFEFFFF);
        }
        if (a.calculatedImplicitHCount < 0) {
            atom.setValenceError(true);
            return;
        }
        if (a.calculatedImplicitHCount != atom.getImplicitHcount()) {
            atom.setImplicitHcount(a.calculatedImplicitHCount);
        }
    }

    private static boolean qpropCheck(MolAtom atom) {
        atom.qpropCheck();
        return atom.hasValenceError();
    }

    private static void checkNobleGas(AtomClass a) {
        MolAtom atom = a.ma;
        int electronCountInBonds = ValenceCheck.getBondingElectronCount(atom);
        int charge = atom.getCharge();
        int radical = atom.getRadicalCount();
        int atomNumber = atom.getAtno();
        if ((charge < 0 ? -charge : charge) + radical + electronCountInBonds == 0) {
            atom.setValenceError(false);
            return;
        }
        if (radical != 0 || charge != 0) {
            atom.setValenceError(true);
            return;
        }
        if (atomNumber >= 36) {
            if ((electronCountInBonds /= 2) == 2) {
                atom.setValenceError(false);
                return;
            }
            if (atomNumber == 54 && electronCountInBonds % 2 == 0 && electronCountInBonds < 9) {
                atom.setValenceError(false);
                return;
            }
        }
        atom.setValenceError(true);
    }

    private static void checkHalogen(AtomClass a) {
        MolAtom atom = a.ma;
        atom.setValenceError(true);
        int electronCountInBonds = ValenceCheck.getBondingElectronCount(atom);
        int charge = atom.getCharge();
        int radical = atom.getRadicalCount();
        int bondCount = atom.getRealBondCount();
        if (bondCount == 0 && charge == 0 && radical != 0) {
            atom.setValenceError(false);
            a.calculatedImplicitHCount = 0;
            a.calculatedCharge = 0;
            return;
        }
        int nH = 1;
        nH += charge;
        nH -= electronCountInBonds / 2;
        if ((nH -= radical) >= 0) {
            atom.setValenceError(false);
            a.calculatedImplicitHCount = nH;
            a.calculatedCharge = charge;
        }
        int oxState = electronCountInBonds / 2 - charge + radical;
        int atNo = atom.getAtno();
        if (atNo > 9 && (oxState == 3 || oxState == 5 || oxState == 7 && atNo != 35)) {
            int numberOfnotHalogenorOAtoms = 0;
            for (int i = 0; i < atom.getBondCount(); ++i) {
                int ligAtNo;
                MolAtom ligand;
                MolBond mb = atom.getBond(i);
                if (mb == null) continue;
                int bondType = mb.getType();
                if (bondType == 1) {
                    ligand = mb.getOtherAtom(atom);
                    ligAtNo = ligand.getAtno();
                    if (ligAtNo == 9 || ligAtNo == 17 || ligAtNo == 8 || ligAtNo > 109) continue;
                    ++numberOfnotHalogenorOAtoms;
                    continue;
                }
                if (bondType == 2) {
                    ligand = mb.getOtherAtom(atom);
                    ligAtNo = ligand.getAtno();
                    if (ligAtNo == 8 || ligAtNo > 109) continue;
                    numberOfnotHalogenorOAtoms += 20;
                    continue;
                }
                if (bondType <= 2) continue;
                numberOfnotHalogenorOAtoms += 20;
            }
            if (numberOfnotHalogenorOAtoms > 1) {
                atom.setValenceError(true);
                a.calculatedImplicitHCount = 0;
                a.calculatedCharge = 0;
                return;
            }
            atom.setValenceError(false);
            a.calculatedImplicitHCount = 0;
            a.calculatedCharge = 0;
        }
    }

    private static void checkOxigenFamily(AtomClass a) {
        MolAtom atom = a.ma;
        int electronCountInBonds = ValenceCheck.getBondingElectronCount(atom);
        int charge = atom.getCharge();
        int radical = atom.getRadicalCount();
        int[] bonds = ValenceCheck.getBonds(atom);
        HybridisationState hState = ValenceCheck.getOxigenFamilyHybridisationState(atom, electronCountInBonds, bonds);
        int bondCount = atom.getRealBondCount();
        int nH = 0;
        int prevHc = atom.getImplicitHcount();
        if (charge > 1) {
            atom.setValenceError(true);
        }
        switch (hState) {
            case SP: {
                nH = 2;
                break;
            }
            case SP2: {
                if (bonds[2] == 1) {
                    nH = 2;
                    if (atom.getAtno() != 16 || bonds[4] != 2) break;
                    nH += 2;
                    break;
                }
                if (bondCount == 2) {
                    if (electronCountInBonds == 4) {
                        if (charge != 0 || radical != 0) {
                            atom.setValenceError(true);
                            return;
                        }
                        a.calculatedImplicitHCount = 0;
                        a.calculatedCharge = 0;
                        atom.setValenceError(false);
                        return;
                    }
                    if (electronCountInBonds == 6) {
                        if (radical == 0 && charge == 1) {
                            a.calculatedImplicitHCount = 0;
                            a.calculatedCharge = charge;
                            atom.setValenceError(false);
                            return;
                        }
                        atom.setValenceError(true);
                        return;
                    }
                }
                atom.setValenceError(true);
                return;
            }
            case SP3: {
                nH = 2;
                break;
            }
            case SP3D: {
                nH = 4;
                break;
            }
            case SP3D2: {
                nH = 6;
                break;
            }
            case NONE: {
                atom.setValenceError(ValenceCheck.checkOxStates(a, atom, charge, radical));
                return;
            }
        }
        if (atom.getAtno() == 52 && (nH -= electronCountInBonds / 2) == 2) {
            nH += 2;
        }
        nH += charge;
        nH -= radical;
        if (atom.getAtno() == 16) {
            if (nH == -2 && radical - charge == 1) {
                nH = 0;
            }
            if (nH == -1 && radical == 1 && electronCountInBonds >= 8) {
                nH = 1;
            }
            if (nH < 0 && prevHc > 0) {
                nH = prevHc;
            }
        }
        a.calculatedImplicitHCount = nH;
        a.calculatedCharge = charge;
    }

    private static HybridisationState getOxigenFamilyHybridisationState(MolAtom atom, int electronCountInBonds, int[] bonds) {
        HybridisationState result = ValenceCheck.getCarbonFamilyHybridisationState(atom, electronCountInBonds, bonds);
        int atno = atom.getAtno();
        if (atno >= 16) {
            if (bonds[4] != 2) {
                if (electronCountInBonds == 8) {
                    result = HybridisationState.SP3D;
                } else if (electronCountInBonds > 8) {
                    result = HybridisationState.SP3D2;
                }
            }
            if (result == HybridisationState.NONE && (atno == 52 || atno == 84)) {
                result = HybridisationState.SP3;
            }
        }
        return result;
    }

    private static void checkNitrogenFamily(AtomClass a, boolean ignoreAmbiguousAromaticAtoms) {
        MolAtom atom = a.ma;
        int electronCountInBonds = ValenceCheck.getBondingElectronCount(atom);
        int charge = atom.getCharge();
        if (charge > 1 && atom.getAtno() == 7) {
            atom.setValenceError(true);
            return;
        }
        int radical = atom.getRadicalCount();
        int[] bonds = ValenceCheck.getBonds(atom);
        HybridisationState hState = ValenceCheck.getNitrogenFamilyHybridisationState(atom, electronCountInBonds, bonds);
        int bondCount = atom.getRealBondCount();
        int prevHc = atom.getImplicitHcount();
        int nH = 0;
        switch (hState) {
            case SP: {
                if (bonds[3] != 1) {
                    if (bonds[2] == 2) {
                        nH = -charge - radical;
                        if (bonds[1] == 1 && charge == 0 && radical == 0 && electronCountInBonds == 10) {
                            atom.setValenceError(false);
                            a.calculatedCharge = 0;
                            a.calculatedImplicitHCount = 0;
                            return;
                        }
                        a.calculatedCharge = 1;
                        if (a.chargeNotSet || charge == 1) {
                            if (bondCount == 2) {
                                atom.setValenceError(false);
                                a.calculatedCharge = 1;
                                a.calculatedImplicitHCount = 0;
                                return;
                            }
                            atom.setValenceError(true);
                            return;
                        }
                        if (bondCount == 2 && atom.getLigand(0).getAtno() == 8 && atom.getLigand(1).getAtno() == 8 && radical == 0 && charge == 0) {
                            atom.setValenceError(false);
                            a.calculatedCharge = 0;
                            a.calculatedImplicitHCount = nH;
                            return;
                        }
                    }
                    atom.setValenceError(true);
                    return;
                }
                nH = charge - radical - (electronCountInBonds / 2 - 3);
                if (nH < 0 && prevHc > 0) {
                    nH = prevHc;
                }
                a.calculatedCharge = charge;
                a.calculatedImplicitHCount = nH;
                atom.setValenceError(false);
                return;
            }
            case SP2: {
                if (bonds[4] > 0) {
                    MoleculeGraph m = atom.getParent();
                    if (m == null || !(m instanceof Molecule) || !"N".equals(((Molecule)m).getPropertyObject("ValenceCheck"))) {
                        if (!ignoreAmbiguousAromaticAtoms) {
                            ValenceCheck.checkAromaticNitrogen(a, bonds, electronCountInBonds);
                        } else {
                            a.calculatedImplicitHCount = atom.getImplicitHcount();
                            a.calculatedCharge = atom.getCharge();
                        }
                    } else if (electronCountInBonds < 7) {
                        a.calculatedCharge = charge;
                        if (prevHc > 1) {
                            prevHc = 0;
                        }
                        a.calculatedImplicitHCount = prevHc;
                        atom.setValenceError(false);
                    } else if (bonds[4] == 2 && bonds[2] == 1) {
                        a.calculatedCharge = 0;
                        a.calculatedImplicitHCount = 0;
                        if (charge != 0 || radical != 0) {
                            atom.setValenceError(true);
                            return;
                        }
                        atom.setValenceError(false);
                    } else if (bonds[4] == 2 && bonds[1] == 1) {
                        a.calculatedCharge = charge;
                        if (prevHc > 1) {
                            prevHc = 0;
                        }
                        a.calculatedImplicitHCount = prevHc;
                        atom.setValenceError(false);
                    } else {
                        atom.setValenceError(true);
                    }
                    return;
                }
                nH = 3;
                nH += charge;
                nH -= radical;
                if ((nH -= electronCountInBonds / 2) == -2 && charge == 0 && radical == 0 && ValenceCheck.hasDoubleBondedOxigen(atom)) {
                    nH = 0;
                }
                a.calculatedImplicitHCount = nH;
                a.calculatedCharge = charge;
                return;
            }
            case SP3: {
                nH = 3;
                nH += charge;
                nH -= radical;
                if ((nH -= electronCountInBonds / 2) == 1 && a.chargeNotSet && charge == 1) {
                    a.calculatedImplicitHCount = 0;
                    a.calculatedCharge = 0;
                    atom.setValenceError(false);
                    return;
                }
                if (nH < 0) {
                    if (a.chargeNotSet && nH == -1) {
                        a.calculatedImplicitHCount = 0;
                        a.calculatedCharge = 1;
                        atom.setValenceError(false);
                        return;
                    }
                    if (prevHc > 0) {
                        a.calculatedImplicitHCount = prevHc;
                        a.calculatedCharge = charge;
                        atom.setValenceError(false);
                        return;
                    }
                    atom.setValenceError(true);
                    return;
                }
                atom.setValenceError(false);
                a.calculatedImplicitHCount = nH;
                a.calculatedCharge = charge;
                return;
            }
            case SP3D: {
                if (electronCountInBonds > 10) break;
                nH = 5 - electronCountInBonds / 2 - radical + charge;
                if (nH < 0 && prevHc > 0) {
                    nH = prevHc;
                }
                if (nH >= 0 && nH < 6) {
                    a.calculatedCharge = charge;
                    a.calculatedImplicitHCount = nH;
                    atom.setValenceError(false);
                    return;
                }
                atom.setValenceError(true);
                return;
            }
            case SP3D2: {
                if (electronCountInBonds != 14 || radical != 0 || charge != 0) break;
                atom.setValenceError(false);
                return;
            }
            case NONE: {
                atom.setValenceError(ValenceCheck.checkOxStates(a, atom, charge, radical));
                return;
            }
        }
        atom.setValenceError(true);
    }

    private static boolean hasDoubleBondedOxigen(MolAtom atom) {
        for (int i = 0; i < atom.getBondCount(); ++i) {
            int atno;
            MolBond mb = atom.getBond(i);
            if (mb == null || mb.getType() != 2 || (atno = mb.getOtherAtom(atom).getAtno()) != 8 && atno != 16) continue;
            return true;
        }
        return false;
    }

    private static void checkAromaticNitrogen(AtomClass a, int[] bonds, int electronCountInBonds) {
        MolAtom atom = a.ma;
        List<MolAtom> ring = ValenceCheck.getSmallestAromaticRing(atom);
        int nH = 0;
        int charge = atom.getCharge();
        if (ring == null || ValenceCheck.leaveOriginalHCount(ring) && atom.getImplicitHcount() < 2) {
            a.calculatedImplicitHCount = atom.getImplicitHcount();
            a.calculatedCharge = charge;
            atom.setValenceError(false);
            return;
        }
        int eletronCountInRing = ValenceCheck.getDelocalizedElectronCount(ring);
        for (int i = 0; i < 4; ++i) {
            if (4 * i + 2 - eletronCountInRing <= 0) continue;
            eletronCountInRing = 4 * i + 2 - eletronCountInRing;
            break;
        }
        if (eletronCountInRing == 1) {
            nH = 0;
            if (electronCountInBonds == 10 && bonds[2] != 0) {
                nH = 2 - charge;
                if (charge != 0 && charge != 1 || atom.getRadicalCount() != 0) {
                    a.calculatedImplicitHCount = 0;
                    a.calculatedCharge = charge;
                    atom.setValenceError(true);
                    return;
                }
            }
        } else {
            nH = eletronCountInRing == 2 ? 1 : 0;
        }
        int electronCountInAromaticBonds = 6;
        if (atom.getImplicitHcount() + bonds[1] - charge == 1) {
            electronCountInAromaticBonds -= 2;
        } else if (bonds[4] == 3) {
            electronCountInAromaticBonds = charge == 1 ? --electronCountInAromaticBonds : (electronCountInAromaticBonds -= 3);
        }
        nH -= (electronCountInBonds - electronCountInAromaticBonds) / 2;
        nH += charge;
        a.calculatedCharge = atom.getCharge();
        a.calculatedImplicitHCount = nH -= atom.getRadicalCount();
        if (nH > 2) {
            atom.setValenceError(true);
            return;
        }
        atom.setValenceError(false);
    }

    private static int getNumberOfNeighbourNitrogens(MolAtom atom, List<MolAtom> ring) {
        int result = 0;
        for (MolAtom ma : atom.getLigands()) {
            if (ma == null || ma.getAtno() != 7 && ma.getAtno() != 15 || !ring.contains(ma)) continue;
            ++result;
        }
        return result;
    }

    private static int getDelocalizedElectronCount(List<MolAtom> ringAtoms) {
        int result = 0;
        for (int i = 1; i < ringAtoms.size(); ++i) {
            result += ValenceCheck.getDelocElectronCount(ringAtoms.get(i), ringAtoms);
        }
        return result;
    }

    private static int getDelocElectronCount(MolAtom atom, List<MolAtom> ring) {
        int charge = atom.getCharge();
        switch (atom.getAtno()) {
            case 6: {
                for (int j = 0; j < atom.getBondCount(); ++j) {
                    MolAtom other;
                    MolBond mb = atom.getBond(j);
                    if (mb == null) continue;
                    if (mb.getType() == 2) {
                        other = mb.getOtherAtom(atom);
                        if (other == null) continue;
                        if (other.getAtno() == 6) {
                            return 1;
                        }
                        if (other.getAtno() == 7) {
                            if (ValenceCheck.getRingWithBondType(other, 7, 7) == null) {
                                return 0;
                            }
                            return 1;
                        }
                        return 0;
                    }
                    if (mb.getType() != 4 || (other = mb.getOtherAtom(atom)) == null || ring.contains(other)) continue;
                    return 1;
                }
                if (charge == -1) {
                    return 2;
                }
                if (charge == 1) {
                    return 0;
                }
                return 1;
            }
            case 7: 
            case 15: {
                if (charge == -1 && (atom.getImplicitHcount() == 0 || atom.getRealBondCount() == 2) || charge == 0 && (atom.getRadical() == 1 || atom.getImplicitHcount() == 1 || atom.getRealBondCount() > 2 && !ValenceCheck.hasDoubleBondedOxigen(atom))) {
                    return 2;
                }
                return 1;
            }
            case 8: 
            case 34: 
            case 52: 
            case 84: {
                return 2;
            }
            case 16: {
                if (charge == 1) {
                    return 1;
                }
                return 2;
            }
        }
        return 1;
    }

    private static MolAtom getNeighbourWithDoubleBondedHetero(MolAtom atom) {
        for (MolAtom neighbour : atom.getLigands()) {
            MolBond mb = neighbour.getBondTo(atom);
            if (mb == null || mb.getType() != 4) continue;
            for (int i = 0; i < neighbour.getBondCount(); ++i) {
                MolAtom o;
                if (neighbour.getBond(i).getType() != 2 || (o = neighbour.getBond(i).getOtherAtom(neighbour)).getAtno() == 6) continue;
                return neighbour;
            }
        }
        return null;
    }

    private static boolean leaveOriginalHCount(List<MolAtom> ring) {
        for (int i = 0; i < ring.size(); ++i) {
            if (!ValenceCheck.hasOutgoingAromaticBond(ring.get(i))) continue;
            return true;
        }
        return false;
    }

    private static boolean hasOutgoingAromaticBond(MolAtom ma) {
        int numberOfAromaticBonds = 0;
        for (int i = 0; i < ma.getBondCount(); ++i) {
            if (ma.getBond(i) == null || ma.getBond(i).getType() != 4) continue;
            ++numberOfAromaticBonds;
        }
        return numberOfAromaticBonds > 2;
    }

    private static boolean hasOtherNitrogen3Bonds(MolAtom other) {
        return other.getCharge() != 1 && (other.getImplicitHcount() != 0 || other.getRadicalCount() > 0 || other.getRealBondCount() > 2);
    }

    private static int[] getOtherHeteroAtoms(MolAtom[] ring) {
        IntVector v = new IntVector();
        for (int i = 1; i < ring.length; ++i) {
            if (ring[i].getAtno() == 6) continue;
            v.add(i);
        }
        return v.toArray();
    }

    private static List<MolAtom> getSmallestAromaticRing(MolAtom atom) {
        return ValenceCheck.getRingWithBondType(atom, 4, 10);
    }

    private static List<MolAtom> getRingWithBondType(MolAtom atom, int type, int maxLength) {
        ArrayList<ArrayList<MolAtom>> paths = new ArrayList<ArrayList<MolAtom>>();
        ArrayList<MolAtom> first = new ArrayList<MolAtom>();
        first.add(atom);
        paths.addAll(ValenceCheck.extendPathsFrom(first, type));
        ArrayList currentPath = (ArrayList)paths.remove(0);
        while (currentPath.get(currentPath.size() - 1) != atom) {
            if (paths.size() == 0 || currentPath.size() > maxLength) {
                return null;
            }
            paths.addAll(ValenceCheck.extendPathsFrom(currentPath, type));
            currentPath = (ArrayList)paths.remove(0);
        }
        currentPath.remove(currentPath.size() - 1);
        return currentPath;
    }

    private static Collection<? extends ArrayList<MolAtom>> extendPathsFrom(ArrayList<MolAtom> source, int type) {
        ArrayList<ArrayList<MolAtom>> result = new ArrayList<ArrayList<MolAtom>>();
        MolAtom sourceAtom = source.get(source.size() - 1);
        for (MolAtom ma : sourceAtom.getLigands()) {
            MolBond mb;
            if (source.contains(ma) && (source.size() == 2 || ma != source.get(0)) || (mb = sourceAtom.getBondTo(ma)) == null || (mb.getType() & type) == 0) continue;
            ArrayList<MolAtom> path = new ArrayList<MolAtom>(source);
            path.add(ma);
            result.add(path);
        }
        return result;
    }

    private static HybridisationState getNitrogenFamilyHybridisationState(MolAtom atom, int electronCountInBonds, int[] bonds) {
        HybridisationState result = ValenceCheck.getCarbonFamilyHybridisationState(atom, electronCountInBonds, bonds);
        if (atom.getAtno() == 7) {
            for (int i = 0; i < atom.getBondCount(); ++i) {
                if (atom.getBond(i).getType() != 2 || atom.getLigand(i).getAtno() != 8) continue;
                if (electronCountInBonds == 10) {
                    result = HybridisationState.SP2;
                }
                break;
            }
        } else {
            if (electronCountInBonds == 8 && atom.getCharge() < 1 || atom.getImplicitHcount() > 3) {
                if (atom.getImplicitHcount() == 4 && atom.getCharge() == 1) {
                    return result;
                }
                result = HybridisationState.SP3D;
            } else if (electronCountInBonds == 12 && atom.getCharge() < 1) {
                result = HybridisationState.SP3D2;
            }
            if (result == HybridisationState.NONE && atom.getAtno() == 51) {
                result = HybridisationState.SP3;
            }
        }
        return result;
    }

    private static void checkCarbonFamily(AtomClass a) {
        MolAtom atom = a.ma;
        int electronCountInBonds = ValenceCheck.getBondingElectronCount(atom);
        int charge = atom.getCharge();
        int radical = atom.getRadicalCount();
        int[] bonds = ValenceCheck.getBonds(atom);
        HybridisationState hState = ValenceCheck.getCarbonFamilyHybridisationState(atom, electronCountInBonds, bonds);
        int bondCount = atom.getRealBondCount();
        int nH = 4;
        nH -= Math.abs(charge);
        nH -= radical;
        nH -= electronCountInBonds / 2;
        switch (hState) {
            case SP: {
                if (bondCount == 1) {
                    if (bonds[3] != 1) {
                        atom.setValenceError(true);
                        return;
                    }
                    if (nH < 0 || nH > 1) {
                        atom.setValenceError(true);
                        if (nH == 2 && atom.getAtno() == 82) {
                            atom.setValenceError(false);
                            return;
                        }
                        return;
                    }
                    atom.setValenceError(false);
                    a.calculatedImplicitHCount = nH;
                    a.calculatedCharge = charge;
                    return;
                }
                if (bondCount == 2 && electronCountInBonds == 8 && radical == 0 && charge == 0) {
                    a.calculatedCharge = 0;
                    a.calculatedImplicitHCount = 0;
                    atom.setValenceError(false);
                    return;
                }
                atom.setValenceError(true);
                return;
            }
            case SP2: {
                if (bonds[2] == 1) {
                    a.calculatedCharge = 0;
                    a.calculatedImplicitHCount = nH;
                    atom.setValenceError(false);
                    return;
                }
                if (bondCount == 2) {
                    a.calculatedCharge = charge;
                    if (charge == 1 || charge == -1) {
                        nH = atom.getImplicitHcount();
                    }
                    if (bonds[1] == 1 && bonds[4] == 1) {
                        --nH;
                    }
                    if (nH < 0 || nH > 2) {
                        atom.setValenceError(true);
                        return;
                    }
                    atom.setValenceError(false);
                    a.calculatedImplicitHCount = nH;
                    a.calculatedCharge = charge;
                    return;
                }
                if (bondCount == 3) {
                    if (electronCountInBonds == 6 && charge == -1 || electronCountInBonds >= 7 && electronCountInBonds <= 10) {
                        if (charge * charge <= 1 && radical == 0) {
                            a.calculatedImplicitHCount = charge != 0 ? nH : 0;
                            a.calculatedCharge = charge;
                            atom.setValenceError(false);
                            return;
                        }
                        atom.setValenceError(true);
                        return;
                    }
                    if (bonds[4] == 2 && bonds[1] == 1) {
                        if (charge == 1) {
                            a.calculatedCharge = 1;
                            a.calculatedImplicitHCount = nH;
                            atom.setValenceError(false);
                            return;
                        }
                        atom.setValenceError(true);
                    } else if (bonds[9] == 1) {
                        a.calculatedCharge = 0;
                        a.calculatedImplicitHCount = nH;
                        atom.setValenceError(false);
                        return;
                    }
                } else if (bondCount == 4 && charge == 1 && radical == 0) {
                    a.calculatedCharge = 1;
                    a.calculatedImplicitHCount = 5 - electronCountInBonds / 2;
                    atom.setValenceError(false);
                    return;
                }
                if (bondCount == 1) {
                    nH = 3 + charge - radical - electronCountInBonds / 2;
                    a.calculatedCharge = charge;
                    a.calculatedImplicitHCount = nH;
                    atom.setValenceError(false);
                    return;
                }
                atom.setValenceError(true);
                return;
            }
            case SP3: {
                int nHyd = 4;
                nHyd -= charge < 0 ? -charge : charge;
                nHyd -= radical;
                if ((nHyd -= electronCountInBonds / 2) < 0) {
                    atom.setValenceError(true);
                    return;
                }
                if (atom.getAtno() == 82 && nHyd >= 2) {
                    nHyd -= 2;
                }
                atom.setValenceError(false);
                a.calculatedImplicitHCount = nHyd;
                a.calculatedCharge = charge;
                return;
            }
            case SP3D: 
            case SP3D2: 
            case NONE: {
                atom.setValenceError(ValenceCheck.checkOxStates(a, atom, charge, radical));
                return;
            }
        }
        atom.setValenceError(true);
    }

    private static boolean checkOxStates(AtomClass a, MolAtom atom, int charge, int radical) {
        int atNo = atom.getAtno();
        int impH = atom.getImplicitHcount();
        int oxState = charge + impH + radical;
        for (int i = 0; i < MolAtom.numoxstatesOf(atNo); ++i) {
            if (oxState != MolAtom.oxstateOf(atNo, i)) continue;
            a.calculatedCharge = charge;
            a.calculatedImplicitHCount = impH;
            return false;
        }
        return true;
    }

    private static HybridisationState getCarbonFamilyHybridisationState(MolAtom atom, int electronCountInBonds, int[] bonds) {
        HybridisationState result = HybridisationState.SP3;
        if (bonds[2] == 1 && bonds[3] == 0 || bonds[4] > 0) {
            result = HybridisationState.SP2;
        } else if (bonds[2] == 2) {
            result = bonds[1] == 0 && bonds[3] == 0 ? HybridisationState.SP : HybridisationState.NONE;
        } else if (bonds[3] == 1) {
            result = bonds[1] < 2 && bonds[2] == 0 ? HybridisationState.SP : HybridisationState.NONE;
        }
        if (atom.getAtno() > 10) {
            if (bonds[1] + 2 * bonds[2] + 3 * bonds[3] == 5) {
                result = HybridisationState.SP3D;
            }
            if (bonds[1] + 2 * bonds[2] + 3 * bonds[3] == 6) {
                result = HybridisationState.SP3D2;
            }
        }
        if (electronCountInBonds == 0 && atom.getAtno() >= 50) {
            result = HybridisationState.NONE;
        }
        return result;
    }

    private static void checkBoronFamily(AtomClass a) {
        MolAtom atom = a.ma;
        int electronCountInBonds = ValenceCheck.getBondingElectronCount(atom);
        int charge = atom.getCharge();
        int radical = atom.getRadicalCount();
        HybridisationState hState = ValenceCheck.getBoronFamilyHybridisationState(atom, electronCountInBonds);
        switch (hState) {
            case SP: {
                if (radical != 0) {
                    atom.setValenceError(true);
                    return;
                }
                if (electronCountInBonds == 8) {
                    if (charge == -1 || a.chargeNotSet) {
                        a.calculatedCharge = -1;
                        charge = -1;
                    }
                    a.calculatedImplicitHCount = -1 - charge - radical;
                    atom.setValenceError(false);
                    return;
                }
                if (electronCountInBonds == 6) {
                    if (charge != 0) {
                        atom.setValenceError(true);
                        return;
                    }
                    a.calculatedImplicitHCount = 0;
                    atom.setValenceError(false);
                    return;
                }
                atom.setValenceError(true);
                return;
            }
            case SP2: {
                int radCharge;
                int implHnum;
                a.calculatedImplicitHCount = implHnum = 3 - electronCountInBonds / 2 - radical - charge;
                if (atom.getAtno() == 13 && atom.getRealBondCount() == 1 && implHnum == 2) {
                    a.calculatedImplicitHCount = 0;
                }
                if ((radCharge = radical + (charge > 0 ? charge : -charge)) > 3 || a.calculatedImplicitHCount > 4) {
                    atom.setValenceError(true);
                } else {
                    atom.setValenceError(false);
                }
                return;
            }
            case SP3: {
                if (electronCountInBonds == 8) {
                    if (radical == 0 && (charge == -1 || a.chargeNotSet)) {
                        a.calculatedCharge = -1;
                        a.calculatedImplicitHCount = 0;
                        atom.setValenceError(false);
                    } else {
                        atom.setValenceError(true);
                    }
                } else {
                    atom.setValenceError(true);
                }
                return;
            }
            case NONE: {
                atom.setValenceError(ValenceCheck.checkOxStates(a, atom, charge, radical));
                return;
            }
        }
        atom.setValenceError(true);
    }

    private static HybridisationState getBoronFamilyHybridisationState(MolAtom atom, int electronCountInBonds) {
        HybridisationState result = HybridisationState.INVALID;
        int bondCount = atom.getRealBondCount();
        if (bondCount == 0 && electronCountInBonds == 0) {
            result = atom.getAtno() == 5 ? HybridisationState.SP2 : HybridisationState.NONE;
        } else if (bondCount == 1) {
            result = electronCountInBonds == 6 ? HybridisationState.SP : HybridisationState.SP2;
        } else if (bondCount == 2) {
            result = electronCountInBonds == 6 ? HybridisationState.SP2 : (electronCountInBonds == 8 ? HybridisationState.SP : (electronCountInBonds > 8 ? HybridisationState.INVALID : HybridisationState.SP2));
        } else if (bondCount == 3) {
            result = HybridisationState.SP2;
        } else if (bondCount == 4) {
            result = HybridisationState.SP3;
        }
        return result;
    }

    private static void checkAlkaliEarthMetal(AtomClass a) {
        MolAtom atom = a.ma;
        int electronCountInBonds = ValenceCheck.getBondingElectronCount(atom);
        int charge = atom.getCharge();
        int radical = atom.getRadicalCount();
        if (electronCountInBonds == 0 && charge == 2 && radical == 0) {
            a.calculatedCharge = 2;
            a.calculatedImplicitHCount = 0;
            atom.setValenceError(false);
            return;
        }
        if (electronCountInBonds == 4 && charge == 0 && radical == 0) {
            a.calculatedCharge = 0;
            a.calculatedImplicitHCount = 0;
            atom.setValenceError(false);
            return;
        }
        if (electronCountInBonds == 0 && charge == 0 && radical == 0) {
            a.calculatedCharge = 0;
            a.calculatedImplicitHCount = 0;
            atom.setValenceError(false);
            return;
        }
        if (electronCountInBonds == 0 && charge == 0 && radical == 2) {
            a.calculatedCharge = 0;
            a.calculatedImplicitHCount = 0;
            atom.setValenceError(false);
            return;
        }
        atom.setValenceError(true);
    }

    private static void checkAlkaliMetal(AtomClass a) {
        MolAtom atom = a.ma;
        int charge = atom.getCharge();
        int radical = atom.getRadicalCount();
        int electronCountInBonds = ValenceCheck.getBondingElectronCount(atom);
        if (electronCountInBonds == 0 && charge == 1 && radical == 0) {
            a.calculatedCharge = 1;
            a.calculatedImplicitHCount = 0;
            atom.setValenceError(false);
            return;
        }
        if (electronCountInBonds == 0 && charge == 0 && radical == 0) {
            if (atom.getAtno() == 1) {
                if (a.chargeNotSet) {
                    a.calculatedCharge = 1;
                } else if (charge != 1) {
                    atom.setValenceError(true);
                    return;
                }
            } else {
                a.calculatedCharge = 0;
            }
            a.calculatedImplicitHCount = 0;
            atom.setValenceError(false);
            return;
        }
        if (electronCountInBonds == 0 && charge == -1 && atom.getAtno() == 1) {
            atom.setValenceError(false);
            return;
        }
        if (electronCountInBonds == 2 && charge == 0 && radical == 0) {
            a.calculatedCharge = 0;
            a.calculatedImplicitHCount = 0;
            atom.setValenceError(false);
            return;
        }
        if (electronCountInBonds == 0 && radical == 1 && charge == 0) {
            atom.setValenceError(false);
            return;
        }
        atom.setValenceError(true);
    }

    private static int getBondingElectronCount(MolAtom atom) {
        int bondingElectronCount = atom.twicesumbonds(true, false);
        int atc = atom.getAttach();
        if (atc != 0 && (atc = (atc == 3 ? 2 : 1) - ValenceCheck.getAttachSumBondOrders(atom)) < 0) {
            atom.setValenceError(true);
            return Integer.MAX_VALUE;
        }
        int valenceElectronCount = 2 * atc + bondingElectronCount;
        return valenceElectronCount;
    }

    private static int[] getBonds(MolAtom ma) {
        int[] result = new int[15];
        int bondC = ma.getBondCount();
        for (int i = 0; i < bondC; ++i) {
            MolBond mb = ma.getBond(i);
            if (mb.getOtherAtom(ma).getAtno() == 130) continue;
            int n = mb.getType();
            result[n] = result[n] + 1;
        }
        return result;
    }

    private static int getAttachSumBondOrders(MolAtom atom) {
        int n = 0;
        Sgroup sg = atom.getAttachParentSgroup();
        if (sg != null) {
            for (int i = 0; i < atom.getBondCount(); ++i) {
                MolBond b = atom.getBond(i);
                MolAtom a = b.getOtherAtom(atom);
                if (sg.hasAtom(a)) continue;
                int t = b.getType();
                n += t > 0 && t <= 3 ? t : 1;
            }
        }
        return n;
    }

    public static void checkSgroupAtom(SgroupAtom sgroupAtom) {
        SuperatomSgroup sgroup = sgroupAtom.getSgroup();
        MolAtom[] attach = sgroup.getAttachAtoms();
        int att = 0;
        int connections = 0;
        for (MolAtom ma : attach) {
            att += ma.getAttach() == 3 ? 2 : 1;
        }
        for (int j = 0; j < sgroupAtom.getBondCount(); ++j) {
            MolAtom aa = sgroupAtom.getLigand(j);
            if (sgroup.indexOf(aa) >= 0) continue;
            connections += sgroupAtom.getBond(j).getType();
        }
        sgroupAtom.setValenceError(att < connections);
    }

    private static class AtomClass {
        protected MolAtom ma;
        protected int calculatedImplicitHCount = 0;
        protected int calculatedCharge = 0;
        protected final boolean chargeNotSet;

        public AtomClass(MolAtom atom, boolean chargeSet) {
            this.ma = atom;
            this.chargeNotSet = chargeSet;
        }
    }

    static enum HybridisationState {
        NONE,
        SP,
        SP2,
        SP3,
        SP3D,
        SP3D2,
        INVALID;

    }
}

