/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.core.calculations.column;

import chemaxon.struc.MolAtom;
import java.util.Arrays;

public class FreeValenceElectronCountForColumn14 {
    public static int checkValencefor14Group(MolAtom atm) {
        int bondingElectronCount = atm.twicesumbonds(true, false);
        boolean isStandalone = bondingElectronCount == 0;
        int impHNo = 4 - bondingElectronCount / 2 - Math.abs(atm.getCharge()) - atm.getRadical();
        switch (atm.getAtno()) {
            case 6: 
            case 14: 
            case 32: {
                return FreeValenceElectronCountForColumn14.checkValenceFromCToGeGroup(impHNo);
            }
            case 50: {
                return FreeValenceElectronCountForColumn14.checkValenceForSn(impHNo, atm.getCharge(), isStandalone);
            }
            case 82: {
                return FreeValenceElectronCountForColumn14.checkValenceForPb(impHNo, atm.getCharge(), isStandalone);
            }
        }
        return -1;
    }

    private static int checkValenceForPb(int impHNo, int charge, boolean isStandalone) {
        if (isStandalone) {
            return FreeValenceElectronCountForColumn14.checkOddChargesForStanadaloneAtoms(charge);
        }
        return FreeValenceElectronCountForColumn14.checkValenceForNotStandalonePb(impHNo);
    }

    private static int checkValenceForNotStandalonePb(int impHNo) {
        int result = -1;
        Integer[] hNosWithZeroImplicit = new Integer[]{-1, -2, 0, 2, 4};
        if (impHNo == 1 || impHNo == 3) {
            result = 1;
        } else if (Arrays.asList(hNosWithZeroImplicit).contains(impHNo)) {
            result = 0;
        }
        return result;
    }

    private static int checkValenceForSn(int impHNo, int charge, boolean isStandalone) {
        if (isStandalone) {
            return FreeValenceElectronCountForColumn14.checkOddChargesForStanadaloneAtoms(charge);
        }
        return FreeValenceElectronCountForColumn14.checkValenceForNotStandaloneSn(impHNo);
    }

    private static int checkValenceForNotStandaloneSn(int impHNo) {
        int result = 0;
        if (impHNo >= 1 && impHNo <= 3) {
            result = impHNo;
        }
        return result;
    }

    private static int checkValenceFromCToGeGroup(int impHNo) {
        return impHNo;
    }

    private static int checkOddChargesForStanadaloneAtoms(int charge) {
        int result = 0;
        result = charge > 5 ? 5 - charge : (charge % 2 != 0 ? -1 : (charge < 0 ? charge : 0));
        return result;
    }
}

