/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.core.calculations.column;

import chemaxon.struc.MolAtom;

public class FreeValenceElectronCountForColumn16 {
    public static int checkValencefor16Group(MolAtom atm) {
        int bondingElectronCount = atm.twicesumbonds(true, false);
        boolean isStandalone = bondingElectronCount == 0;
        int impHNo = 2 - bondingElectronCount / 2 - atm.getRadical() - atm.getCharge();
        switch (atm.getAtno()) {
            case 8: {
                return FreeValenceElectronCountForColumn16.checkValenceForO(impHNo, atm.getCharge(), isStandalone);
            }
            case 16: {
                return FreeValenceElectronCountForColumn16.checkValenceForS(impHNo, atm.getCharge(), isStandalone);
            }
            case 34: {
                return FreeValenceElectronCountForColumn16.checkValenceForSe(impHNo, atm.getCharge(), isStandalone);
            }
            case 52: {
                return FreeValenceElectronCountForColumn16.checkValenceForTe(impHNo, atm.getCharge(), isStandalone);
            }
            case 84: {
                return FreeValenceElectronCountForColumn16.checkValenceForPo(impHNo, atm.getCharge(), isStandalone);
            }
        }
        return 0;
    }

    private static int checkValenceForPo(int impHNo, int charge, boolean isStandalone) {
        return FreeValenceElectronCountForColumn16.checkValenceForS(impHNo, charge, isStandalone);
    }

    private static int checkValenceForTe(int impHNo, int charge, boolean isStandalone) {
        return FreeValenceElectronCountForColumn16.checkValenceForS(impHNo, charge, isStandalone);
    }

    private static int checkValenceForSe(int impHNo, int charge, boolean isStandalone) {
        return FreeValenceElectronCountForColumn16.checkValenceForS(impHNo, charge, isStandalone);
    }

    private static int checkValenceForS(int impHNo, int charge, boolean isStandalone) {
        int result = 0;
        if (impHNo >= 0 && impHNo <= 2) {
            result = FreeValenceElectronCountForColumn16.checkValenceForO(impHNo, charge, isStandalone);
        } else if (impHNo == -1) {
            result = -1;
        } else if (impHNo == -2 || impHNo == -4) {
            result = 0;
        } else if (impHNo == -3) {
            result = 1;
        } else if (impHNo <= -5) {
            result = impHNo + 4;
        }
        return result;
    }

    private static int checkValenceForO(int impHNo, int charge, boolean isStandalone) {
        int result = 0;
        result = impHNo <= 2 ? impHNo : 0;
        return result;
    }
}

