/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.core.calculations.stereo;

import chemaxon.core.calculations.stereo.StereoCalculations;
import chemaxon.core.calculations.stereo.TempSAP;
import chemaxon.struc.AtropStereoDescriptor;
import chemaxon.struc.CIPStereoDescriptorIface;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.StereoActivePart;
import java.util.BitSet;
import java.util.Collection;

public class AtropStereoRecognizer {
    static final double TRESHOLD = 1.0E-16;
    static final double TRESHOLD_FOR_UNKNOWN = 0.08726646259971647;

    public AtropStereoRecognizer(int[] graphInvariants) {
    }

    public void calculateAtropStereo(MoleculeGraph m, Collection<CIPStereoDescriptorIface> descriptors) {
        long[] rb = m.getSSSRBondSetInLong();
        BitSet ringAtoms = this.setRingAtoms(rb, m);
        int[] grinv = new int[m.getAtomCount()];
        m.getGrinv(grinv, 3);
        int bondCount = m.getBondCount();
        for (int i = 0; i < bondCount; ++i) {
            MolBond[] axisAtom1Bonds;
            MolBond axisBond;
            if (this.get(i, rb) || (axisBond = m.getBond(i)).getType() != 1) continue;
            TempSAP sap1 = new TempSAP(axisBond.getAtom1(), m);
            TempSAP sap2 = new TempSAP(axisBond.getAtom2(), m);
            if (!ringAtoms.get(sap1.getAxisAtomIndex()) || !ringAtoms.get(sap2.getAxisAtomIndex()) || sap1.getAxisAtom().getBondCount() != 3 || sap2.getAxisAtom().getBondCount() != 3 || (axisAtom1Bonds = this.calculateRingBonds(axisBond, sap1.getAxisAtom())) == null) continue;
            sap1.setLigands(m, axisAtom1Bonds);
            MolBond[] axisAtom2Bonds = this.calculateRingBonds(axisBond, sap2.getAxisAtom());
            if (axisAtom2Bonds == null) continue;
            sap2.setLigands(m, axisAtom2Bonds);
            if (this.calculateOrthoLigandNumber(sap1.getLigandHigh(), sap1.getLigandLow(), sap2.getLigandHigh(), sap2.getLigandLow()) <= 2) continue;
            CIPStereoDescriptorIface.CIPValue.AtropStereoValue value = CIPStereoDescriptorIface.CIPValue.AtropStereoValue.UNKNOWN;
            if (axisAtom1Bonds[0].getStereo1(sap1.getAxisAtom()) == 48 || axisAtom1Bonds[1].getStereo1(sap1.getAxisAtom()) == 48 || axisAtom2Bonds[0].getStereo1(sap2.getAxisAtom()) == 48 || axisAtom2Bonds[1].getStereo1(sap2.getAxisAtom()) == 48 || axisBond.getStereo1(sap1.getAxisAtom()) == 48) {
                value = CIPStereoDescriptorIface.CIPValue.AtropStereoValue.WIGGLY;
            } else {
                int wedgeInfo1 = StereoCalculations.convertWedge(sap1.getAxisAtom(), sap1.getAxisAtom().getBondTo(sap1.getLigandHigh()));
                int wedgeInfo2 = StereoCalculations.convertWedge(sap2.getAxisAtom(), sap2.getAxisAtom().getBondTo(sap2.getLigandHigh()));
                value = m.getDim() == 2 && wedgeInfo1 == 0 && wedgeInfo2 == 0 ? CIPStereoDescriptorIface.CIPValue.AtropStereoValue.UNKNOWN : (sap1.getLigandHighIndex() > sap2.getLigandHighIndex() ? this.calculateValue(sap2.getLigandHigh(), sap2.getAxisAtom(), sap1.getAxisAtom(), sap1.getLigandHigh(), wedgeInfo2, wedgeInfo1, m) : this.calculateValue(sap1.getLigandHigh(), sap1.getAxisAtom(), sap2.getAxisAtom(), sap2.getLigandHigh(), wedgeInfo1, wedgeInfo2, m));
            }
            descriptors.add(new AtropStereoDescriptor(value, new StereoActivePart(sap1.getAxisAtomIndex(), new int[]{sap1.getLigandHighIndex(), sap1.getLigandLowIndex()}), new StereoActivePart(sap2.getAxisAtomIndex(), new int[]{sap2.getLigandHighIndex(), sap2.getLigandLowIndex()})));
        }
    }

    private CIPStereoDescriptorIface.CIPValue.AtropStereoValue calculateValue(MolAtom ligandFront, MolAtom axisAtomFront, MolAtom axisAtomBack, MolAtom ligandBack, int frontWedgeInfo, int backWedgeInfo, MoleculeGraph m) {
        DPoint3 axisAtomFrontPosition = axisAtomFront.getLocation();
        DPoint3 axisAtomBackPosition = axisAtomBack.getLocation();
        DPoint3 frontLigandPosition = m.getDim() == 2 && frontWedgeInfo == 16 ? new DPoint3(axisAtomFrontPosition.x, axisAtomFrontPosition.y, 1.0) : (m.getDim() == 2 && frontWedgeInfo == 32 ? new DPoint3(axisAtomFrontPosition.x, axisAtomFrontPosition.y, -1.0) : ligandFront.getLocation());
        DPoint3 backLigandPosition = m.getDim() == 2 && backWedgeInfo == 16 ? new DPoint3(axisAtomBackPosition.x, axisAtomBackPosition.y, 1.0) : (m.getDim() == 2 && backWedgeInfo == 32 ? new DPoint3(axisAtomBackPosition.x, axisAtomBackPosition.y, -1.0) : ligandBack.getLocation());
        return StereoCalculations.calculateValueFromVectors(new DPoint3(frontLigandPosition.x - axisAtomFrontPosition.x, frontLigandPosition.y - axisAtomFrontPosition.y, frontLigandPosition.z - axisAtomFrontPosition.z), new DPoint3(axisAtomBackPosition.x - axisAtomFrontPosition.x, axisAtomBackPosition.y - axisAtomFrontPosition.y, axisAtomBackPosition.z - axisAtomFrontPosition.z), new DPoint3(backLigandPosition.x - axisAtomBackPosition.x, backLigandPosition.y - axisAtomBackPosition.y, backLigandPosition.z - axisAtomBackPosition.z), axisAtomFrontPosition);
    }

    private int calculateOrthoLigandNumber(MolAtom axisAtom1LigandHigh, MolAtom axisAtom1LigandLow, MolAtom axisAtom2LigandHigh, MolAtom axisAtom2LigandLow) {
        int orthoLigands = 0;
        if (axisAtom1LigandHigh.getBondCount() > 2) {
            ++orthoLigands;
        }
        if (axisAtom1LigandLow.getBondCount() > 2) {
            ++orthoLigands;
        }
        if (axisAtom2LigandHigh.getBondCount() > 2) {
            ++orthoLigands;
        }
        if (axisAtom2LigandLow.getBondCount() > 2) {
            ++orthoLigands;
        }
        return orthoLigands;
    }

    private MolBond[] calculateRingBonds(MolBond axisBond, MolAtom axisAtom) {
        MolBond[] result = new MolBond[2];
        int n = 0;
        for (int j = 0; j < axisAtom.getBondCount(); ++j) {
            MolBond bond = axisAtom.getBond(j);
            if (bond == axisBond || bond.getType() != 4) continue;
            if (n == 2) {
                return null;
            }
            result[n] = bond;
            ++n;
        }
        return n == 2 ? result : null;
    }

    private BitSet setRingAtoms(long[] rb, MoleculeGraph m) {
        BitSet result = new BitSet(m.getAtomCount());
        int bc = m.getBondCount();
        for (int i = 0; i < bc; ++i) {
            if (!this.get(i, rb)) continue;
            MolBond b = m.getBond(i);
            int i1 = m.indexOf(b.getAtom1());
            int i2 = m.indexOf(b.getAtom2());
            result.set(i1);
            result.set(i2);
        }
        return result;
    }

    private boolean get(int n, long[] r) {
        return (r[n / 64] & 1L << 63 - n % 64) != 0L;
    }
}

