/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.core.calculations.stereo;

import chemaxon.common.util.IntVector;
import chemaxon.core.calculations.stereo.DoubleBondRigidPart;
import chemaxon.core.calculations.stereo.RigidPart;
import chemaxon.core.calculations.stereo.RingRigidPart;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.MoleculeGraph;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;

public class RigidPartDetection {
    private RigidPartDetection() {
    }

    public static RigidPart[] detectRigidParts(MoleculeGraph molecule) {
        int i;
        IntVector doubleBonds = RigidPartDetection.findDoubleBonds(molecule);
        int[][] cssr = molecule.getCSSR();
        ArrayList<BitSet> ringRigidParts = new ArrayList<BitSet>();
        RingCollection oddMemberedRings = new RingCollection();
        RingCollection fourMemberedRings = new RingCollection();
        RingCollection sixMemberedRings = new RingCollection();
        BitSet ringBitSet = null;
        block6: for (int i2 = 0; i2 < cssr.length; ++i2) {
            int[] ring = cssr[i2];
            switch (ring.length) {
                case 3: 
                case 5: 
                case 7: {
                    ringBitSet = RigidPartDetection.generateRingBitSet(ring, molecule);
                    RigidPartDetection.checkRing(ringBitSet, oddMemberedRings, ringRigidParts);
                    continue block6;
                }
                case 4: {
                    ringBitSet = RigidPartDetection.generateRingBitSet(ring, molecule);
                    RigidPartDetection.checkRing(ringBitSet, fourMemberedRings, ringRigidParts);
                    ringRigidParts.add(ringBitSet);
                    continue block6;
                }
                case 6: {
                    ringBitSet = RigidPartDetection.generateRingBitSet(ring, molecule);
                    RigidPartDetection.checkRing(ringBitSet, sixMemberedRings, ringRigidParts);
                    ringRigidParts.add(ringBitSet);
                    continue block6;
                }
                case 1: 
                case 2: {
                    throw new RuntimeException("Error in CSSR result: 1 or 2 membered ring found.");
                }
            }
        }
        if (oddMemberedRings.hasCommonBond(fourMemberedRings) || oddMemberedRings.hasCommonBond(sixMemberedRings)) {
            RingCollection evenMemberedRings = fourMemberedRings;
            evenMemberedRings.addRingCollection(sixMemberedRings);
            ringRigidParts.addAll(RigidPartDetection.findOddEvenOddChains(oddMemberedRings, evenMemberedRings, molecule));
        }
        int rigidPartCount = doubleBonds.size() + ringRigidParts.size();
        RigidPart[] rigidParts = new RigidPart[rigidPartCount];
        for (i = 0; i < doubleBonds.size(); ++i) {
            rigidParts[i] = new DoubleBondRigidPart(doubleBonds.get(i), molecule);
        }
        for (i = 0; i < ringRigidParts.size(); ++i) {
            rigidParts[doubleBonds.size() + i] = new RingRigidPart((BitSet)ringRigidParts.get(i), molecule);
        }
        return rigidParts;
    }

    private static IntVector findDoubleBonds(MoleculeGraph molecule) {
        IntVector doubleBonds = new IntVector();
        for (int i = 0; i < molecule.getBondCount(); ++i) {
            MolBond bond = molecule.getBond(i);
            if (bond.getType() != 2) continue;
            doubleBonds.add(molecule.indexOf(bond));
        }
        return doubleBonds;
    }

    private static void checkRing(BitSet ring, RingCollection rings, List<BitSet> rigidParts) {
        if (rings.hasCommonBond(ring)) {
            rigidParts.addAll(rings.getFusedRingPairs(ring));
        }
        rings.addRing(ring);
    }

    private static BitSet generateRingBitSet(int[] ring, MoleculeGraph molecule) {
        BitSet toReturn = new BitSet(molecule.getBondCount());
        for (int i = 0; i < ring.length; ++i) {
            MolAtom a1 = molecule.getAtom(ring[i]);
            for (int j = i + 1; j < ring.length; ++j) {
                MolAtom a2 = molecule.getAtom(ring[j]);
                MolBond bond = a1.getBondTo(a2);
                if (bond == null) continue;
                toReturn.set(molecule.indexOf(bond));
            }
        }
        assert (toReturn.cardinality() == ring.length);
        return toReturn;
    }

    private static List<BitSet> findOddEvenOddChains(RingCollection oddMemberedRings, RingCollection evenMemberedRings, MoleculeGraph molecule) {
        BitSet oddEvenCommonBonds = oddMemberedRings.getCommonBonds(evenMemberedRings);
        BitSet firstEvenRing = null;
        ArrayList<BitSet> rigidParts = new ArrayList<BitSet>();
        int bond = oddEvenCommonBonds.nextSetBit(0);
        while (bond >= 0) {
            BitSet rigidPart = new BitSet(molecule.getBondCount());
            BitSet checkedBonds = new BitSet(molecule.getBondCount());
            BitSet chainRing = firstEvenRing = evenMemberedRings.getRingContainingBond(bond);
            int chainBond = bond;
            BitSet oddRing1 = oddMemberedRings.getFusedRing(firstEvenRing, bond);
            boolean chainEnd = oddRing1.isEmpty();
            while (!chainEnd) {
                BitSet oddRing2;
                rigidPart.xor(chainRing);
                checkedBonds.set(chainBond);
                int oppositeBond = RigidPartDetection.getOppositeBond(chainRing, chainBond, molecule);
                if (checkedBonds.get(oppositeBond)) {
                    chainEnd = true;
                } else if (oddMemberedRings.hasBond(oppositeBond) && !(oddRing2 = oddMemberedRings.getFusedRing(chainRing, oppositeBond)).isEmpty()) {
                    rigidPart.xor(oddRing1);
                    rigidPart.xor(oddRing2);
                    if (!rigidParts.contains(rigidPart)) {
                        rigidParts.add(rigidPart);
                    }
                    chainEnd = true;
                }
                if (chainEnd || !(chainRing = evenMemberedRings.getFusedRing(chainRing, chainBond = oppositeBond)).isEmpty()) continue;
                chainEnd = true;
            }
            bond = oddEvenCommonBonds.nextSetBit(bond + 1);
        }
        return rigidParts;
    }

    private static int getOppositeBond(BitSet ring, int bond, MoleculeGraph molecule) {
        if (ring.cardinality() % 2 == 1) {
            throw new IllegalArgumentException("Size of the ring must be even.");
        }
        int stepCount = ring.cardinality() / 2;
        MolBond previousMolBond = molecule.getBond(bond);
        MolAtom actAtom = previousMolBond.getAtom1();
        block0: for (int i = 0; i < stepCount; ++i) {
            for (int j = 0; j < actAtom.getBondCount(); ++j) {
                MolBond actMolBond = actAtom.getBond(j);
                if (actMolBond == previousMolBond || !ring.get(molecule.indexOf(actMolBond))) continue;
                actAtom = actMolBond.getOtherAtom(actAtom);
                previousMolBond = actMolBond;
                continue block0;
            }
        }
        return molecule.indexOf(previousMolBond);
    }

    private static class RingCollection {
        private List<BitSet> rings = new ArrayList<BitSet>();
        private BitSet gatheredRings = new BitSet();

        public void addRing(BitSet ring) {
            this.rings.add(ring);
            this.gatheredRings.or(ring);
        }

        public void addRingCollection(RingCollection ringCollection) {
            this.rings.addAll(ringCollection.rings);
            this.gatheredRings.or(ringCollection.gatheredRings);
        }

        public boolean hasCommonBond(BitSet ring) {
            return this.gatheredRings.intersects(ring);
        }

        public boolean hasCommonBond(RingCollection ringCollection) {
            return this.gatheredRings.intersects(ringCollection.gatheredRings);
        }

        public boolean hasBond(int bondIndex) {
            return this.gatheredRings.get(bondIndex);
        }

        public BitSet getCommonBonds(RingCollection ringCollection) {
            BitSet result = new BitSet(this.gatheredRings.size());
            result.or(this.gatheredRings);
            result.and(ringCollection.gatheredRings);
            return result;
        }

        public BitSet getRingContainingBond(int bondIndex) {
            for (BitSet ring : this.rings) {
                if (!ring.get(bondIndex)) continue;
                return ring;
            }
            return new BitSet();
        }

        public BitSet getFusedRing(BitSet fusedToThisRing, int bondIndex) {
            for (BitSet ring : this.rings) {
                if (!ring.get(bondIndex) || !this.hasExactlyOneCommonBond(ring, fusedToThisRing)) continue;
                return ring;
            }
            return new BitSet();
        }

        public List<BitSet> getFusedRingPairs(BitSet ring) {
            ArrayList<BitSet> result = new ArrayList<BitSet>();
            for (BitSet otherRing : this.rings) {
                if (!this.hasExactlyOneCommonBond(ring, otherRing)) continue;
                BitSet ringUnion = new BitSet(ring.size());
                ringUnion.or(otherRing);
                ringUnion.xor(ring);
                result.add(ringUnion);
            }
            return result;
        }

        private boolean hasExactlyOneCommonBond(BitSet ring, BitSet otherRing) {
            BitSet intersection = new BitSet(ring.size());
            intersection.or(otherRing);
            intersection.and(ring);
            return intersection.cardinality() == 1;
        }
    }
}

