/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.core.calculations.stereo;

import chemaxon.struc.CIPStereoDescriptorIface;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.StereoActivePart;
import chemaxon.struc.TetrahedralStereoDescriptor;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashSet;

public class TetrahedralStereoDetection {
    public void calculateTetrahedralDescriptors(BitSet activeAtomSet, BitSet possibleTHAtomSet, MoleculeGraph molecule, HashSet<CIPStereoDescriptorIface> descriptors) {
        int[][] ctab = molecule.getCtab();
        int i = possibleTHAtomSet.nextSetBit(0);
        while (i >= 0) {
            if (this.isTHStereo(i, molecule)) {
                descriptors.add(new TetrahedralStereoDescriptor(this.getLocalParity(molecule.getLocalParity(i)), new StereoActivePart(i, Arrays.copyOf(ctab[i], ctab[i].length))));
                activeAtomSet.clear(i);
            }
            i = possibleTHAtomSet.nextSetBit(i + 1);
        }
    }

    private boolean isTHStereo(int index, MoleculeGraph m) {
        MolAtom activeAtom = m.getAtom(index);
        int doubleBondCount = 0;
        for (int i = 0; i < activeAtom.getBondCount(); ++i) {
            if (activeAtom.getBond(i).getType() == 2) {
                ++doubleBondCount;
                if (activeAtom.getAtno() == 16 || activeAtom.getAtno() == 15 || activeAtom.getAtno() == 7) {
                    if (doubleBondCount <= 2 && (activeAtom.getLigand(i).getBondCount() == 1 || activeAtom.getLigand(i).getCharge() != 0)) continue;
                    return false;
                }
                return false;
            }
            if (activeAtom.getBond(i).getType() <= 2) continue;
            return false;
        }
        return true;
    }

    private CIPStereoDescriptorIface.CIPValue.TetrahedralStereoValue getLocalParity(int parityValue) {
        switch (parityValue) {
            case 1: {
                return CIPStereoDescriptorIface.CIPValue.TetrahedralStereoValue.ODD;
            }
            case 2: {
                return CIPStereoDescriptorIface.CIPValue.TetrahedralStereoValue.EVEN;
            }
            case 3: {
                return CIPStereoDescriptorIface.CIPValue.TetrahedralStereoValue.WIGGLY;
            }
            case 0: {
                return CIPStereoDescriptorIface.CIPValue.TetrahedralStereoValue.UNKNOWN;
            }
        }
        return CIPStereoDescriptorIface.CIPValue.TetrahedralStereoValue.UNKNOWN;
    }
}

