/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.core.util;

import chemaxon.core.util.BondTable;
import java.lang.ref.SoftReference;

final class BondTableJavaArray
extends BondTable {
    private int[][] value;
    private SoftReference arrayReference = null;

    public static BondTable create(int atomCount) {
        return new BondTableJavaArray(atomCount);
    }

    private BondTableJavaArray(int atomCount) {
        super(atomCount);
        int i;
        this.value = new int[atomCount][];
        for (i = 0; i < this.value.length; ++i) {
            this.value[i] = new int[atomCount];
            this.value[0][i] = -1;
        }
        for (i = 1; i < atomCount; ++i) {
            System.arraycopy(this.value[0], 0, this.value[i], 0, atomCount);
        }
    }

    @Override
    public int[][] getMatrixArray() {
        Object result = null;
        if (this.arrayReference != null) {
            result = (int[][])this.arrayReference.get();
        }
        if (result == null) {
            int i;
            result = new int[this.getAtomCount()][];
            for (i = 0; i < ((int[][])result).length; ++i) {
                result[i] = new int[this.getAtomCount()];
            }
            for (i = 0; i < ((int[][])result).length; ++i) {
                System.arraycopy(this.value[i], 0, result[i], 0, this.getAtomCount());
            }
            this.arrayReference = new SoftReference<int[][]>((int[][])result);
        }
        return result;
    }

    @Override
    public int[] getBondIndexesToAtom(int i) {
        int[] result = new int[this.getAtomCount()];
        System.arraycopy(this.value[i], 0, result, 0, this.getAtomCount());
        return result;
    }

    @Override
    public int getBondIndex(int i1, int i2) {
        return this.value[i1][i2];
    }

    @Override
    public void setBondIndex(int i1, int i2, int bondIndex) {
        this.value[i1][i2] = bondIndex;
        this.value[i2][i1] = bondIndex;
    }

    @Override
    public BondTableJavaArray clone() {
        int i;
        BondTableJavaArray result = (BondTableJavaArray)super.clone();
        result.value = new int[this.getAtomCount()][];
        for (i = 0; i < this.value.length; ++i) {
            result.value[i] = new int[this.getAtomCount()];
        }
        for (i = 0; i < this.getAtomCount(); ++i) {
            System.arraycopy(this.value[i], 0, result.value[i], 0, this.getAtomCount());
        }
        return result;
    }
}

