/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.core.util;

import chemaxon.common.util.BasicEnvironment;
import chemaxon.struc.MacroMolecule;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class PDBResidues {
    public static final String UNKNOWN_RESIDUE = "UNK";
    public static final int UNKNOWN_RESIDUE_TYPE_ID = -1;
    private static final String NUCLEIC_ACIDS = "A Adenosine A 23 18 42 : C1* C2 C2* C3* C4 C4* C5 C5* C6 C8 N1 N3 N6 N7 N9 O1P O2* O2P O3P O3* O4* O5* P : 1H5* 1H6 2HOP 3HOP 2H5* H1* H2 H2* 1H2* 2H2* H3* H4* H5T H5PT 2H6 H8 H3T 2HO* : O4* C2* N9 H1* , N1 =N3 H2 , C3* O2* H2* 1H2* 2H2* , C4* O3* H3* , N9 =C5 N3 , C5* O4* H4* , N7 C6 H5T H5PT , O5* 1H5* 2H5* , N6 =N1 , N9 =N7 H8 ,  ,  , 1H6 2H6 ,  ,  , =P , 2HO* , P 2HOP , P 3HOP , H3T ,  , P . C Cytidine C 21 17 39 : C1* C2 C2* C3* C4 C4* C5 C5* C6 N1 N3 N4 O1P O2 O2* O2P O3P O3* O4* O5* P : 1H4 1H5* 2HOP 3HOP 2H4 2H5* H1* H2* 1H2* 2H2* H3* H4* H5 H5T H6 H3T 2HO* : O4* C2* N1 H1* , N1 =O2 N3 , C3* O2* H2* 1H2* 2H2* , C4* O3* H3* , =N3 N4 C5 , C5* O4* H4* , =C6 H5 H5T , O5* 1H5* 2H5* , N1 H6 ,  ,  , 1H4 2H4 , =P ,  , 2HO* , P 2HOP , P 3HOP , H3T ,  , P . G Guanosine G 24 17 46 : C1* C2 C2* C3* C4 C4* C5 C5* C6 C8 N1 N2 N3 N7 N9 O1P O2* O2P O3* O3P O4* O5* O6 P : 1H2 1H5* 2HOP 3HOP 2H5* H1 H1* H2* 1H2* 2H2* H3* H4* H8 H3T 2HO* 2H2 H5T : O4* C2* N9 H1* , N1 N2 =N3 , C3* O2* H2* 1H2* 2H2* , C4* O3* H3* , N9 =C5 N3 , C5* O4* H4* , N7 C6 , O5* 1H5* 2H5* , =O6 N1 , N9 =N7 H8 , H1 , 1H2 2H2 ,  ,  ,  , =P , 2HO* , P 2HOP , H3T , P 3HOP ,  , P H5T . I Inosine I 23 15 40 : C1* C2 C2* C3* C4 C4* C5 C5* C6 C8 N1 N3 N7 N9 O1P O2* O2P O3* O3P O4* O5* O6 P : 1H5* 2HOP 3HOP 2H5* H1 H1* H2 H2* 1H2* 2H2* H3* H4* H8 H3T 2HO* : O4* C2* N9 H1* , N1 =N3 H2 , C3* O2* H2* 1H2* 2H2* , C4* O3* H3* , N9 =C5 N3 , C5* O4* H4* , N7 C6 , O5* 1H5* 2H5* , =O6 N1 , N9 =N7 H8 , H1 ,  ,  ,  , =P , 2HO* , P 2HOP , H3T , P 3HOP ,  , P . T Thymidine T 21 16 37 : C1* C2 C2* C3* C4 C4* C5 C5* C5M C6 N1 N3 O1P O2 O2P O3* O3P O4 O4* O5* P : 1H2* 1H5* 1H5M 2H5M 2HOP 3HOP 2H5* H1* H3 H3* H4* H6 H3T 2H2 2H2* 3H5M : O4* C2* N1 H1* , N1 =O2 N3 , C3* 1H2* 2H2* , C4* O3* H3* , N3 =O4 C5 , C5* O4* H4* , C5M =C6 , O5* 1H5* 2H5* , 1H5M 2H5M 3H5M , N1 H6 ,  , H3 , =P ,  , P 2HOP , H3T , P 3HOP ,  ,  , P . U Uridine U 21 13 35 : C1* C2 C2* C3* C4 C4* C5 C5* C6 N1 N3 O1P O2 O2* O2P O3* O3P O4 O4* O5* P : 1H5* 2HOP 3HOP 2H5* H1* H3 H3* H4* H5 H6 H3T H2* 2HO* : O4* C2* N1 H1* , N1 =O2 N3 , C3* O2* H2* , C4* O3* H3* , N3 =O4 C5 , C5* O4* H4* , =C6 H5 , O5* 1H5* 2H5* , N1 H6 ,  , H3 , =P ,  , 2HO* , P 2HOP , H3T , P 3HOP ,  ,  , P . ";
    private static final String AMINO_ACIDS = "ALA Alanine A 5 5 11 : C CA N O CB : H HA 1HB 2HB 3HB : =O CA , CB N HA , H ,  , 1HB 2HB 3HB . ARG Arginine R 11 13 24 : C CA N O CB CG CD CZ NE NH1 NH2 : H HA 1HB 2HB 1HG 2HG 1HD 2HD HE 1HH1 2HH1 1HH2 2HH2 : =O CA , CB N HA , H ,  , CG 1HB 2HB , CD 1HG 2HG , NE 1HD 2HD , NE -NH1 =NH2 , HE , 1HH1 2HH1 , 1HH2 2HH2 . ASN Asparagine N 8 6 14 : C CA N O CB CG OD1 ND2 : H HA 1HB 2HB 1HD2 2HD2 : =O CA , CB N HA , H ,  , CG 1HB 2HB , =OD1 -ND2 ,  , 1HD2 2HD2 . ASP Aspartic_acid D 8 6 14 : C CA N O CB CG OD1 OD2 : H HA 1HB 2HB HD1 HD2 : =O CA , CB N HA , H ,  , CG 1HB 2HB , =OD1 OD2 , HD1 , HD2 . ASX ASP/ASN_ambiguous B 8 5 13 : C CA N O CB CG AD1 AD2 : H HA 1HB 2HB HD2 : =O CA , CB N HA , H ,  , CG 1HB 2HB , =AD1 AD2 ,  , HD2 . CYS Cystein C 6 5 11 : C CA N O CB SG : H HA 1HB 2HB HG : =O CA , CB N HA , H ,  , SG 1HB 2HB , HG . GLN Glutamine Q 9 8 17 : C CA N O CB CG CD OE1 NE2 : H HA 1HB 2HB 1HG 2HG 1HE2 2HE2 : =O CA , CB N HA , H ,  , CG 1HB 2HB , CD 1HG 2HG , =OE1 -NE2 ,  , 1HE2 2HE2 . GLU Glutamic_acid E 9 7 16 : C CA N O CB CG CD OE1 OE2 : H HA 1HB 2HB 1HG 2HG HE2 : =O CA , CB N HA , H ,  , CG 1HB 2HB , CD 1HG 2HG , =OE1 -OE2 ,  , HE2 . GLX GLN/GLU_ambiguous Z 9 7 17 : C CA N O CB CG CD AE1 AE2 : H HA 1HB 2HB 1HG 2HG HE2 : =O CA , CB N HA , H ,  , CG 1HB 2HB , CD 1HG 2HG , =AE1 -AE2 ,  , HE2 . GLY Glycine G 4 3 6 : C CA N O : H 1HA 2HA : =O CA , N 1HA 2HA , H . HIS Histidine H 10 8 19 : C CA N O CB CG ND1 CE1 CD2 NE2 : H HA 1HB 2HB HD1 HD2 HE1 HE2 : =O CA , CB N HA , H ,  , CG 1HB 2HB , ND1 =CD2 , =CE1 HD1 , NE2 HE1 , NE2 HD2 , HE2 . ILE Isoleucine I 8 11 19 : C CA N O CB CG1 CG2 CD1 : H HA HB 1HG1 2HG1 1HG2 2HG2 3HG2 1HD1 2HD1 3HD1 : =O CA , CB N HA , H ,  , CG1 CG2 HB , CD1 1HG1 2HG1 , 1HG2 2HG2 3HG2 , 1HD1 2HD1 3HD1 . LEU Leucine L 8 11 19 : C CA N O CB CG CD1 CD2 : H HA 1HB 2HB HG 1HD1 2HD1 3HD1 1HD2 2HD2 3HD2 : =O CA , CB N HA , H ,  , CG 1HB 2HB , CD1 CD2 HG , 1HD1 2HD1 3HD1 , 1HD2 2HD2 3HD2 . LYS Lysine K 9 13 22 : C CA N O CB CG CD CE NZ : H HA 1HB 2HB 1HG 2HG 1HD 2HD 1HE 2HE 1HZ 2HZ 3HZ : =O CA , CB N HA , H ,  , CG 1HB 2HB , CD 1HG 2HG , CE 1HD 2HD , NZ 1HE 2HE , 1HZ 2HZ 3HZ . MET Methionine M 8 9 16 : C CA N O CB CG SD CE : H HA 1HB 2HB 1HG 2HG 1HE 2HE 3HE : =O CA , CB N HA , H ,  , CG 1HB 2HB , SD 1HG 2HG , CE , 1HE 2HE 3HE . PHE Phenylalanine F 11 9 21 : C CA N O CB CG CD1 CD2 CE1 CE2 CZ : H HA 1HB 2HB HD1 HD2 HE1 HE2 HZ : =O CA , CB N HA , H ,  , CG 1HB 2HB , -CD1 =CD2 , =CE1 HD1 , -CE2 HD2 , CZ HE1 , =CZ HE2 , HZ . PRO Proline P 7 8 16 : C CA N O CB CG CD : H HA 1HB 2HB 1HG 2HG 1HD 2HD : =O CA , CB N HA , H ,  , CG 1HB 2HB , CD 1HG 2HG , N 1HD 2HD . SER Serine S 6 5 10 : C CA N O CB OG : H HA 1HB 2HB HG : =O CA , CB N HA , H ,  , OG 1HB 2HB , HG . THR Threonine T 7 7 14 : C CA N O CB CG2 OG1 : H HA HB HG1 1HG2 2HG2 3HG2 : =O CA , CB N HA , H ,  , CG2 OG1 HB , 1HG2 2HG2 3HG2 , HG1 . TRP Tryptophan W 14 10 23 : C CA N O CB CG CD1 CD2 CE2 CE3 CZ2 CZ3 CH2 NE1 : H HA 1HB 2HB HD1 HE1 HE3 HZ2 HZ3 HH2 : =O CA , CB N HA , H ,  , CG 1HB 2HB , =CD1 -CD2 , NE1 HD1 , =CE2 -CE3 , CZ2 NE1 , =CZ3 HE3 , =CH2 HZ2 , CH2 HZ3 , HH2 , HE1 . TYR Tyrosine Y 12 9 20 : C CA N O CB CG CD1 CD2 CE1 CE2 CZ OH : H HA 1HB 2HB HD1 HD2 HE1 HE2 HH : =O CA , CB N HA , H ,  , CG 1HB 2HB , -CD1 =CD2 , =CE1 HD1 , CE2 HD2 , CZ HE1 , =CZ HE2 , -OH , HH . VAL Valine V 7 9 16 : C CA N O CB CG1 CG2 : H HA HB 1HG1 2HG1 3HG1 1HG2 2HG2 3HG2 : =O CA , CB N HA , H ,  , CG1 CG2 HB , 1HG1 2HG1 3HG1 , 1HG2 2HG2 3HG2 . ";
    private static final int NUCLEIC_ACID_COUNT = 6;
    private static final int AMINO_ACID_COUNT = 22;
    public static final int MAX_MODRES_COUNT = 100;
    private static Molecule[] residues = null;
    private static float[][] partialCharge = null;
    private static Hashtable residueAbbrevToResidueTypeId = new Hashtable();
    private static Hashtable residueAtomLabelToResidueAtomId = new Hashtable();
    private static Hashtable fullResidueAtomLabelToResidueAtomId = null;
    private static Hashtable[] residueAtomLabelToAtomIndex = new Hashtable[128];
    private static int[][] nucleicAcidPolymerAtomIndex = new int[6][2];
    private static int[][] modifiedResiduePolymerAtomIndex = new int[100][2];
    private static String abbrev = new String();
    private static String name = new String();
    private static String syn = new String();
    private static int nAtoms = 0;
    private static int nHydrogens = 0;
    private static int nBonds = 0;
    private static Tokenizer tokenizer = null;

    public static boolean isAminoAcid(String residueName) {
        Integer typeId = (Integer)residueAbbrevToResidueTypeId.get(residueName);
        return typeId != null && typeId < 22;
    }

    public static boolean isNucleicAcid(String residueName) {
        Integer typeId = (Integer)residueAbbrevToResidueTypeId.get(residueName);
        return typeId != null && PDBResidues.isNucleicAcid(typeId);
    }

    private static boolean isNucleicAcid(int typeId) {
        return typeId >= 22 && typeId < 28;
    }

    public static boolean isStandardResidue(String residueName) {
        return residueAbbrevToResidueTypeId.containsKey(residueName);
    }

    public static boolean isModRes(String residueName) {
        Integer typeId = (Integer)residueAbbrevToResidueTypeId.get(residueName);
        return typeId != null && typeId >= 28;
    }

    public static boolean isModRes(int resTypeId) {
        return resTypeId >= 28;
    }

    public static boolean isStdResKnown(String modResName) {
        return !residues[PDBResidues.getResidueTypeId(modResName)].getName().equals(modResName);
    }

    public static int getResidueTypeId(String residueName) {
        Integer id = (Integer)residueAbbrevToResidueTypeId.get(residueName);
        return id != null ? id : -1;
    }

    public static String getResidueName(int residueTypeId) {
        return residues[residueTypeId].getName();
    }

    public static int getResidueAtomIndex(int resTypeId, String residueAtomName) {
        Object idObj = residueAtomLabelToAtomIndex[resTypeId].get(residueAtomName);
        if (idObj == null) {
            residueAtomName = PDBResidues.standardizeAtomName(resTypeId, residueAtomName);
            idObj = residueAtomLabelToAtomIndex[resTypeId].get(residueAtomName);
        }
        if (idObj == null) {
            return -1;
        }
        return (Integer)idObj;
    }

    private static String standardizeAtomName(int resTypeId, String residueAtomName) {
        if (PDBResidues.isNucleicAcid(resTypeId)) {
            String t1;
            if (residueAtomName.endsWith("T")) {
                t1 = residueAtomName.replace('T', 'P');
                if (residueAtomLabelToAtomIndex[resTypeId].get(t1) != null) {
                    return t1;
                }
                t1 = residueAtomName.replace('T', '*');
                if (residueAtomLabelToAtomIndex[resTypeId].get(t1) != null) {
                    return t1;
                }
            }
            if (residueAtomName.endsWith("A") && residueAtomLabelToAtomIndex[resTypeId].get(t1 = residueAtomName.replace('A', 'M')) != null) {
                return t1;
            }
        }
        if (residueAtomName.charAt(residueAtomName.length() - 1) == '\'') {
            return residueAtomName.replace('\'', '*');
        }
        return residueAtomName;
    }

    public static int getResidueAtomCount(int resTypeId) {
        Molecule r = residues[resTypeId];
        return r.getAtomCount();
    }

    public static int getResidueHeavyAtomCount(int resTypeId) {
        Molecule r = residues[resTypeId];
        return r.getAtomCount() - r.getExplicitHcount();
    }

    public static int getResidueHydrogenCount(int resTypeId) {
        Molecule r = residues[resTypeId];
        return r.getExplicitHcount();
    }

    public static Molecule getResidue(int resTypeId) {
        return residues[resTypeId];
    }

    public static int getResidueAtomType(int resTypeId, int atomIndex) {
        Molecule r = residues[resTypeId];
        return r.getAtom(atomIndex).getAtno();
    }

    public static String getResidueAtomLabel(int atomIndex, int seqNo, char iCode, int resTypeId) {
        Molecule res = residues[resTypeId];
        return res.getAtom(atomIndex).getExtraLabel() + " " + res.getName() + "-" + seqNo + iCode;
    }

    public static String getResidueAtomName(int resTypeId, int atomIndex) {
        Molecule res = residues[resTypeId];
        return res.getAtom(atomIndex).getExtraLabel();
    }

    public static boolean isHydrogen(int resTypeId, int atomIndex) {
        Molecule r = residues[resTypeId];
        return atomIndex >= r.getAtomCount() - r.getExplicitHcount();
    }

    public static int getPolymerAtomType(int resTypeId, int whichAtom) {
        if (resTypeId < 22) {
            return whichAtom == 1 ? 6 : 7;
        }
        if (resTypeId < 28) {
            return residues[resTypeId].getAtom(nucleicAcidPolymerAtomIndex[resTypeId - 22][whichAtom - 1]).getAtno();
        }
        return residues[resTypeId].getAtom(modifiedResiduePolymerAtomIndex[resTypeId - 22 - 6][whichAtom - 1]).getAtno();
    }

    public static int getPolymerAtomIndex(int resTypeId, int whichAtom) {
        if (resTypeId < 22) {
            return whichAtom == 1 ? 0 : 2;
        }
        if (resTypeId < 28) {
            return nucleicAcidPolymerAtomIndex[resTypeId - 22][whichAtom - 1];
        }
        return modifiedResiduePolymerAtomIndex[resTypeId - 22 - 6][whichAtom - 1];
    }

    public static int getPolymerAtomNeighborIndex(int resTypeId) {
        return resTypeId < 22 ? 1 : 3;
    }

    public static int getHydrogenCountOfAtom(int resTypeId, int atomIndex) {
        Molecule r = residues[resTypeId];
        MolAtom a = r.getAtom(atomIndex);
        return a.getExplicitHcount();
    }

    public static int getHydrogenIndex(int resTypeId, int atomIndex, int h) {
        Molecule r = residues[resTypeId];
        MolAtom a = r.getAtom(atomIndex);
        int ahc = a.getExplicitHcount();
        for (int i = 0; i < a.getBondCount(); ++i) {
            MolAtom n;
            MolAtom a1 = a.getBond(i).getAtom1();
            MolAtom a2 = a.getBond(i).getAtom2();
            MolAtom molAtom = n = r.indexOf(a) == r.indexOf(a1) ? a2 : a1;
            if (n.getAtno() != 1) continue;
            if (h == 0 || ahc <= h) {
                return r.indexOf(n);
            }
            --h;
        }
        return -1;
    }

    public static String getHydrogenOfAtom(int resTypeId, int atomIndex, int hc) {
        Molecule r = residues[resTypeId];
        MolAtom a = r.getAtom(atomIndex);
        int ahc = a.getExplicitHcount();
        for (int i = 0; i < a.getBondCount(); ++i) {
            MolAtom n;
            MolAtom a1 = a.getBond(i).getAtom1();
            MolAtom a2 = a.getBond(i).getAtom2();
            MolAtom molAtom = n = r.indexOf(a) == r.indexOf(a1) ? a2 : a1;
            if (n.getAtno() != 1) continue;
            if (hc == 0 || ahc <= hc) {
                return n.getExtraLabel();
            }
            --hc;
        }
        return null;
    }

    public static float getPartialAtomCharge(int resTypeId, int atomIndex) {
        return partialCharge == null || partialCharge[resTypeId] == null || partialCharge[resTypeId].length <= atomIndex ? 0.0f : partialCharge[resTypeId][atomIndex];
    }

    public static float getCummulatedPartialAtomCharge(int resTypeId, int atomIndex) {
        if (partialCharge == null || partialCharge[resTypeId] == null || partialCharge[resTypeId].length <= atomIndex) {
            return 0.0f;
        }
        float pc = partialCharge[resTypeId][atomIndex];
        Molecule r = residues[resTypeId];
        MolAtom a = r.getAtom(atomIndex);
        int ahc = a.getExplicitHcount();
        for (int i = 0; i < a.getBondCount(); ++i) {
            MolAtom n;
            MolAtom a1 = a.getBond(i).getAtom1();
            MolAtom a2 = a.getBond(i).getAtom2();
            MolAtom molAtom = n = r.indexOf(a) == r.indexOf(a1) ? a2 : a1;
            if (n.getAtno() != 1) continue;
            pc += partialCharge[resTypeId][r.indexOf(n)];
        }
        return pc;
    }

    public static int addModRes(String resName) {
        if (!residueAbbrevToResidueTypeId.containsKey(resName)) {
            int id = 28 + residueAbbrevToResidueTypeId.size();
            residueAbbrevToResidueTypeId.put(resName, new Integer(id));
            PDBResidues.residueAtomLabelToAtomIndex[id] = new Hashtable();
            PDBResidues.residues[id] = new Molecule();
            residues[id].setName(resName);
            return id;
        }
        return (Integer)residueAbbrevToResidueTypeId.get(resName);
    }

    public static int addModResName(String resName, String stdResName) {
        if (!residueAbbrevToResidueTypeId.containsKey(resName)) {
            PDBResidues.addModRes(resName);
        }
        int id = (Integer)residueAbbrevToResidueTypeId.get(resName);
        residues[id].setName(stdResName);
        return id;
    }

    public static int addModResAtom(String resName, String atomName, String element) {
        int id;
        Molecule res;
        int atomId;
        if (!residueAbbrevToResidueTypeId.containsKey(resName)) {
            PDBResidues.addModRes(resName);
        }
        if ((atomId = PDBResidues.findModResAtom(res = residues[id = ((Integer)residueAbbrevToResidueTypeId.get(resName)).intValue()], id, atomName)) == -1) {
            MolAtom a = PDBResidues.createAtom(PDBResidues.getAtomType(element.charAt(0)), atomName, id);
            res.add(a);
            atomId = res.indexOf(a);
            residueAtomLabelToAtomIndex[id].put(atomName, new Integer(atomId));
            if (atomName.equals("C")) {
                PDBResidues.modifiedResiduePolymerAtomIndex[id - 22 - 6][0] = atomId;
            }
            if (atomName.equals("N")) {
                PDBResidues.modifiedResiduePolymerAtomIndex[id - 22 - 6][1] = atomId;
            }
            return atomId;
        }
        return -1;
    }

    public static int addModResAtom(String resName, String atomName, String element, float x, float y, float z) {
        int atomId = PDBResidues.addModResAtom(resName, atomName, element);
        if (atomId != -1) {
            int id = (Integer)residueAbbrevToResidueTypeId.get(resName);
            Molecule res = residues[id];
            res.getAtom(atomId).setX(x);
            res.getAtom(atomId).setY(y);
            res.getAtom(atomId).setZ(z);
        }
        return atomId;
    }

    public static void addModResBond(String resName, int atom1, int atom2) {
        int id = (Integer)residueAbbrevToResidueTypeId.get(resName);
        Molecule res = residues[id];
        if (res != null && atom1 < res.getAtomCount() && atom2 < res.getAtomCount()) {
            MolAtom a1 = res.getAtom(atom1);
            MolAtom a2 = res.getAtom(atom2);
            res.add(new MolBond(a1, a2));
        }
    }

    private static int findModResAtom(Molecule res, int resId, String atomName) {
        Integer atomId = (Integer)residueAtomLabelToAtomIndex[resId].get(atomName);
        return atomId == null ? -1 : atomId;
    }

    public static void completeModifiedResidues() {
        MacroMolecule.BondMaker bm = new MacroMolecule.BondMaker();
        bm.setFixBondTypes(true);
        int id = 28;
        int i = 0;
        while (i < residueAbbrevToResidueTypeId.size()) {
            if (residues[id] != null && residues[id].getBondCount() == 0) {
                bm.setMolecule(residues[id]);
                PDBResidues.residues[id] = bm.getFixed();
            }
            ++i;
            ++id;
        }
    }

    private static void initializeAminoAcids() {
        tokenizer = new Tokenizer(AMINO_ACIDS);
        for (int i = 0; i < 22; ++i) {
            fullResidueAtomLabelToResidueAtomId = new Hashtable();
            PDBResidues.residues[i] = PDBResidues.buildResidue(residueAbbrevToResidueTypeId);
            PDBResidues.residueAtomLabelToAtomIndex[i] = fullResidueAtomLabelToResidueAtomId;
        }
    }

    private static void initializeNucleicAcids() {
        tokenizer = new Tokenizer(NUCLEIC_ACIDS);
        for (int i = 0; i < 6; ++i) {
            Molecule na;
            fullResidueAtomLabelToResidueAtomId = new Hashtable();
            PDBResidues.residues[22 + i] = na = PDBResidues.buildResidue(residueAbbrevToResidueTypeId);
            PDBResidues.residueAtomLabelToAtomIndex[22 + i] = fullResidueAtomLabelToResidueAtomId;
            PDBResidues.nucleicAcidPolymerAtomIndex[i][1] = na.getAtomCount() - na.getExplicitHcount() - 1;
            PDBResidues.nucleicAcidPolymerAtomIndex[i][0] = PDBResidues.findO3(na);
        }
    }

    private static int findO3(Molecule nucleicAcid) {
        for (int i = 0; i < nucleicAcid.getAtomCount(); ++i) {
            if (!nucleicAcid.getAtom(i).getExtraLabel().equals("O3*")) continue;
            return i;
        }
        PDBResidues.asser(false);
        return -1;
    }

    private static Molecule buildResidue(Hashtable abbrevToId) {
        PDBResidues.readHeader();
        int residueTypeId = abbrevToId.size();
        abbrevToId.put(abbrev, new Integer(residueTypeId));
        Molecule mol = new Molecule(null, nAtoms + nHydrogens, nBonds);
        mol.setName(abbrev);
        PDBResidues.addAtoms(mol, residueTypeId);
        PDBResidues.addBonds(mol);
        return mol;
    }

    private static void readHeader() {
        abbrev = tokenizer.nextToken();
        name = tokenizer.nextToken();
        syn = tokenizer.nextToken();
        nAtoms = Integer.parseInt(tokenizer.nextToken());
        nHydrogens = Integer.parseInt(tokenizer.nextToken());
        nBonds = Integer.parseInt(tokenizer.nextToken());
        tokenizer.nextToken();
    }

    private static void addAtoms(Molecule frag, int residueTypeId) {
        for (int i = 0; i < nAtoms; ++i) {
            MolAtom a = PDBResidues.readAtom(residueTypeId);
            frag.add(a);
            String fullResidueAtomLabel = tokenizer.getToken();
            fullResidueAtomLabelToResidueAtomId.put(fullResidueAtomLabel, new Integer(frag.indexOf(a)));
        }
        String sep = tokenizer.nextToken();
        PDBResidues.asser(sep.equals(":"));
        for (int i = 0; i < nHydrogens; ++i) {
            MolAtom a = PDBResidues.readHydrogen(residueTypeId);
            frag.add(a);
            String fullResidueAtomLabel = tokenizer.getToken();
            fullResidueAtomLabelToResidueAtomId.put(fullResidueAtomLabel, new Integer(frag.indexOf(a)));
        }
        sep = tokenizer.nextToken();
        PDBResidues.asser(sep.equals(":"));
    }

    private static void addBonds(Molecule frag) {
        for (int atomIndex = 0; atomIndex < nAtoms && !tokenizer.getToken().equals("."); ++atomIndex) {
            MolBond b = PDBResidues.readBond(frag, atomIndex);
            while (b != null) {
                frag.add(b);
                b = PDBResidues.readBond(frag, atomIndex);
            }
        }
        PDBResidues.asser(tokenizer.getToken().equals("."));
    }

    private static MolAtom readAtom(int residueTypeId) {
        String as = tokenizer.nextToken();
        PDBResidues.asser(!as.equals(":"));
        char symbol = as.charAt(0);
        int atomType = PDBResidues.getAtomType(symbol);
        PDBResidues.asser(atomType != -1);
        String residueAtomLabel = as.substring(1);
        MolAtom atom = PDBResidues.createAtom(atomType, residueAtomLabel, residueTypeId);
        atom.setExtraLabel(as);
        return atom;
    }

    private static int getAtomType(char symbol) {
        switch (symbol) {
            case 'C': {
                return 6;
            }
            case 'N': {
                return 7;
            }
            case 'O': {
                return 8;
            }
            case 'P': {
                return 15;
            }
            case 'S': {
                return 16;
            }
            case 'A': {
                return 8;
            }
        }
        return 1;
    }

    private static MolAtom readHydrogen(int residueTypeId) {
        String as = tokenizer.nextToken();
        PDBResidues.asser(!as.equals(":"));
        char firstChar = as.charAt(0);
        int hId = firstChar == 'H' ? 0 : firstChar - 48;
        PDBResidues.asser(0 <= hId && hId <= 3);
        PDBResidues.asser(hId == 0 || hId != 0 && as.charAt(1) == 'H');
        String residueAtomLabel = (hId == 0 ? "" : Integer.toString(hId)) + as.substring(hId == 0 ? 1 : 2);
        MolAtom atom = PDBResidues.createAtom(1, residueAtomLabel, residueTypeId);
        atom.setExtraLabel(as);
        return atom;
    }

    private static MolBond readBond(Molecule frag, int atomIndex) {
        String na = tokenizer.nextToken();
        if (na.equals(",") || na.equals(".")) {
            return null;
        }
        String otherAtom = na.charAt(0) == '-' || na.charAt(0) == '=' ? na.substring(1) : na;
        int naIndex = (Integer)fullResidueAtomLabelToResidueAtomId.get(otherAtom);
        int bondType = na.charAt(0) == '-' ? 1 : (na.charAt(0) == '=' ? 2 : 1);
        return new MolBond(frag.getAtom(atomIndex), frag.getAtom(naIndex), bondType);
    }

    private static MolAtom createAtom(int atomType, String residueAtomLabel, int residueTypeId) {
        MolAtom atom = new MolAtom(atomType);
        PDBResidues.extendResidueAtomLabels(residueAtomLabel);
        Integer id = (Integer)residueAtomLabelToResidueAtomId.get(residueAtomLabel);
        if (id != null) {
            atom.setResidueAtomId(id);
        }
        atom.setResidueType(residueTypeId);
        atom.setExtraLabel(residueAtomLabel);
        return atom;
    }

    private static void extendResidueAtomLabels(String residueAtomLabel) {
        if (residueAtomLabel.length() > 0 && !residueAtomLabelToResidueAtomId.containsKey(residueAtomLabel)) {
            Integer id = new Integer(residueAtomLabelToResidueAtomId.size() + 1);
            residueAtomLabelToResidueAtomId.put(residueAtomLabel, id);
        }
    }

    public static void readPartialCharges() {
        partialCharge = new float[residues.length][];
        try {
            String relativeResiduesTxt = "/chemaxon/Residues.txt";
            InputStream resource = BasicEnvironment.getResourceAsStream(PDBResidues.class, relativeResiduesTxt);
            BufferedReader is = new BufferedReader(new InputStreamReader(resource));
            String line = is.readLine();
            while (line != null) {
                if (line.charAt(0) != '!') {
                    String atom = line.substring(0, 3);
                    String res = line.substring(4, 7);
                    String charge = line.substring(20, 28);
                    PDBResidues.addAtomPartialCharge(atom, res, Float.valueOf(charge).floatValue());
                }
                line = is.readLine();
            }
            is.close();
        }
        catch (FileNotFoundException fnf) {
            fnf.printStackTrace();
            System.err.println("File Residues.txt is not found or is not readable.");
        }
        catch (IOException e) {
            System.err.println("File Residues.txt is not readable.");
        }
    }

    private static void addAtomPartialCharge(String atom, String resName, float charge) {
        int resTypeId = PDBResidues.getResidueTypeId(resName);
        if (resTypeId == -1 && !resName.equals("***")) {
            return;
        }
        if (resTypeId == -1) {
            for (resTypeId = 0; resTypeId < 22; ++resTypeId) {
                PDBResidues.setAtomPartialCharge(resTypeId, atom, charge);
            }
        } else {
            PDBResidues.setAtomPartialCharge(resTypeId, atom, charge);
        }
    }

    private static void setAtomPartialCharge(int resTypeId, String atom, float charge) {
        int ai;
        Molecule r = PDBResidues.getResidue(resTypeId);
        if (atom.endsWith(" ")) {
            atom = atom.trim();
        }
        if ((ai = PDBResidues.getResidueAtomIndex(resTypeId, atom)) == -1) {
            return;
        }
        if (partialCharge[resTypeId] == null) {
            PDBResidues.partialCharge[resTypeId] = new float[r.getAtomCount()];
        }
        PDBResidues.partialCharge[resTypeId][ai] = charge;
    }

    private static void asser(boolean cond) {
        if (!cond) {
            throw new RuntimeException("Assertion failed");
        }
    }

    static {
        residues = new Molecule[128];
        PDBResidues.initializeAminoAcids();
        PDBResidues.initializeNucleicAcids();
    }

    private static class Tokenizer
    extends StringTokenizer {
        private String currentToken = null;

        public Tokenizer(String str) {
            super(str);
        }

        @Override
        public String nextToken() {
            this.currentToken = super.nextToken();
            return this.currentToken;
        }

        public String getToken() {
            return this.currentToken;
        }
    }
}

