/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.core.util.differ;

import chemaxon.common.util.ArrayTools;
import chemaxon.core.util.differ.DifferUtils;
import chemaxon.core.util.differ.MObjectDifferFactory;
import chemaxon.struc.MObject;
import chemaxon.struc.Sgroup;
import chemaxon.struc.graphics.MBracket;
import java.util.ArrayList;
import java.util.Arrays;

public class BasicSgroupDiffer {
    private boolean ignoreType = false;
    private boolean ignoreSubtype = false;
    private boolean ignoreSubscript = false;
    private boolean ignoreConnectivity = false;
    private boolean ignoreChargeLocation = false;
    private boolean ignoreBrackets = false;
    private boolean ignoreParentSgroup = false;
    private boolean ignoreChildrenSgroups = false;

    protected String compareType(Sgroup sgroup1, Sgroup sgroup2) {
        if (sgroup1.getType() != sgroup2.getType()) {
            return DifferUtils.getAttributeDifferenceString("S-group type", sgroup1.getType(), sgroup2.getType());
        }
        return null;
    }

    public void ignoreType(boolean ignoreState) {
        this.ignoreType = ignoreState;
    }

    protected String compareSubtype(Sgroup sgroup1, Sgroup sgroup2) {
        if (sgroup1.getSubType() != sgroup2.getSubType()) {
            return DifferUtils.getAttributeDifferenceString("S-group subtype", sgroup1.getSubType(), sgroup2.getSubType());
        }
        return null;
    }

    public void ignoreSubtype(boolean ignoreState) {
        this.ignoreSubtype = ignoreState;
    }

    protected String compareSubscript(Sgroup sgroup1, Sgroup sgroup2) {
        if (!DifferUtils.equalsStrings(sgroup1.getSubscript(), sgroup2.getSubscript())) {
            return DifferUtils.getAttributeDifferenceString("S-group subscript", sgroup1.getSubscript(), sgroup2.getSubscript());
        }
        return null;
    }

    public void ignoreSubscript(boolean ignoreState) {
        this.ignoreSubscript = ignoreState;
    }

    protected String compareConnectivity(Sgroup sgroup1, Sgroup sgroup2) {
        if (sgroup1.getConnectivity() != sgroup2.getConnectivity()) {
            return DifferUtils.getAttributeDifferenceString("S-group connectivity", sgroup1.getConnectivity(), sgroup2.getConnectivity());
        }
        return null;
    }

    public void ignoreConnectivity(boolean ignoreState) {
        this.ignoreConnectivity = ignoreState;
    }

    protected String compareChargeLocation(Sgroup sgroup1, Sgroup sgroup2) {
        if (sgroup1.getChargeLocation() != sgroup2.getChargeLocation()) {
            return DifferUtils.getAttributeDifferenceString("S-group charge location", sgroup1.getChargeLocation(), sgroup2.getChargeLocation());
        }
        return null;
    }

    public void ignoreChargeLocation(boolean ignoreState) {
        this.ignoreChargeLocation = ignoreState;
    }

    protected String compareBrackets(Sgroup sgroup1, Sgroup sgroup2) {
        if (sgroup1.getBracketCount() != sgroup2.getBracketCount()) {
            return DifferUtils.getAttributeDifferenceString("S-group bracket count", sgroup1.getBracketCount(), sgroup2.getBracketCount());
        }
        if (sgroup1.getBracketCount() == 0) {
            return null;
        }
        ArrayList<MBracket> brackets1 = sgroup1.getBrackets();
        ArrayList<MBracket> brackets2 = sgroup2.getBrackets();
        MObjectDifferFactory mObjectDifferFactory = new MObjectDifferFactory();
        for (int i = 0; i < brackets1.size(); ++i) {
            String difference = mObjectDifferFactory.diff((MObject)brackets1.get(i), (MObject)brackets2.get(i));
            if (difference == null) continue;
            return difference;
        }
        return null;
    }

    public void ignoreBrackets(boolean ignoreState) {
        this.ignoreBrackets = ignoreState;
    }

    protected String compareParentSgroup(Sgroup sgroup1, Sgroup sgroup2) {
        Sgroup parent1 = sgroup1.getParentSgroup();
        Sgroup parent2 = sgroup2.getParentSgroup();
        if (parent1 == null && parent2 == null) {
            return null;
        }
        if (parent1 == null) {
            return DifferUtils.getAttributeDifferenceString("S-group parent group", "null", "not null");
        }
        if (parent2 == null) {
            return DifferUtils.getAttributeDifferenceString("S-group parent group", "not null", "null");
        }
        if (sgroup1.getParentMolecule().indexOf(parent1) != sgroup2.getParentMolecule().indexOf(parent2)) {
            return DifferUtils.getAttributeDifferenceString("S-group parent group", sgroup1.getParentMolecule().indexOf(parent1), sgroup2.getParentMolecule().indexOf(parent2));
        }
        return null;
    }

    public void ignoreParentSgroup(boolean ignoreState) {
        this.ignoreParentSgroup = ignoreState;
    }

    protected String compareChildrenSgroups(Sgroup sgroup1, Sgroup sgroup2) {
        if (sgroup1.getChildSgroupCount() != sgroup2.getChildSgroupCount()) {
            return DifferUtils.getAttributeDifferenceString("number of children S-groups", sgroup1.getChildSgroupCount(), sgroup2.getChildSgroupCount());
        }
        int[] sgroupIndexes1 = new int[sgroup1.getChildSgroupCount()];
        int[] sgroupIndexes2 = new int[sgroup2.getChildSgroupCount()];
        for (int i = 0; i < sgroupIndexes1.length; ++i) {
            sgroupIndexes1[i] = sgroup1.getParentMolecule().indexOf(sgroup1.getChildSgroup(i));
            sgroupIndexes2[i] = sgroup2.getParentMolecule().indexOf(sgroup2.getChildSgroup(i));
        }
        if (!ArrayTools.equalsArrays(sgroupIndexes1, sgroupIndexes2)) {
            return DifferUtils.getAttributeDifferenceString("S-group children groups", Arrays.toString(sgroupIndexes1), Arrays.toString(sgroupIndexes2));
        }
        return null;
    }

    public void ignoreChildrenSgroups(boolean ignoreState) {
        this.ignoreChildrenSgroups = ignoreState;
    }

    String compareAttributes(Sgroup sgroup1, Sgroup sgroup2) {
        String difference;
        if (!this.ignoreType && (difference = this.compareType(sgroup1, sgroup2)) != null) {
            return difference;
        }
        if (!this.ignoreSubtype && (difference = this.compareSubtype(sgroup1, sgroup2)) != null) {
            return difference;
        }
        if (!this.ignoreSubscript && (difference = this.compareSubscript(sgroup1, sgroup2)) != null) {
            return difference;
        }
        if (!this.ignoreConnectivity && (difference = this.compareConnectivity(sgroup1, sgroup2)) != null) {
            return difference;
        }
        if (!this.ignoreChargeLocation && (difference = this.compareChargeLocation(sgroup1, sgroup2)) != null) {
            return difference;
        }
        if (!this.ignoreBrackets && (difference = this.compareBrackets(sgroup1, sgroup2)) != null) {
            return difference;
        }
        if (!this.ignoreParentSgroup && (difference = this.compareParentSgroup(sgroup1, sgroup2)) != null) {
            return difference;
        }
        if (!this.ignoreChildrenSgroups && (difference = this.compareChildrenSgroups(sgroup1, sgroup2)) != null) {
            return difference;
        }
        return null;
    }
}

