/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.core.util.differ;

import chemaxon.struc.MolAtom;
import chemaxon.struc.sgroup.SgroupAtom;

class DifferUtils {
    DifferUtils() {
    }

    static String getAttributeDifferenceString(String attributeName, String attribute1, String attribute2) {
        attribute1 = String.valueOf(attribute1);
        attribute2 = String.valueOf(attribute2);
        String separator = attribute1.length() > 10 || attribute2.length() > 10 ? System.getProperty("line.separator") : " ";
        return "Different " + attributeName + ":" + separator + "+" + attribute1 + "," + separator + "-" + attribute2;
    }

    static String getAttributeDifferenceString(String attributeName, int attribute1, int attribute2) {
        return DifferUtils.getAttributeDifferenceString(attributeName, String.valueOf(attribute1), String.valueOf(attribute2));
    }

    static String getAttributeDifferenceString(String attributeName, boolean attribute1, boolean attribute2) {
        return DifferUtils.getAttributeDifferenceString(attributeName, String.valueOf(attribute1), String.valueOf(attribute2));
    }

    static String getAttributeDifferenceString(String attributeName, double attribute1, double attribute2) {
        return DifferUtils.getAttributeDifferenceString(attributeName, String.valueOf(attribute1), String.valueOf(attribute2));
    }

    static String getAttributeDifferenceString(String attributeName, Object attribute1, Object attribute2) {
        return DifferUtils.getAttributeDifferenceString(attributeName, String.valueOf(attribute1), String.valueOf(attribute2));
    }

    static String getLabelCenter(MolAtom atom) {
        if (atom.getAtno() == 135) {
            return Integer.toString(((SgroupAtom)atom).getLabelCenter());
        }
        return "";
    }

    static String getLeftName(MolAtom atom) {
        if (atom.getAtno() == 135) {
            return ((SgroupAtom)atom).getLeftName();
        }
        return "";
    }

    static String getRightName(MolAtom atom) {
        if (atom.getAtno() == 135) {
            return ((SgroupAtom)atom).getRightName();
        }
        return "";
    }

    static String getQueryPropertyList(MolAtom atom) {
        if (atom != null) {
            String[] propertyNames;
            String propertyList = "";
            for (String name : propertyNames = atom.getQPropNames()) {
                propertyList = propertyList.concat("(" + name + ", " + atom.getQProp(name).toString() + ")");
            }
            return propertyList;
        }
        return "";
    }

    static boolean equalsStrings(String string1, String string2) {
        if (string1 != null && string2 != null) {
            return string1.equals(string2);
        }
        return string1 == null && string2 == null;
    }
}

